#include <vector>
#include <array>
#include <algorithm>
#include "RepeatCoefficients.h"

using namespace std;

double* FixedAllocate(std::initializer_list<double> list) {
	auto ret = new double[list.size()];
	copy(list.begin(), list.end(), ret);
	return ret;
}

std::array<std::array<const double*, 17>, 17> GetNonRepeatCoefficients() {
	auto niz = std::array<std::array<const double*, 17>, 17>();
	for (auto& row : niz) {
		for (auto& col : row) {
			col = nullptr;
		}
	}

	static double niz1_1[] = { 0.4375, 0.5625 }; // computed in 0 seconds.
	niz[1][1] = niz1_1;
	static double niz1_2[] = { 0.191406, 0.492188, 0.316406 }; // computed in 0 seconds.
	niz[2][1] = niz[1][2] = niz1_2;
	static double niz1_3[] = { 0.0837402, 0.322998, 0.415283, 0.177979 }; // computed in 0 seconds.
	niz[3][1] = niz[1][3] = niz1_3;
	static double niz1_4[] = { 0.0366364, 0.188416, 0.363373, 0.311462, 0.100113 }; 
	niz[4][1] = niz[1][4] = niz1_4;// computed in 0 seconds.
	static double niz1_5[] = { 0.0160284, 0.10304, 0.264959, 0.340662, 0.218997, 0.0563135 }; // computed in 0 seconds.
	niz[1][5] = niz[5][1] = niz1_5;
	static double niz1_6[] = { 0.00701243, 0.0540959, 0.17388, 0.298079, 0.287434, 0.147823, 0.0316764 }; // computed in 0 seconds.
	niz[1][6] = niz[6][1] = niz1_6;
	static double niz1_7[] = { 0.00306794, 0.0276114, 0.106501, 0.228217, 0.293422, 0.226354, 0.0970088, 0.0178179 }; // computed in 0 seconds.
	niz[1][7] = niz[7][1] = niz1_7;
	static double niz1_8[] = { 0.00134222, 0.0138057, 0.0621257, 0.159752, 0.256744, 0.26408, 0.169765, 0.0623628, 0.0100226 }; // computed in 0 seconds.
	niz[1][8] = niz[8][1] = niz1_8;
	static double niz1_9[] = { 0.000587222, 0.006795, 0.0349457, 0.104837, 0.202186, 0.259953, 0.222817, 0.122777, 0.039464, 0.00563771 }; // computed in 1 seconds.
	niz[1][9] = niz[9][1] = niz1_9;
	static double niz1_10[] = { 0.00025691, 0.00330313, 0.0191109, 0.0655232, 0.147427, 0.227459, 0.243706, 0.179049, 0.0863274, 0.024665, 0.00317121 }; // computed in 3 seconds.
	niz[1][10] = niz[10][1] = niz1_10;
	static double niz1_11[] = { 0.000112398, 0.00158963, 0.010219, 0.0394163, 0.101356, 0.182441, 0.234567, 0.215419, 0.138484, 0.0593501, 0.0152615, 0.00178381 }; // computed in 7 seconds.
	niz[1][11] = niz[11][1] = niz1_11;
	static double niz1_12[] = { 4.91741e-05, 0.000758687, 0.005365, 0.0229928, 0.066515, 0.136831, 0.205246, 0.22619, 0.18176, 0.103863, 0.0400613, 0.00936499, 0.00100339 }; // computed in 16 seconds.
	niz[1][12] = niz[12][1] = niz1_12;
	static double niz1_13[] = { 2.15137e-05, 0.000359586, 0.00277395, 0.0130772, 0.0420338, 0.0972782, 0.166763, 0.214409, 0.206752, 0.14768, 0.0759496, 0.0266317, 0.00570679, 0.000564408 }; // computed in 37 seconds.
	niz[1][13] = niz[13][1] = niz1_13;
	static double niz1_14[] = { 9.41224e-06, 0.00016942, 0.00141587, 0.00728161, 0.0257457, 0.0662032, 0.127678, 0.187608, 0.211059, 0.180908, 0.116298, 0.054373, 0.017477, 0.003457, 0.000317479 }; // computed in 74 seconds.
	niz[1][14] = niz[14][1] = niz1_14;
	static double niz1_15[] = { 4.11785e-06, 7.94157e-05, 0.000714742, 0.00398213, 0.0153597, 0.0434459, 0.0930983, 0.153897, 0.197868, 0.197868, 0.152641, 0.0892057, 0.038231, 0.0113433, 0.00208346, 0.000178582 }; // computed in 148 seconds.
	niz[1][15] = niz[15][1] = niz1_15;
	static double niz2_2[] = { 0.0441895, 0.158203, 0.408691, 0.28125, 0.107666 }; // computed in 0 seconds.
	niz[2][2] = niz2_2;
	static double niz2_3[] = { 0.0121918, 0.0428467, 0.175095, 0.302124, 0.302811, 0.125244, 0.0396881 }; // computed in 0 seconds.
	niz[2][3] = niz[3][2] = niz2_3;
	static double niz2_4[] = { 0.00389194, 0.0115356, 0.0620384, 0.14447, 0.280752, 0.259277, 0.170528, 0.0516357, 0.0158701 }; // computed in 0 seconds.
	niz[2][4] = niz[4][2] = niz2_4;
	static double niz2_5[] = { 0.00138515, 0.00317574, 0.0218895, 0.05373, 0.151228, 0.226713, 0.263334, 0.164452, 0.0864717, 0.020771, 0.00684983 }; // computed in 0 seconds.
	niz[2][5] = niz[5][2] = niz2_5;
	static double niz2_6[] = { 0.000531975, 0.000888348, 0.00812528, 0.0183678, 0.0661317, 0.125515, 0.222072, 0.225769, 0.189004, 0.0897789, 0.0423395, 0.00831699, 0.00315994 }; // computed in 0 seconds.
	niz[2][6] = niz[6][2] = niz2_6;
	static double niz2_7[] = { 0.000214902, 0.000249714, 0.00319208, 0.00615272, 0.0272023, 0.0555359, 0.131623, 0.18509, 0.229503, 0.173174, 0.117243, 0.0452151, 0.0207267, 0.00333828, 0.00153902 }; // computed in 1 seconds.
	niz[2][7] = niz[7][2] = niz2_7;
	static double niz2_8[] = { 8.96445e-05, 7.00057e-05, 0.00131602, 0.00205591, 0.0112677, 0.0221156, 0.0650501, 0.110098, 0.18617, 0.198108, 0.189098, 0.113152, 0.0671611, 0.0217983, 0.0103224, 0.00134486, 0.000781645 }; // computed in 3 seconds.
	niz[2][8] = niz[8][2] = niz2_8;
	static double niz2_9[] = { 3.81361e-05, 1.95005e-05, 0.000563718, 0.000684315, 0.00481256, 0.0084347, 0.0297658, 0.0541429, 0.11626, 0.157581, 0.202684, 0.17032, 0.134455, 0.0667563, 0.0369919, 0.0102686, 0.00526869, 0.000543223, 0.000409496 }; // computed in 10 seconds.
	niz[2][9] = niz[9][2] = niz2_9;
	static double niz2_10[] = { 1.6415e-05, 5.39061e-06, 0.000248619, 0.000225588, 0.00212365, 0.00316603, 0.0134091, 0.0239449, 0.0621666, 0.0978207, 0.161073, 0.175958, 0.182239, 0.125743, 0.0868951, 0.0368878, 0.0200981, 0.00477825, 0.00276062, 0.000219637, 0.00021936 }; // computed in 25 seconds.
	niz[2][10] = niz[10][2] = niz2_10;
	static double niz2_11[] = { 7.11435e-06, 1.47882e-06, 0.000111983, 7.33394e-05, 0.000963626, 0.0011773, 0.00612319, 0.0100387, 0.0307282, 0.0516084, 0.103993, 0.137541, 0.181161, 0.163071, 0.142703, 0.0833872, 0.0529163, 0.0195549, 0.0109406, 0.00220734, 0.00148273, 8.87564e-05, 0.000119356 }; // computed in 59 seconds.
	niz[2][11] = niz[11][2] = niz2_11;
	static double niz2_12[] = { 3.09574e-06, 4.02822e-07, 5.11532e-05, 2.34705e-05, 0.000447237, 0.000432685, 0.00285826, 0.00410547, 0.0147846, 0.024624, 0.0587359, 0.0878484, 0.142171, 0.157919, 0.172916, 0.13138, 0.101228, 0.0512663, 0.0311574, 0.0101012, 0.00601845, 0.001014, 0.000813947, 3.58065e-05, 6.56455e-05 }; // computed in 133 seconds.
	niz[2][12] = niz[12][2] = niz2_12;
	static double niz2_13[] = { 1.35019e-06, 1.09031e-07, 2.35658e-05, 7.39329e-06, 0.000211262, 0.000156564, 0.00136247, 0.00165591, 0.00712992, 0.0110976, 0.0307663, 0.048726, 0.0939499, 0.122052, 0.163492, 0.154304, 0.145374, 0.0952443, 0.0670229, 0.0298948, 0.0180657, 0.00513313, 0.00335856, 0.000463224, 0.000455067, 1.44102e-05, 3.63714e-05 }; // computed in 300 seconds.
	niz[2][13] = niz[13][2] = niz2_13;
	static double niz3_3[] = { 0.00251865, 0.0066433, 0.033062, 0.0967655, 0.204011, 0.27307, 0.225718, 0.112473, 0.0352249, 0.0105143 }; // computed in 0 seconds.
	niz[3][3] = niz3_3;
	static double niz3_4[] = { 0.00063628, 0.00130033, 0.00679135, 0.0209062, 0.0622053, 0.128624, 0.216454, 0.236732, 0.179844, 0.0961282, 0.0366411, 0.0105572, 0.00318056 }; // computed in 0 seconds.
	niz[3][4] = niz[4][3] = niz3_4;
	static double niz3_5[] = { 0.000180874, 0.000314824, 0.00161938, 0.00472421, 0.0156386, 0.0377798, 0.0884551, 0.153022, 0.207889, 0.208402, 0.14843, 0.0811905, 0.0358422, 0.0120337, 0.00340372, 0.00107426 }; // computed in 0 seconds.
	niz[3][5] = niz[5][3] = niz3_5;
	static double niz3_6[] = { 5.64426e-05, 8.4565e-05, 0.000440515, 0.00124827, 0.00400364, 0.00982237, 0.0275764, 0.056921, 0.108666, 0.166122, 0.196734, 0.179652, 0.127289, 0.0700778, 0.0323995, 0.0132154, 0.00412551, 0.00116445, 0.000400171 }; // computed in 2 seconds.
	niz[3][6] = niz[6][3] = niz3_6;
	static double niz3_7[] = { 1.91893e-05, 2.35042e-05, 0.00012751, 0.00039402, 0.00111724, 0.00256409, 0.00816769, 0.0176209, 0.0396515, 0.076264, 0.124661, 0.168724, 0.18374, 0.157123, 0.108142, 0.0623294, 0.0296888, 0.0125491, 0.0050311, 0.00148143, 0.000416771, 0.000162822 }; // computed in 8 seconds.
	niz[3][7] = niz[7][3] = niz3_7;
	static double niz3_8[] = { 7.03763e-06, 6.56971e-06, 3.75797e-05, 0.00013997, 0.000340031, 0.000725777, 0.002512, 0.00517905, 0.0128898, 0.0276235, 0.0532612, 0.091482, 0.136504, 0.166847, 0.167782, 0.139008, 0.0938462, 0.0540728, 0.0278894, 0.0121667, 0.00489256, 0.00200784, 0.000554039, 0.000154355, 7.15724e-05 }; // computed in 23 seconds.
	niz[3][8] = niz[8][3] = niz3_8;
	static double niz3_9[] = { 2.74167e-06, 1.82864e-06, 1.10689e-05, 5.33151e-05, 0.000108276, 0.000225738, 0.000845611, 0.00154619, 0.00406875, 0.00928925, 0.0193354, 0.0374159, 0.0674493, 0.104701, 0.141591, 0.162431, 0.153229, 0.121729, 0.0829427, 0.0479385, 0.024859, 0.01215, 0.00498102, 0.00194532, 0.000843686, 0.000214239, 5.86449e-05, 3.35572e-05 }; // computed in 64 seconds.
	niz[3][9] = niz[9][3] = niz3_9;
	static double niz3_10[] = { 1.11541e-06, 5.05402e-07, 3.23705e-06, 2.12902e-05, 3.49306e-05, 7.4373e-05, 0.000310427, 0.000492182, 0.00131562, 0.00310989, 0.00661895, 0.0136126, 0.0274332, 0.0482941, 0.0790963, 0.115592, 0.143837, 0.1538, 0.140394, 0.107856, 0.0722486, 0.0434033, 0.0227177, 0.0110647, 0.00531466, 0.0020643, 0.000791394, 0.000373251, 8.50497e-05, 2.26939e-05, 1.65589e-05 }; // computed in 159 seconds.
	niz[3][10] = niz[10][3] = niz3_10;
	static double niz3_11[] = { 4.67007e-07, 1.38641e-07, 9.38161e-07, 8.82415e-06, 1.12384e-05, 2.50428e-05, 0.000120881, 0.000167079, 0.000448606, 0.00109587, 0.00224543, 0.00472589, 0.0103494, 0.0192627, 0.0351676, 0.0597959, 0.0899946, 0.121617, 0.143947, 0.145027, 0.126627, 0.0967712, 0.0639655, 0.0381936, 0.0213118, 0.0104364, 0.00488871, 0.0023704, 0.000870098, 0.000329201, 0.000173396, 3.44321e-05, 8.89185e-06, 8.49398e-06 }; // computed in 378 seconds.
	niz[3][11] = niz[11][3] = niz3_11;
	static double niz4_4[] = { 0.000139434, 0.000170588, 0.00108308, 0.00310063, 0.00965703, 0.0239081, 0.0622798, 0.11135, 0.180687, 0.209887, 0.183203, 0.115562, 0.0635423, 0.0230541, 0.00923753, 0.00237322, 0.000764463 }; // computed in 0 seconds.
	niz[4][4] = niz4_4;
	static double niz4_5[] = { 3.4834e-05, 3.10969e-05, 0.000207997, 0.000561252, 0.00173833, 0.00419466, 0.0119666, 0.0258571, 0.0577947, 0.100778, 0.155163, 0.185425, 0.179316, 0.130501, 0.0792321, 0.0400545, 0.0176292, 0.00624821, 0.00245053, 0.000604838, 0.000210572 }; // computed in 3 seconds.
	niz[4][5] = niz[5][4] = niz4_5;
	static double niz4_7[] = { 2.63549e-06, 1.98527e-06, 1.3777e-05, 2.80119e-05, 8.54942e-05, 0.000186385, 0.000576657, 0.00110858, 0.00295755, 0.00618891, 0.0137657, 0.026362, 0.0512841, 0.0814908, 0.121607, 0.151286, 0.160866, 0.138941, 0.105544, 0.0654614, 0.0379336, 0.0190056, 0.00906543, 0.00372588, 0.00170873, 0.000506624, 0.000220982, 5.36494e-05, 2.19351e-05 }; // computed in 39 seconds.
	niz[4][7] = niz[7][4] = niz4_7;
	static double niz4_8[] = { 7.98095e-07, 5.49375e-07, 3.96584e-06, 7.74098e-06, 2.42779e-05, 4.58113e-05, 0.000145719, 0.00025899, 0.000731606, 0.00148857, 0.0033873, 0.00657464, 0.0144983, 0.0258734, 0.0474143, 0.0749372, 0.10968, 0.136714, 0.152198, 0.138116, 0.111848, 0.0766178, 0.0478574, 0.0258553, 0.0143303, 0.0062438, 0.00312027, 0.00120051, 0.000566624, 0.000158429, 7.40943e-05, 1.78041e-05, 8.14866e-06 }; // computed in 114 seconds.
	niz[4][8] = niz[8][4] = niz4_8;
	static double niz4_6[] = { 9.30655e-06, 7.4117e-06, 5.01311e-05, 0.000114775, 0.000358129, 0.000848536, 0.0024812, 0.00511496, 0.0131261, 0.0268948, 0.0541265, 0.0898134, 0.13748, 0.166424, 0.169945, 0.13771, 0.0946447, 0.0527066, 0.0283293, 0.0117201, 0.00542072, 0.00173026, 0.000706293, 0.000172474, 6.47252e-05 }; // computed in 12 seconds.
	niz[4][6] = niz[6][4] = niz4_6;
	static double niz4_9[] = { 2.60832e-07, 1.5252e-07, 1.15138e-06, 2.26751e-06, 7.78673e-06, 1.27604e-05, 4.06028e-05, 6.54244e-05, 0.000196526, 0.000381869, 0.000883463, 0.00166737, 0.00390838, 0.00701965, 0.0143189, 0.0254519, 0.0445047, 0.0681609, 0.100183, 0.124994, 0.142091, 0.136345, 0.116012, 0.0843375, 0.057785, 0.0334342, 0.0192978, 0.00986467, 0.00507153, 0.00217808, 0.00109409, 0.000399961, 0.000199481, 5.27763e-05, 2.62493e-05, 6.20537e-06, 3.29863e-06 }; // computed in 304 seconds.
	niz[4][9] = niz[9][4] = niz4_9;
	static double niz5_5[] = { 8.11789e-06, 3.81769e-06, 2.98867e-05, 9.44274e-05, 0.000268221, 0.000552185, 0.00159419, 0.0036928, 0.00905975, 0.0184035, 0.0385423, 0.069212, 0.111215, 0.149641, 0.16874, 0.157823, 0.118209, 0.0750761, 0.0419514, 0.0208024, 0.00933223, 0.00361925, 0.0014222, 0.000534137, 0.000122978, 4.88928e-05 }; // computed in 14 seconds.
	niz[5][5] = niz5_5;
	static double niz5_6[] = { 2.02794e-06, 6.83158e-07, 5.66834e-06, 1.75585e-05, 4.92554e-05, 9.37781e-05, 0.000270899, 0.000575994, 0.00143405, 0.00299861, 0.00683781, 0.0134999, 0.0270446, 0.0478088, 0.0792472, 0.11476, 0.144728, 0.154686, 0.1412, 0.107944, 0.0717279, 0.0421308, 0.0228401, 0.0113263, 0.00517032, 0.00219173, 0.000900163, 0.000337199, 0.000129297, 2.88272e-05, 1.28512e-05 }; // computed in 50 seconds.
	niz[5][6] = niz[6][5] = niz5_6;
	static double niz5_7[] = { 5.23593e-07, 1.62691e-07, 1.38171e-06, 3.93198e-06, 1.015e-05, 1.71758e-05, 5.5708e-05, 0.000111794, 0.000261256, 0.000526001, 0.00122542, 0.00246859, 0.00526446, 0.00999745, 0.0192738, 0.0340223, 0.0568204, 0.0857343, 0.116209, 0.138575, 0.143241, 0.128377, 0.0991878, 0.0680078, 0.0421478, 0.0239638, 0.0127766, 0.00641621, 0.00301899, 0.00132739, 0.000590709, 0.000233546, 8.59597e-05, 3.48708e-05, 7.64802e-06, 3.72673e-06 }; // computed in 159 seconds.
	niz[5][7] = niz[7][5] = niz5_7;
	static double niz5_8[] = { 1.39399e-07, 4.34622e-08, 3.79796e-07, 1.02312e-06, 2.45042e-06, 3.4268e-06, 1.27304e-05, 2.45606e-05, 5.55467e-05, 0.000106023, 0.000248527, 0.000484879, 0.00103454, 0.00198547, 0.00406871, 0.00757414, 0.0140795, 0.0245256, 0.0411098, 0.0635941, 0.0905229, 0.115953, 0.132446, 0.133208, 0.118039, 0.0919041, 0.0644947, 0.0414779, 0.0247434, 0.0138359, 0.0074172, 0.00375009, 0.00180972, 0.000840899, 0.000377556, 0.000165957, 6.44901e-05, 2.38245e-05, 1.03373e-05, 2.23313e-06, 1.18081e-06 }; // computed in 456 seconds.
	niz[5][8] = niz[8][5] = niz5_8;
	static double niz6_6[] = { 4.90264e-07, 8.09991e-08, 7.69013e-07, 2.80581e-06, 8.61297e-06, 1.5203e-05, 3.81206e-05, 7.44087e-05, 0.000196735, 0.000392304, 0.000889782, 0.0017429, 0.00378951, 0.00720791, 0.0142367, 0.0254363, 0.043926, 0.0683666, 0.0997922, 0.125989, 0.141702, 0.136503, 0.116174, 0.0852419, 0.0564689, 0.0335017, 0.0192964, 0.00985345, 0.00511805, 0.00221164, 0.00111337, 0.000411505, 0.000193732, 6.93383e-05, 2.64468e-05, 5.56776e-06, 2.96398e-06 }; // computed in 177 seconds.
	niz[6][6] = niz6_6;
	static double niz6_7[] = { 1.22532e-07, 1.4372e-08, 1.44374e-07, 5.35541e-07, 1.65467e-06, 2.76738e-06, 6.7894e-06, 1.22848e-05, 3.24805e-05, 6.14652e-05, 0.000135024, 0.000256685, 0.000568471, 0.00106776, 0.0021779, 0.00407186, 0.00779522, 0.01381, 0.0243807, 0.0394652, 0.0611328, 0.0863959, 0.111777, 0.128216, 0.13123, 0.117891, 0.0951179, 0.0681121, 0.0450921, 0.0273817, 0.0160941, 0.00874143, 0.00462259, 0.00232059, 0.0011127, 0.000510531, 0.000243232, 9.40421e-05, 4.409e-05, 1.54987e-05, 6.11368e-06, 1.24316e-06, 7.60516e-07 }; // computed in 558 seconds.
	niz[6][7] = niz[7][6] = niz6_7;
	static double niz7_7[] = { 3.01694e-08, 1.66526e-09, 1.87892e-08, 8.14164e-08, 2.83381e-07, 5.35499e-07, 1.14026e-06, 1.71288e-06, 4.59846e-06, 8.80472e-06, 1.91592e-05, 3.37395e-05, 7.38754e-05, 0.000132966, 0.000270269, 0.000505185, 0.000973958, 0.00177538, 0.00335438, 0.00587221, 0.0103711, 0.017495, 0.0284703, 0.0438785, 0.0638796, 0.0861919, 0.106938, 0.120352, 0.121342, 0.11024, 0.090535, 0.0677236, 0.0466965, 0.0303078, 0.0185416, 0.0109235, 0.0062149, 0.00335579, 0.00176889, 0.000908064, 0.000444274, 0.000211545, 0.000103907, 4.48942e-05, 1.90195e-05, 8.87011e-06, 3.06443e-06, 1.2134e-06, 2.33388e-07, 1.76391e-07 }; // computed in 1753 seconds.
	niz[7][7] = niz7_7;
	static double niz8_8[] = { 1.87267e-09, 3.33723e-11, 4.38161e-10, 2.2442e-09, 9.11328e-09, 2.0496e-08, 4.31963e-08, 5.24068e-08, 1.15247e-07, 2.11035e-07, 5.08187e-07, 8.06406e-07, 1.67484e-06, 2.67194e-06, 5.46131e-06, 9.51873e-06, 1.78774e-05, 3.06714e-05, 5.77768e-05, 9.91696e-05, 0.000181883, 0.000312835, 0.000558346, 0.000948442, 0.00166231, 0.002766, 0.0046816, 0.00758783, 0.0122159, 0.0188701, 0.0286325, 0.0411401, 0.0570529, 0.0741358, 0.0908806, 0.102676, 0.107859, 0.103296, 0.0918621, 0.075216, 0.0578282, 0.0416282, 0.0288083, 0.0188614, 0.012112, 0.00746157, 0.00453204, 0.00261973, 0.00154552, 0.000840395, 0.000477027, 0.00024707, 0.000138751, 6.74922e-05, 3.65825e-05, 1.68664e-05, 9.38956e-06, 3.74766e-06, 1.97872e-06, 7.86616e-07, 3.80556e-07, 1.31413e-07, 5.33307e-08, 9.32907e-09, 1.04747e-08 }; // computed in 14458 seconds.
	niz[8][8] = niz8_8;

	return niz;
}

std::array<std::array<const double*, 17>, 17> DnaNonRepeatCoefficients = GetNonRepeatCoefficients();

std::array<std::array<const double*, 31>, 23> ComputeGenericRepeatCoefficients() {
	auto repRatios = std::array<std::array<const double*, 31>, 23>();
	for (auto& row : repRatios) {
		for (auto& col : row) {
			col = nullptr;
		}
	}
	for (auto& x : repRatios) fill(x.begin(), x.end(), nullptr);

	static double niz4_1[] = { 1.00000000000000000e+00 }; repRatios[4][1] = niz4_1;
	static double niz4_2[] = { 4.37500000000000000e-01, 5.62500000000000000e-01 }; repRatios[4][2] = niz4_2;
	static double niz4_3[] = { 1.21093750000000000e-01, 2.10937500000000000e-01, 5.27343750000000000e-01, 1.40625000000000000e-01 }; repRatios[4][3] = niz4_3;
	static double niz4_4[] = { 3.10058593750000000e-02, 2.63671875000000000e-02, 1.71386718750000000e-01, 2.54882812500000000e-01, 3.49365234375000000e-01, 1.58203125000000000e-01, 8.78906250000000000e-03 }; repRatios[4][4] = niz4_4;
	static double niz4_5[] = { 7.79724121093750000e-03, 2.74658203125000000e-03, 2.47192382812500000e-02, 5.76782226562500000e-02, 1.39389038085937500e-01, 1.64794921875000000e-01, 3.03497314453125000e-01, 2.03247070312500000e-01, 9.06372070312500000e-02, 5.49316406250000000e-03, 0.00000000000000000e+00 }; repRatios[4][5] = niz4_5;
	static double niz4_6[] = { 1.95217132568359375e-03, 2.57492065429687500e-04, 3.08990478515625000e-03, 9.26971435546875000e-03, 2.34317779541015625e-02, 2.86331176757812500e-02, 9.57870483398437500e-02, 1.09176635742187500e-01, 1.90157890319824219e-01, 2.28567123413085938e-01, 1.80244445800781250e-01, 1.08146667480468750e-01, 1.97410583496093750e-02, 1.54495239257812500e-03, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[4][6] = niz4_6;
	static double niz4_7[] = { 4.88221645355224609e-04, 2.25305557250976563e-05, 3.37958335876464844e-04, 1.35183334350585938e-03, 4.05550003051757813e-03, 4.21321392059326172e-03, 1.27485394477844238e-02, 1.68979167938232422e-02, 4.74268198013305664e-02, 6.01565837860107422e-02, 1.03922188282012939e-01, 1.41536951065063477e-01, 1.91828906536102295e-01, 1.68077945709228516e-01, 1.56136751174926758e-01, 6.91688060760498047e-02, 1.96015834808349609e-02, 1.80244445800781250e-03, 2.25305557250976563e-04, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[4][7] = niz4_7;
	static double niz4_8[] = { 1.22066587209701538e-04, 1.87754631042480469e-06, 3.37958335876464844e-05, 1.68979167938232422e-04, 6.33671879768371582e-04, 9.12487506866455078e-04, 2.03150510787963867e-03, 1.35585665702819824e-03, 6.06494396924972534e-03, 1.00354850292205811e-02, 1.89406871795654297e-02, 2.23503112792968750e-02, 5.06909340620040894e-02, 6.67392611503601074e-02, 1.01725459098815918e-01, 1.31572812795639038e-01, 1.53915848582983017e-01, 1.65329217910766602e-01, 1.33519828319549561e-01, 9.18120145797729492e-02, 3.26411426067352295e-02, 7.94202089309692383e-03, 1.33305788040161133e-03, 1.12652778625488281e-04, 1.40815973281860352e-05, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[4][8] = niz4_8;
	static double niz4_9[] = { 3.05173452943563461e-05, 1.50874257087707520e-07, 3.16835939884185791e-06, 1.90101563930511475e-05, 8.55457037687301636e-05, 1.71091407537460327e-04, 3.99213284254074097e-04, 2.37928703427314758e-04, 6.87100226059556007e-04, 1.04133412241935730e-03, 2.68993712961673737e-03, 3.32994572818279266e-03, 7.75403156876564026e-03, 8.11628066003322601e-03, 1.68264778330922127e-02, 2.72672027349472046e-02, 4.19599036686122417e-02, 5.23539707064628601e-02, 8.69575599208474159e-02, 1.02899864315986633e-01, 1.33890907745808363e-01, 1.36273954063653946e-01, 1.45041156560182571e-01, 1.13292083144187927e-01, 7.66452541574835777e-02, 2.97677926719188690e-02, 9.96977090835571289e-03, 1.78718939423561096e-03, 4.69973310828208923e-04, 2.11223959922790527e-05, 1.05611979961395264e-05, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[4][9] = niz4_9;
	static double niz4_10[] = { 7.62937997933477163e-06, 1.17870513349771500e-08, 2.82889232039451599e-07, 1.98022462427616119e-06, 1.03961792774498463e-05, 2.67330324277281761e-05, 7.12880864739418030e-05, 6.87420833855867386e-05, 1.21288758236914873e-04, 9.24798951018601656e-05, 3.04011628031730652e-04, 3.98025149479508400e-04, 1.27036910271272063e-03, 1.12542766146361828e-03, 2.00625043362379074e-03, 3.12935211695730686e-03, 5.73437100683804601e-03, 8.10356243164278567e-03, 1.47502531763166189e-02, 1.75725133158266544e-02, 2.85789318149909377e-02, 4.18505544075742364e-02, 5.88368112221360207e-02, 7.53322709351778030e-02, 9.79938161617610604e-02, 1.13134209736017510e-01, 1.27785875229164958e-01, 1.30396471358835697e-01, 1.10726570128463209e-01, 8.74784030020236969e-02, 4.59566130302846432e-02, 1.91778154112398624e-02, 5.95074001466855407e-03, 1.59358576638624072e-03, 3.26737063005566597e-04, 7.92089849710464478e-05, 3.11702024191617966e-06, 3.30037437379360199e-06, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[4][10] = niz4_10;
	static double niz4_11[] = { 1.90734772331779823e-06, 9.00399754755198956e-10, 2.43107933783903718e-08, 1.94486347027122974e-07, 1.16691808216273785e-06, 3.67579195881262422e-06, 1.12315865408163518e-05, 1.57533941091969609e-05, 2.69120482698781416e-05, 1.83924657903844491e-05, 3.62613491233787499e-05, 2.62232424574904144e-05, 1.80829083546996117e-04, 1.64956836670171469e-04, 3.29897466144757345e-04, 4.58220638392958790e-04, 6.60400000924710184e-04, 8.02256181486882269e-04, 1.76926345829997445e-03, 2.42686726778629236e-03, 4.33132439866312779e-03, 5.38693146154400893e-03, 8.42177745653316379e-03, 1.12450709275435656e-02, 1.94554052586681792e-02, 2.43487733205256518e-02, 3.73384775411977898e-02, 4.55071418218722101e-02, 6.35414258886157768e-02, 7.89942602568771690e-02, 9.93018196004413767e-02, 1.03328889017575420e-01, 1.21062694379361346e-01, 1.13573716662358493e-01, 1.03718747704988346e-01, 7.51856470888014883e-02, 4.66356650576926768e-02, 2.00888837571255863e-02, 8.45477530674543232e-03, 2.10979869734728709e-03, 8.41537021187832579e-04, 1.33644534798804671e-04, 5.22249865753110498e-05, 5.29435055796056986e-06, 1.13450369099155068e-06, 5.04223862662911415e-07, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[4][11] = niz4_11;
	static double niz4_12[] = { 4.76837101359706139e-07, 6.75299816066399217e-11, 2.02589944819919765e-09, 1.82330950337927788e-08, 1.23073391478101257e-07, 4.59473994851578027e-07, 1.59721912496024743e-06, 2.95376139547443017e-06, 5.57932708034059033e-06, 5.19643208463094197e-06, 6.86199155097710900e-06, 1.56400051309901755e-06, 2.18763375414710026e-05, 1.54657163875526749e-05, 5.26612302564899437e-05, 7.89120249464758672e-05, 1.12329945409328502e-04, 1.01399306231542141e-04, 2.09242323307989864e-04, 2.36962030157883419e-04, 5.15932300913846120e-04, 7.36189304461731808e-04, 1.12722666017361917e-03, 1.36573175041121431e-03, 2.45766319039830705e-03, 2.95142593859054614e-03, 4.76076281347559416e-03, 7.03580618278465408e-03, 9.94288624042383162e-03, 1.33225700346883968e-02, 1.95123383455211297e-02, 2.49356731492298422e-02, 3.57862771940631319e-02, 4.55681956782427733e-02, 5.88431145320100768e-02, 7.18926686845406948e-02, 8.62570783434648547e-02, 9.68262332776248513e-02, 1.07029746754960797e-01, 1.08007309418098885e-01, 9.93103814566893561e-02, 8.44482344036805443e-02, 5.77858036876932601e-02, 3.38340442613116466e-02, 1.53824093763432757e-02, 6.46117247742949985e-03, 2.03214002885943046e-03, 7.25912186680943705e-04, 2.21211674897858757e-04, 5.12512042405433021e-05, 1.42238400258065667e-05, 4.28275143349310383e-06, 1.06359721030457877e-07, 2.83625922747887671e-07, 3.15139914164319634e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[4][12] = niz4_12;
	static double niz4_13[] = { 1.19209285998067571e-07, 4.98801000503590330e-12, 1.64604330166184809e-10, 1.64604330166184809e-09, 1.23453247624638607e-08, 5.33318029738438781e-08, 2.08882894980888523e-07, 4.79986226764594903e-07, 1.03330368261822514e-06, 1.28885190520122705e-06, 1.63995294144569925e-06, 5.99224605934978172e-07, 2.89432231781461269e-06, 8.02830186330538709e-07, 6.51613675017870264e-06, 1.05647448549461842e-05, 2.04966134944584155e-05, 1.83652343253015715e-05, 3.64830134742533119e-05, 2.83681846013905670e-05, 5.95107477536771512e-05, 8.29344651833707758e-05, 1.24151786003778852e-04, 1.87715885459738274e-04, 3.49063234637014830e-04, 3.77374356403947786e-04, 5.53502141912076695e-04, 7.38010976363057125e-04, 1.21822721024500424e-03, 1.57097220480295618e-03, 2.67908673568939548e-03, 3.19165568546964096e-03, 4.92259364298064384e-03, 6.22003005722149283e-03, 9.17918187028021748e-03, 1.19462145688657984e-02, 1.81417107576145042e-02, 2.15039779488392924e-02, 2.97964477050811638e-02, 3.72265842727870222e-02, 4.99769990343956749e-02, 5.87047390577311035e-02, 7.26252589490883338e-02, 7.97490103624909352e-02, 9.59509248713885654e-02, 9.69647235444313083e-02, 9.95791435577757511e-02, 9.23244147779485047e-02, 7.94941307078289583e-02, 5.57374458779236193e-02, 3.68128057118042307e-02, 1.80622699598984582e-02, 8.63857318555005804e-03, 3.23566484786397268e-03, 1.34991791696847940e-03, 3.64874468175457878e-04, 1.74676962942044156e-04, 3.77532102220357046e-05, 1.37115407028431946e-05, 2.51186207833598019e-06, 1.44604904050993355e-06, 4.60892124465317465e-08, 5.76115155581646832e-08, 2.56051180258509703e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[4][13] = niz4_13;
	static double niz4_14[] = { 2.98023221656507076e-08, 3.63709062867201283e-13, 1.30935262632192462e-11, 1.44028788895411708e-10, 1.18823750838714659e-09, 5.83316595026417417e-09, 2.54930956344878723e-08, 6.99979914031700901e-08, 1.72078395532793138e-07, 2.72214411012328128e-07, 3.84988952717435495e-07, 2.57719877438944422e-07, 4.92000888030474925e-07, 5.06945245781764697e-08, 7.65722509399324736e-07, 1.02590106010325144e-06, 2.93328231304457177e-06, 2.84245615844724853e-06, 7.33332180580248405e-06, 5.31941526027424061e-06, 9.77896664844379870e-06, 1.09566380448455902e-05, 1.29191714126619672e-05, 1.91328977940941058e-05, 4.39088353536565279e-05, 5.51023441994757945e-05, 8.16944253205775794e-05, 9.97245252296607987e-05, 1.48105579776292018e-04, 1.65856567895694695e-04, 3.06046149399108458e-04, 3.58884630909273028e-04, 5.76945373528037209e-04, 8.09268095236514995e-04, 1.12781815304430211e-03, 1.48074588999946855e-03, 2.08571368545840130e-03, 2.65235775302219423e-03, 3.99043425966638665e-03, 5.38987503998100692e-03, 7.47178617246491150e-03, 9.35330223739683220e-03, 1.31219209439219497e-02, 1.63500836865289045e-02, 2.23576760136472430e-02, 2.86214935598114728e-02, 3.59690961681025101e-02, 4.44263582143662461e-02, 5.45330986651959559e-02, 6.28726840433317946e-02, 7.64759254635691832e-02, 8.26274236510116111e-02, 8.89122928490415632e-02, 9.40921465973527660e-02, 9.03582405252905119e-02, 8.02604529979973336e-02, 6.69910403730069604e-02, 4.78674775953686904e-02, 2.89067146146297915e-02, 1.61942369514278539e-02, 7.37246947875380698e-03, 3.33815668051684611e-03, 1.27893646956067641e-03, 5.20755482128265612e-04, 1.80108888691243862e-04, 6.69010843843409475e-05, 2.24244182582822305e-05, 6.82552430575356084e-06, 1.79863151572590141e-06, 6.48273578818248097e-07, 2.35247021862505790e-07, 2.01640304453576391e-08, 8.68173533064009462e-09, 8.40167935223234963e-09, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[4][14] = niz4_14;
	static double niz4_15[] = { 7.45058058304604032e-09, 2.62290189567693233e-14, 1.02293173931400361e-12, 1.22751808717680433e-11, 1.10476627845912390e-10, 6.07621453152518143e-10, 2.93683702357050436e-09, 9.37473099149599420e-09, 2.61277224855582801e-08, 5.02300401272748331e-08, 8.20288961755899493e-08, 8.05374616996701320e-08, 1.06886137440920237e-07, 2.80928268148183946e-08, 1.07641411409287180e-07, 8.81330708413230468e-08, 3.58653165916100747e-07, 2.82303927734428584e-07, 1.20436198139395323e-06, 9.89987881672149683e-07, 2.07676385963195820e-06, 2.03713718893716589e-06, 1.98791848732282617e-06, 2.11500479879722647e-06, 5.63199278463821784e-06, 5.91734409421951213e-06, 9.09711444611882580e-06, 1.54018454365245638e-05, 2.36945368151109115e-05, 2.54779951161521190e-05, 3.98545812502204555e-05, 3.94145808016443944e-05, 6.65920968730138174e-05, 8.49210665437860612e-05, 1.32942372341876558e-04, 1.74181730044353777e-04, 2.81477485440453923e-04, 3.16576762948023172e-04, 4.66564982009032292e-04, 5.80570011258496610e-04, 8.48191403977627267e-04, 1.08147149143353327e-03, 1.66761833092748946e-03, 2.02053337011731671e-03, 2.94480586794050592e-03, 3.66589806110401151e-03, 5.07608482449350973e-03, 6.29057168331392802e-03, 9.07076566559264497e-03, 1.10006217869640377e-02, 1.54762806861055008e-02, 1.83011682860229064e-02, 2.39851305005081561e-02, 2.96596695114559328e-02, 3.81313075203541102e-02, 4.35230007446341105e-02, 5.52537053036755016e-02, 6.09921541150831859e-02, 7.10077296150959936e-02, 7.89455315386516920e-02, 8.56216725152286751e-02, 8.44964359296501710e-02, 8.62918886999991530e-02, 7.65497147311408610e-02, 6.55237529493069015e-02, 4.90313671630182579e-02, 3.33753999575209237e-02, 1.86972746334176931e-02, 1.06425543173718773e-02, 4.74162554497670197e-03, 2.26814788152979174e-03, 8.92701865858880339e-04, 4.14053827289539988e-04, 1.36003639805148957e-04, 6.40834491871800083e-05, 1.91203948404217172e-05, 8.52848469845568502e-06, 2.19216317598469601e-06, 9.68976181792147173e-07, 1.35792142530455351e-07, 1.52805543218725859e-07, 1.83436665857072967e-08, 2.36297231781534833e-09, 3.15062975708713111e-09, 1.31276239878630463e-09, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[4][15] = niz4_15;
	static double niz4_16[] = { 1.86264514836359529e-09, 1.87350135405495166e-15, 7.86870568703079698e-14, 1.02293173931400361e-12, 9.97358445831153517e-12, 6.07621453152518143e-11, 3.22223497883911136e-10, 1.17184137393699928e-09, 3.66742948509912736e-09, 8.30415985975108129e-09, 1.56766334913349681e-08, 2.01343654249175330e-08, 2.57548638665783258e-08, 1.39391760634044459e-08, 2.00666945560090682e-08, 9.88971367299473769e-09, 4.57081474232456930e-08, 1.68780327214346215e-08, 1.60314089503454937e-07, 1.25313911747415574e-07, 3.83047189592145010e-07, 4.11004116990243418e-07, 4.81338435359690564e-07, 3.76496505222201350e-07, 9.04940711740631620e-07, 6.69029989033842476e-07, 9.43106316791952892e-07, 1.82114082439288616e-06, 2.85000927264383863e-06, 3.68925720348189934e-06, 6.75717532577779778e-06, 6.91894116000568715e-06, 9.83278001419167491e-06, 9.80499223687814059e-06, 1.45526770134463135e-05, 1.95678377993557806e-05, 3.36442154439189900e-05, 3.78814884535727536e-05, 5.68433746335472723e-05, 7.74822419968151932e-05, 1.06181693148521550e-04, 1.30450978773552495e-04, 1.78254922064274846e-04, 2.16119316060747746e-04, 3.16114841413250858e-04, 4.36247759954960790e-04, 6.09122373956411112e-04, 7.59056913651467990e-04, 1.08335164106436108e-03, 1.26855105848817928e-03, 1.78461054738804359e-03, 2.33737564897834593e-03, 3.12155618947061730e-03, 4.07169541522464651e-03, 5.48581584966054137e-03, 6.69956386040011787e-03, 8.91332796835231367e-03, 1.10742775010419514e-02, 1.44705873783118610e-02, 1.81966911596476155e-02, 2.30062907728832214e-02, 2.71717971580290318e-02, 3.46359841413185210e-02, 4.04082593849452304e-02, 4.80568246923532769e-02, 5.63951978640279128e-02, 6.41018107998528319e-02, 6.96524975148415937e-02, 7.81651718918340011e-02, 8.02070057245500567e-02, 8.06980811698243539e-02, 7.79211248818970081e-02, 7.00862725359360089e-02, 5.72812984884113474e-02, 4.43116421930925264e-02, 2.94694881749543725e-02, 1.74554207392806082e-02, 1.01434292713341312e-02, 4.95197459658869299e-03, 2.40382110278991590e-03, 1.09152175299669779e-03, 4.97582258196516136e-04, 1.96546445028061845e-04, 8.92200510646534717e-05, 3.48099147825381428e-05, 1.32588447166459567e-05, 5.53144814202655155e-06, 1.85808389924213557e-06, 6.56551858504994534e-07, 2.75657599246859064e-07, 5.76095151583189136e-08, 3.43418643522497291e-08, 1.45716626265279814e-08, 9.97699423077591518e-10, 3.15062975708713111e-10, 7.87657439271782778e-10, 8.20476499241440393e-11, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[4][16] = niz4_16;
	static double niz4_17[] = { 4.65661287253529149e-10, 1.32706345912225743e-16, 5.97178556605015842e-15, 8.36049979247022179e-14, 8.77852478209373288e-13, 5.86907085431409570e-12, 3.39101871582592196e-11, 1.38342384423117970e-10, 4.81578224563808388e-10, 1.25486324456525189e-09, 2.71151073469311221e-09, 4.27855265279497576e-09, 5.99378860996827023e-09, 4.93679152245574127e-09, 5.04127388271935484e-09, 2.24220363369970199e-09, 6.52014531477224449e-09, 5.88491599201601545e-10, 2.03343193455260418e-08, 9.95399247402661835e-09, 5.52554725373292921e-08, 6.37229037193237646e-08, 1.06321824157318279e-07, 9.12365178719343195e-08, 1.92756531605360951e-07, 1.10488543579936871e-07, 1.29926634068709690e-07, 2.30178451650527027e-07, 3.32050989673010610e-07, 3.89241425107281214e-07, 8.59528448138736217e-07, 9.80187380402244846e-07, 1.67921830399693148e-06, 1.97657831578663956e-06, 2.30919884924678243e-06, 2.65956555526962457e-06, 4.00928209984231440e-06, 4.05945696858259902e-06, 6.67571628894161190e-06, 8.74986342817851703e-06, 1.41026365839454909e-05, 1.60612547105837278e-05, 2.60372621903467126e-05, 2.81846534663354048e-05, 3.99409641869030892e-05, 4.56602828975355771e-05, 6.29592006182368852e-05, 8.22047616050747970e-05, 1.25308752491736647e-04, 1.50619702800058874e-04, 2.14197896976315444e-04, 2.69511413076905203e-04, 3.66183784685636523e-04, 4.31377674433072039e-04, 6.23738324439641369e-04, 7.24820922126871540e-04, 1.06985515280113175e-03, 1.33580211921861900e-03, 1.82884598799691600e-03, 2.21762420454190909e-03, 3.02851371668394313e-03, 3.56466335404320017e-03, 4.88038200230999850e-03, 6.02917622245587211e-03, 8.04726707077543617e-03, 9.81262903247182364e-03, 1.27187344730979816e-02, 1.47104802301813945e-02, 1.96469812750421913e-02, 2.28484323999344346e-02, 2.86928687542484240e-02, 3.38783786210107851e-02, 4.06477677841993526e-02, 4.53951988512462865e-02, 5.47649272362472142e-02, 6.01074242402957204e-02, 6.70013049771621266e-02, 7.23206848383600859e-02, 7.60995638291586396e-02, 7.47830107516708614e-02, 7.59198054896044888e-02, 6.74773378017931580e-02, 5.82499558728094627e-02, 4.64883548823512641e-02, 3.38938576094012650e-02, 2.12511149932475413e-02, 1.35145071530003054e-02, 7.12121261253564376e-03, 3.88314937265185232e-03, 1.84076379459273062e-03, 9.37586013933622286e-04, 3.93345381774906633e-04, 2.00501913772558119e-04, 7.75345856075110307e-05, 3.90871644973412452e-05, 1.37841871923859161e-05, 7.01728238101202370e-06, 2.22763917328075434e-06, 1.16113154349263559e-06, 2.84777703449951014e-07, 1.80085120940476351e-07, 4.88358864597637776e-08, 1.87502322262361742e-08, 5.54735882229984156e-09, 5.23053768266418251e-09, 1.45060245065886662e-10, 1.39481004871044867e-10, 1.67377205845253840e-10, 6.97405024355224334e-11, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[4][17] = niz4_17;
	static double niz4_18[] = { 1.16415321823546683e-10, 9.33091494695337254e-18, 4.47883917453761882e-16, 6.71825876180642823e-15, 7.55804110703223175e-14, 5.50225392591946472e-13, 3.44243578954961382e-12, 1.55635182476007716e-11, 5.97387569099827598e-11, 1.76006622606495258e-10, 4.30119049751875870e-10, 8.02228622399057956e-10, 1.27432200924294803e-09, 1.38847261569067723e-09, 1.42357215859173492e-09, 8.23016258659839406e-10, 1.12438170810102468e-09, 5.82691383547149534e-11, 2.73887778570128942e-09, 4.90279862606739225e-10, 7.03318162010527909e-09, 7.02449491152626337e-09, 1.75567102174726750e-08, 1.71003977218709899e-08, 4.17468087028183103e-08, 2.71888734548991588e-08, 3.24051820894477940e-08, 3.80971986087014908e-08, 4.56588850802615385e-08, 4.06263837878623711e-08, 1.11473456471415308e-07, 1.03581219165348355e-07, 1.99688789568857862e-07, 2.94270867993352988e-07, 3.90505475943939834e-07, 5.43591415879253297e-07, 7.41448831929913434e-07, 6.24181858167101745e-07, 8.20761100581005910e-07, 9.18855394647509656e-07, 1.68025334761878731e-06, 1.83907001729299619e-06, 3.29285919075132313e-06, 3.67364727316382266e-06, 5.35675237964779497e-06, 7.08833395741763871e-06, 8.71093896816785632e-06, 1.06705242504604846e-05, 1.37975942033419295e-05, 1.63822641923205066e-05, 2.31221420496687804e-05, 3.00822066674268388e-05, 4.18179277697690603e-05, 5.31129005111201152e-05, 7.67800640771827215e-05, 8.85255235649650340e-05, 1.18641073652479479e-04, 1.44000972938529144e-04, 1.88744961477554278e-04, 2.39716524950910710e-04, 3.40823110463341192e-04, 4.17161244476707798e-04, 5.63457007850263689e-04, 7.14927285251991374e-04, 9.03702985533857040e-04, 1.12196524420915848e-03, 1.50003153898912696e-03, 1.84810373589794851e-03, 2.46281941605026432e-03, 3.01274184360014134e-03, 3.94996177288275182e-03, 4.92822227706815868e-03, 6.25604935731246224e-03, 7.38514836191913725e-03, 9.73557618236556982e-03, 1.17799471240986418e-02, 1.45983462279748386e-02, 1.79203253135635787e-02, 2.17761393040195698e-02, 2.51691826538563805e-02, 3.12555382137890692e-02, 3.58238804914008183e-02, 4.18934577365878899e-02, 4.82882604655021433e-02, 5.44624186591933790e-02, 5.90601496761149272e-02, 6.68885329806526568e-02, 6.91417617305525173e-02, 7.13659880317061984e-02, 7.25603819932650329e-02, 6.96729607193217471e-02, 6.18440552087794887e-02, 5.50199583110066726e-02, 4.29066729347709827e-02, 3.14161780572571742e-02, 2.14418361422192665e-02, 1.31868103636229167e-02, 7.67171499286692198e-03, 4.22695472434249982e-03, 2.25897460407550703e-03, 1.09441933890448142e-03, 5.63982890982303651e-04, 2.58705818954136409e-04, 1.25105297894289886e-04, 5.80335702810247465e-05, 2.64574272030518179e-05, 1.09549643172993831e-05, 5.46656055045325467e-06, 2.15116309635205718e-06, 8.82901737862340844e-07, 4.11269108015459989e-07, 1.37460024739752620e-07, 5.65517888443127417e-08, 3.33206919756108035e-08, 7.96237279235278983e-09, 2.07308624954050114e-09, 2.13630103353384254e-09, 8.99054705683077771e-10, 0.00000000000000000e+00, 6.27664521919701901e-11, 2.56296346450544943e-11, 2.35374195719888213e-11, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[4][18] = niz4_18;
	static double niz4_19[] = { 2.91038304565219454e-11, 6.51791852912184111e-19, 3.32413844985213897e-17, 5.31862151976342235e-16, 6.38234582371610681e-15, 5.02609733617643412e-14, 3.38663225270935918e-13, 1.68015253809326512e-12, 7.05628165303912947e-12, 2.31858656877186693e-11, 6.33557519572668722e-11, 1.36092355585554475e-10, 2.45675637792304100e-10, 3.29762246226535842e-10, 3.81039209264112991e-10, 2.94414421675112149e-10, 2.70302617222187167e-10, 5.62004233624673543e-11, 3.87540507716566766e-10, 1.45348618547474747e-11, 9.26965879665471622e-10, 5.97312901563269586e-10, 2.36692025098225300e-09, 2.12482688207089356e-09, 7.37454611803818941e-09, 5.79302017679409061e-09, 8.97879080964805932e-09, 8.98137562277179268e-09, 9.87036429914595623e-09, 5.73469293771360707e-09, 1.62787679112049160e-08, 1.08050321632778893e-08, 2.34703213119314079e-08, 3.61562308374737670e-08, 4.36588764587591927e-08, 7.60063817342233571e-08, 1.30039087427605567e-07, 1.31056485459622859e-07, 1.61939471335526499e-07, 1.74028205885396847e-07, 2.44790548588875714e-07, 2.04988407523298361e-07, 3.64442018747562494e-07, 3.99904347739171739e-07, 6.96136747868325229e-07, 8.92791115088827720e-07, 1.20686648425178754e-06, 1.41285402536532535e-06, 2.30505347520656684e-06, 2.41590590785752299e-06, 3.29154949868312481e-06, 3.35833897952304172e-06, 4.56308424611670866e-06, 5.68389368789799170e-06, 8.51861572492127023e-06, 1.04281438044550949e-05, 1.47699891348349524e-05, 1.85647417475002410e-05, 2.41208943241866326e-05, 2.80142422685538340e-05, 3.92976538997012929e-05, 4.34301535481197782e-05, 6.11781183099591766e-05, 7.42411670911051220e-05, 1.01430815861759712e-04, 1.22829849471628021e-04, 1.79735284296886149e-04, 2.05819091365137450e-04, 2.77707143346658033e-04, 3.28282852272416105e-04, 4.33096966289859544e-04, 5.25892024071410798e-04, 7.14090854172355800e-04, 8.55683601619274458e-04, 1.17548415477458884e-03, 1.40579008386365330e-03, 1.81377324749516138e-03, 2.18371348080282929e-03, 2.85673953769696818e-03, 3.35809244966386996e-03, 4.55489485078571042e-03, 5.33805240225456584e-03, 6.80762131900501492e-03, 8.21445154372828744e-03, 1.03653632417130444e-02, 1.19305715168964641e-02, 1.54358951521835729e-02, 1.77641628139295071e-02, 2.16786265194336171e-02, 2.55847389954833374e-02, 3.03918599606576995e-02, 3.40239717716407583e-02, 4.10434503595385053e-02, 4.52730743155691784e-02, 5.11804766841554293e-02, 5.68999999679169616e-02, 6.18889998678450182e-02, 6.40428220186050334e-02, 6.91597760411375995e-02, 6.81016759945441003e-02, 6.63920797406162694e-02, 6.26790620487753941e-02, 5.55822737065976222e-02, 4.51138822370490827e-02, 3.64139124952042106e-02, 2.54424794364004545e-02, 1.71880393057856906e-02, 1.06720412271175055e-02, 6.45970036375551841e-03, 3.44724965102634470e-03, 2.02466726318880968e-03, 9.81728952284498073e-04, 5.29157845283517812e-04, 2.55689266468496869e-04, 1.33601829180571546e-04, 5.73820426958640431e-05, 3.27117983890170676e-05, 1.31593372442906470e-05, 6.80014905521621795e-06, 2.75207737725137214e-06, 1.54688509818122472e-06, 4.86745740089887394e-07, 3.05419088873318357e-07, 9.70459935705643136e-08, 5.09703381246169639e-08, 1.57800825224756300e-08, 1.13671150182085006e-08, 3.46269066789058402e-09, 1.13785910669574888e-09, 2.36560406944349554e-10, 5.59013714834734506e-10, 6.65492517660398221e-11, 8.42957189036504413e-12, 7.45351619779646007e-12, 9.31689524724557509e-12, 3.72675809889823004e-12, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[4][19] = niz4_19;
	static double niz4_20[] = { 7.27595761417019101e-12, 4.52633231189016744e-20, 2.44421944842069042e-18, 4.15517306231517371e-17, 5.29784565445184648e-16, 4.48758690730038760e-15, 3.24103498860583549e-14, 1.75015889384715117e-13, 7.98790469499468993e-13, 2.89524148635996674e-12, 8.75752584959670641e-12, 2.12644305602428867e-11, 4.32984822750877898e-11, 6.87004679638616338e-11, 9.14794591053184013e-11, 8.95542843220865350e-11, 8.00075041251683729e-11, 3.50718775529797837e-11, 6.23695904311775064e-11, 2.08325042368838142e-12, 1.30223944215952397e-10, 4.79750556869801878e-11, 3.10899670056490035e-10, 1.74538321494086359e-10, 1.06178521395655281e-09, 8.58189920517413846e-10, 1.90417777960991400e-09, 2.03757686220550958e-09, 2.67869912672641279e-09, 1.61253374478098537e-09, 3.23336507468844082e-09, 1.40550243162549017e-09, 3.02475136775148944e-09, 4.66345420780457745e-09, 4.74365863725910631e-09, 8.70013920091049079e-09, 1.71771369245382214e-08, 1.73344299737647291e-08, 2.62104145254098130e-08, 3.79274676795608679e-08, 5.18649076157778665e-08, 4.34442217292135059e-08, 5.78632185314328023e-08, 4.96254877403198611e-08, 8.16399078244298882e-08, 9.70605058799864224e-08, 1.42611917633905108e-07, 1.73874373537356685e-07, 3.09867515273144667e-07, 3.38535297464762583e-07, 4.80179434981735552e-07, 5.93573995375013594e-07, 7.18203494776198686e-07, 8.40530050072230304e-07, 1.00761473057971100e-06, 1.17831673713013036e-06, 1.64451707262844189e-06, 2.04756827784721390e-06, 2.80365195027509250e-06, 3.52938010793804408e-06, 5.04535542316847801e-06, 5.87742352926932933e-06, 7.82940096468344511e-06, 9.54490041222975355e-06, 1.17108449568537793e-05, 1.32389663694179058e-05, 1.85985229009806197e-05, 2.16987628631658543e-05, 3.01995300034715068e-05, 3.89258973128594706e-05, 5.01440527459321808e-05, 6.20105679753621473e-05, 8.02502671207729827e-05, 9.44656450469792209e-05, 1.21638702200087089e-04, 1.49273463182372697e-04, 1.91759242720729886e-04, 2.40967834160654801e-04, 3.19325834552864664e-04, 3.79692992589733980e-04, 5.04628043970922844e-04, 6.12476702080999818e-04, 7.70950404724504408e-04, 9.34427790416744904e-04, 1.19768521215979969e-03, 1.43735129824195968e-03, 1.90019041941467352e-03, 2.29215746116696872e-03, 2.86892896033299908e-03, 3.52481171534474317e-03, 4.35613279393357641e-03, 5.12203398601901623e-03, 6.61200104286220527e-03, 7.81758258081084040e-03, 9.59835752388927578e-03, 1.16137559549038261e-02, 1.40506372011372140e-02, 1.61407033213794952e-02, 1.99196172185303749e-02, 2.28828396096800134e-02, 2.70249182005856022e-02, 3.14317673568391687e-02, 3.60077783347917263e-02, 3.98930736259569957e-02, 4.67023306925581014e-02, 5.05306745023180043e-02, 5.50990264530175008e-02, 5.98727881306640036e-02, 6.32790385423183666e-02, 6.35387134947481697e-02, 6.62870570040734047e-02, 6.26612889141772711e-02, 5.87019428793979642e-02, 5.26664594405123684e-02, 4.43552617263426527e-02, 3.41549654103994044e-02, 2.61772989567666016e-02, 1.76875081050262388e-02, 1.13663253301594536e-02, 7.20912875162491376e-03, 4.17757770229586472e-03, 2.36367058974146010e-03, 1.32126026249532636e-03, 7.14082402818701028e-04, 3.59796456846119971e-04, 1.96437136653099877e-04, 9.64513427802244543e-05, 4.99684006410652589e-05, 2.41534209001815978e-05, 1.23141199249705831e-05, 5.88082234894472618e-06, 2.79796767745017567e-06, 1.28333821746754619e-06, 6.77220648108883538e-07, 2.74265636411523260e-07, 1.25920929053213085e-07, 6.30774182344770473e-08, 2.65005617006947733e-08, 1.07146249567383910e-08, 4.81544311839418840e-09, 2.83832558782159841e-09, 1.14617617866050943e-09, 2.61744545219812338e-10, 1.11469996708116702e-10, 1.27936315044394472e-10, 5.34612322520519904e-11, 1.33098503532079644e-12, 3.21654716869192473e-12, 9.70509921588080739e-13, 2.32922381181139377e-12, 2.32922381181139377e-13, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[4][20] = niz4_20;
	static double niz4_21[] = { 1.81898940354502930e-12, 3.12674271545044461e-21, 1.78224334780675343e-19, 3.20803802605215617e-18, 4.33085133517041083e-17, 3.92663854388783915e-16, 3.02678387758020935e-15, 1.76698734474952762e-14, 8.71222926925114312e-14, 3.45216971983472526e-13, 1.14589129307006866e-12, 3.10106279003542097e-12, 7.05396072918551005e-12, 1.28813377432240563e-11, 1.96665691470622424e-11, 2.33100970519357683e-11, 2.33650945330410974e-11, 1.53439464294286553e-11, 1.41612342383069679e-11, 2.42436763161719927e-12, 1.86596533473310099e-11, 4.47745154398760314e-12, 4.40142635385534350e-11, 9.53586594234114756e-12, 1.39814794555186639e-10, 8.70466030988015636e-11, 3.07190622632530343e-10, 3.47202606843190557e-10, 6.10942397636026482e-10, 4.64277031724873593e-10, 8.26672963714997536e-10, 3.87227399086261672e-10, 5.88817434630052869e-10, 6.81091973981590513e-10, 5.51499333101787629e-10, 9.72553259986209619e-10, 2.34444648454169113e-09, 1.91598509575633413e-09, 2.94385280471217414e-09, 5.30577782735123647e-09, 8.39269922833860346e-09, 9.13642128007651471e-09, 1.30464088283842141e-08, 1.17093647595243582e-08, 1.46253055512665666e-08, 1.49172464033230952e-08, 1.67414412290130614e-08, 1.83757520323832927e-08, 3.62697343643075813e-08, 3.87266889240754839e-08, 6.52043125916962943e-08, 7.76164928550392975e-08, 1.10057961689394924e-07, 1.19445920594231673e-07, 1.87727632029871557e-07, 1.96649690297648692e-07, 2.66520214574743793e-07, 2.47291187304599669e-07, 3.21496891377447687e-07, 3.87973610809551970e-07, 5.74659222492814749e-07, 6.82567555772475071e-07, 9.47886907784912189e-07, 1.23425664645292805e-06, 1.61668140003497568e-06, 1.92166616846870171e-06, 2.57011686533216212e-06, 2.71937523676541171e-06, 3.55042440295537368e-06, 4.12939117535012157e-06, 5.53212968686076870e-06, 6.39366034619966030e-06, 9.41384967227644207e-06, 1.05492998145463129e-05, 1.47769401970156269e-05, 1.77475557514950537e-05, 2.31633741141946422e-05, 2.68501486095237639e-05, 3.52334813146732096e-05, 3.93131174240543882e-05, 5.32578045600002624e-05, 6.34891931070198916e-05, 8.30873782779235513e-05, 1.01845936172136867e-04, 1.37307563305451172e-04, 1.58854736511601484e-04, 2.08720667689702214e-04, 2.42685109820433751e-04, 3.12821007525040506e-04, 3.69605989167732759e-04, 4.86368472443858763e-04, 5.72192057075814140e-04, 7.66149480829065839e-04, 8.95263053239536677e-04, 1.13416743645063448e-03, 1.36941573122902819e-03, 1.74860439734486530e-03, 2.00463002456951296e-03, 2.61817799522874551e-03, 3.04499904342608787e-03, 3.84605528423669031e-03, 4.64392647724548580e-03, 5.76866680863653575e-03, 6.58581245608261517e-03, 8.36322016673963879e-03, 9.59121796145507785e-03, 1.17339095923078927e-02, 1.38765375940643702e-02, 1.66572347656036672e-02, 1.88479118007344355e-02, 2.29188769077816427e-02, 2.56733107809260196e-02, 2.97526518511212687e-02, 3.42393016645145820e-02, 3.89229349137975231e-02, 4.22192523608875755e-02, 4.85007558505764075e-02, 5.14740983006344091e-02, 5.54030732277224283e-02, 5.96336830385339953e-02, 6.15504344476303922e-02, 6.09589938811801041e-02, 6.21133751584160218e-02, 5.82027554941350680e-02, 5.31810186390241565e-02, 4.70284522504162694e-02, 3.88677561913210040e-02, 2.96043857717529987e-02, 2.27256894454269456e-02, 1.52269698825540090e-02, 1.00765883896396010e-02, 6.31975615518377484e-03, 3.90459982358064978e-03, 2.17276112938871680e-03, 1.31556156283914034e-03, 6.88290005724675872e-04, 3.95636860540575746e-04, 2.01228405571829801e-04, 1.13344694223652527e-04, 5.52784766544078265e-05, 3.15712440511718698e-05, 1.45668568855186692e-05, 8.13757630772167837e-06, 3.72598651357600832e-06, 2.16144639396672189e-06, 8.50487343283312494e-07, 5.09124265844584025e-07, 2.13491856590944338e-07, 1.20594702828769573e-07, 4.30027192518286303e-08, 2.75772811828789955e-08, 9.51747538528979168e-09, 6.59560102459347937e-09, 1.54789515816468676e-09, 1.15954792377912479e-09, 6.80999879764630625e-10, 2.59826591492544669e-10, 2.56006652887484441e-11, 5.26259004981136781e-11, 2.10981924739523123e-11, 1.87174969752281221e-11, 5.82305952952848443e-13, 4.77167378114139697e-13, 4.36729464714636332e-13, 5.09517708833742388e-13, 2.03807083533496955e-13, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[4][21] = niz4_21;
	static double niz4_22[] = { 4.54747350886412420e-13, 2.14963561687218067e-22, 1.28978137012330840e-20, 2.45058460323428596e-19, 3.49208305960885750e-18, 3.37445499865361177e-17, 2.76572978321021514e-16, 1.73543399930757177e-15, 9.19538987133109208e-15, 3.95373644008914846e-14, 1.42941913742966995e-13, 4.26396133629870384e-13, 1.07341413507171390e-12, 2.21397992461663468e-12, 3.83183827047111847e-12, 5.32569985707507624e-12, 6.16300337589099693e-12, 5.27448158511610028e-12, 4.31201754542658851e-12, 1.66562576372087377e-12, 2.97264626393211715e-12, 5.50116716530319398e-13, 6.44779238922805956e-12, 3.42683706140927905e-13, 1.89584083684078048e-11, 6.17862048595633442e-12, 4.23038909181679033e-11, 4.28025148308808893e-11, 1.07588279191953551e-10, 9.50556741407749762e-11, 1.95760279823023633e-10, 1.24153630422519379e-10, 1.73780890294410876e-10, 1.48026667514753022e-10, 1.08993139142292681e-10, 1.14435631901090221e-10, 3.32792250259787899e-10, 2.04360148334945554e-10, 3.30647080556840318e-10, 6.88630157017366022e-10, 1.03026050244332617e-09, 1.16197758194317416e-09, 2.12101180278032780e-09, 2.38094050376176928e-09, 3.32161930287243983e-09, 3.73229119118570247e-09, 3.38575084095182085e-09, 3.15879672362633309e-09, 5.15204809395800565e-09, 4.32941300938005813e-09, 7.36689373662465404e-09, 8.03371124554985180e-09, 1.41733233665206202e-08, 1.59845270510398747e-08, 2.63489471257158620e-08, 2.93010289458859417e-08, 4.06482509704271731e-08, 4.94090249104990848e-08, 5.76277603318040354e-08, 6.64245785302171002e-08, 7.51572749433231934e-08, 7.88289085995359497e-08, 1.06804608888724111e-07, 1.39579219141476455e-07, 1.87641438494421343e-07, 2.33485340635303025e-07, 3.27033074555682960e-07, 3.85093262772326908e-07, 5.10405550219988042e-07, 6.17991690701559783e-07, 7.71925129206335390e-07, 8.50735023050078022e-07, 1.12274924239042519e-06, 1.18872417449449399e-06, 1.57679727995442726e-06, 1.95962673691606512e-06, 2.54169532428904547e-06, 3.14285121735400935e-06, 4.30305744184141418e-06, 5.11998222114433514e-06, 6.55367037506052329e-06, 7.78983006365819356e-06, 9.24758491249141854e-06, 1.11868372300120447e-05, 1.42274214057381324e-05, 1.65259060999594459e-05, 2.20375587188397613e-05, 2.71955923104264103e-05, 3.42908650173993560e-05, 4.18182613113035062e-05, 5.44088287334411160e-05, 6.37483886190397128e-05, 7.98622561988061500e-05, 9.39594468707383970e-05, 1.19863230335894889e-04, 1.44262209612616471e-04, 1.84738522697448874e-04, 2.17222502180424646e-04, 2.85572196491344350e-04, 3.42902529753643477e-04, 4.21331708513217925e-04, 5.16197886827367974e-04, 6.34805049213570723e-04, 7.42380961099289079e-04, 9.57637347038556969e-04, 1.13561953833009777e-03, 1.41087834967330199e-03, 1.71777527723722357e-03, 2.12368203033423512e-03, 2.46646098645275907e-03, 3.11527112065549186e-03, 3.62667500587332851e-03, 4.43587928402845721e-03, 5.33687205341344759e-03, 6.45695425771969887e-03, 7.46046443497142778e-03, 9.29452926649510999e-03, 1.06725815156746371e-02, 1.25782272943077977e-02, 1.48506615710087622e-02, 1.74640612822016643e-02, 1.97617862027634379e-02, 2.37522797649091857e-02, 2.63864285073979500e-02, 3.01161470918277357e-02, 3.43826889634528607e-02, 3.85551558496494279e-02, 4.16326555169203374e-02, 4.74962925540437925e-02, 5.00883524387661233e-02, 5.35302498042324604e-02, 5.69786758054173087e-02, 5.90920017795724048e-02, 5.81017371553118889e-02, 5.95567052303450084e-02, 5.54353465159049888e-02, 5.14150353768360463e-02, 4.58102808716541743e-02, 3.85887750490160608e-02, 2.99920224843405782e-02, 2.35879784078477130e-02, 1.65329773144723968e-02, 1.12191910900623099e-02, 7.42744353524652651e-03, 4.63948398736949586e-03, 2.80176224741428455e-03, 1.69550370065072180e-03, 9.75387439682700707e-04, 5.40238305999310594e-04, 3.15736053916705682e-04, 1.68970182619011930e-04, 9.30212943722344497e-05, 5.05320823752344515e-05, 2.73648508012004106e-05, 1.38485106739679551e-05, 7.93388308724349288e-06, 3.90600210600124702e-06, 2.00456708225920443e-06, 1.07680659522905772e-06, 5.47210178921974821e-07, 2.57630980769350199e-07, 1.38595074575550187e-07, 6.69830729504648764e-08, 3.39731815940446975e-08, 1.53326523920751175e-08, 7.71759054657571979e-09, 3.87656388740411271e-09, 1.98219849249647217e-09, 8.41570861054589443e-10, 3.08794972986872820e-10, 2.36455210601063132e-10, 1.29094168041917680e-10, 3.81402817075353323e-11, 9.42098676896947527e-12, 6.53881059669969398e-12, 7.98669008596891193e-12, 3.20232529897043869e-12, 1.77529660879783966e-13, 0.00000000000000000e+00, 2.00167671327541652e-13, 7.89550259125303184e-14, 7.00586849646395783e-14, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[4][22] = niz4_22;
	static double niz4_23[] = { 1.13686837721612799e-13, 1.47147676154940939e-23, 9.27030359776127914e-22, 1.85406071955225583e-20, 2.78109107932838374e-19, 2.85339944739092172e-18, 2.47823026078952275e-17, 1.66312424933642294e-16, 9.42640888870215211e-16, 4.37045682025376177e-15, 1.70989961884900984e-14, 5.57222220084489706e-14, 1.53939473487016531e-13, 3.53621793515156929e-13, 6.85726917054523885e-13, 1.09234000696416259e-12, 1.45254153579075674e-12, 1.51641345572087883e-12, 1.35754045458932339e-12, 7.98112345116252015e-13, 6.78719879812307076e-13, 1.55033716992081581e-13, 9.34119329377503694e-13, 7.77708017544828334e-15, 2.69962405662953159e-12, 3.21823576613611654e-13, 5.77143911306234851e-12, 3.95296995848987186e-12, 1.56357742921773568e-11, 1.34696626870850438e-11, 3.72169556381804103e-11, 2.91549577121336796e-11, 4.81947583546865331e-11, 4.09257030088018630e-11, 3.78850531700741873e-11, 2.43905444580948042e-11, 5.70129037770881970e-11, 2.18075350557881678e-11, 3.70094095738226143e-11, 9.23982231452364630e-11, 1.27520752845718102e-10, 1.31999572250922804e-10, 2.76740682985266600e-10, 2.98958103343003228e-10, 5.08138146178515210e-10, 7.38807981851896042e-10, 7.86003685460383242e-10, 8.58270708522209300e-10, 1.16322963825448923e-09, 8.69384637695438253e-10, 1.07515814794836137e-09, 9.84375313048268153e-10, 1.65734908959653206e-09, 1.67961638398693739e-09, 3.07105740678747347e-09, 3.65495701492602193e-09, 5.91913910109075884e-09, 6.65761710314999013e-09, 9.05794783471189558e-09, 9.99939550308788284e-09, 1.62626101356201917e-08, 1.49499937622118216e-08, 1.94393078505614001e-08, 1.82398381504897542e-08, 2.29527475704866782e-08, 2.73338192627888223e-08, 3.74722816055598681e-08, 4.40994485520447242e-08, 6.04753898950129553e-08, 7.71112623574950387e-08, 1.05217972758291159e-07, 1.24850292539338525e-07, 1.71739905106042226e-07, 1.86571749390759831e-07, 2.32141484223575322e-07, 2.61053525042986181e-07, 3.14652873104913681e-07, 3.44435827250565087e-07, 4.86879730310015226e-07, 5.30988499130114505e-07, 7.64804884752237044e-07, 9.12706396528009926e-07, 1.22201578230577824e-06, 1.40158788753427371e-06, 1.90062614369995852e-06, 2.06368750261449531e-06, 2.73092143883445453e-06, 3.08962461189288840e-06, 3.78068173925883252e-06, 4.38023592461198923e-06, 5.83746553895718508e-06, 6.68805836877385114e-06, 8.95127435918868592e-06, 1.07145457962036574e-05, 1.38949830832353579e-05, 1.63532570931638093e-05, 2.11323457172937890e-05, 2.37652409564678830e-05, 3.01828631543795752e-05, 3.45185936653359362e-05, 4.42334483244515459e-05, 5.24743441002912628e-05, 6.95183973297080153e-05, 7.90222951932776079e-05, 1.05126549971256249e-04, 1.21412501234949768e-04, 1.52540287559844534e-04, 1.81368388135731945e-04, 2.26500399363116392e-04, 2.58667812250549232e-04, 3.37174655548598133e-04, 3.92491793292441089e-04, 4.93593162669394517e-04, 5.90661229261050928e-04, 7.45923170185661469e-04, 8.54287800281104855e-04, 1.09478124984794677e-03, 1.24947295355174858e-03, 1.54349358949068169e-03, 1.84147659291948075e-03, 2.28195296062726205e-03, 2.61674475739236871e-03, 3.34083778683899385e-03, 3.81664712311119685e-03, 4.61913356749237523e-03, 5.44118747775721497e-03, 6.54876097547366174e-03, 7.49231807926737953e-03, 9.28544870337902339e-03, 1.05260184884533557e-02, 1.24197338529188992e-02, 1.44835051147503419e-02, 1.69264138012498143e-02, 1.88734740217121576e-02, 2.26017131654924763e-02, 2.50280303074798573e-02, 2.84202514163734328e-02, 3.24201258233989958e-02, 3.60857784403828402e-02, 3.88756282583173837e-02, 4.40889401981592738e-02, 4.68317620215628200e-02, 5.01152102510333888e-02, 5.36591250859169491e-02, 5.55050645113727356e-02, 5.56617136560822040e-02, 5.73597228256517433e-02, 5.49905501736240171e-02, 5.16422588015308590e-02, 4.80637804228441420e-02, 4.18327887797743034e-02, 3.42125791548033437e-02, 2.82670347086315943e-02, 2.09115205069247898e-02, 1.51709059856304975e-02, 1.05370399343179561e-02, 7.06063159982608241e-03, 4.37794159183798551e-03, 2.88066990648527550e-03, 1.68277965743468387e-03, 1.02622548010533957e-03, 5.92539335672560927e-04, 3.53436428139802523e-04, 1.88050500234897982e-04, 1.16161128381562273e-04, 5.99856589848843635e-05, 3.50269238551446070e-05, 1.85642009652427724e-05, 1.07424107949940870e-05, 5.31776226552509346e-06, 3.21660792477572229e-06, 1.53355316301885162e-06, 9.01899875067430565e-07, 4.17473968255573173e-07, 2.59894618193046276e-07, 1.12723106448120872e-07, 6.77171466304083444e-08, 2.84334341633579536e-08, 1.90266824193695460e-08, 7.52370602616373005e-09, 4.36507762658436195e-09, 1.78139767920764770e-09, 1.28865481034105692e-09, 4.70717585922996975e-10, 2.98628086113791644e-10, 7.45910380576995596e-11, 7.17290710260065787e-11, 4.29201139279682787e-11, 1.65803059767136038e-11, 3.01524540473572035e-12, 3.00147004772030615e-12, 9.12207567049151687e-13, 2.08697882172247715e-12, 2.15120672965402651e-13, 3.59676284416676407e-14, 2.77464562264293228e-14, 2.39784189611117604e-14, 2.87741027533341125e-14, 1.11899288485188215e-14, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[4][23] = niz4_23;
	static double niz4_24[] = { 2.84217094304038055e-14, 1.00327961014732458e-24, 6.62164542697234224e-23, 1.39054553966419187e-21, 2.19010922497110220e-20, 2.37783287282576810e-19, 2.18176595173311705e-18, 1.55917898375289651e-17, 9.41451972433802327e-17, 4.68150000604673248e-16, 1.97098566828527918e-15, 6.96527775105612132e-15, 2.09611047655274313e-14, 5.30432690272735393e-14, 1.14038350871686851e-13, 2.04704608776917783e-13, 3.09066305080688220e-13, 3.79103363930219707e-13, 3.89799331758764577e-13, 2.99292129418594506e-13, 2.19194015628317804e-13, 8.25738776205775861e-14, 1.46368525721631749e-13, 2.83873280981735954e-15, 3.85229823288669805e-13, 1.43187133251303795e-14, 8.39395186639963885e-13, 3.00094569833612861e-13, 2.12909798264786994e-12, 1.34597905456659693e-12, 5.77966136138325731e-12, 4.78899730018297165e-12, 1.04313458506232285e-11, 9.83019792361215600e-12, 1.21764428172355118e-11, 8.25600451613172450e-12, 1.38369587744763839e-11, 4.68578224191243739e-12, 6.10963644993569698e-12, 1.27345882286644610e-11, 1.54881303065292075e-11, 1.43660662377686049e-11, 3.79640603820978425e-11, 3.45859223291737961e-11, 6.19815862172787239e-11, 1.01625363408498358e-10, 1.14343074485822606e-10, 1.60586849656546120e-10, 2.60458315820437166e-10, 2.37150143452176254e-10, 2.63310420271738037e-10, 2.38273373691822584e-10, 2.78416492778369432e-10, 2.26216333011305793e-10, 3.72922365759787085e-10, 4.09680166229585045e-10, 7.07704389553761867e-10, 7.11437896795747906e-10, 1.17725214633621617e-09, 1.40019324550797904e-09, 2.45509796614379915e-09, 2.33664879802229534e-09, 3.07880962009372039e-09, 4.08544159369358411e-09, 4.61993627680997305e-09, 5.33812208876747915e-09, 5.29031237278903436e-09, 5.56583486840255788e-09, 7.13066819949663619e-09, 8.54153707389035929e-09, 1.21831357619098326e-08, 1.47084173756627888e-08, 2.14917418934180182e-08, 2.48765425650461182e-08, 3.29290756743451282e-08, 4.04281914369795870e-08, 5.01780913518539529e-08, 5.77249325448043329e-08, 7.22666806489435310e-08, 7.45590003607026670e-08, 9.20418734001618699e-08, 1.05786312527628521e-07, 1.33447103169649734e-07, 1.56936668880201074e-07, 2.19957911972786779e-07, 2.49769358261726874e-07, 3.33809130843588028e-07, 4.15122475139580659e-07, 5.16023984279381943e-07, 6.17221557867518069e-07, 7.58246094479357884e-07, 8.31722569737192508e-07, 1.00931575326459857e-06, 1.20173390458427510e-06, 1.44427148137686261e-06, 1.76860607386074091e-06, 2.29563618314970519e-06, 2.72989855841463021e-06, 3.51528370608377708e-06, 4.19188623966120853e-06, 5.27276819184702031e-06, 6.18450837769203951e-06, 7.70158160742380020e-06, 8.57378744836463431e-06, 1.08091773332299868e-05, 1.28129906879268681e-05, 1.58623885377511482e-05, 1.91038005471254807e-05, 2.42049022767940751e-05, 2.83255513657971122e-05, 3.65410723573373133e-05, 4.28849153885360536e-05, 5.23622025814579812e-05, 6.30407673066605038e-05, 7.70228512527813537e-05, 8.83093730540518131e-05, 1.11624135907795679e-04, 1.31995428051497228e-04, 1.63518156066676647e-04, 1.98282443184913149e-04, 2.46049347845567591e-04, 2.85471446399819648e-04, 3.58881241413986426e-04, 4.15360669004393639e-04, 5.04375456423928757e-04, 6.06150063756745938e-04, 7.42133761778396945e-04, 8.56427162030787650e-04, 1.08818737808736915e-03, 1.26089705447673776e-03, 1.52565777269936817e-03, 1.83441674432466045e-03, 2.19664496593862790e-03, 2.51920954994088765e-03, 3.11260453168393184e-03, 3.59163028536675644e-03, 4.32833368435052955e-03, 5.12567416168180010e-03, 6.09275565416119661e-03, 6.91042120992985641e-03, 8.42629269211331647e-03, 9.53519330749682745e-03, 1.11415764361664973e-02, 1.30541748956845491e-02, 1.51356023902195855e-02, 1.68879605356592050e-02, 2.00929921241558944e-02, 2.21809324426675142e-02, 2.51323891389969162e-02, 2.86052262982214416e-02, 3.20003515974412386e-02, 3.45286226566533794e-02, 3.93939469651056681e-02, 4.17973714360075493e-02, 4.52790501124861397e-02, 4.86762238714533238e-02, 5.14932264531775125e-02, 5.19709874080925630e-02, 5.52223705292798905e-02, 5.38094711152656488e-02, 5.28305385043035328e-02, 5.09183350506143967e-02, 4.70587693815588473e-02, 4.06584585464494150e-02, 3.61338915376398020e-02, 2.86952419132356605e-02, 2.24505251437022053e-02, 1.69175018054990162e-02, 1.21375285198534830e-02, 8.16940999500233994e-03, 5.62513170392225318e-03, 3.57286069155458375e-03, 2.24302999516263731e-03, 1.42188377812393647e-03, 8.51913993637815731e-04, 5.06173853244836717e-04, 3.03888761666614858e-04, 1.76900211243633334e-04, 9.98779529859463203e-05, 5.95597666268727117e-05, 3.30891230308994884e-05, 1.88817214566745642e-05, 1.06167775014333897e-05, 6.01775664177734411e-06, 3.21404701550934043e-06, 1.86026129007161365e-06, 9.95296427552333332e-07, 5.53173362236776721e-07, 2.90600363586212459e-07, 1.58150578497757670e-07, 8.45560936641502484e-08, 4.69149545764479137e-08, 2.38804535195351375e-08, 1.21372103120220071e-08, 6.30294331014595293e-09, 3.87419924476411329e-09, 1.68860401468067885e-09, 8.65795407346891053e-10, 4.69111919612661220e-10, 2.54295051819102738e-10, 1.55061124144656888e-10, 5.37189804543945400e-11, 2.13212675913782758e-11, 1.90089528008574734e-11, 1.16885158249230100e-11, 4.79935395838986919e-12, 1.25407131166614507e-12, 4.75186608614460619e-13, 4.18428763197061182e-13, 4.90016118912433904e-13, 1.89209299822731881e-13, 7.70734895178592300e-15, 4.49595355520845508e-15, 1.05333769007740948e-14, 3.08293958071436920e-15, 7.19352568833352813e-15, 6.99370553032426346e-16, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[4][24] = niz4_24;
	static double niz4_25[] = { 7.10542735760098924e-15, 6.81575822110954200e-26, 4.70287317256558398e-24, 1.03463209796442848e-22, 1.70714296164130698e-21, 1.95545466515276982e-20, 1.89027284298101082e-19, 1.43306891889052988e-18, 9.18470072455594724e-18, 4.87569341533638955e-17, 2.19816849169819611e-16, 8.37172806617322274e-16, 2.72675620368836181e-15, 7.53455525955590047e-15, 1.77965663692420453e-14, 3.55300777060529073e-14, 6.01656072234702839e-14, 8.46212865915668990e-14, 9.99063996804532907e-14, 9.35287904433107831e-14, 7.48789446698893396e-14, 4.06684594517548146e-14, 3.27227745470208437e-14, 4.27828604587886389e-15, 5.38357217070974490e-14, 7.84883005788303671e-16, 1.25622070200821386e-13, 2.24364075403914550e-14, 3.02344170189703197e-13, 9.62017761255455772e-14, 8.04222544033408551e-13, 5.60806223514918331e-13, 1.78218394807539027e-12, 1.78598073219677874e-12, 2.97428597809908784e-12, 2.38671925247482839e-12, 3.84086357508678843e-12, 1.85078540010126036e-12, 2.08489855087577354e-12, 2.29863295126264148e-12, 2.26780253821326591e-12, 1.43829734908214792e-12, 5.26821761065282550e-12, 3.80343527128789765e-12, 7.64157997526995232e-12, 1.39499631393874253e-11, 1.33806387985752464e-11, 1.97738569224368154e-11, 3.99716586427095578e-11, 4.23430687576779568e-11, 5.75104775565063084e-11, 6.70351500057445500e-11, 7.31887153472785286e-11, 6.02589415743308442e-11, 7.11961836367617588e-11, 6.56440334214151383e-11, 9.48616919019677659e-11, 7.92484200730417833e-11, 1.27286630859243775e-10, 1.48552705419929325e-10, 3.13243187942949302e-10, 2.98078215671487621e-10, 4.63348889891091721e-10, 5.82454293504469544e-10, 7.72414709909735689e-10, 8.35920793095336165e-10, 1.24227894146856117e-09, 1.18216468092274080e-09, 1.53549015706253557e-09, 1.25295231040341831e-09, 1.62834856593637030e-09, 1.70468448792829151e-09, 2.49720921439631430e-09, 2.85950030150687698e-09, 3.89245209582664838e-09, 4.93850942633513399e-09, 6.42020363629696831e-09, 8.00309579304656230e-09, 1.07522458498084902e-08, 1.23242393853164724e-08, 1.57843115251069955e-08, 1.78565809813409506e-08, 2.06110041642735993e-08, 2.15652436869087234e-08, 2.80711961089949059e-08, 2.83911147844825511e-08, 3.84634829793085966e-08, 4.46429939647602029e-08, 6.11396351912118013e-08, 6.95375145553475112e-08, 1.01165582226834523e-07, 1.10075320708494046e-07, 1.48962245287707469e-07, 1.68381390592272743e-07, 2.07479286819560419e-07, 2.28417678648083434e-07, 2.89313050224391880e-07, 3.05844619566153504e-07, 3.93009191240023541e-07, 4.59274792826892967e-07, 5.77945188716397304e-07, 6.82900766171088247e-07, 8.91244323639727659e-07, 1.03179232150114832e-06, 1.35922031355135507e-06, 1.56890977404092377e-06, 1.95193284823781555e-06, 2.22343911165017811e-06, 2.80991258416610559e-06, 3.00061266844272582e-06, 3.81743054868625628e-06, 4.39538697314601784e-06, 5.66169580466927711e-06, 6.64642714574781840e-06, 8.53750987783521275e-06, 9.68234140719715835e-06, 1.27453275539457581e-05, 1.44865894468011326e-05, 1.78774865970877153e-05, 2.06461904111878599e-05, 2.56620894646075422e-05, 2.87629507382933567e-05, 3.69253470964768686e-05, 4.28647219326323288e-05, 5.34417923206798420e-05, 6.32196432775766385e-05, 7.92505476231803249e-05, 9.00451106568713573e-05, 1.15517784349485154e-04, 1.31700989832753444e-04, 1.61492991552242743e-04, 1.89013508311039826e-04, 2.32808498989938681e-04, 2.64185802479657492e-04, 3.39342115838967180e-04, 3.89428660583017255e-04, 4.79438671014184971e-04, 5.67604830944427939e-04, 6.91609424755766189e-04, 7.81368430022186971e-04, 9.85197726171161553e-04, 1.11745559123995700e-03, 1.35793674645644431e-03, 1.60385620007137751e-03, 1.94431313303350048e-03, 2.21599684480336661e-03, 2.73751276313354474e-03, 3.11505565269955221e-03, 3.71976779854364540e-03, 4.36210170042448334e-03, 5.16252017127102371e-03, 5.80328533698928895e-03, 7.12095341834538195e-03, 8.03226271160295026e-03, 9.39328412723775506e-03, 1.09203963564741390e-02, 1.25659623527797533e-02, 1.39802238441281285e-02, 1.66584864206108588e-02, 1.85033485347812637e-02, 2.09697948475815639e-02, 2.38873173814455296e-02, 2.67115527977929909e-02, 2.90767814817421734e-02, 3.32123969209568506e-02, 3.57321881086613211e-02, 3.88546116578709702e-02, 4.26694895527158086e-02, 4.53628259131006045e-02, 4.69995590202873514e-02, 5.07142752733571664e-02, 5.13771198415921906e-02, 5.15850759340317558e-02, 5.24166051282860326e-02, 5.05168139712977443e-02, 4.71377341413208792e-02, 4.45461723788746697e-02, 3.87982833363914106e-02, 3.29078606371336763e-02, 2.73779712474991402e-02, 2.14651423451413734e-02, 1.58114435915009677e-02, 1.19315100352153352e-02, 8.14957828767436804e-03, 5.57310957133859679e-03, 3.70375610352906108e-03, 2.41987280181747049e-03, 1.48018780533337919e-03, 9.77832091541884409e-04, 5.73774549735292429e-04, 3.55579933586544624e-04, 2.10385989578186781e-04, 1.29655325115436042e-04, 7.17753787642611625e-05, 4.54451642256971920e-05, 2.47320274129614235e-05, 1.51019272127413108e-05, 8.32624629441735729e-06, 5.04196110741354331e-06, 2.66019712014071768e-06, 1.66514394947976351e-06, 8.41081058332924273e-07, 5.15856951187666521e-07, 2.72743591094518073e-07, 1.64851374201636251e-07, 7.56363288302551189e-08, 5.06772621237148350e-08, 2.39915776978692358e-08, 1.52842263758345098e-08, 6.86374936460780510e-09, 4.30911106248184085e-09, 1.84164547699123937e-09, 1.38671095520296869e-09, 6.02370370429088521e-10, 3.26479963924441909e-10, 1.44754396768396294e-10, 1.11501786577256805e-10, 4.50669768282840957e-11, 3.53616330908060656e-11, 7.97427553399490543e-12, 5.48412668036364677e-12, 4.11445698599896173e-12, 2.94307980669447600e-12, 1.08986731271347817e-12, 3.03586778807108340e-13, 1.07938567496076005e-15, 2.02016841665951341e-13, 7.97878832459187564e-14, 6.92401378994714827e-14, 9.36656990668428142e-16, 2.00712212286091745e-15, 1.58658224949958236e-15, 1.40498548600264221e-15, 1.60569769828873396e-15, 6.24437993778952095e-16, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[4][25] = niz4_25;
	static double niz4_26[] = { 1.77635683940024968e-15, 4.61483629554291906e-27, 3.32268213279090172e-25, 7.64216890541907397e-24, 1.31827413618479026e-22, 1.58880691543662548e-21, 1.61402607282450842e-20, 1.29374277399839503e-19, 8.77248389737508210e-19, 4.95121412206958871e-18, 2.38007815380736315e-17, 9.71718436252249068e-17, 3.40633703004958443e-16, 1.02030435806486152e-15, 2.62713288337086815e-15, 5.77291313128015834e-15, 1.08453486437204957e-14, 1.71886988389120264e-14, 2.30451812846786110e-14, 2.53307140783966704e-14, 2.33443136797100252e-14, 1.63434132722958145e-14, 1.09228071592038802e-14, 3.47564286902901802e-15, 7.96118311694478269e-15, 1.68634259351407008e-16, 1.83905641630871571e-14, 1.98093157362911608e-15, 4.51387956205430737e-14, 4.93639722261462979e-15, 1.12063355931712672e-13, 4.76420143243845675e-14, 2.60662119778635527e-13, 2.41694074321180958e-13, 5.60735524231907198e-13, 5.03858361761338315e-13, 9.39953242409936815e-13, 6.15699652504947648e-13, 7.75570854371013180e-13, 6.28490220999254240e-13, 5.84306140275687701e-13, 2.38406174136515129e-13, 8.29841222763700580e-13, 3.74231759498853805e-13, 8.95165161827850266e-13, 1.92928237642757863e-12, 1.57921239006508370e-12, 2.35830125336586382e-12, 5.51279210592925404e-12, 5.21090031673374193e-12, 8.00953978483298684e-12, 1.20827319106450701e-11, 1.55534739134357907e-11, 1.64383826400887691e-11, 1.98209801262940517e-11, 1.80980962398580407e-11, 2.00529644369717260e-11, 1.53561584576375361e-11, 1.69619986017429849e-11, 1.72308012206979770e-11, 3.97609432315442437e-11, 3.11217376172565382e-11, 5.32754687763429292e-11, 6.67790418745614243e-11, 1.09605880753740283e-10, 1.25545823080172770e-10, 1.86708980824562069e-10, 1.90087856370355814e-10, 2.53878612551632436e-10, 3.16675199659430051e-10, 3.73578962416106822e-10, 3.91913303411630244e-10, 3.91270817783549455e-10, 3.77528325380401258e-10, 4.75814876961647177e-10, 5.83183286544033528e-10, 7.41025829951897698e-10, 9.37250130918166969e-10, 1.28298188201570468e-09, 1.54229868978473854e-09, 2.12880922291536173e-09, 2.58430957394254803e-09, 3.25944599326925691e-09, 3.81325268341146302e-09, 4.91681894666456919e-09, 5.10531274490908266e-09, 5.94245622268430933e-09, 6.46429562583707075e-09, 7.60925476467920156e-09, 8.19776534673091654e-09, 1.13990435756946053e-08, 1.25450794749398881e-08, 1.68939455155120814e-08, 2.04965977326480584e-08, 2.60624824498585963e-08, 3.13335771323445060e-08, 4.12895381731001158e-08, 4.69100939061362273e-08, 5.73798655306734553e-08, 6.73230839540738210e-08, 7.53510786873437076e-08, 8.59429684724443859e-08, 1.03352778101812911e-07, 1.16248274084864255e-07, 1.45621203473524504e-07, 1.73680408179566910e-07, 2.19308578003008184e-07, 2.69379580089301525e-07, 3.41191741654191513e-07, 3.89036847956874955e-07, 4.96929751567802806e-07, 5.83219940547221293e-07, 6.83863018472508462e-07, 7.75410182766487213e-07, 9.48474128835391500e-07, 1.06094890570994758e-06, 1.32717860589101532e-06, 1.53741451006691688e-06, 1.93100660640910913e-06, 2.30538368332061360e-06, 2.89223994647141183e-06, 3.32777461842913672e-06, 4.18788328373193535e-06, 4.87651559605229926e-06, 5.83639727314822006e-06, 6.89867049952370135e-06, 8.33762442216255101e-06, 9.40870121212464425e-06, 1.16170575685677691e-05, 1.36009629362838739e-05, 1.66349202416265670e-05, 2.01158893003103424e-05, 2.47839382198249676e-05, 2.84557114204426921e-05, 3.57692919068284914e-05, 4.11631491940118053e-05, 4.94193709755712552e-05, 5.81043176275625688e-05, 7.02333618194520069e-05, 8.01165159518818623e-05, 1.01296210181887832e-04, 1.17191462716045476e-04, 1.42076951161513199e-04, 1.70236050565228126e-04, 2.05821509796255876e-04, 2.35478985584479953e-04, 2.92194156604675803e-04, 3.34560922432951117e-04, 4.00657657856145165e-04, 4.75282300343947677e-04, 5.69676014710288514e-04, 6.55665254392609129e-04, 8.15589645139800550e-04, 9.37883415906384994e-04, 1.11701132069517029e-03, 1.31596204727748548e-03, 1.56453700922361597e-03, 1.77796608793923724e-03, 2.18358598439600355e-03, 2.48170849870754879e-03, 2.94215855903001092e-03, 3.46962670796678672e-03, 4.07762975159483166e-03, 4.58996291957496430e-03, 5.57507264710055059e-03, 6.27061508452761429e-03, 7.27631288312090979e-03, 8.48346509185914956e-03, 9.79442245222976113e-03, 1.09258925828082769e-02, 1.29993484431536431e-02, 1.43975339886154349e-02, 1.63938472925654090e-02, 1.86736383328865059e-02, 2.10614861690799592e-02, 2.29759765318454066e-02, 2.66140554834746329e-02, 2.86839032255083136e-02, 3.16254809258688444e-02, 3.49178927653597954e-02, 3.80701409847134589e-02, 3.98248582601275630e-02, 4.42234153333613128e-02, 4.54085675771631336e-02, 4.76036999157002580e-02, 4.95913727042141539e-02, 5.04534364728090740e-02, 4.89980047462687321e-02, 4.99740376481324286e-02, 4.65401405242908128e-02, 4.34446260088285838e-02, 3.94731404300006847e-02, 3.45316496333357842e-02, 2.82033739910337866e-02, 2.36815895563507843e-02, 1.79157481668411160e-02, 1.34853170060580500e-02, 9.91563540787362453e-03, 6.98137314370783982e-03, 4.65206928035707436e-03, 3.23199464667871380e-03, 2.07528620412176807e-03, 1.33034172721631047e-03, 8.63781363248833887e-04, 5.34555026269259805e-04, 3.27352119065961130e-04, 2.04571625545425426e-04, 1.23812328596122832e-04, 7.35143069547352312e-05, 4.53433839030273786e-05, 2.65094288833396565e-05, 1.57355624535134729e-05, 9.41178852056074270e-06, 5.54785934115592994e-06, 3.15102356699274900e-06, 1.91357068744305949e-06, 1.07636828010652700e-06, 6.27683955059495137e-07, 3.58540943292639837e-07, 2.08705100117523632e-07, 1.14358633761188849e-07, 6.89231864849879054e-08, 3.67198374838734258e-08, 2.05578901823329831e-08, 1.16919741753525785e-08, 6.69823449210562246e-09, 3.74926250892756297e-09, 1.99816987389871810e-09, 9.98081706214710156e-10, 6.27338799897361627e-10, 3.44543537644976453e-10, 2.03386377865938190e-10, 9.09577751066365866e-11, 4.66076454487295191e-11, 3.01259106658272351e-11, 1.82611019096847789e-11, 1.05360601504399942e-11, 3.84815684504417499e-12, 1.67285584522425358e-12, 1.15891329123443414e-12, 9.68958463234608746e-13, 5.86914533738562736e-13, 1.42810323188202242e-13, 4.72203356099181676e-14, 2.98563398160725877e-14, 2.57943865960811619e-14, 2.95715992768175171e-14, 1.16691850087441673e-14, 4.21286570579661318e-16, 6.08956471452321506e-16, 0.00000000000000000e+00, 6.52314689929798171e-16, 2.51089384615835010e-16, 2.17438229976599390e-16, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[4][26] = niz4_26;
	static double niz4_27[] = { 4.44089209850062567e-16, 3.11501449949147037e-28, 2.33626087461860277e-26, 5.60702609908464666e-25, 1.00926469783523640e-23, 1.27671984276157404e-22, 1.35990007494149478e-21, 1.14904785848541664e-20, 8.21888398777763291e-20, 4.91430746142975876e-19, 2.50923326096752859e-18, 1.09318324078378020e-17, 4.10412909836132454e-17, 1.32443354171881063e-16, 3.69276822404194162e-16, 8.85558858384955943e-16, 1.82856000329597276e-15, 3.22288103229600474e-15, 4.84761172323721416e-15, 6.10651142961348305e-15, 6.47310825457610431e-15, 5.50175490216616453e-15, 3.99314369734826079e-15, 1.95504911382882264e-15, 1.64191897085453067e-15, 1.82154218780135415e-16, 2.60323005136304386e-15, 2.04075240782366632e-16, 6.74655633896640169e-15, 1.80303429340160417e-16, 1.64372719595077786e-14, 2.96181638869865752e-15, 3.65723151427848418e-14, 2.47984666354197259e-14, 8.74770647835395604e-14, 7.76109589119266912e-14, 1.86852188527973867e-13, 1.47687793052944292e-13, 2.27606843948277952e-13, 1.87388966329350583e-13, 2.01248842680526316e-13, 9.57893050160385458e-14, 1.86848455542515940e-13, 5.43872146715462751e-14, 1.19404258990716430e-13, 2.62964319707928758e-13, 1.71568930222039049e-13, 2.64322822905299236e-13, 7.88917686096672352e-13, 6.31163796687895905e-13, 9.72395331898634917e-13, 1.65496971979983841e-12, 2.16617840455253335e-12, 2.72423689423606932e-12, 4.16801749762722718e-12, 4.59999931067162368e-12, 5.42425571688388408e-12, 4.91329156149292987e-12, 4.27917547218438883e-12, 3.73418696849272414e-12, 6.49270721171354522e-12, 4.01581093472494735e-12, 6.01948474699304058e-12, 7.36589639810372791e-12, 1.30711624068160123e-11, 1.44756792757813876e-11, 2.30987977085194308e-11, 2.53090138236439533e-11, 4.06584702199281581e-11, 4.60954029323085181e-11, 6.46782666348195645e-11, 6.28990138418606930e-11, 1.01877444754540493e-10, 9.00567959533395646e-11, 1.15290923178242112e-10, 9.53102818554030900e-11, 1.07381708960280098e-10, 1.20480214444529925e-10, 1.52364691528106875e-10, 1.74580795432941919e-10, 2.51163205867973435e-10, 3.04088640371727752e-10, 3.99471939560228678e-10, 4.95824334897742513e-10, 6.89748095546215807e-10, 7.93507465413973561e-10, 9.97908924994503994e-10, 1.16915333554697970e-09, 1.40971915710653292e-09, 1.49968097544816670e-09, 1.85457715181103703e-09, 1.80500836912979786e-09, 2.14872480695493695e-09, 2.37030378675159112e-09, 3.05606970852083927e-09, 3.39297264748318319e-09, 5.00586083171103560e-09, 5.32006368999336645e-09, 7.55801197296845998e-09, 8.71699366437002317e-09, 1.13885573169206542e-08, 1.26548846416057036e-08, 1.68480234833968231e-08, 1.75282819452627097e-08, 2.16732833744017405e-08, 2.30372926167007803e-08, 2.70889123190278064e-08, 3.00534754476069712e-08, 3.84595361833283693e-08, 4.33223127237427119e-08, 5.72144169255255571e-08, 6.66889733849589024e-08, 8.21905632266921697e-08, 9.78590721854569765e-08, 1.26967292471068270e-07, 1.41536736406176307e-07, 1.79690256800167321e-07, 2.00231052530798138e-07, 2.41607085896638497e-07, 2.65684025843611381e-07, 3.25764534669048994e-07, 3.54540075564051685e-07, 4.54548232058935860e-07, 5.18009614905230457e-07, 6.60896388950861738e-07, 7.58847487417714866e-07, 9.91131414048274263e-07, 1.09674745899394109e-06, 1.41166967136320705e-06, 1.58763726130717016e-06, 1.92893219346111506e-06, 2.19208830587573421e-06, 2.65796011139755030e-06, 2.93631137580714788e-06, 3.71314287808328068e-06, 4.23728788816004113e-06, 5.21587178820948570e-06, 6.16993484140853296e-06, 7.69089664723262885e-06, 8.66994667946062014e-06, 1.09976561721278855e-05, 1.24018292225492635e-05, 1.50947146320870456e-05, 1.73631893393636791e-05, 2.13428253376823798e-05, 2.36606812481846854e-05, 2.99431333917036999e-05, 3.38741311064716345e-05, 4.13028583533218697e-05, 4.87087136048627774e-05, 5.98508682625146794e-05, 6.80504895716639303e-05, 8.57625822568283333e-05, 9.62895126747489256e-05, 1.15884982068658061e-04, 1.34550944758895537e-04, 1.62808951998431655e-04, 1.83495743351482193e-04, 2.31137271482697535e-04, 2.62995168764913474e-04, 3.17577999385412464e-04, 3.71964159043080265e-04, 4.48476005253295093e-04, 5.06896507184516234e-04, 6.25711662200911659e-04, 7.03802124952482072e-04, 8.40331997060453991e-04, 9.86675702960769030e-04, 1.17621029688949087e-03, 1.32625405739673669e-03, 1.63933710102707022e-03, 1.85215549421765689e-03, 2.18381453920112522e-03, 2.54420793825005029e-03, 2.98040762385040365e-03, 3.34738046379612049e-03, 4.06655064425166714e-03, 4.57460386593800099e-03, 5.32940092210535364e-03, 6.18688226895380139e-03, 7.13731958169543188e-03, 7.95577565812257206e-03, 9.46633122072901463e-03, 1.05095140442163972e-02, 1.19634557025313434e-02, 1.37760309912718787e-02, 1.55646914855909722e-02, 1.70939082310000053e-02, 1.98175045208609721e-02, 2.16650515991937617e-02, 2.40104408726950005e-02, 2.69299221664087707e-02, 2.94919286471804938e-02, 3.16698500451876100e-02, 3.54701596112905471e-02, 3.75185836977136103e-02, 3.98167834262681750e-02, 4.31407986398489110e-02, 4.49409461845844058e-02, 4.58820206163666477e-02, 4.84466511426767180e-02, 4.82458082936849803e-02, 4.75498660615321714e-02, 4.73957541211873154e-02, 4.48620780855536819e-02, 4.11325555483862404e-02, 3.81535373022072605e-02, 3.27941875355581280e-02, 2.74853288372477675e-02, 2.28504960793714171e-02, 1.78885299995531384e-02, 1.33148573206596614e-02, 1.02128227676883294e-02, 7.15154342076063359e-03, 5.00870883772712265e-03, 3.44439280758436321e-03, 2.32744578886033516e-03, 1.48906635159283714e-03, 1.01469577142274808e-03, 6.25774425537604559e-04, 4.04324441404250133e-04, 2.51854883896939668e-04, 1.60723550701445098e-04, 9.45674426380612592e-05, 6.18244419998028298e-05, 3.58636805983577201e-05, 2.25929914813520331e-05, 1.33148880456033652e-05, 8.38447518265565254e-06, 4.67798724006610777e-06, 3.06301244870397373e-06, 1.68604251988590224e-06, 1.05774217639756862e-06, 5.94678594516882861e-07, 3.73106469237963041e-07, 2.01038284578910254e-07, 1.30347337330675205e-07, 6.71571272443431389e-08, 4.31875659285769278e-08, 2.28697017221328136e-08, 1.48698956926422748e-08, 7.10078733173478855e-09, 4.76615579270472310e-09, 2.35282031166420807e-09, 1.61014973897085161e-09, 7.78866228556700192e-10, 4.95647823133439929e-10, 2.05529498176482675e-10, 1.62603165154357871e-10, 8.68760867578885624e-11, 5.19800565907161430e-11, 2.07730084837631277e-11, 1.37591071902983713e-11, 6.42911920481377224e-12, 6.41981862427375806e-12, 2.38281004480538456e-12, 1.43953202219019608e-12, 3.75975364396292953e-13, 3.30838030478549930e-13, 2.68768808507569754e-13, 2.00963105606119799e-13, 6.63147817296292662e-14, 1.65881587165741652e-14, 5.13625015340929251e-15, 1.17214615921230281e-14, 3.38490169571384332e-15, 7.79850948168528051e-15, 8.23401690078796575e-16, 4.91420106810952863e-17, 1.22309004361837157e-16, 9.25811213572239591e-17, 7.86272170897524581e-17, 9.17317532713778677e-17, 3.49454298176677591e-17, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[4][27] = niz4_27;
	static double niz4_28[] = { 1.11022302462515654e-16, 2.09664437465772044e-29, 1.63538261223302194e-27, 4.08845653058255486e-26, 7.66585599484229036e-25, 1.01557260219670663e-23, 1.13184830592647449e-22, 1.00541687617473956e-21, 7.56601588636546437e-21, 4.77742278283367409e-20, 2.58224567697545610e-19, 1.19566916960725960e-18, 4.78675420242685816e-18, 1.65554192714851329e-17, 4.96964203207406408e-17, 1.29139308235717260e-16, 2.90766914770679715e-16, 5.64004180651800889e-16, 9.41366794078027826e-16, 1.33579937522794949e-15, 1.60964099947837764e-15, 1.60353233789295885e-15, 1.34020817393074270e-15, 8.55333987300109854e-16, 5.40148463679774904e-16, 1.54561859714410364e-16, 3.83194469668827223e-16, 2.59076938065189203e-17, 9.76759164051486932e-16, 4.57288261760211863e-18, 2.46878301729990277e-15, 1.34626106905766750e-16, 5.35241356727084092e-15, 2.00389832519726965e-15, 1.25094481061728746e-14, 8.87206586453998106e-15, 3.07738301464744837e-14, 2.58239216329297630e-14, 5.13767512341857755e-14, 4.63784170674655316e-14, 6.14722698092565985e-14, 3.83698440881015080e-14, 5.66599527287855730e-14, 2.10581204587526198e-14, 2.89788534668927586e-14, 4.05412686377105888e-14, 2.11500869931393653e-14, 2.56916184726242084e-14, 1.10994754314332563e-13, 7.14431196507370498e-14, 1.17905188503879042e-13, 2.36235536045251189e-13, 2.73183778124101292e-13, 3.35600951168557150e-13, 6.05391533758851302e-13, 7.31190746715015438e-13, 1.05685046069720262e-12, 1.26082860770439475e-12, 1.26594521485969783e-12, 1.23921401011155882e-12, 1.62437041500544658e-12, 1.00700295628400825e-12, 1.02780482310847269e-12, 1.12671111796273569e-12, 1.71163130611377773e-12, 1.68334444194130266e-12, 2.63093359540715239e-12, 2.68487211811192089e-12, 5.06762609030389514e-12, 5.37461587877418322e-12, 9.47582434379894440e-12, 9.77031853631947986e-12, 1.61028631365581387e-11, 1.50569244467862977e-11, 1.92444560072544320e-11, 2.58579095699611075e-11, 2.74258925394902097e-11, 3.13598415207698568e-11, 2.68483149473291965e-11, 2.58585768174674511e-11, 3.42100008498034181e-11, 3.61435292797379871e-11, 4.57897553189698318e-11, 5.64320955010193552e-11, 8.21224781953098333e-11, 9.77233542557635316e-11, 1.27274108839943295e-10, 1.57439386479339709e-10, 2.04790360008003514e-10, 2.40266542285510974e-10, 3.22106083185192640e-10, 3.55894124241939809e-10, 4.18201202105118600e-10, 4.50555470569252542e-10, 4.91129993956694585e-10, 4.98379220893764236e-10, 6.32942578925451649e-10, 6.43694522512739421e-10, 8.55034181748625799e-10, 1.02204528444206460e-09, 1.30679988837265222e-09, 1.51910313085365943e-09, 2.07718392178929356e-09, 2.36147881514761223e-09, 3.07040418583885213e-09, 3.70797351006660261e-09, 4.37405002248499024e-09, 5.00348655420191682e-09, 5.92783562663560524e-09, 6.33668240749361820e-09, 7.36877294815280901e-09, 8.31516527647433000e-09, 9.58125815492871793e-09, 1.13039474372212611e-08, 1.39594515621821258e-08, 1.59975096598131931e-08, 2.07439310531623668e-08, 2.52114587656664531e-08, 3.04590342101722529e-08, 3.64666958712940193e-08, 4.52214534665380253e-08, 5.11126620083659730e-08, 6.23473122631625249e-08, 6.82933804239423362e-08, 7.97614409786073031e-08, 8.89355698246062095e-08, 1.08515569953903202e-07, 1.20280154568900724e-07, 1.49774190332570363e-07, 1.78096232821514759e-07, 2.19884698307195559e-07, 2.57816696620758730e-07, 3.22585876742067514e-07, 3.64865007460765175e-07, 4.50452515579124133e-07, 5.16116343953786430e-07, 6.10659367439675239e-07, 7.17765430342377487e-07, 8.34194375259559505e-07, 9.25665764970986468e-07, 1.14209219093349795e-06, 1.31840873658466733e-06, 1.59111237775781391e-06, 1.88536457589753021e-06, 2.31082443532257491e-06, 2.63759134066032136e-06, 3.29242885973715180e-06, 3.80561967322540069e-06, 4.50931744647393372e-06, 5.25235287756460246e-06, 6.24362735890304317e-06, 6.96455505759749208e-06, 8.59078891322586122e-06, 9.80110261102757802e-06, 1.18147147921275098e-05, 1.39387985491945982e-05, 1.69305071437976078e-05, 1.93667229721511034e-05, 2.40801130443125919e-05, 2.73830437778091114e-05, 3.24872612673930106e-05, 3.81363669594269721e-05, 4.52839516037321197e-05, 5.12785352452418112e-05, 6.32247398388957707e-05, 7.21659834641279495e-05, 8.56749530259115174e-05, 1.01815224997324076e-04, 1.21844984677598093e-04, 1.38392078050873882e-04, 1.70644955005411762e-04, 1.93812253143338208e-04, 2.30354308563141452e-04, 2.68953004409851009e-04, 3.16973441228829043e-04, 3.59064398353493126e-04, 4.41316785431563295e-04, 5.03659646511679313e-04, 5.96576418136340468e-04, 7.00044059189711327e-04, 8.25727612832873265e-04, 9.30793681311733339e-04, 1.13350643595070766e-03, 1.27687197512956255e-03, 1.49490677477384041e-03, 1.75266238705807601e-03, 2.04651090154794879e-03, 2.30184029572177941e-03, 2.78930016436942669e-03, 3.13436098052070899e-03, 3.63877641470259760e-03, 4.21482185562220210e-03, 4.85851646048066077e-03, 5.40756133236696291e-03, 6.46851691073646942e-03, 7.20015206716116945e-03, 8.25413439942397111e-03, 9.46518100908387040e-03, 1.07589672869289211e-02, 1.18336934630981858e-02, 1.38514776258238659e-02, 1.51785053995736885e-02, 1.70716057265606624e-02, 1.92308338526293032e-02, 2.14216031618893916e-02, 2.30163457691076601e-02, 2.64029537967706320e-02, 2.81346530349497123e-02, 3.07674551141542511e-02, 3.36774540377317994e-02, 3.63017591794922712e-02, 3.76740553215979962e-02, 4.15826879232876340e-02, 4.25248720851637146e-02, 4.43793483396225097e-02, 4.59782068692683454e-02, 4.68442960638937034e-02, 4.56126177154977872e-02, 4.67075161626789997e-02, 4.38387847735179012e-02, 4.14666590083162187e-02, 3.84832858504097139e-02, 3.44331872580454917e-02, 2.89342227645971277e-02, 2.52400370188810910e-02, 1.98816865195967432e-02, 1.56539083115365858e-02, 1.20418093450844355e-02, 8.95758083893079607e-03, 6.30383670513267463e-03, 4.60937396532721654e-03, 3.10835997569556058e-03, 2.11696027149830060e-03, 1.43681016992564664e-03, 9.45747345179894687e-04, 6.04498910676731153e-04, 4.02667193707191291e-04, 2.54563442445584966e-04, 1.59313031388198150e-04, 1.03121533222003597e-04, 6.37014037816181186e-05, 3.93724703064345457e-05, 2.51125578538086651e-05, 1.52968365935465343e-05, 9.24301061083410850e-06, 5.90192529402547181e-06, 3.51836487741905772e-06, 2.13914140289419196e-06, 1.31380053385920772e-06, 7.99524389117982572e-07, 4.68063934954064084e-07, 2.91856942309615363e-07, 1.69471956062113319e-07, 1.01962913026988217e-07, 6.16004937746846578e-08, 3.65348316540322401e-08, 2.03050308501397534e-08, 1.28928474869615931e-08, 7.28629866239551152e-09, 4.35442268500977046e-09, 2.51683067156626667e-09, 1.41163868345940913e-09, 8.15651028268093083e-10, 5.16202340733962442e-10, 2.99627112203152215e-10, 1.57671888507134056e-10, 8.36683850663871752e-11, 5.41540925974496719e-11, 3.13648385836741853e-11, 2.13398793592244086e-11, 9.69714862778262967e-12, 4.60548690651788659e-12, 3.04562134742990427e-12, 1.90968052515195152e-12, 1.25172291742594790e-12, 7.51818960364821291e-13, 3.00786298452206445e-13, 8.26839157179807586e-14, 8.43438145339476396e-14, 7.58698814834826492e-14, 5.19553361903539041e-14, 2.17267120914941684e-14, 4.04564443351365036e-15, 2.38896935550896908e-15, 1.85183476916594080e-15, 1.61821607715397327e-15, 1.80469484040148254e-15, 7.28503007230192566e-16, 7.74517523280904566e-18, 2.67550947041518781e-17, 1.52886255452296446e-17, 3.50364335411512689e-17, 1.00331605140569543e-17, 2.29329383178444669e-17, 2.18408936360423495e-18, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[4][28] = niz4_28;
	static double niz4_29[] = { 2.77555756156289135e-17, 1.40746960335819196e-30, 1.14005037872013549e-28, 2.96413098467235227e-27, 5.78005542011108693e-26, 8.00315365861535113e-25, 9.31478161933286701e-24, 8.67770518127007358e-23, 6.85370071439672132e-22, 4.55712907910989119e-21, 2.59956436350729182e-20, 1.27479433524303413e-19, 5.42137330293170995e-19, 2.00044649530445355e-18, 6.43274006918212936e-18, 1.80046258971027709e-17, 4.39056757188338802e-17, 9.29325070392171925e-17, 1.70512481182314507e-16, 2.69015151955628700e-16, 3.63881159194444773e-16, 4.15106618274183430e-16, 3.99436676616795615e-16, 3.10058570396289812e-16, 2.07274700908107861e-16, 9.30749741386610504e-17, 7.72084361470418430e-17, 9.49250963365305636e-18, 1.36581286068913511e-16, 7.65076338732205830e-20, 3.64773513080202234e-16, 4.42044635975324336e-18, 8.17066067791659429e-16, 1.38431565184182187e-16, 1.81298117025131956e-15, 7.63323797858127718e-16, 4.50958996202653632e-15, 3.36458802189239376e-15, 9.28255910853408431e-15, 8.84173051833312518e-15, 1.49169288630290352e-14, 1.13818940334769290e-14, 1.70849496865908478e-14, 9.12393865400547670e-15, 1.08872336219593516e-14, 9.04934095811763614e-15, 5.51217873922217742e-15, 2.97919495935783182e-15, 1.64275882161026054e-14, 6.99255064910761952e-15, 1.29843019632297469e-14, 3.35200327801743154e-14, 3.42934180972016372e-14, 4.16047207645847550e-14, 8.52452641956067803e-14, 9.10541136735384389e-14, 1.42789381683629278e-13, 2.06471720796597998e-13, 2.41661951422937423e-13, 3.00807263635069558e-13, 4.28239715452144383e-13, 3.38420310492312913e-13, 3.17918390312363849e-13, 3.14499617637356707e-13, 3.36424438861371097e-13, 2.82363127902152634e-13, 3.53881453229394882e-13, 3.12488307031654524e-13, 6.11977887880781544e-13, 5.71225149620186984e-13, 1.12986423245126639e-12, 1.11847579817926470e-12, 2.14729411900460077e-12, 2.11300761576237361e-12, 3.16767797210557642e-12, 3.90213305894917920e-12, 4.87079738181432995e-12, 5.09655799662554163e-12, 7.66957658256514323e-12, 6.93654272350968893e-12, 9.47862900017389796e-12, 6.52156756344809545e-12, 7.26011169926694836e-12, 7.63726387759373339e-12, 1.04473598762879012e-11, 1.15308979602048053e-11, 1.45656610098675382e-11, 1.82684332381963142e-11, 2.48321873736602937e-11, 2.99081678060271147e-11, 4.22686925070509436e-11, 4.96272025122864931e-11, 6.31479227878044232e-11, 7.63496167384351427e-11, 9.29719335181284366e-11, 1.03712466402441745e-10, 1.26066792954956462e-10, 1.23978751911022713e-10, 1.42357081467682854e-10, 1.48923384220690886e-10, 1.70587717381232057e-10, 1.77951570598139243e-10, 2.49568606710125852e-10, 2.60785255981661962e-10, 3.68819916181312047e-10, 4.23015393225433574e-10, 5.66127949184527567e-10, 6.25964592724660510e-10, 8.93731532195891211e-10, 9.40441723832336589e-10, 1.26002264055038233e-09, 1.37010837811963148e-09, 1.67005120080676415e-09, 1.72628561985858786e-09, 2.07929308861630724e-09, 2.09049058363438013e-09, 2.55464916750133458e-09, 2.85194133285450218e-09, 3.43177095404531513e-09, 4.12624751113011004e-09, 5.32737179235528336e-09, 5.96770284025868235e-09, 7.71581772140169778e-09, 8.99552699187288734e-09, 1.11465584211537797e-08, 1.29062986890141870e-08, 1.58661518769707111e-08, 1.72448244394544706e-08, 2.11801915510964369e-08, 2.26361479759190610e-08, 2.67607244177923261e-08, 2.89363743007752804e-08, 3.67912777622344414e-08, 3.93443886769593618e-08, 5.01111367506065394e-08, 5.78623021216512185e-08, 7.36372904504930761e-08, 8.28845632221735991e-08, 1.05667836143756438e-07, 1.16863411437503887e-07, 1.50515728106171783e-07, 1.64095851496152571e-07, 1.95140156650094474e-07, 2.21864910622367304e-07, 2.63318404724784162e-07, 2.84656027650762969e-07, 3.52523184604172500e-07, 3.97441268010874670e-07, 4.84330623348858229e-07, 5.64526656760133064e-07, 7.06413843484640225e-07, 7.90346422597507970e-07, 9.96360751142083776e-07, 1.12000489372034131e-06, 1.34382582675469644e-06, 1.53234556492238143e-06, 1.85880930265455568e-06, 2.03518336305989107e-06, 2.51130469924449245e-06, 2.78132461921387878e-06, 3.37399613724548124e-06, 3.90172827307911438e-06, 4.77552349883404853e-06, 5.33615724647115865e-06, 6.72508075398527482e-06, 7.57592466214123391e-06, 9.14674928176602395e-06, 1.05686209678462921e-05, 1.27081230506655137e-05, 1.40423956279733263e-05, 1.73337430364030339e-05, 1.92947022047200966e-05, 2.30240120984806190e-05, 2.69329302906979666e-05, 3.24858839780696018e-05, 3.65087311609812169e-05, 4.57380285066153776e-05, 5.13562363529051574e-05, 6.13287719100521193e-05, 7.10128020934155344e-05, 8.45745832433393064e-05, 9.43933434733906145e-05, 1.15566227405662210e-04, 1.29970621721581367e-04, 1.55701966529501188e-04, 1.80818693901457550e-04, 2.15917289948844515e-04, 2.42373704845164349e-04, 2.98246802725014284e-04, 3.34623909338386746e-04, 3.94272894589434522e-04, 4.59480499648905704e-04, 5.40023243756775659e-04, 6.04338569859921349e-04, 7.38143004873644047e-04, 8.27955206197311514e-04, 9.72605371519549584e-04, 1.13372359837418191e-03, 1.32871998496426956e-03, 1.48622834933202883e-03, 1.79247491591456236e-03, 2.00076458342161954e-03, 2.31976929683188867e-03, 2.69455909495637524e-03, 3.11082678337769791e-03, 3.47866029889815813e-03, 4.15764896628261719e-03, 4.62955539954887363e-03, 5.29023878946074336e-03, 6.09143303202540516e-03, 6.95352142086208460e-03, 7.69415773326265120e-03, 9.01076980324711820e-03, 9.95260329717457398e-03, 1.12291328954540366e-02, 1.28235039535669459e-02, 1.42953018644221743e-02, 1.56197702025272275e-02, 1.79537489906778647e-02, 1.95231330394159928e-02, 2.14458336690697728e-02, 2.40693291332877146e-02, 2.62006480951787329e-02, 2.79944276762207483e-02, 3.12684071908126276e-02, 3.31266628724404405e-02, 3.51952553010453223e-02, 3.82220731540179742e-02, 3.99623733523306393e-02, 4.12087357012975164e-02, 4.38573001617760874e-02, 4.43126677066810956e-02, 4.44547904573022595e-02, 4.53809624805723497e-02, 4.42113769626064912e-02, 4.20377499604876609e-02, 4.08485735676248421e-02, 3.71077935687510047e-02, 3.29595625064618772e-02, 2.93809107197686714e-02, 2.46077370314694392e-02, 1.98587901788368285e-02, 1.62958332719702025e-02, 1.23963106532774293e-02, 9.32176725965767547e-03, 6.95116848728893812e-03, 5.00946013258529027e-03, 3.44650705510111954e-03, 2.49170240325177978e-03, 1.65212418249516247e-03, 1.12195675374882845e-03, 7.53596949268581207e-04, 5.02370618018322421e-04, 3.16010735978846042e-04, 2.16185513154935270e-04, 1.33777203081491690e-04, 8.73713993621140581e-05, 5.52035122740094397e-05, 3.57538343777665194e-05, 2.14624846706109221e-05, 1.44943220589514395e-05, 8.57866282525263928e-06, 5.53013083826090992e-06, 3.36275672631818809e-06, 2.18281628449566322e-06, 1.26223704847141290e-06, 8.43482887158994249e-07, 4.82376334252539325e-07, 3.12551728503068165e-07, 1.82311541768376330e-07, 1.18437051424968411e-07, 6.58528327665027590e-08, 4.39092149001528997e-08, 2.42295607019362311e-08, 1.60838895974159654e-08, 8.74398302390371640e-09, 5.69423415217795722e-09, 3.01697068817261549e-09, 2.15098032722211282e-09, 1.11227142213041074e-09, 7.22010067594819416e-10, 3.61935564357188677e-10, 2.55075725160193549e-10, 1.37108093471062721e-10, 9.71271641069751676e-11, 4.32731700386740515e-11, 2.93410344419766001e-11, 1.38780565165063317e-11, 1.13530283252494927e-11, 6.36378863075819802e-12, 3.76188786721577103e-12, 1.52407048885874257e-12, 1.04740940919816898e-12, 5.33863615923668218e-13, 5.18731663853146921e-13, 2.30017574018091404e-13, 1.70398817168764147e-13, 3.43961795294992899e-14, 2.89288800332802643e-14, 1.91012337795038356e-14, 1.84010521910082659e-14, 1.24055119347067949e-14, 4.66330605170524863e-15, 1.03661212491299309e-15, 7.48167869123980788e-16, 5.14326157665040838e-18, 7.77738124372321556e-16, 2.95195223960540780e-16, 2.57152207507030422e-16, 5.46515277736594415e-18, 3.23290727675168527e-18, 6.92765845018218272e-18, 5.34007005534876585e-18, 4.61843896678812181e-18, 5.19574383763663704e-18, 1.97933098576633792e-18, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[4][29] = niz4_29;
	static double niz4_30[] = { 6.93889390390722838e-18, 9.42501966534503546e-32, 7.91701651888982978e-30, 2.13759446010025404e-28, 4.32862878170301443e-27, 6.25246379579324307e-26, 7.58632273889580159e-25, 7.39577146130972180e-24, 6.11714261507000360e-23, 4.27210009620566322e-22, 2.56488569831030417e-21, 1.32791076587816055e-20, 5.97856211429092847e-20, 2.34427323668490651e-19, 8.03994884464476881e-19, 2.41130424241898996e-18, 6.33149207165789886e-18, 1.45207042248776860e-17, 2.90547910982146127e-17, 5.04403409916803844e-17, 7.57344007912476498e-17, 9.72829257535777119e-17, 1.06479772798374396e-16, 9.68933032488405786e-17, 7.42411637844854853e-17, 4.36073679950820791e-17, 2.57502495197260494e-17, 6.95144822430508680e-18, 1.95987260096928726e-17, 1.49458464507039094e-19, 5.20695444851237712e-17, 1.02010115712519643e-19, 1.24657535880171642e-16, 9.61765011310466929e-18, 2.75877263207980040e-16, 4.98960766938863602e-17, 6.45910487937796098e-16, 3.32019999518940362e-16, 1.43812701484214904e-15, 1.29177931944812630e-15, 2.90054550898348033e-15, 2.48719080137980208e-15, 4.33953318257566236e-15, 2.98152364626782699e-15, 3.86272317966542042e-15, 2.80113052868903163e-15, 2.35164323462035862e-15, 9.70924099964479624e-16, 3.05067275507327475e-15, 7.47435869199508255e-16, 1.48041072715745490e-15, 4.64703842461567659e-15, 3.93576737996717326e-15, 4.75251108039086262e-15, 1.23838641985781745e-14, 1.14510892966254856e-14, 1.83315719917638853e-14, 2.89098153104333467e-14, 3.16575262099567103e-14, 4.51371177363608289e-14, 7.95079075557671095e-14, 7.83300696329143497e-14, 8.97993845869897874e-14, 1.01941890154334508e-13, 1.00433599511196505e-13, 8.28781097749176710e-14, 8.08748886991678153e-14, 6.08788219152105911e-14, 9.27538158720317697e-14, 7.53023391414770223e-14, 1.35109298771693025e-13, 1.19248585979708893e-13, 2.64489849786316823e-13, 2.31549467456031386e-13, 3.92435234060598481e-13, 4.88060472698913807e-13, 7.44868332191264573e-13, 8.18119679611489976e-13, 1.21349227929073226e-12, 1.19253060113695219e-12, 1.65026252545205635e-12, 1.94578433146726587e-12, 2.04673437296462214e-12, 2.30332198758312101e-12, 2.04738302243469950e-12, 1.92474213273641322e-12, 2.08682673467093289e-12, 2.29733949340467259e-12, 3.00979666252573676e-12, 3.44182326589607789e-12, 5.04632481990035661e-12, 5.88999730044692492e-12, 7.64535669948886596e-12, 9.65037277994260105e-12, 1.25162185451576481e-11, 1.53221686657545740e-11, 2.01093455080689974e-11, 2.24170537546522082e-11, 2.78865146617887644e-11, 3.15569889794084944e-11, 3.55960976460652371e-11, 3.59355862986608098e-11, 4.13414294988166058e-11, 3.92144236816974760e-11, 4.68759418861367799e-11, 5.28648054199166162e-11, 6.42407511687289119e-11, 7.29704489904263426e-11, 1.03530888576194549e-10, 1.13200991702951117e-10, 1.52887065009535073e-10, 1.82359229406907093e-10, 2.30901656070789443e-10, 2.66782891245204901e-10, 3.39136349696501699e-10, 3.78731304657810442e-10, 4.45403524685276822e-10, 5.02031093532723858e-10, 5.38814159648100251e-10, 5.94977452470485081e-10, 6.79227668427892377e-10, 7.27258193096514880e-10, 8.86019240968964987e-10, 1.05252186572897828e-09, 1.24656295895665955e-09, 1.50822182855963978e-09, 1.90202817651693771e-09, 2.19827675210751618e-09, 2.77590233288663176e-09, 3.19491061208755459e-09, 3.88596889997402739e-09, 4.56930877972887393e-09, 5.46114463972938788e-09, 5.85473089986537510e-09, 6.84676614069781297e-09, 7.49438041468568151e-09, 8.52527493698262168e-09, 9.39418407501430027e-09, 1.18256235152302416e-08, 1.32461204885707035e-08, 1.62910886278198163e-08, 1.90721481880584877e-08, 2.36482190117907827e-08, 2.80577396646652830e-08, 3.37504354818579697e-08, 3.76181360799946817e-08, 4.67684004441217750e-08, 5.25812276430330978e-08, 6.11178120921822099e-08, 6.97976719186039077e-08, 8.08022927501316749e-08, 8.81461364933144809e-08, 1.06312936233124127e-07, 1.22534337615755374e-07, 1.44328881967730497e-07, 1.71342906593945171e-07, 2.07427237890665819e-07, 2.35879097561543959e-07, 2.90578479551446070e-07, 3.33451091689585879e-07, 3.97087277611496682e-07, 4.58072857133340257e-07, 5.43131205952780826e-07, 6.00279170892680009e-07, 7.20452772431146989e-07, 8.01566228012539131e-07, 9.44414838718190711e-07, 1.09597626392209208e-06, 1.31900125430722805e-06, 1.48357791265762050e-06, 1.84437912717847922e-06, 2.10952530212519991e-06, 2.51263830303806398e-06, 2.93879846241148253e-06, 3.46755566144485370e-06, 3.87090360208984712e-06, 4.69748862380348555e-06, 5.26714219178742574e-06, 6.13336668087767421e-06, 7.20267789885569276e-06, 8.52268441324361583e-06, 9.57891432141861094e-06, 1.17985020202391690e-05, 1.33664161744975980e-05, 1.58877580682737107e-05, 1.86110912672729904e-05, 2.19609664379361209e-05, 2.47477129429710462e-05, 3.00057835587099659e-05, 3.37889687255745589e-05, 3.95946638844943424e-05, 4.57062370536677305e-05, 5.40408215027178253e-05, 6.10465452902966246e-05, 7.48130075935283758e-05, 8.46702752982448405e-05, 9.96542603240421537e-05, 1.16638185252077001e-04, 1.36865518467746259e-04, 1.53237193804230853e-04, 1.85939962839228387e-04, 2.08049573107219830e-04, 2.43035084972534793e-04, 2.84160254180285208e-04, 3.33016536717330625e-04, 3.75064837881490141e-04, 4.54445705423730108e-04, 5.11088143547972916e-04, 5.95900805981440995e-04, 6.92689842624877664e-04, 8.03650384074687898e-04, 8.97388923456386386e-04, 1.08154775911416582e-03, 1.20744181886682338e-03, 1.40076131317413543e-03, 1.62658136141364835e-03, 1.88624074099480086e-03, 2.09862584113306837e-03, 2.50600019700944823e-03, 2.78357477287416097e-03, 3.19696902862863204e-03, 3.67787041329335242e-03, 4.20498906229570778e-03, 4.66379613408089699e-03, 5.51943184651100972e-03, 6.09608088103048666e-03, 6.91477957688783462e-03, 7.86965167134970507e-03, 8.90438209889006863e-03, 9.73754828095772795e-03, 1.13786724578855917e-02, 1.23731275300742617e-02, 1.38425402556344584e-02, 1.55587826991965897e-02, 1.72965454582418333e-02, 1.85788350718485880e-02, 2.13007026564353656e-02, 2.27176559714172312e-02, 2.48810292187363682e-02, 2.73143315233342759e-02, 2.96483926079999828e-02, 3.10291524685040662e-02, 3.45153704276328910e-02, 3.57036879606796032e-02, 3.78624693931946740e-02, 3.99891706975497099e-02, 4.16671089547293871e-02, 4.16502620286214251e-02, 4.41732940094635845e-02, 4.31931669910419896e-02, 4.29100397163688432e-02, 4.22711568122019904e-02, 4.06091201716548417e-02, 3.70622473421947027e-02, 3.52992951452029483e-02, 3.05968802055519018e-02, 2.66214459234446060e-02, 2.26310234868882590e-02, 1.86251717019996453e-02, 1.44406030181892884e-02, 1.16944745922110682e-02, 8.63402257353875630e-03, 6.42329697871016608e-03, 4.72164508038190513e-03, 3.37854061704813196e-03, 2.31607734573111273e-03, 1.66676124059833173e-03, 1.11313521647200212e-03, 7.53115450114371070e-04, 5.13756037225494041e-04, 3.40601264442889082e-04, 2.20090724313703784e-04, 1.48830176997809445e-04, 9.55481099395473753e-05, 6.13986699834311310e-05, 4.05129672797703200e-05, 2.57515457832340483e-05, 1.63599475517592313e-05, 1.06421189021800406e-05, 6.72407011111140624e-06, 4.23070307482001506e-06, 2.73023948242656918e-06, 1.69683493224813796e-06, 1.06662186007288377e-06, 6.79171036096645677e-07, 4.25926657973051068e-07, 2.57776103422901549e-07, 1.67034216978796838e-07, 1.01358167340806006e-07, 6.30810518901409625e-08, 3.91334749523536023e-08, 2.40712708338287998e-08, 1.44770434494719338e-08, 9.23276697277004393e-09, 5.54227207115399269e-09, 3.39613516733810468e-09, 2.01173794262560511e-09, 1.24190675539942673e-09, 7.37252793271842637e-10, 4.91550073579331305e-10, 2.76259026135347820e-10, 1.57901646876302965e-10, 9.70286801662936379e-11, 6.03290272113033010e-11, 3.75983413084210737e-11, 2.34088059542641843e-11, 1.27059382769710350e-11, 6.82399826228775164e-12, 4.14751610452849301e-12, 3.11837853120575800e-12, 1.77164069918352721e-12, 1.10371742374245989e-12, 5.10572099088058936e-13, 2.56179871257930484e-13, 1.83678112389561116e-13, 1.30286534834229191e-13, 8.96713527311095162e-14, 5.22335658024576019e-14, 1.86990818944142366e-14, 6.33152556820485764e-15, 6.66398593091671434e-15, 4.66647171608511206e-15, 4.11789502573135711e-15, 2.58785436725257224e-15, 6.73623061810206643e-16, 9.88837960089404006e-17, 1.54140400516553569e-16, 1.16864874651084652e-16, 9.77572314754578795e-17, 1.13040464177521219e-16, 4.17515129810086882e-17, 1.29893595940915926e-18, 1.47934373154932027e-18, 2.09874374923053983e-18, 0.00000000000000000e+00, 2.16489326568193210e-18, 8.18278109350015954e-19, 6.95858549683478175e-19, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[4][30] = niz4_30;
	
	static double niz5_1[] = { 1.00000000000000000e+00 }; repRatios[5][1] = niz5_1;
	static double niz5_2[] = { 3.60053989999999990e-01, 6.39946009999999954e-01 }; repRatios[5][2] = niz5_2;
	static double niz5_3[] = { 7.84032900000000005e-02, 1.53634970000000010e-01, 5.37506860000000031e-01, 2.30454880000000001e-01 }; repRatios[5][3] = niz5_3;
	static double niz5_4[] = { 1.59291499999999996e-02, 1.22956000000000003e-02, 1.04493520000000006e-01, 2.00722180000000000e-01, 3.53225540000000005e-01, 2.76455300000000015e-01, 3.68787100000000020e-02 }; repRatios[5][4] = niz5_4;
	static double niz5_5[] = { 3.19282999999999980e-03, 8.16250000000000027e-04, 9.84637000000000012e-03, 2.86648899999999984e-02, 7.51649999999999957e-02, 1.10573359999999996e-01, 2.59731119999999982e-01, 2.61664220000000003e-01, 2.04611480000000012e-01, 4.42590600000000028e-02, 1.47542000000000007e-03 }; repRatios[5][5] = niz5_5;
	static double niz5_6[] = { 6.37069999999999997e-04, 4.79799999999999980e-05, 7.88419999999999963e-04, 3.14421000000000015e-03, 9.14108999999999929e-03, 1.07737400000000004e-02, 3.97122300000000011e-02, 6.19303199999999970e-02, 1.18179859999999998e-01, 1.85797889999999993e-01, 2.22406070000000011e-01, 2.11505190000000010e-01, 1.09376349999999997e-01, 2.56693199999999989e-02, 8.90260000000000031e-04, 0.00000000000000000e+00 }; repRatios[5][6] = niz5_6;
	static double niz5_7[] = { 1.28419999999999994e-04, 3.02999999999999979e-06, 5.41199999999999968e-05, 2.95200000000000020e-04, 1.10487999999999992e-03, 1.47437000000000002e-03, 3.57647000000000000e-03, 4.36512000000000011e-03, 1.62377000000000007e-02, 2.55454300000000009e-02, 4.37675299999999989e-02, 7.45558600000000016e-02, 1.29387100000000005e-01, 1.56368559999999990e-01, 1.98525759999999996e-01, 1.78792000000000006e-01, 1.15223539999999999e-01, 4.40763500000000003e-02, 6.26699000000000006e-03, 2.51570000000000005e-04, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[5][7] = niz5_7;
	static double niz5_8[] = { 2.46699999999999993e-05, 2.10000000000000001e-07, 3.75000000000000010e-06, 2.30700000000000010e-05, 1.12460000000000004e-04, 2.27700000000000005e-04, 5.01170000000000001e-04, 2.84709999999999976e-04, 1.19161000000000006e-03, 2.34599000000000005e-03, 5.18698999999999983e-03, 6.88462000000000015e-03, 1.46793300000000008e-02, 2.30007100000000006e-02, 4.18955999999999981e-02, 6.52705299999999933e-02, 9.25062200000000001e-02, 1.30503330000000001e-01, 1.62177170000000009e-01, 1.65645939999999992e-01, 1.46983069999999993e-01, 9.26736100000000035e-02, 3.93656400000000004e-02, 7.74051999999999987e-03, 7.32189999999999968e-04, 3.91900000000000026e-05, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[5][8] = niz5_8;
	static double niz5_9[] = { 4.78999999999999988e-06, 2.00000000000000004e-08, 2.70000000000000009e-07, 1.76999999999999999e-06, 9.08999999999999937e-06, 2.76700000000000010e-05, 7.20800000000000011e-05, 6.34700000000000005e-05, 1.12999999999999996e-04, 1.26610000000000009e-04, 4.58010000000000014e-04, 6.65820000000000019e-04, 1.66934000000000006e-03, 1.76087000000000010e-03, 3.29481000000000001e-03, 6.42268000000000006e-03, 1.14077499999999995e-02, 1.65567400000000003e-02, 2.77534899999999987e-02, 4.11101999999999995e-02, 6.44535999999999998e-02, 8.63776899999999931e-02, 1.16278389999999995e-01, 1.35572999999999999e-01, 1.52004400000000012e-01, 1.38187260000000006e-01, 1.04816240000000005e-01, 6.26955299999999993e-02, 2.26920600000000000e-02, 4.67679000000000011e-03, 6.79580000000000049e-04, 4.33300000000000002e-05, 3.65000000000000021e-06, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[5][9] = niz5_9;
	static double niz5_10[] = { 1.12999999999999998e-06, 0.00000000000000000e+00, 2.00000000000000004e-08, 1.99999999999999991e-07, 8.70000000000000035e-07, 2.87999999999999995e-06, 8.09000000000000047e-06, 1.20000000000000003e-05, 1.84900000000000008e-05, 1.18999999999999996e-05, 3.13999999999999975e-05, 3.99199999999999973e-05, 1.85100000000000000e-04, 1.90129999999999997e-04, 3.39459999999999979e-04, 4.96780000000000051e-04, 8.05260000000000025e-04, 1.31769999999999999e-03, 2.66379000000000008e-03, 3.90019999999999993e-03, 6.10061000000000023e-03, 9.19713999999999948e-03, 1.51281599999999999e-02, 2.29845400000000012e-02, 3.52737200000000015e-02, 4.73198700000000000e-02, 6.71966999999999981e-02, 8.94717500000000027e-02, 1.11070769999999999e-01, 1.25524550000000013e-01, 1.35276370000000007e-01, 1.22908850000000000e-01, 9.95842100000000063e-02, 6.28593199999999963e-02, 2.95092900000000005e-02, 8.51032000000000004e-03, 1.75369000000000002e-03, 2.74160000000000018e-04, 2.86600000000000000e-05, 1.90000000000000002e-06, 9.99999999999999955e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[5][10] = niz5_10;
	static double niz5_11[] = { 2.59999999999999999e-07, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 4.99999999999999977e-08, 1.90000000000000007e-07, 9.19999999999999980e-07, 1.70999999999999993e-06, 3.40000000000000006e-06, 2.73000000000000012e-06, 3.05999999999999993e-06, 9.70000000000000030e-07, 1.49700000000000007e-05, 1.57800000000000014e-05, 4.24100000000000022e-05, 6.23499999999999977e-05, 8.25400000000000059e-05, 9.07700000000000000e-05, 1.84870000000000010e-04, 2.82579999999999995e-04, 5.79309999999999981e-04, 8.45700000000000011e-04, 1.24843000000000003e-03, 1.74563999999999991e-03, 3.00639999999999978e-03, 4.40158000000000042e-03, 7.18044999999999968e-03, 1.04868900000000004e-02, 1.55906499999999993e-02, 2.14455900000000005e-02, 3.24229799999999971e-02, 4.39493300000000017e-02, 6.01755100000000015e-02, 7.50862100000000005e-02, 9.50476299999999941e-02, 1.09446310000000005e-01, 1.21261949999999993e-01, 1.18132740000000000e-01, 1.05893299999999996e-01, 8.34385299999999969e-02, 5.20928999999999975e-02, 2.47988399999999991e-02, 8.41251999999999972e-03, 2.02855000000000006e-03, 4.21580000000000012e-04, 6.05699999999999978e-05, 9.76999999999999963e-06, 4.70000000000000000e-07, 1.10000000000000006e-07, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[5][11] = niz5_11;
	static double niz5_12[] = { 5.99999999999999946e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 4.99999999999999977e-08, 8.99999999999999986e-08, 1.99999999999999991e-07, 5.60000000000000038e-07, 5.60000000000000038e-07, 7.19999999999999989e-07, 2.59999999999999999e-07, 1.01999999999999998e-06, 7.09999999999999978e-07, 4.10999999999999961e-06, 6.56999999999999978e-06, 1.28900000000000003e-05, 1.11599999999999999e-05, 2.02999999999999988e-05, 1.90699999999999987e-05, 4.02299999999999994e-05, 6.45700000000000001e-05, 1.08129999999999996e-04, 1.62480000000000003e-04, 2.70100000000000006e-04, 3.40399999999999980e-04, 5.00039999999999990e-04, 7.72030000000000047e-04, 1.27431000000000007e-03, 1.85892000000000002e-03, 2.86579999999999994e-03, 3.89995000000000012e-03, 5.93915999999999975e-03, 8.50620000000000022e-03, 1.25810699999999998e-02, 1.73968299999999985e-02, 2.49982200000000016e-02, 3.28996599999999972e-02, 4.45860900000000018e-02, 5.69976499999999969e-02, 7.35466000000000036e-02, 8.66604799999999981e-02, 1.00028510000000001e-01, 1.08585180000000003e-01, 1.10698699999999997e-01, 1.00867550000000000e-01, 8.51398200000000049e-02, 6.03084700000000029e-02, 3.54369199999999968e-02, 1.54264199999999997e-02, 5.35954000000000031e-03, 1.40686999999999995e-03, 3.20599999999999987e-04, 6.35499999999999997e-05, 8.84999999999999997e-06, 1.70000000000000003e-06, 4.00000000000000008e-08, 2.99999999999999973e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[5][12] = niz5_12;
	static double niz5_13[] = { 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.99999999999999973e-08, 4.00000000000000008e-08, 1.40000000000000010e-07, 8.00000000000000017e-08, 1.40000000000000010e-07, 1.49999999999999993e-07, 0.00000000000000000e+00, 2.80000000000000019e-07, 3.99999999999999982e-07, 1.37000000000000001e-06, 1.17999999999999993e-06, 3.06999999999999983e-06, 2.20000000000000011e-06, 4.15000000000000008e-06, 5.24999999999999971e-06, 7.09999999999999978e-06, 1.19800000000000005e-05, 2.53699999999999993e-05, 3.41800000000000014e-05, 4.96299999999999975e-05, 6.32899999999999988e-05, 9.38899999999999972e-05, 1.25190000000000013e-04, 2.18199999999999991e-04, 3.01310000000000000e-04, 4.82359999999999983e-04, 6.79770000000000005e-04, 9.81289999999999897e-04, 1.31072999999999997e-03, 2.03418000000000002e-03, 2.84674999999999989e-03, 4.27677000000000005e-03, 5.88395999999999971e-03, 8.38225000000000081e-03, 1.12762000000000001e-02, 1.60530400000000011e-02, 2.13171800000000015e-02, 2.93499899999999994e-02, 3.72682699999999992e-02, 4.87205699999999978e-02, 5.98653999999999992e-02, 7.34656900000000002e-02, 8.49364999999999981e-02, 9.57967500000000000e-02, 1.00478449999999997e-01, 1.00890049999999995e-01, 9.27196899999999935e-02, 7.83717899999999967e-02, 5.76874299999999979e-02, 3.58181700000000033e-02, 1.79051599999999998e-02, 7.11751999999999958e-03, 2.29824000000000001e-03, 6.39959999999999965e-04, 1.52120000000000000e-04, 3.74900000000000019e-05, 6.33000000000000038e-06, 1.12000000000000008e-06, 1.79999999999999997e-07, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[5][13] = niz5_13;
	static double niz5_14[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.00000000000000004e-08, 0.00000000000000000e+00, 2.00000000000000004e-08, 2.00000000000000004e-08, 8.00000000000000017e-08, 8.00000000000000017e-08, 2.89999999999999976e-07, 4.70000000000000000e-07, 6.60000000000000034e-07, 6.30000000000000003e-07, 6.60000000000000034e-07, 7.80000000000000049e-07, 1.95999999999999987e-06, 2.56999999999999996e-06, 3.98999999999999991e-06, 6.56999999999999978e-06, 1.06899999999999993e-05, 1.16300000000000005e-05, 1.77500000000000012e-05, 2.16599999999999993e-05, 3.35699999999999988e-05, 4.78800000000000024e-05, 7.81299999999999990e-05, 1.13930000000000002e-04, 1.65500000000000011e-04, 2.09249999999999990e-04, 2.95689999999999983e-04, 4.21670000000000020e-04, 6.31629999999999995e-04, 8.68230000000000000e-04, 1.28992999999999990e-03, 1.75570000000000001e-03, 2.47978999999999995e-03, 3.34111999999999994e-03, 4.72590999999999983e-03, 6.40511000000000032e-03, 9.10367999999999941e-03, 1.19640400000000004e-02, 1.62853799999999986e-02, 2.08699200000000001e-02, 2.79379499999999996e-02, 3.53154599999999999e-02, 4.51308699999999965e-02, 5.46097600000000002e-02, 6.58085800000000054e-02, 7.61615800000000065e-02, 8.62564999999999998e-02, 9.16633599999999993e-02, 9.45987499999999953e-02, 9.04818000000000011e-02, 8.18659300000000034e-02, 6.64007600000000031e-02, 4.83469399999999980e-02, 2.94399400000000012e-02, 1.52485699999999995e-02, 6.29823000000000015e-03, 2.30085000000000012e-03, 7.00969999999999979e-04, 1.97640000000000012e-04, 5.41199999999999968e-05, 1.16999999999999998e-05, 2.62999999999999981e-06, 3.70000000000000004e-07, 1.29999999999999999e-07, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[5][14] = niz5_14;
	static double niz5_15[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 1.29999999999999999e-07, 8.99999999999999986e-08, 8.99999999999999986e-08, 9.99999999999999955e-08, 2.80000000000000019e-07, 1.19999999999999989e-07, 2.20000000000000011e-07, 4.70000000000000000e-07, 9.09999999999999969e-07, 1.46999999999999990e-06, 2.61000000000000000e-06, 2.20000000000000011e-06, 3.26000000000000013e-06, 3.82999999999999975e-06, 5.31999999999999989e-06, 7.62999999999999979e-06, 1.29699999999999995e-05, 1.78300000000000004e-05, 2.58700000000000013e-05, 3.60599999999999969e-05, 4.95099999999999986e-05, 6.28900000000000026e-05, 9.02799999999999962e-05, 1.20299999999999997e-04, 1.82449999999999990e-04, 2.50369999999999976e-04, 3.64730000000000013e-04, 4.75600000000000014e-04, 6.67539999999999995e-04, 8.78279999999999946e-04, 1.25029999999999998e-03, 1.69476000000000002e-03, 2.42627999999999984e-03, 3.16072000000000011e-03, 4.41124000000000030e-03, 5.78325000000000020e-03, 7.89328000000000078e-03, 1.01723700000000000e-02, 1.37629499999999995e-02, 1.77238200000000012e-02, 2.31496700000000007e-02, 2.87623699999999989e-02, 3.63534500000000024e-02, 4.41881199999999974e-02, 5.41896499999999989e-02, 6.30156800000000045e-02, 7.23278499999999991e-02, 7.97331700000000060e-02, 8.63142100000000023e-02, 8.74828700000000042e-02, 8.57604099999999953e-02, 7.82650700000000060e-02, 6.69135700000000055e-02, 5.08816699999999969e-02, 3.47080400000000025e-02, 2.00831500000000010e-02, 9.90334000000000006e-03, 4.16738000000000004e-03, 1.53121000000000008e-03, 5.11249999999999986e-04, 1.54589999999999995e-04, 4.50300000000000009e-05, 1.19199999999999994e-05, 2.87000000000000005e-06, 8.89999999999999949e-07, 9.99999999999999955e-08, 5.99999999999999946e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[5][15] = niz5_15;
	static double niz5_16[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.99999999999999973e-08, 2.99999999999999973e-08, 2.00000000000000004e-08, 4.00000000000000008e-08, 4.00000000000000008e-08, 4.00000000000000008e-08, 8.99999999999999986e-08, 8.00000000000000017e-08, 5.99999999999999946e-08, 1.79999999999999997e-07, 2.59999999999999999e-07, 4.89999999999999967e-07, 4.59999999999999990e-07, 4.89999999999999967e-07, 8.09999999999999974e-07, 1.17999999999999993e-06, 1.28000000000000003e-06, 2.08999999999999989e-06, 2.83999999999999991e-06, 4.95999999999999994e-06, 6.70000000000000023e-06, 8.77000000000000074e-06, 1.14900000000000001e-05, 1.42299999999999993e-05, 1.72499999999999992e-05, 2.47499999999999985e-05, 3.53499999999999987e-05, 5.11699999999999997e-05, 6.69099999999999947e-05, 9.49000000000000028e-05, 1.23499999999999993e-04, 1.70490000000000002e-04, 2.18309999999999988e-04, 3.07860000000000024e-04, 4.11090000000000023e-04, 5.79360000000000010e-04, 7.67369999999999966e-04, 1.06560000000000010e-03, 1.39988000000000005e-03, 1.89436000000000010e-03, 2.43844999999999999e-03, 3.37741999999999990e-03, 4.39293999999999969e-03, 5.95664000000000003e-03, 7.61021000000000006e-03, 1.00683100000000005e-02, 1.27329899999999996e-02, 1.66085899999999995e-02, 2.07096899999999993e-02, 2.63154700000000005e-02, 3.22742499999999974e-02, 3.95657599999999984e-02, 4.67546299999999984e-02, 5.54969199999999982e-02, 6.33319400000000032e-02, 7.15884100000000051e-02, 7.70641600000000065e-02, 8.13124000000000069e-02, 8.17724299999999932e-02, 7.97440400000000021e-02, 7.19100800000000012e-02, 6.16194499999999992e-02, 4.75736500000000020e-02, 3.34171200000000015e-02, 2.02008600000000010e-02, 1.07997900000000001e-02, 4.91193000000000012e-03, 2.04550000000000001e-03, 7.39120000000000011e-04, 2.63209999999999996e-04, 8.13499999999999987e-05, 2.65599999999999998e-05, 8.07000000000000066e-06, 2.12999999999999994e-06, 5.50000000000000028e-07, 1.49999999999999993e-07, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[5][16] = niz5_16;
	static double niz5_17[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.99999999999999973e-08, 2.00000000000000004e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 4.00000000000000008e-08, 4.00000000000000008e-08, 2.00000000000000004e-08, 7.00000000000000048e-08, 7.00000000000000048e-08, 1.29999999999999999e-07, 1.29999999999999999e-07, 1.99999999999999991e-07, 1.19999999999999989e-07, 2.49999999999999989e-07, 3.80000000000000015e-07, 4.59999999999999990e-07, 6.09999999999999983e-07, 1.12000000000000008e-06, 1.63999999999999997e-06, 1.79999999999999992e-06, 2.33000000000000014e-06, 2.62999999999999981e-06, 4.04000000000000028e-06, 4.83000000000000034e-06, 6.46999999999999989e-06, 8.76000000000000083e-06, 1.32500000000000002e-05, 1.80999999999999995e-05, 2.52799999999999985e-05, 3.10199999999999978e-05, 4.03899999999999978e-05, 5.24600000000000026e-05, 7.05699999999999969e-05, 9.24400000000000026e-05, 1.34399999999999987e-04, 1.77130000000000007e-04, 2.40749999999999997e-04, 3.10180000000000015e-04, 4.24869999999999989e-04, 5.35189999999999950e-04, 7.31549999999999974e-04, 9.45769999999999966e-04, 1.30247999999999996e-03, 1.68497999999999998e-03, 2.26598999999999984e-03, 2.88170000000000006e-03, 3.82673999999999992e-03, 4.84155999999999996e-03, 6.38389999999999964e-03, 8.12145000000000054e-03, 1.05731599999999999e-02, 1.32021599999999992e-02, 1.67373799999999996e-02, 2.05497200000000005e-02, 2.56397600000000010e-02, 3.09448400000000012e-02, 3.76132200000000028e-02, 4.40753899999999990e-02, 5.16428099999999973e-02, 5.84870899999999985e-02, 6.58320599999999978e-02, 7.12611499999999953e-02, 7.59183699999999989e-02, 7.70158100000000040e-02, 7.64843800000000046e-02, 7.14956499999999939e-02, 6.40164200000000044e-02, 5.26351300000000022e-02, 4.02916300000000019e-02, 2.74474299999999984e-02, 1.67922299999999983e-02, 8.92304000000000014e-03, 4.25415999999999989e-03, 1.83581999999999994e-03, 7.28589999999999989e-04, 2.69230000000000023e-04, 9.65200000000000042e-05, 3.22099999999999982e-05, 1.12099999999999994e-05, 3.58000000000000003e-06, 1.04000000000000000e-06, 2.89999999999999976e-07, 1.29999999999999999e-07, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[5][17] = niz5_17;
	static double niz5_18[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.00000000000000004e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 4.99999999999999977e-08, 5.99999999999999946e-08, 8.99999999999999986e-08, 8.00000000000000017e-08, 1.19999999999999989e-07, 1.99999999999999991e-07, 2.59999999999999999e-07, 2.59999999999999999e-07, 5.70000000000000048e-07, 5.89999999999999963e-07, 5.70000000000000048e-07, 7.99999999999999964e-07, 9.90000000000000050e-07, 1.10999999999999996e-06, 1.88000000000000000e-06, 2.35999999999999985e-06, 3.86000000000000031e-06, 4.83000000000000034e-06, 6.52000000000000026e-06, 7.81999999999999967e-06, 1.04799999999999996e-05, 1.22799999999999993e-05, 1.72400000000000010e-05, 2.16199999999999997e-05, 3.09200000000000021e-05, 3.92600000000000002e-05, 5.41299999999999984e-05, 6.98699999999999934e-05, 9.31299999999999977e-05, 1.16379999999999994e-04, 1.52699999999999998e-04, 1.93940000000000003e-04, 2.63019999999999986e-04, 3.40059999999999993e-04, 4.62950000000000004e-04, 5.85479999999999985e-04, 7.81129999999999997e-04, 9.88469999999999974e-04, 1.30886000000000001e-03, 1.65933000000000009e-03, 2.18935000000000006e-03, 2.78847999999999987e-03, 3.66376999999999979e-03, 4.62362000000000016e-03, 5.94230000000000019e-03, 7.37509999999999988e-03, 9.44367999999999944e-03, 1.16768400000000008e-02, 1.47484199999999999e-02, 1.80377400000000000e-02, 2.21752399999999988e-02, 2.65116900000000009e-02, 3.20350599999999971e-02, 3.75367600000000023e-02, 4.42944600000000008e-02, 5.03725699999999985e-02, 5.71454600000000021e-02, 6.25723799999999969e-02, 6.81369299999999983e-02, 7.12783099999999975e-02, 7.33828799999999976e-02, 7.18480299999999933e-02, 6.85542799999999952e-02, 6.13085999999999978e-02, 5.25025100000000022e-02, 4.10564100000000015e-02, 2.99179499999999987e-02, 1.94099299999999989e-02, 1.14025800000000007e-02, 5.91444999999999992e-03, 2.85118999999999997e-03, 1.23627000000000003e-03, 5.14580000000000050e-04, 2.00509999999999989e-04, 7.58200000000000025e-05, 2.73500000000000007e-05, 9.51000000000000043e-06, 3.09000000000000006e-06, 1.01999999999999998e-06, 2.99999999999999986e-07, 1.79999999999999997e-07, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[5][18] = niz5_18;
	static double niz5_19[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 2.00000000000000004e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 2.00000000000000004e-08, 4.99999999999999977e-08, 8.99999999999999986e-08, 1.10000000000000006e-07, 8.00000000000000017e-08, 1.10000000000000006e-07, 7.00000000000000048e-08, 1.19999999999999989e-07, 1.99999999999999991e-07, 3.80000000000000015e-07, 3.99999999999999982e-07, 5.09999999999999988e-07, 6.89999999999999958e-07, 1.01000000000000007e-06, 1.28000000000000003e-06, 1.63999999999999997e-06, 1.74999999999999997e-06, 2.38999999999999999e-06, 2.52000000000000001e-06, 3.53000000000000008e-06, 4.69999999999999989e-06, 6.70000000000000023e-06, 8.20999999999999932e-06, 1.27200000000000002e-05, 1.40099999999999997e-05, 1.90400000000000007e-05, 2.32699999999999991e-05, 2.99899999999999992e-05, 3.74999999999999967e-05, 5.32600000000000017e-05, 6.56699999999999997e-05, 8.81700000000000046e-05, 1.11680000000000001e-04, 1.53659999999999989e-04, 1.88810000000000003e-04, 2.48210000000000010e-04, 3.13289999999999977e-04, 4.16230000000000018e-04, 5.17089999999999998e-04, 6.80950000000000045e-04, 8.70200000000000010e-04, 1.14835000000000002e-03, 1.43406000000000002e-03, 1.85834999999999993e-03, 2.31684000000000013e-03, 2.97582000000000011e-03, 3.71791999999999999e-03, 4.75158000000000004e-03, 5.90694000000000028e-03, 7.47447000000000042e-03, 9.18350000000000069e-03, 1.14342599999999999e-02, 1.38876299999999998e-02, 1.70748000000000011e-02, 2.05424700000000002e-02, 2.48282800000000012e-02, 2.91778599999999999e-02, 3.45427400000000023e-02, 3.97091899999999984e-02, 4.58218300000000009e-02, 5.13577900000000004e-02, 5.72795499999999985e-02, 6.18463799999999994e-02, 6.62069700000000039e-02, 6.81382199999999993e-02, 6.93977300000000047e-02, 6.73599299999999984e-02, 6.36853799999999998e-02, 5.65956400000000026e-02, 4.83863500000000016e-02, 3.80981599999999990e-02, 2.80717400000000013e-02, 1.86401199999999996e-02, 1.13495599999999999e-02, 6.19358999999999969e-03, 3.15596000000000019e-03, 1.46874000000000006e-03, 6.48479999999999998e-04, 2.73499999999999980e-04, 1.10909999999999994e-04, 4.25800000000000023e-05, 1.57100000000000004e-05, 6.11999999999999985e-06, 2.20000000000000011e-06, 9.40000000000000000e-07, 3.30000000000000017e-07, 1.10000000000000006e-07, 5.99999999999999946e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[5][19] = niz5_19;
	static double niz5_20[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.99999999999999973e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 2.99999999999999973e-08, 2.99999999999999973e-08, 9.99999999999999955e-08, 4.99999999999999977e-08, 1.29999999999999999e-07, 1.29999999999999999e-07, 2.20000000000000011e-07, 2.99999999999999986e-07, 2.99999999999999986e-07, 3.30000000000000017e-07, 4.30000000000000012e-07, 5.60000000000000038e-07, 8.19999999999999984e-07, 1.15000000000000000e-06, 1.32999999999999997e-06, 1.88999999999999990e-06, 2.42000000000000012e-06, 2.65000000000000004e-06, 3.67000000000000001e-06, 4.94000000000000014e-06, 6.15000000000000041e-06, 7.40000000000000030e-06, 1.01800000000000008e-05, 1.27400000000000000e-05, 1.65099999999999995e-05, 2.06199999999999991e-05, 2.86900000000000014e-05, 3.56899999999999988e-05, 4.56999999999999995e-05, 5.61999999999999972e-05, 7.31399999999999943e-05, 9.23100000000000022e-05, 1.19810000000000007e-04, 1.51139999999999993e-04, 2.02639999999999998e-04, 2.49949999999999977e-04, 3.22369999999999992e-04, 4.07210000000000026e-04, 5.30479999999999949e-04, 6.54869999999999996e-04, 8.46309999999999966e-04, 1.04421000000000006e-03, 1.35833999999999998e-03, 1.68640000000000001e-03, 2.16284000000000007e-03, 2.67541999999999997e-03, 3.38279000000000010e-03, 4.14372999999999998e-03, 5.18596999999999982e-03, 6.36898999999999972e-03, 7.96209999999999973e-03, 9.64974000000000040e-03, 1.18913400000000002e-02, 1.42530699999999996e-02, 1.73013399999999984e-02, 2.04583100000000004e-02, 2.44278900000000007e-02, 2.85000899999999988e-02, 3.34655599999999984e-02, 3.81789599999999979e-02, 4.35747100000000026e-02, 4.84402000000000027e-02, 5.39169599999999999e-02, 5.81177400000000011e-02, 6.22735099999999972e-02, 6.43285100000000054e-02, 6.59339199999999931e-02, 6.46626200000000040e-02, 6.22563100000000022e-02, 5.67974399999999977e-02, 5.02044899999999975e-02, 4.13104200000000005e-02, 3.23401400000000033e-02, 2.30685199999999986e-02, 1.53782999999999993e-02, 9.22305999999999994e-03, 5.17375000000000040e-03, 2.65483999999999989e-03, 1.29678999999999992e-03, 5.89090000000000013e-04, 2.64100000000000023e-04, 1.10100000000000006e-04, 4.61700000000000001e-05, 1.76999999999999999e-05, 7.39000000000000040e-06, 2.69000000000000008e-06, 1.14000000000000010e-06, 4.09999999999999992e-07, 1.40000000000000010e-07, 7.00000000000000048e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[5][20] = niz5_20;
	static double niz5_21[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 2.99999999999999973e-08, 4.00000000000000008e-08, 0.00000000000000000e+00, 2.99999999999999973e-08, 4.00000000000000008e-08, 1.10000000000000006e-07, 4.99999999999999977e-08, 1.90000000000000007e-07, 1.40000000000000010e-07, 1.69999999999999987e-07, 1.69999999999999987e-07, 1.99999999999999991e-07, 3.59999999999999994e-07, 4.40000000000000022e-07, 6.79999999999999948e-07, 7.70000000000000039e-07, 1.03000000000000009e-06, 1.43999999999999998e-06, 1.68999999999999991e-06, 1.90000000000000002e-06, 2.34999999999999995e-06, 3.31999999999999998e-06, 4.33000000000000005e-06, 5.11000000000000020e-06, 6.77000000000000040e-06, 8.81000000000000035e-06, 1.13200000000000000e-05, 1.37800000000000002e-05, 1.69800000000000001e-05, 2.09300000000000012e-05, 2.57000000000000013e-05, 3.47700000000000008e-05, 4.14599999999999995e-05, 5.50500000000000032e-05, 6.81099999999999967e-05, 9.25900000000000063e-05, 1.11379999999999994e-04, 1.43830000000000010e-04, 1.75880000000000003e-04, 2.23749999999999991e-04, 2.78739999999999977e-04, 3.58419999999999973e-04, 4.41859999999999974e-04, 5.67659999999999996e-04, 7.04980000000000016e-04, 8.92479999999999966e-04, 1.09381999999999991e-03, 1.38523000000000010e-03, 1.69344000000000005e-03, 2.13430999999999994e-03, 2.62286999999999980e-03, 3.28726000000000018e-03, 4.01081000000000007e-03, 4.96962000000000011e-03, 6.01621000000000013e-03, 7.38713000000000043e-03, 8.88350000000000077e-03, 1.08581000000000007e-02, 1.29323300000000006e-02, 1.55849999999999999e-02, 1.83426000000000006e-02, 2.17638599999999995e-02, 2.52235999999999988e-02, 2.95042299999999993e-02, 3.36145500000000000e-02, 3.84762300000000002e-02, 4.29545900000000008e-02, 4.80673400000000001e-02, 5.20322599999999968e-02, 5.64705699999999977e-02, 5.92656199999999980e-02, 6.19976900000000011e-02, 6.23199099999999992e-02, 6.20448799999999967e-02, 5.88932500000000012e-02, 5.49039799999999981e-02, 4.83219699999999988e-02, 4.11357099999999989e-02, 3.24650299999999989e-02, 2.43529700000000016e-02, 1.67176500000000006e-02, 1.07304199999999992e-02, 6.28652000000000030e-03, 3.49524000000000015e-03, 1.80005000000000009e-03, 8.87149999999999961e-04, 4.16140000000000010e-04, 1.90170000000000004e-04, 8.17800000000000064e-05, 3.76299999999999972e-05, 1.53100000000000008e-05, 6.82999999999999983e-06, 3.00999999999999998e-06, 1.08999999999999994e-06, 3.70000000000000004e-07, 1.60000000000000003e-07, 4.99999999999999977e-08, 2.00000000000000004e-08, 2.00000000000000004e-08, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[5][21] = niz5_21;
	static double niz5_22[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 2.99999999999999973e-08, 4.00000000000000008e-08, 2.00000000000000004e-08, 2.99999999999999973e-08, 4.00000000000000008e-08, 7.00000000000000048e-08, 8.00000000000000017e-08, 4.00000000000000008e-08, 7.00000000000000048e-08, 8.00000000000000017e-08, 1.29999999999999999e-07, 2.39999999999999979e-07, 2.70000000000000009e-07, 2.39999999999999979e-07, 3.09999999999999997e-07, 4.20000000000000002e-07, 5.99999999999999973e-07, 6.70000000000000044e-07, 7.99999999999999964e-07, 7.19999999999999989e-07, 1.08000000000000004e-06, 1.83999999999999996e-06, 1.94999999999999996e-06, 2.47999999999999997e-06, 3.04000000000000012e-06, 4.18999999999999969e-06, 5.09000000000000039e-06, 6.22999999999999964e-06, 7.52000000000000000e-06, 9.35000000000000027e-06, 1.14400000000000006e-05, 1.46600000000000002e-05, 1.74199999999999992e-05, 2.40499999999999984e-05, 2.88199999999999985e-05, 3.68900000000000009e-05, 4.52100000000000025e-05, 5.67499999999999971e-05, 7.03700000000000056e-05, 8.62799999999999939e-05, 1.09080000000000006e-04, 1.39509999999999998e-04, 1.71950000000000005e-04, 2.17810000000000003e-04, 2.67680000000000012e-04, 3.41139999999999976e-04, 4.12729999999999987e-04, 5.20810000000000023e-04, 6.36289999999999968e-04, 7.99009999999999955e-04, 9.85390000000000051e-04, 1.24026999999999991e-03, 1.50135999999999998e-03, 1.87696999999999994e-03, 2.27544000000000010e-03, 2.81826999999999989e-03, 3.39049999999999985e-03, 4.17881999999999976e-03, 5.04411000000000009e-03, 6.17136999999999981e-03, 7.39231999999999997e-03, 8.93475999999999992e-03, 1.05734100000000001e-02, 1.26849200000000006e-02, 1.49000000000000000e-02, 1.76935299999999990e-02, 2.05305999999999995e-02, 2.40201999999999985e-02, 2.74607600000000007e-02, 3.15575999999999982e-02, 3.54768899999999970e-02, 4.00030499999999983e-02, 4.40534900000000007e-02, 4.85676300000000005e-02, 5.19525399999999984e-02, 5.56767599999999988e-02, 5.76785100000000023e-02, 5.96196000000000018e-02, 5.93322599999999978e-02, 5.84049099999999974e-02, 5.50585300000000014e-02, 5.08952599999999977e-02, 4.45486800000000002e-02, 3.77319600000000019e-02, 2.98463399999999990e-02, 2.25033900000000016e-02, 1.56406299999999991e-02, 1.02462700000000000e-02, 6.17016000000000005e-03, 3.54257000000000009e-03, 1.88554000000000000e-03, 9.80020000000000066e-04, 4.79290000000000000e-04, 2.29089999999999990e-04, 1.06059999999999998e-04, 4.70600000000000001e-05, 2.05900000000000011e-05, 9.63999999999999918e-06, 4.44999999999999975e-06, 1.61999999999999995e-06, 6.60000000000000034e-07, 1.79999999999999997e-07, 5.99999999999999946e-08, 8.00000000000000017e-08, 2.99999999999999973e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[5][22] = niz5_22;
	static double niz5_23[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.00000000000000004e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 0.00000000000000000e+00, 5.99999999999999946e-08, 5.99999999999999946e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 4.99999999999999977e-08, 8.00000000000000017e-08, 2.10000000000000001e-07, 1.00000000000000002e-08, 1.29999999999999999e-07, 9.99999999999999955e-08, 2.10000000000000001e-07, 2.29999999999999995e-07, 2.99999999999999986e-07, 4.09999999999999992e-07, 6.50000000000000024e-07, 5.89999999999999963e-07, 6.50000000000000024e-07, 1.01999999999999998e-06, 1.12999999999999998e-06, 1.41000000000000005e-06, 1.61000000000000004e-06, 2.08999999999999989e-06, 2.57999999999999986e-06, 3.15999999999999981e-06, 3.99999999999999982e-06, 5.12000000000000011e-06, 6.42000000000000037e-06, 7.04000000000000036e-06, 9.37999999999999998e-06, 1.09500000000000002e-05, 1.37600000000000004e-05, 1.64300000000000002e-05, 2.22099999999999991e-05, 2.59500000000000006e-05, 3.42300000000000026e-05, 3.97999999999999984e-05, 5.25999999999999978e-05, 6.30299999999999979e-05, 7.94800000000000047e-05, 9.52400000000000029e-05, 1.21150000000000004e-04, 1.48130000000000006e-04, 1.81750000000000000e-04, 2.21849999999999999e-04, 2.82540000000000016e-04, 3.42569999999999995e-04, 4.25950000000000027e-04, 5.18930000000000021e-04, 6.43730000000000018e-04, 7.75509999999999980e-04, 9.65640000000000031e-04, 1.16522999999999996e-03, 1.44465999999999995e-03, 1.74168999999999995e-03, 2.15119999999999981e-03, 2.58596999999999994e-03, 3.15958999999999988e-03, 3.77816000000000003e-03, 4.60361000000000017e-03, 5.47927999999999957e-03, 6.62414999999999966e-03, 7.83834999999999914e-03, 9.39193999999999966e-03, 1.10486100000000004e-02, 1.31090600000000005e-02, 1.52183800000000001e-02, 1.78928600000000000e-02, 2.05469300000000014e-02, 2.38516000000000006e-02, 2.70866599999999985e-02, 3.09005200000000008e-02, 3.44371899999999995e-02, 3.86118400000000014e-02, 4.22459199999999993e-02, 4.64122800000000002e-02, 4.95153600000000013e-02, 5.30004800000000026e-02, 5.48816899999999969e-02, 5.68398800000000023e-02, 5.67418900000000032e-02, 5.63596899999999970e-02, 5.36645399999999967e-02, 5.03326499999999996e-02, 4.49868599999999966e-02, 3.91621899999999995e-02, 3.20707100000000023e-02, 2.52466400000000007e-02, 1.84566999999999995e-02, 1.28576200000000002e-02, 8.23538000000000048e-03, 5.05595999999999997e-03, 2.88442999999999989e-03, 1.60490999999999997e-03, 8.33720000000000034e-04, 4.26920000000000012e-04, 2.04429999999999993e-04, 9.66200000000000067e-05, 4.68600000000000020e-05, 2.12200000000000001e-05, 9.05999999999999965e-06, 4.19999999999999960e-06, 1.95999999999999987e-06, 8.80000000000000045e-07, 3.59999999999999994e-07, 1.29999999999999999e-07, 8.99999999999999986e-08, 2.00000000000000004e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[5][23] = niz5_23;
	static double niz5_24[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 2.00000000000000004e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.99999999999999973e-08, 2.99999999999999973e-08, 1.00000000000000002e-08, 4.00000000000000008e-08, 4.00000000000000008e-08, 5.99999999999999946e-08, 2.00000000000000004e-08, 0.00000000000000000e+00, 9.99999999999999955e-08, 4.00000000000000008e-08, 4.99999999999999977e-08, 1.29999999999999999e-07, 1.49999999999999993e-07, 8.00000000000000017e-08, 2.49999999999999989e-07, 1.90000000000000007e-07, 2.80000000000000019e-07, 2.29999999999999995e-07, 4.20000000000000002e-07, 5.19999999999999998e-07, 5.19999999999999998e-07, 6.40000000000000013e-07, 8.29999999999999994e-07, 1.08999999999999994e-06, 1.59999999999999993e-06, 1.85999999999999998e-06, 2.43999999999999993e-06, 2.59000000000000019e-06, 3.14999999999999991e-06, 4.03000000000000038e-06, 4.76000000000000017e-06, 6.16000000000000031e-06, 7.50000000000000019e-06, 9.19000000000000010e-06, 1.16700000000000001e-05, 1.33299999999999994e-05, 1.78399999999999986e-05, 2.11499999999999991e-05, 2.63699999999999999e-05, 3.18600000000000033e-05, 4.07799999999999992e-05, 4.77100000000000023e-05, 6.12299999999999948e-05, 7.32099999999999987e-05, 9.26700000000000055e-05, 1.11479999999999997e-04, 1.40790000000000012e-04, 1.69120000000000007e-04, 2.05989999999999998e-04, 2.51079999999999988e-04, 3.05399999999999997e-04, 3.65770000000000017e-04, 4.57590000000000015e-04, 5.51350000000000039e-04, 6.78279999999999964e-04, 8.21239999999999991e-04, 1.00679999999999997e-03, 1.20307000000000009e-03, 1.47251000000000001e-03, 1.76867999999999991e-03, 2.14862999999999990e-03, 2.56267999999999991e-03, 3.12313000000000000e-03, 3.69849999999999996e-03, 4.46746000000000035e-03, 5.27653999999999970e-03, 6.33186999999999986e-03, 7.42127999999999972e-03, 8.83539000000000026e-03, 1.03054500000000007e-02, 1.21460900000000000e-02, 1.40665400000000006e-02, 1.64159200000000005e-02, 1.88008700000000008e-02, 2.16966300000000015e-02, 2.45345499999999987e-02, 2.79912699999999987e-02, 3.11728400000000003e-02, 3.50086299999999989e-02, 3.83406199999999989e-02, 4.22021299999999974e-02, 4.52805999999999972e-02, 4.88047200000000028e-02, 5.10203600000000007e-02, 5.34465699999999988e-02, 5.42070899999999994e-02, 5.48188000000000009e-02, 5.34304599999999991e-02, 5.17293200000000022e-02, 4.78201200000000007e-02, 4.35772599999999996e-02, 3.76798699999999973e-02, 3.17156899999999978e-02, 2.50225799999999991e-02, 1.89927299999999993e-02, 1.34216600000000002e-02, 9.06677000000000004e-03, 5.71662000000000038e-03, 3.46693999999999995e-03, 1.96670000000000005e-03, 1.10018000000000008e-03, 5.74669999999999999e-04, 3.01100000000000000e-04, 1.51869999999999994e-04, 7.56300000000000060e-05, 3.58400000000000024e-05, 1.71199999999999987e-05, 8.80000000000000045e-06, 3.67000000000000001e-06, 1.93000000000000016e-06, 6.89999999999999958e-07, 2.49999999999999989e-07, 1.29999999999999999e-07, 1.10000000000000006e-07, 2.00000000000000004e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[5][24] = niz5_24;
	static double niz5_25[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 2.00000000000000004e-08, 0.00000000000000000e+00, 2.00000000000000004e-08, 2.99999999999999973e-08, 5.99999999999999946e-08, 9.99999999999999955e-08, 8.00000000000000017e-08, 7.00000000000000048e-08, 9.99999999999999955e-08, 9.99999999999999955e-08, 9.99999999999999955e-08, 2.10000000000000001e-07, 2.80000000000000019e-07, 2.20000000000000011e-07, 3.99999999999999982e-07, 4.59999999999999990e-07, 6.60000000000000034e-07, 7.29999999999999999e-07, 8.89999999999999949e-07, 9.70000000000000030e-07, 1.32000000000000007e-06, 1.59999999999999993e-06, 2.21000000000000002e-06, 2.21999999999999992e-06, 2.97999999999999984e-06, 3.71000000000000005e-06, 3.99999999999999982e-06, 4.96999999999999985e-06, 5.99000000000000025e-06, 7.49000000000000029e-06, 9.04999999999999975e-06, 1.01599999999999993e-05, 1.35099999999999994e-05, 1.57699999999999998e-05, 1.90699999999999987e-05, 2.33900000000000014e-05, 2.93000000000000007e-05, 3.40500000000000009e-05, 4.34600000000000006e-05, 5.27000000000000003e-05, 6.52599999999999952e-05, 7.53399999999999936e-05, 9.43299999999999998e-05, 1.10630000000000003e-04, 1.36389999999999987e-04, 1.63539999999999996e-04, 2.00850000000000003e-04, 2.41560000000000011e-04, 2.98880000000000012e-04, 3.55989999999999985e-04, 4.41199999999999991e-04, 5.24830000000000001e-04, 6.36759999999999995e-04, 7.61019999999999947e-04, 9.28470000000000033e-04, 1.10588000000000006e-03, 1.34620000000000009e-03, 1.59774000000000005e-03, 1.92457999999999995e-03, 2.28175999999999986e-03, 2.74707999999999983e-03, 3.25129999999999994e-03, 3.87515999999999989e-03, 4.56449000000000004e-03, 5.45356999999999960e-03, 6.35892999999999962e-03, 7.55370999999999994e-03, 8.76082000000000076e-03, 1.03037600000000003e-02, 1.18895100000000007e-02, 1.38434000000000005e-02, 1.58383900000000008e-02, 1.82963499999999994e-02, 2.07011199999999999e-02, 2.36395600000000004e-02, 2.64151400000000001e-02, 2.97152400000000004e-02, 3.27482399999999979e-02, 3.63551500000000027e-02, 3.93458299999999983e-02, 4.28731300000000023e-02, 4.54835300000000012e-02, 4.84706599999999987e-02, 5.02103299999999975e-02, 5.20282300000000017e-02, 5.22087499999999982e-02, 5.23180000000000034e-02, 5.05493799999999979e-02, 4.83808199999999980e-02, 4.44626799999999975e-02, 4.02031500000000000e-02, 3.45590399999999992e-02, 2.89763300000000015e-02, 2.28093200000000010e-02, 1.73703299999999998e-02, 1.23218400000000006e-02, 8.45347999999999933e-03, 5.40311000000000003e-03, 3.34936000000000001e-03, 1.95641000000000001e-03, 1.11180999999999997e-03, 6.00040000000000035e-04, 3.22830000000000024e-04, 1.67879999999999999e-04, 8.52499999999999986e-05, 4.32799999999999990e-05, 2.08900000000000016e-05, 1.05700000000000004e-05, 4.42999999999999994e-06, 2.26999999999999987e-06, 1.19000000000000004e-06, 6.70000000000000044e-07, 2.99999999999999986e-07, 1.19999999999999989e-07, 5.99999999999999946e-08, 2.99999999999999973e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[5][25] = niz5_25;
	static double niz5_26[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 2.99999999999999973e-08, 5.99999999999999946e-08, 1.00000000000000002e-08, 2.99999999999999973e-08, 4.99999999999999977e-08, 2.99999999999999973e-08, 8.00000000000000017e-08, 1.49999999999999993e-07, 9.99999999999999955e-08, 1.49999999999999993e-07, 1.60000000000000003e-07, 1.90000000000000007e-07, 2.89999999999999976e-07, 3.39999999999999974e-07, 3.59999999999999994e-07, 2.89999999999999976e-07, 6.19999999999999993e-07, 6.89999999999999958e-07, 6.99999999999999968e-07, 1.08999999999999994e-06, 1.34999999999999999e-06, 1.48000000000000002e-06, 1.61000000000000004e-06, 2.09999999999999980e-06, 2.22999999999999982e-06, 2.73000000000000012e-06, 3.41999999999999987e-06, 4.35999999999999976e-06, 5.25999999999999961e-06, 5.66000000000000002e-06, 7.11999999999999959e-06, 8.64000000000000029e-06, 1.04799999999999996e-05, 1.31599999999999994e-05, 1.55600000000000001e-05, 1.81700000000000005e-05, 2.18499999999999992e-05, 2.57099999999999995e-05, 3.10800000000000006e-05, 3.81799999999999970e-05, 4.65399999999999983e-05, 5.62399999999999969e-05, 6.71500000000000059e-05, 8.21300000000000014e-05, 9.96499999999999963e-05, 1.18920000000000007e-04, 1.41120000000000004e-04, 1.72299999999999987e-04, 2.09399999999999994e-04, 2.53570000000000000e-04, 3.00939999999999975e-04, 3.67209999999999976e-04, 4.32990000000000013e-04, 5.31519999999999953e-04, 6.33129999999999978e-04, 7.60209999999999987e-04, 9.01200000000000005e-04, 1.08894999999999999e-03, 1.28858000000000011e-03, 1.54487999999999999e-03, 1.82744999999999999e-03, 2.19099999999999981e-03, 2.57661999999999995e-03, 3.07147000000000019e-03, 3.60173999999999998e-03, 4.26680000000000028e-03, 4.98633999999999970e-03, 5.87268999999999985e-03, 6.81906999999999999e-03, 8.01947000000000076e-03, 9.22994000000000071e-03, 1.07722200000000008e-02, 1.23220699999999992e-02, 1.42430500000000002e-02, 1.61612299999999987e-02, 1.85260099999999990e-02, 2.08158900000000001e-02, 2.35780000000000017e-02, 2.61956100000000011e-02, 2.93110500000000017e-02, 3.21241099999999974e-02, 3.54747200000000013e-02, 3.81727800000000034e-02, 4.14483699999999983e-02, 4.38548799999999989e-02, 4.65870300000000015e-02, 4.81471600000000013e-02, 4.99404099999999976e-02, 5.01338799999999987e-02, 5.03476200000000026e-02, 4.88583500000000018e-02, 4.71201700000000029e-02, 4.37609200000000018e-02, 4.01239200000000004e-02, 3.50489000000000009e-02, 3.00362300000000006e-02, 2.43405600000000007e-02, 1.91407000000000001e-02, 1.41159600000000003e-02, 1.00924599999999993e-02, 6.74657000000000034e-03, 4.38335000000000027e-03, 2.68252999999999981e-03, 1.59895000000000002e-03, 9.16069999999999949e-04, 5.11430000000000001e-04, 2.79539999999999997e-04, 1.47400000000000005e-04, 7.51600000000000055e-05, 4.08300000000000004e-05, 1.92500000000000003e-05, 9.55000000000000004e-06, 5.18000000000000038e-06, 2.75999999999999983e-06, 9.70000000000000030e-07, 7.70000000000000039e-07, 3.20000000000000007e-07, 9.99999999999999955e-08, 8.00000000000000017e-08, 8.00000000000000017e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[5][26] = niz5_26;
	static double niz5_27[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.00000000000000004e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 0.00000000000000000e+00, 4.00000000000000008e-08, 2.00000000000000004e-08, 2.99999999999999973e-08, 2.99999999999999973e-08, 2.99999999999999973e-08, 7.00000000000000048e-08, 8.00000000000000017e-08, 8.00000000000000017e-08, 1.29999999999999999e-07, 1.29999999999999999e-07, 1.60000000000000003e-07, 1.90000000000000007e-07, 2.10000000000000001e-07, 2.10000000000000001e-07, 3.20000000000000007e-07, 3.70000000000000004e-07, 5.30000000000000008e-07, 6.40000000000000013e-07, 7.50000000000000019e-07, 7.70000000000000039e-07, 1.17999999999999993e-06, 1.06999999999999992e-06, 1.57999999999999991e-06, 1.83999999999999996e-06, 2.33000000000000014e-06, 3.09999999999999997e-06, 3.57000000000000012e-06, 3.96000000000000020e-06, 4.17999999999999979e-06, 5.75999999999999991e-06, 6.44000000000000017e-06, 8.13000000000000009e-06, 9.33000000000000046e-06, 1.11799999999999997e-05, 1.36699999999999996e-05, 1.60100000000000009e-05, 1.99399999999999988e-05, 2.32499999999999993e-05, 2.72900000000000013e-05, 3.27400000000000016e-05, 3.96699999999999980e-05, 4.66199999999999975e-05, 5.53099999999999973e-05, 6.73600000000000056e-05, 7.91499999999999994e-05, 9.75200000000000014e-05, 1.14430000000000000e-04, 1.40590000000000007e-04, 1.66650000000000012e-04, 1.99860000000000001e-04, 2.34099999999999998e-04, 2.88090000000000015e-04, 3.31989999999999998e-04, 3.99769999999999976e-04, 4.74570000000000005e-04, 5.72110000000000023e-04, 6.71810000000000007e-04, 8.10880000000000043e-04, 9.51180000000000038e-04, 1.14105000000000001e-03, 1.34084999999999998e-03, 1.58824000000000009e-03, 1.85950000000000004e-03, 2.20971000000000015e-03, 2.59360000000000016e-03, 3.06456000000000003e-03, 3.57946999999999996e-03, 4.21076999999999996e-03, 4.87101000000000027e-03, 5.72398999999999998e-03, 6.59249000000000033e-03, 7.69937999999999959e-03, 8.79231999999999930e-03, 1.02174799999999993e-02, 1.16310900000000002e-02, 1.33871500000000004e-02, 1.51130699999999993e-02, 1.72571699999999988e-02, 1.93075600000000014e-02, 2.18472400000000004e-02, 2.41923999999999993e-02, 2.70529800000000008e-02, 2.96081899999999995e-02, 3.27134499999999981e-02, 3.52383900000000014e-02, 3.83650000000000033e-02, 4.06644700000000012e-02, 4.34150999999999981e-02, 4.51908999999999991e-02, 4.71947699999999970e-02, 4.79103999999999988e-02, 4.87299399999999994e-02, 4.79996599999999995e-02, 4.72051500000000013e-02, 4.47977300000000009e-02, 4.21830300000000033e-02, 3.81699500000000011e-02, 3.40372400000000033e-02, 2.88557899999999992e-02, 2.39658100000000006e-02, 1.87700600000000016e-02, 1.43183600000000005e-02, 1.02718900000000005e-02, 7.15728000000000024e-03, 4.70756000000000039e-03, 3.00146000000000007e-03, 1.82490999999999990e-03, 1.09022999999999998e-03, 6.22970000000000034e-04, 3.55579999999999980e-04, 1.93439999999999991e-04, 1.06689999999999997e-04, 5.72400000000000008e-05, 2.92699999999999993e-05, 1.60199999999999991e-05, 7.63999999999999970e-06, 4.04000000000000028e-06, 2.13999999999999984e-06, 9.90000000000000050e-07, 5.30000000000000008e-07, 3.20000000000000007e-07, 9.99999999999999955e-08, 8.99999999999999986e-08, 5.99999999999999946e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[5][27] = niz5_27;
	static double niz5_28[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 2.00000000000000004e-08, 4.99999999999999977e-08, 0.00000000000000000e+00, 2.00000000000000004e-08, 2.00000000000000004e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 2.99999999999999973e-08, 2.00000000000000004e-08, 5.99999999999999946e-08, 5.99999999999999946e-08, 4.99999999999999977e-08, 8.00000000000000017e-08, 9.99999999999999955e-08, 8.99999999999999986e-08, 1.29999999999999999e-07, 2.10000000000000001e-07, 2.10000000000000001e-07, 1.29999999999999999e-07, 3.59999999999999994e-07, 3.20000000000000007e-07, 3.59999999999999994e-07, 3.20000000000000007e-07, 4.09999999999999992e-07, 6.40000000000000013e-07, 9.59999999999999914e-07, 7.80000000000000049e-07, 1.15000000000000000e-06, 1.50999999999999994e-06, 1.77999999999999990e-06, 1.72000000000000005e-06, 2.22999999999999982e-06, 2.47999999999999997e-06, 3.09000000000000006e-06, 3.09000000000000006e-06, 4.78999999999999988e-06, 5.43999999999999958e-06, 6.01999999999999996e-06, 7.02999999999999961e-06, 8.59000000000000077e-06, 9.79999999999999934e-06, 1.19800000000000005e-05, 1.40099999999999997e-05, 1.79800000000000006e-05, 1.91599999999999995e-05, 2.37399999999999997e-05, 2.86799999999999998e-05, 3.43600000000000031e-05, 4.05800000000000011e-05, 4.88000000000000003e-05, 5.72999999999999969e-05, 6.82399999999999972e-05, 8.18100000000000045e-05, 9.69599999999999932e-05, 1.15769999999999998e-04, 1.37209999999999996e-04, 1.61050000000000012e-04, 1.96590000000000013e-04, 2.32789999999999999e-04, 2.77169999999999977e-04, 3.24330000000000007e-04, 3.89609999999999978e-04, 4.57810000000000009e-04, 5.48509999999999991e-04, 6.42540000000000038e-04, 7.66920000000000037e-04, 8.94709999999999950e-04, 1.05896000000000007e-03, 1.24255000000000003e-03, 1.47505000000000010e-03, 1.72352000000000009e-03, 2.03923999999999989e-03, 2.34949000000000009e-03, 2.77076000000000015e-03, 3.20418999999999999e-03, 3.75787999999999990e-03, 4.33845999999999971e-03, 5.07820999999999967e-03, 5.81031999999999989e-03, 6.77098000000000023e-03, 7.72093999999999992e-03, 8.93858999999999973e-03, 1.01420099999999999e-02, 1.16391900000000006e-02, 1.31389899999999997e-02, 1.49697100000000007e-02, 1.67532799999999989e-02, 1.89370300000000005e-02, 2.10112600000000004e-02, 2.35057200000000008e-02, 2.57782499999999991e-02, 2.85519899999999993e-02, 3.09573799999999996e-02, 3.38706299999999988e-02, 3.62411499999999998e-02, 3.89731300000000017e-02, 4.09588800000000031e-02, 4.33753200000000019e-02, 4.46695999999999968e-02, 4.62557099999999985e-02, 4.65665700000000016e-02, 4.69086299999999998e-02, 4.58146200000000003e-02, 4.46415100000000023e-02, 4.19835000000000000e-02, 3.92246399999999981e-02, 3.51450300000000007e-02, 3.10771700000000012e-02, 2.62031500000000014e-02, 2.16541500000000005e-02, 1.69463699999999988e-02, 1.29284199999999995e-02, 9.29373000000000005e-03, 6.51105000000000000e-03, 4.32172000000000025e-03, 2.80724999999999985e-03, 1.73478000000000000e-03, 1.05301000000000006e-03, 6.15989999999999962e-04, 3.57000000000000004e-04, 2.03539999999999993e-04, 1.13489999999999999e-04, 6.26500000000000049e-05, 3.34200000000000019e-05, 1.81300000000000009e-05, 9.08999999999999937e-06, 4.87999999999999986e-06, 2.60000000000000009e-06, 1.45000000000000009e-06, 6.70000000000000044e-07, 2.80000000000000019e-07, 2.10000000000000001e-07, 4.99999999999999977e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 2.00000000000000004e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[5][28] = niz5_28;
	static double niz5_29[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 1.00000000000000002e-08, 4.00000000000000008e-08, 2.00000000000000004e-08, 2.00000000000000004e-08, 2.00000000000000004e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 1.10000000000000006e-07, 5.99999999999999946e-08, 2.99999999999999973e-08, 5.99999999999999946e-08, 1.29999999999999999e-07, 1.19999999999999989e-07, 1.49999999999999993e-07, 1.90000000000000007e-07, 2.29999999999999995e-07, 1.90000000000000007e-07, 2.10000000000000001e-07, 2.39999999999999979e-07, 2.59999999999999999e-07, 4.30000000000000012e-07, 4.09999999999999992e-07, 5.30000000000000008e-07, 7.09999999999999978e-07, 6.50000000000000024e-07, 6.60000000000000034e-07, 1.06000000000000002e-06, 1.15999999999999991e-06, 1.39999999999999994e-06, 1.37000000000000001e-06, 1.52000000000000006e-06, 2.19000000000000021e-06, 2.31999999999999981e-06, 3.09999999999999997e-06, 3.53999999999999999e-06, 4.68999999999999999e-06, 5.45000000000000034e-06, 6.36000000000000009e-06, 7.31000000000000032e-06, 8.34999999999999968e-06, 9.86000000000000046e-06, 1.16700000000000001e-05, 1.40399999999999994e-05, 1.59000000000000002e-05, 1.96499999999999999e-05, 2.33700000000000016e-05, 2.65400000000000000e-05, 3.26500000000000008e-05, 3.80699999999999997e-05, 4.63600000000000034e-05, 5.30800000000000000e-05, 6.29700000000000019e-05, 7.33800000000000056e-05, 8.93899999999999963e-05, 1.04019999999999997e-04, 1.27479999999999992e-04, 1.45069999999999992e-04, 1.77219999999999987e-04, 2.02110000000000001e-04, 2.43489999999999988e-04, 2.84960000000000009e-04, 3.40630000000000023e-04, 3.93320000000000009e-04, 4.72639999999999974e-04, 5.53839999999999996e-04, 6.54199999999999964e-04, 7.54859999999999993e-04, 8.98660000000000019e-04, 1.03808999999999998e-03, 1.22067000000000009e-03, 1.42682000000000008e-03, 1.67847999999999999e-03, 1.95242000000000007e-03, 2.28414999999999998e-03, 2.63220999999999985e-03, 3.06886000000000008e-03, 3.54635000000000020e-03, 4.12402999999999988e-03, 4.71328000000000025e-03, 5.47909999999999977e-03, 6.23881000000000002e-03, 7.21824999999999984e-03, 8.17708999999999971e-03, 9.39100000000000004e-03, 1.05893900000000006e-02, 1.20860099999999995e-02, 1.35354499999999992e-02, 1.53319500000000004e-02, 1.70435799999999991e-02, 1.91847100000000007e-02, 2.11347599999999990e-02, 2.35437699999999986e-02, 2.56654400000000012e-02, 2.83016999999999991e-02, 3.05385399999999994e-02, 3.32110300000000025e-02, 3.53854799999999969e-02, 3.80144999999999997e-02, 3.97836499999999968e-02, 4.20105699999999971e-02, 4.31670999999999999e-02, 4.46114599999999986e-02, 4.48690500000000006e-02, 4.52798400000000018e-02, 4.42802500000000002e-02, 4.33356000000000019e-02, 4.09074300000000016e-02, 3.85129000000000027e-02, 3.48234399999999972e-02, 3.11946199999999993e-02, 2.67070099999999998e-02, 2.24585399999999991e-02, 1.79907499999999998e-02, 1.40583099999999992e-02, 1.04108699999999992e-02, 7.54481999999999983e-03, 5.17945000000000037e-03, 3.47547000000000003e-03, 2.22621000000000017e-03, 1.41245999999999993e-03, 8.61840000000000002e-04, 5.18229999999999949e-04, 3.00709999999999986e-04, 1.77190000000000003e-04, 1.00180000000000006e-04, 5.56000000000000030e-05, 3.02600000000000017e-05, 1.62099999999999990e-05, 9.27999999999999924e-06, 4.70999999999999980e-06, 2.53999999999999982e-06, 1.41000000000000005e-06, 6.30000000000000003e-07, 3.30000000000000017e-07, 1.69999999999999987e-07, 8.99999999999999986e-08, 2.00000000000000004e-08, 2.99999999999999973e-08, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[5][29] = niz5_29;
	static double niz5_30[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 2.00000000000000004e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.99999999999999973e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.99999999999999973e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 5.99999999999999946e-08, 2.00000000000000004e-08, 2.99999999999999973e-08, 4.99999999999999977e-08, 4.99999999999999977e-08, 2.99999999999999973e-08, 5.99999999999999946e-08, 4.99999999999999977e-08, 4.99999999999999977e-08, 9.99999999999999955e-08, 1.29999999999999999e-07, 1.40000000000000010e-07, 1.79999999999999997e-07, 1.90000000000000007e-07, 2.29999999999999995e-07, 2.80000000000000019e-07, 2.49999999999999989e-07, 3.20000000000000007e-07, 4.09999999999999992e-07, 4.99999999999999977e-07, 6.19999999999999993e-07, 8.40000000000000004e-07, 8.09999999999999974e-07, 9.79999999999999934e-07, 1.21999999999999997e-06, 1.34000000000000009e-06, 1.81000000000000003e-06, 1.88999999999999990e-06, 2.56999999999999996e-06, 2.59000000000000019e-06, 3.15999999999999981e-06, 3.86000000000000031e-06, 4.43999999999999984e-06, 5.47000000000000014e-06, 6.63000000000000005e-06, 7.11999999999999959e-06, 8.69999999999999971e-06, 9.85000000000000056e-06, 1.20899999999999994e-05, 1.39300000000000005e-05, 1.69900000000000017e-05, 1.97000000000000011e-05, 2.32600000000000009e-05, 2.75899999999999984e-05, 3.20499999999999998e-05, 3.90799999999999985e-05, 4.49600000000000032e-05, 5.22699999999999993e-05, 6.22199999999999972e-05, 7.43500000000000047e-05, 8.82500000000000038e-05, 1.01550000000000002e-04, 1.18300000000000002e-04, 1.39729999999999992e-04, 1.62830000000000011e-04, 1.95429999999999991e-04, 2.26989999999999993e-04, 2.64860000000000009e-04, 3.11760000000000010e-04, 3.68170000000000021e-04, 4.23949999999999978e-04, 5.03140000000000011e-04, 5.89820000000000014e-04, 6.90390000000000036e-04, 8.04789999999999998e-04, 9.37299999999999960e-04, 1.08518999999999998e-03, 1.27749999999999999e-03, 1.47659000000000006e-03, 1.72336999999999989e-03, 1.98199999999999982e-03, 2.31220999999999987e-03, 2.64818999999999992e-03, 3.08508999999999997e-03, 3.53696000000000002e-03, 4.10511000000000036e-03, 4.66509000000000021e-03, 5.39623000000000012e-03, 6.10100999999999959e-03, 7.01518000000000020e-03, 7.91851000000000013e-03, 9.06345000000000067e-03, 1.01772600000000005e-02, 1.15770200000000004e-02, 1.28974899999999993e-02, 1.45893199999999994e-02, 1.61317100000000005e-02, 1.81012200000000012e-02, 1.98897700000000011e-02, 2.20671100000000009e-02, 2.40918799999999995e-02, 2.64938800000000009e-02, 2.85491699999999987e-02, 3.10686400000000015e-02, 3.31249200000000021e-02, 3.56138599999999972e-02, 3.74043800000000010e-02, 3.95851499999999995e-02, 4.09452100000000027e-02, 4.25379199999999999e-02, 4.30460900000000021e-02, 4.38057899999999972e-02, 4.33658199999999994e-02, 4.29158899999999982e-02, 4.12045700000000029e-02, 3.94750300000000012e-02, 3.65059100000000025e-02, 3.35440499999999989e-02, 2.96025999999999997e-02, 2.58062499999999993e-02, 2.15154200000000004e-02, 1.75901099999999991e-02, 1.37004899999999992e-02, 1.04355400000000001e-02, 7.53452000000000028e-03, 5.35976999999999981e-03, 3.61671999999999992e-03, 2.40667000000000008e-03, 1.53179000000000010e-03, 9.61909999999999957e-04, 5.86660000000000024e-04, 3.51740000000000017e-04, 2.08850000000000008e-04, 1.21499999999999999e-04, 6.83100000000000016e-05, 3.86599999999999992e-05, 2.21200000000000017e-05, 1.16300000000000005e-05, 6.86000000000000039e-06, 3.71999999999999996e-06, 2.09999999999999980e-06, 1.12000000000000008e-06, 5.30000000000000008e-07, 2.99999999999999986e-07, 1.90000000000000007e-07, 9.99999999999999955e-08, 8.00000000000000017e-08, 2.00000000000000004e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[5][30] = niz5_30;

	static double niz6_1[] = { 1.00000000000000000e+00 }; repRatios[6][1] = niz6_1;
	static double niz6_2[] = { 3.05530259999999998e-01, 6.94469739999999947e-01 }; repRatios[6][2] = niz6_2;
	static double niz6_3[] = { 5.47719399999999981e-02, 1.15744120000000006e-01, 5.20811820000000036e-01, 3.08672119999999994e-01 }; repRatios[6][3] = niz6_3;
	static double niz6_4[] = { 9.23201000000000056e-03, 6.44259999999999972e-03, 6.75462200000000040e-02, 1.56481280000000000e-01, 3.23094649999999983e-01, 3.60068800000000022e-01, 7.71344399999999986e-02 }; repRatios[6][4] = niz6_4;
	static double niz6_5[] = { 1.54243999999999996e-03, 2.97339999999999996e-04, 4.47325999999999974e-03, 1.57961299999999985e-02, 4.40043099999999979e-02, 7.14437299999999970e-02, 2.04943640000000010e-01, 2.59528980000000020e-01, 2.82257240000000020e-01, 1.07131470000000006e-01, 8.58146000000000082e-03 }; repRatios[6][5] = niz6_5;
	static double niz6_6[] = { 2.59110000000000004e-04, 1.29299999999999999e-05, 2.50920000000000017e-04, 1.23174999999999999e-03, 4.14846999999999959e-03, 5.02286999999999959e-03, 1.78926499999999995e-02, 3.42758499999999966e-02, 7.35051099999999985e-02, 1.29210889999999995e-01, 1.99053129999999995e-01, 2.46290890000000012e-01, 1.93058370000000007e-01, 8.48351900000000048e-02, 1.07122799999999994e-02, 2.39590000000000002e-04 }; repRatios[6][6] = niz6_6;
	static double niz6_7[] = { 4.30599999999999977e-05, 3.70000000000000004e-07, 1.25200000000000004e-05, 8.06300000000000056e-05, 3.59200000000000003e-04, 6.15430000000000035e-04, 1.31481999999999996e-03, 1.32021999999999999e-03, 6.26516999999999959e-03, 1.14811600000000007e-02, 2.03679000000000013e-02, 3.70117100000000032e-02, 7.57580999999999949e-02, 1.12119440000000001e-01, 1.65162799999999999e-01, 2.03345520000000002e-01, 1.89759289999999997e-01, 1.23681890000000003e-01, 4.48947899999999969e-02, 6.26702999999999982e-03, 1.38949999999999989e-04, 0.00000000000000000e+00 }; repRatios[6][7] = niz6_7;
	static double niz6_8[] = { 7.34999999999999993e-06, 7.00000000000000048e-08, 5.50000000000000028e-07, 4.42000000000000003e-06, 2.55900000000000006e-05, 6.63599999999999948e-05, 1.57540000000000013e-04, 9.78699999999999964e-05, 3.00120000000000020e-04, 6.41969999999999954e-04, 1.70677999999999997e-03, 2.49045999999999990e-03, 5.13772000000000013e-03, 8.25748999999999928e-03, 1.71310099999999986e-02, 3.08046499999999994e-02, 4.80015199999999989e-02, 7.61765900000000024e-02, 1.17230870000000001e-01, 1.51291459999999989e-01, 1.73820079999999988e-01, 1.68347930000000007e-01, 1.21176519999999996e-01, 5.92426600000000025e-02, 1.62094100000000005e-02, 1.63550999999999996e-03, 3.74999999999999967e-05, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[6][8] = niz6_8;
	static double niz6_9[] = { 1.06000000000000002e-06, 0.00000000000000000e+00, 2.00000000000000004e-08, 1.29999999999999999e-07, 1.48000000000000002e-06, 5.28000000000000027e-06, 1.62000000000000007e-05, 2.01799999999999999e-05, 2.76199999999999998e-05, 2.09500000000000010e-05, 9.66099999999999983e-05, 1.60669999999999991e-04, 4.70780000000000016e-04, 5.14789999999999996e-04, 8.73590000000000044e-04, 1.71568000000000003e-03, 3.39685999999999981e-03, 5.65580999999999983e-03, 9.72262999999999947e-03, 1.54730600000000003e-02, 2.64181399999999997e-02, 4.17006399999999972e-02, 6.42511100000000002e-02, 8.85923299999999969e-02, 1.20461949999999998e-01, 1.46037030000000012e-01, 1.56433290000000003e-01, 1.39216389999999995e-01, 1.04328660000000004e-01, 5.27904699999999991e-02, 1.85120299999999988e-02, 2.85174000000000018e-03, 2.25910000000000011e-04, 6.90999999999999991e-06, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[6][9] = niz6_9;
	static double niz6_10[] = { 1.99999999999999991e-07, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 7.00000000000000048e-08, 4.79999999999999957e-07, 1.46000000000000000e-06, 2.61999999999999990e-06, 4.45999999999999965e-06, 3.13000000000000010e-06, 5.00000000000000041e-06, 5.39000000000000006e-06, 3.29600000000000029e-05, 4.17800000000000032e-05, 8.45999999999999964e-05, 1.15100000000000006e-04, 1.64789999999999999e-04, 2.64740000000000017e-04, 5.84720000000000053e-04, 1.00230000000000002e-03, 1.66028000000000009e-03, 2.43915000000000017e-03, 4.09769000000000019e-03, 6.87884999999999972e-03, 1.17294200000000008e-02, 1.76198400000000012e-02, 2.68683800000000007e-02, 4.02449200000000035e-02, 5.90032699999999966e-02, 8.06556400000000007e-02, 1.04190679999999994e-01, 1.25478580000000006e-01, 1.38503509999999996e-01, 1.35329110000000002e-01, 1.12290360000000006e-01, 7.59920000000000040e-02, 3.90526600000000029e-02, 1.29543999999999996e-02, 2.41347000000000003e-03, 2.66730000000000016e-04, 1.64500000000000000e-05, 7.99999999999999964e-07, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[6][10] = niz6_10;
	static double niz6_11[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.40000000000000010e-07, 2.59999999999999999e-07, 6.70000000000000044e-07, 4.99999999999999977e-07, 5.60000000000000038e-07, 1.10000000000000006e-07, 1.95999999999999987e-06, 1.83000000000000005e-06, 7.16999999999999996e-06, 1.16600000000000002e-05, 1.77500000000000012e-05, 1.62600000000000002e-05, 3.05700000000000004e-05, 4.40200000000000021e-05, 9.86599999999999939e-05, 1.67379999999999986e-04, 2.62030000000000010e-04, 3.73720000000000020e-04, 6.10050000000000002e-04, 9.22670000000000001e-04, 1.57559999999999992e-03, 2.56224999999999986e-03, 4.09771000000000007e-03, 5.95211999999999998e-03, 9.22943000000000027e-03, 1.41687800000000006e-02, 2.15533400000000007e-02, 3.08350600000000009e-02, 4.40061299999999975e-02, 5.86315499999999976e-02, 7.93230899999999989e-02, 9.82545300000000066e-02, 1.14862549999999994e-01, 1.24345769999999994e-01, 1.23730660000000006e-01, 1.07100370000000000e-01, 7.98860099999999934e-02, 4.77909600000000004e-02, 2.19120299999999990e-02, 6.22752000000000028e-03, 1.21601000000000001e-03, 1.54439999999999992e-04, 1.53100000000000008e-05, 7.60000000000000029e-07, 4.00000000000000008e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[6][11] = niz6_11;
	static double niz6_12[] = { 2.99999999999999973e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 4.99999999999999977e-08, 8.00000000000000017e-08, 1.19999999999999989e-07, 1.19999999999999989e-07, 2.99999999999999973e-08, 8.99999999999999986e-08, 2.99999999999999973e-08, 4.79999999999999957e-07, 8.70000000000000035e-07, 1.70999999999999993e-06, 2.22999999999999982e-06, 3.66000000000000011e-06, 2.73000000000000012e-06, 4.97999999999999975e-06, 7.84999999999999938e-06, 1.35199999999999993e-05, 2.67400000000000015e-05, 4.61999999999999981e-05, 6.12799999999999960e-05, 8.21300000000000014e-05, 1.17440000000000000e-04, 2.00399999999999992e-04, 3.22420000000000020e-04, 5.28750000000000032e-04, 7.85499999999999957e-04, 1.17416999999999999e-03, 1.73784000000000004e-03, 2.68739000000000000e-03, 4.04163000000000005e-03, 6.22936999999999970e-03, 9.11113000000000027e-03, 1.32932599999999995e-02, 1.86810900000000009e-02, 2.68345899999999984e-02, 3.73386699999999974e-02, 4.98237500000000000e-02, 6.47166299999999972e-02, 8.07602800000000037e-02, 9.64610300000000032e-02, 1.09515849999999998e-01, 1.14763439999999994e-01, 1.10640769999999999e-01, 9.64652700000000057e-02, 7.30116499999999974e-02, 4.64088500000000015e-02, 2.33011299999999998e-02, 8.31107000000000026e-03, 2.05034999999999983e-03, 3.74209999999999983e-04, 5.16199999999999970e-05, 5.10000000000000030e-06, 4.09999999999999992e-07, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[6][12] = niz6_12;
	static double niz6_13[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.00000000000000004e-08, 7.00000000000000048e-08, 1.49999999999999993e-07, 3.99999999999999982e-07, 3.30000000000000017e-07, 5.30000000000000008e-07, 6.19999999999999993e-07, 5.99999999999999973e-07, 1.17000000000000002e-06, 2.69999999999999998e-06, 4.15999999999999998e-06, 6.53000000000000016e-06, 9.54000000000000014e-06, 1.31599999999999994e-05, 1.59599999999999997e-05, 2.62100000000000015e-05, 3.77599999999999976e-05, 6.22400000000000004e-05, 9.95800000000000054e-05, 1.50320000000000011e-04, 2.11260000000000007e-04, 3.01869999999999981e-04, 4.36960000000000018e-04, 6.83459999999999992e-04, 1.03205000000000007e-03, 1.56464999999999990e-03, 2.21841000000000009e-03, 3.25112000000000014e-03, 4.63460999999999994e-03, 6.84698999999999985e-03, 9.66145000000000025e-03, 1.38430600000000008e-02, 1.89922499999999987e-02, 2.61412100000000015e-02, 3.46588099999999982e-02, 4.58741100000000027e-02, 5.84351899999999980e-02, 7.23101500000000036e-02, 8.53708200000000000e-02, 9.70172499999999993e-02, 1.04467840000000006e-01, 1.05190710000000007e-01, 9.71496000000000026e-02, 8.16541999999999962e-02, 6.03985400000000006e-02, 3.82702399999999970e-02, 1.90595500000000015e-02, 7.32091999999999986e-03, 2.02666999999999995e-03, 4.52130000000000023e-04, 7.86299999999999976e-05, 1.17099999999999997e-05, 1.37999999999999992e-06, 1.10000000000000006e-07, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[6][13] = niz6_13;
	static double niz6_14[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 0.00000000000000000e+00, 4.00000000000000008e-08, 4.00000000000000008e-08, 8.00000000000000017e-08, 1.10000000000000006e-07, 7.00000000000000048e-08, 9.99999999999999955e-08, 2.39999999999999979e-07, 2.10000000000000001e-07, 2.89999999999999976e-07, 6.50000000000000024e-07, 8.19999999999999984e-07, 1.59999999999999993e-06, 2.11000000000000013e-06, 2.38000000000000008e-06, 3.54999999999999989e-06, 4.72999999999999961e-06, 7.65999999999999951e-06, 1.26700000000000007e-05, 1.86299999999999995e-05, 2.66900000000000003e-05, 3.77199999999999980e-05, 5.08100000000000031e-05, 7.44699999999999968e-05, 1.04610000000000003e-04, 1.59640000000000010e-04, 2.34359999999999999e-04, 3.46769999999999988e-04, 4.98689999999999984e-04, 7.08430000000000019e-04, 9.77500000000000070e-04, 1.44151999999999995e-03, 2.07483000000000016e-03, 3.00014000000000010e-03, 4.21068999999999957e-03, 5.90106999999999958e-03, 8.12590000000000014e-03, 1.12926099999999998e-02, 1.54326800000000007e-02, 2.08191500000000015e-02, 2.74937999999999988e-02, 3.58076400000000017e-02, 4.54652700000000021e-02, 5.65821800000000028e-02, 6.84485999999999983e-02, 8.01084499999999977e-02, 8.96497899999999931e-02, 9.61408700000000033e-02, 9.76008500000000029e-02, 9.24968800000000035e-02, 8.08524199999999943e-02, 6.38313300000000056e-02, 4.46774900000000003e-02, 2.64057200000000006e-02, 1.24724099999999997e-02, 4.64783000000000036e-03, 1.34760999999999995e-03, 3.20150000000000003e-04, 6.40700000000000015e-05, 1.05900000000000003e-05, 1.52999999999999996e-06, 2.20000000000000011e-07, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[6][14] = niz6_14;
	static double niz6_15[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 2.99999999999999973e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.00000000000000004e-08, 2.00000000000000004e-08, 2.00000000000000004e-08, 4.99999999999999977e-08, 9.99999999999999955e-08, 9.99999999999999955e-08, 2.20000000000000011e-07, 1.60000000000000003e-07, 2.39999999999999979e-07, 3.09999999999999997e-07, 5.19999999999999998e-07, 6.19999999999999993e-07, 9.90000000000000050e-07, 1.46000000000000000e-06, 2.21999999999999992e-06, 3.24999999999999980e-06, 4.94000000000000014e-06, 6.15000000000000041e-06, 8.64000000000000029e-06, 1.09999999999999997e-05, 1.58499999999999990e-05, 2.24800000000000016e-05, 3.55300000000000003e-05, 5.07799999999999983e-05, 7.54699999999999940e-05, 9.94899999999999978e-05, 1.41249999999999991e-04, 1.90249999999999989e-04, 2.78380000000000001e-04, 3.94709999999999994e-04, 5.72890000000000053e-04, 7.90640000000000006e-04, 1.13075000000000003e-03, 1.53479000000000007e-03, 2.15293999999999989e-03, 2.94234999999999983e-03, 4.12340000000000016e-03, 5.65235000000000043e-03, 7.75665000000000035e-03, 1.03722899999999993e-02, 1.38441899999999993e-02, 1.82404499999999983e-02, 2.39557399999999997e-02, 3.06740199999999998e-02, 3.88722400000000023e-02, 4.78045200000000031e-02, 5.78556399999999998e-02, 6.81788900000000059e-02, 7.78091900000000003e-02, 8.56111299999999936e-02, 9.04485200000000045e-02, 9.03871900000000061e-02, 8.57452499999999951e-02, 7.54097100000000048e-02, 6.09019800000000014e-02, 4.41371899999999998e-02, 2.78517399999999998e-02, 1.46199299999999997e-02, 6.28793999999999968e-03, 2.16722000000000008e-03, 6.28050000000000006e-04, 1.53289999999999991e-04, 3.36200000000000000e-05, 6.60000000000000034e-06, 1.23000000000000008e-06, 1.99999999999999991e-07, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[6][15] = niz6_15;
	static double niz6_16[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.00000000000000004e-08, 2.00000000000000004e-08, 2.99999999999999973e-08, 8.99999999999999986e-08, 4.00000000000000008e-08, 1.10000000000000006e-07, 1.40000000000000010e-07, 2.39999999999999979e-07, 2.29999999999999995e-07, 4.49999999999999980e-07, 7.29999999999999999e-07, 1.10999999999999996e-06, 1.57000000000000000e-06, 1.65999999999999999e-06, 1.68999999999999991e-06, 2.69999999999999998e-06, 3.68999999999999982e-06, 5.21000000000000009e-06, 7.55999999999999962e-06, 1.10600000000000008e-05, 1.60900000000000001e-05, 2.01200000000000005e-05, 2.83700000000000011e-05, 3.56700000000000024e-05, 5.04300000000000034e-05, 6.90400000000000031e-05, 1.00320000000000002e-04, 1.41180000000000000e-04, 1.96619999999999998e-04, 2.65439999999999979e-04, 3.67340000000000017e-04, 4.98619999999999966e-04, 6.92560000000000051e-04, 9.44830000000000019e-04, 1.32416000000000001e-03, 1.79317999999999990e-03, 2.45952000000000020e-03, 3.29277999999999993e-03, 4.45353999999999976e-03, 5.92992999999999992e-03, 7.91541999999999940e-03, 1.05023400000000006e-02, 1.37836399999999998e-02, 1.77460499999999993e-02, 2.26894800000000015e-02, 2.86511199999999987e-02, 3.56913700000000000e-02, 4.36750899999999997e-02, 5.23591600000000018e-02, 6.11815600000000029e-02, 6.98477900000000068e-02, 7.74612400000000006e-02, 8.29368699999999959e-02, 8.50937699999999991e-02, 8.34006000000000053e-02, 7.73628600000000055e-02, 6.70521500000000048e-02, 5.36726999999999968e-02, 3.87782100000000005e-02, 2.46822800000000009e-02, 1.33884599999999996e-02, 6.08738999999999982e-03, 2.30666999999999981e-03, 7.35780000000000006e-04, 2.10420000000000008e-04, 5.35299999999999974e-05, 1.23999999999999999e-05, 2.87000000000000005e-06, 5.40000000000000018e-07, 9.99999999999999955e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[6][16] = niz6_16;
	static double niz6_17[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 2.00000000000000004e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.00000000000000004e-08, 2.99999999999999973e-08, 5.99999999999999946e-08, 4.99999999999999977e-08, 2.99999999999999973e-08, 2.00000000000000004e-08, 8.00000000000000017e-08, 9.99999999999999955e-08, 1.19999999999999989e-07, 2.20000000000000011e-07, 1.29999999999999999e-07, 3.20000000000000007e-07, 3.70000000000000004e-07, 3.59999999999999994e-07, 4.79999999999999957e-07, 7.40000000000000009e-07, 1.08999999999999994e-06, 1.97000000000000020e-06, 2.34999999999999995e-06, 3.21000000000000018e-06, 4.42999999999999994e-06, 5.21000000000000009e-06, 6.74999999999999975e-06, 9.45999999999999921e-06, 1.22100000000000000e-05, 1.75600000000000013e-05, 2.40000000000000006e-05, 3.39800000000000033e-05, 4.50899999999999969e-05, 6.15099999999999989e-05, 8.16300000000000028e-05, 1.07780000000000001e-04, 1.45479999999999996e-04, 2.03009999999999996e-04, 2.74409999999999997e-04, 3.80460000000000000e-04, 5.06260000000000022e-04, 6.87989999999999977e-04, 9.13790000000000045e-04, 1.23156999999999997e-03, 1.65009000000000011e-03, 2.21757999999999981e-03, 2.95096999999999981e-03, 3.92217999999999994e-03, 5.15178999999999984e-03, 6.73919999999999988e-03, 8.76173000000000056e-03, 1.13276999999999996e-02, 1.44932099999999994e-02, 1.84671099999999984e-02, 2.31620899999999998e-02, 2.87242899999999995e-02, 3.50480000000000028e-02, 4.21374399999999982e-02, 4.97942800000000033e-02, 5.79369799999999990e-02, 6.53871099999999983e-02, 7.21372700000000033e-02, 7.70765000000000061e-02, 7.98994700000000002e-02, 7.92065299999999972e-02, 7.50326699999999958e-02, 6.72114899999999987e-02, 5.64695399999999986e-02, 4.36458600000000016e-02, 3.05304900000000004e-02, 1.88802900000000010e-02, 1.00797100000000004e-02, 4.56688999999999967e-03, 1.77987999999999996e-03, 5.97760000000000023e-04, 1.82339999999999992e-04, 4.92099999999999981e-05, 1.38599999999999994e-05, 3.18999999999999995e-06, 7.19999999999999989e-07, 1.49999999999999993e-07, 2.99999999999999973e-08, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[6][17] = niz6_17;
	static double niz6_18[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 2.99999999999999973e-08, 1.00000000000000002e-08, 5.99999999999999946e-08, 7.00000000000000048e-08, 2.99999999999999973e-08, 5.99999999999999946e-08, 5.99999999999999946e-08, 8.99999999999999986e-08, 1.40000000000000010e-07, 2.39999999999999979e-07, 3.59999999999999994e-07, 5.19999999999999998e-07, 5.89999999999999963e-07, 6.40000000000000013e-07, 9.29999999999999990e-07, 1.21999999999999997e-06, 1.46999999999999990e-06, 2.19000000000000021e-06, 2.81000000000000020e-06, 3.44000000000000010e-06, 5.51999999999999967e-06, 7.97999999999999983e-06, 1.03299999999999994e-05, 1.26399999999999993e-05, 1.70900000000000007e-05, 2.23700000000000010e-05, 2.97000000000000002e-05, 4.00199999999999997e-05, 5.45800000000000026e-05, 7.48500000000000033e-05, 9.91700000000000009e-05, 1.32220000000000005e-04, 1.76670000000000001e-04, 2.30730000000000008e-04, 3.06379999999999977e-04, 4.08729999999999998e-04, 5.48610000000000048e-04, 7.29220000000000042e-04, 9.73220000000000010e-04, 1.26913000000000004e-03, 1.68632999999999999e-03, 2.19619000000000021e-03, 2.85951999999999994e-03, 3.74953999999999999e-03, 4.87731000000000015e-03, 6.29996000000000028e-03, 8.08985000000000086e-03, 1.02715900000000006e-02, 1.29947199999999995e-02, 1.62737500000000000e-02, 2.02752900000000014e-02, 2.49145999999999986e-02, 3.02605399999999990e-02, 3.63391100000000009e-02, 4.29337200000000016e-02, 4.97483599999999984e-02, 5.68545800000000018e-02, 6.35104400000000013e-02, 6.91898100000000044e-02, 7.33391600000000005e-02, 7.52607200000000032e-02, 7.45952700000000052e-02, 7.08992299999999936e-02, 6.41286900000000021e-02, 5.46527100000000002e-02, 4.35549100000000022e-02, 3.17587599999999970e-02, 2.08783900000000001e-02, 1.20984999999999999e-02, 6.10935000000000037e-03, 2.68643000000000007e-03, 1.03414000000000002e-03, 3.55320000000000006e-04, 1.13880000000000001e-04, 3.36200000000000000e-05, 8.72999999999999942e-06, 2.21000000000000002e-06, 5.19999999999999998e-07, 1.10000000000000006e-07, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[6][18] = niz6_18;
	static double niz6_19[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 2.99999999999999973e-08, 2.00000000000000004e-08, 5.99999999999999946e-08, 4.99999999999999977e-08, 4.99999999999999977e-08, 7.00000000000000048e-08, 1.10000000000000006e-07, 1.19999999999999989e-07, 2.39999999999999979e-07, 2.49999999999999989e-07, 4.20000000000000002e-07, 5.40000000000000018e-07, 6.60000000000000034e-07, 8.60000000000000025e-07, 1.21999999999999997e-06, 1.79000000000000001e-06, 2.07999999999999999e-06, 2.96999999999999994e-06, 3.83999999999999966e-06, 4.51999999999999992e-06, 6.10000000000000004e-06, 8.06000000000000076e-06, 9.96999999999999941e-06, 1.40199999999999996e-05, 1.82400000000000015e-05, 2.51799999999999995e-05, 3.15900000000000008e-05, 4.24900000000000015e-05, 5.37700000000000019e-05, 7.36599999999999961e-05, 9.49399999999999956e-05, 1.26520000000000002e-04, 1.67519999999999995e-04, 2.21279999999999996e-04, 2.86349999999999994e-04, 3.75359999999999984e-04, 4.89010000000000009e-04, 6.35409999999999990e-04, 8.25890000000000023e-04, 1.08431000000000000e-03, 1.40968999999999990e-03, 1.82939999999999991e-03, 2.37897000000000022e-03, 3.04379000000000021e-03, 3.88093999999999982e-03, 4.97606999999999997e-03, 6.29469000000000035e-03, 7.97910999999999933e-03, 1.00643799999999995e-02, 1.25589900000000008e-02, 1.55312200000000001e-02, 1.90824599999999990e-02, 2.31360299999999984e-02, 2.79463900000000015e-02, 3.32337099999999996e-02, 3.90647599999999970e-02, 4.51712800000000012e-02, 5.14664899999999967e-02, 5.74856099999999995e-02, 6.30179700000000065e-02, 6.74910900000000036e-02, 7.05329799999999951e-02, 7.13119900000000057e-02, 6.97449799999999981e-02, 6.56209700000000007e-02, 5.89249199999999987e-02, 5.01593099999999986e-02, 3.99828200000000022e-02, 2.93948300000000003e-02, 1.97289000000000006e-02, 1.18152399999999994e-02, 6.27689000000000025e-03, 2.93711000000000015e-03, 1.22714000000000004e-03, 4.57319999999999992e-04, 1.59480000000000011e-04, 5.13900000000000009e-05, 1.53500000000000004e-05, 4.12000000000000036e-06, 1.21000000000000006e-06, 2.59999999999999999e-07, 1.10000000000000006e-07, 2.00000000000000004e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[6][19] = niz6_19;
	static double niz6_20[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.00000000000000004e-08, 4.00000000000000008e-08, 5.99999999999999946e-08, 1.00000000000000002e-08, 2.99999999999999973e-08, 4.99999999999999977e-08, 2.99999999999999973e-08, 2.99999999999999973e-08, 8.00000000000000017e-08, 1.10000000000000006e-07, 2.10000000000000001e-07, 1.99999999999999991e-07, 3.39999999999999974e-07, 3.30000000000000017e-07, 4.09999999999999992e-07, 5.19999999999999998e-07, 5.70000000000000048e-07, 7.19999999999999989e-07, 1.08000000000000004e-06, 1.39999999999999994e-06, 1.54000000000000008e-06, 2.09999999999999980e-06, 2.91000000000000009e-06, 3.58000000000000003e-06, 4.61999999999999981e-06, 5.54000000000000032e-06, 7.34999999999999993e-06, 9.55000000000000004e-06, 1.18100000000000004e-05, 1.64300000000000002e-05, 2.06799999999999985e-05, 2.81899999999999995e-05, 3.57299999999999984e-05, 4.58999999999999976e-05, 6.19299999999999983e-05, 7.86899999999999937e-05, 9.90400000000000004e-05, 1.31049999999999987e-04, 1.68739999999999987e-04, 2.19310000000000013e-04, 2.80750000000000021e-04, 3.68639999999999994e-04, 4.76189999999999979e-04, 6.19120000000000022e-04, 7.84709999999999987e-04, 1.00938000000000004e-03, 1.29323000000000003e-03, 1.66219000000000002e-03, 2.11086999999999993e-03, 2.69676999999999981e-03, 3.42403000000000022e-03, 4.32685000000000014e-03, 5.42595999999999964e-03, 6.78556000000000038e-03, 8.43436000000000012e-03, 1.04614400000000007e-02, 1.28704200000000005e-02, 1.57531599999999987e-02, 1.90793000000000004e-02, 2.29319200000000015e-02, 2.72677999999999983e-02, 3.21023900000000015e-02, 3.73829200000000000e-02, 4.29807400000000034e-02, 4.86045900000000031e-02, 5.40721099999999996e-02, 5.91399999999999981e-02, 6.32805000000000034e-02, 6.63260600000000061e-02, 6.76352999999999954e-02, 6.69898200000000055e-02, 6.41412799999999950e-02, 5.90829400000000005e-02, 5.20552199999999993e-02, 4.33497099999999996e-02, 3.38654899999999981e-02, 2.45791500000000010e-02, 1.62671399999999994e-02, 9.72701999999999942e-03, 5.18543000000000042e-03, 2.48201000000000021e-03, 1.07004999999999991e-03, 4.22769999999999993e-04, 1.54759999999999989e-04, 5.32600000000000017e-05, 1.79499999999999992e-05, 5.45000000000000034e-06, 1.65000000000000008e-06, 4.70000000000000000e-07, 1.29999999999999999e-07, 8.00000000000000017e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[6][20] = niz6_20;
	static double niz6_21[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.99999999999999973e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 2.00000000000000004e-08, 2.99999999999999973e-08, 2.99999999999999973e-08, 2.99999999999999973e-08, 4.00000000000000008e-08, 4.99999999999999977e-08, 5.99999999999999946e-08, 1.10000000000000006e-07, 8.00000000000000017e-08, 8.99999999999999986e-08, 1.79999999999999997e-07, 2.29999999999999995e-07, 2.70000000000000009e-07, 2.70000000000000009e-07, 3.49999999999999984e-07, 5.79999999999999953e-07, 5.40000000000000018e-07, 7.70000000000000039e-07, 9.90000000000000050e-07, 1.45000000000000009e-06, 1.41999999999999996e-06, 2.12999999999999994e-06, 2.55000000000000015e-06, 3.58000000000000003e-06, 4.41000000000000013e-06, 5.43999999999999958e-06, 6.90000000000000001e-06, 9.44999999999999931e-06, 1.22299999999999998e-05, 1.57500000000000000e-05, 1.99500000000000004e-05, 2.54299999999999988e-05, 3.21699999999999986e-05, 4.22599999999999986e-05, 5.30400000000000004e-05, 7.03200000000000044e-05, 9.01900000000000022e-05, 1.14320000000000003e-04, 1.44320000000000001e-04, 1.85949999999999993e-04, 2.36600000000000005e-04, 3.04930000000000023e-04, 3.88979999999999979e-04, 4.96690000000000044e-04, 6.32529999999999963e-04, 8.04609999999999982e-04, 1.01833999999999996e-03, 1.30478999999999990e-03, 1.63283999999999999e-03, 2.04807999999999987e-03, 2.57281000000000003e-03, 3.23726999999999999e-03, 4.03777000000000042e-03, 5.01652999999999995e-03, 6.21658000000000020e-03, 7.69992999999999980e-03, 9.42113999999999972e-03, 1.15163899999999996e-02, 1.39080599999999999e-02, 1.67988300000000007e-02, 2.00586399999999991e-02, 2.38103799999999990e-02, 2.79181499999999992e-02, 3.24649499999999994e-02, 3.73055799999999979e-02, 4.23789899999999983e-02, 4.74714300000000020e-02, 5.24806300000000003e-02, 5.68656499999999968e-02, 6.06119999999999992e-02, 6.31013799999999986e-02, 6.43759099999999945e-02, 6.38102200000000008e-02, 6.14572199999999999e-02, 5.70392499999999997e-02, 5.08965799999999968e-02, 4.33547800000000025e-02, 3.48929700000000023e-02, 2.62689200000000012e-02, 1.83366299999999996e-02, 1.17061200000000004e-02, 6.79083000000000030e-03, 3.55089000000000012e-03, 1.69515000000000009e-03, 7.36400000000000010e-04, 3.02110000000000020e-04, 1.12969999999999998e-04, 4.21200000000000033e-05, 1.41699999999999999e-05, 4.68000000000000008e-06, 1.56000000000000010e-06, 6.79999999999999948e-07, 1.99999999999999991e-07, 5.99999999999999946e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[6][21] = niz6_21;
	static double niz6_22[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 4.00000000000000008e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 2.99999999999999973e-08, 4.99999999999999977e-08, 4.99999999999999977e-08, 2.99999999999999973e-08, 5.99999999999999946e-08, 2.00000000000000004e-08, 2.99999999999999973e-08, 8.00000000000000017e-08, 1.49999999999999993e-07, 2.10000000000000001e-07, 1.79999999999999997e-07, 2.49999999999999989e-07, 2.70000000000000009e-07, 3.80000000000000015e-07, 4.09999999999999992e-07, 5.99999999999999973e-07, 7.40000000000000009e-07, 8.29999999999999994e-07, 1.19000000000000004e-06, 1.61999999999999995e-06, 1.88999999999999990e-06, 2.46000000000000016e-06, 3.31000000000000007e-06, 3.89000000000000003e-06, 5.00000000000000041e-06, 6.22999999999999964e-06, 7.89000000000000069e-06, 9.70000000000000030e-06, 1.24599999999999993e-05, 1.54000000000000016e-05, 2.06599999999999987e-05, 2.58399999999999999e-05, 3.35400000000000007e-05, 4.16699999999999991e-05, 5.18100000000000003e-05, 6.65000000000000037e-05, 8.34300000000000059e-05, 1.05089999999999998e-04, 1.33539999999999999e-04, 1.73510000000000011e-04, 2.18099999999999989e-04, 2.76900000000000009e-04, 3.45539999999999975e-04, 4.35859999999999991e-04, 5.48410000000000043e-04, 6.90810000000000035e-04, 8.67240000000000025e-04, 1.09078999999999990e-03, 1.37256000000000010e-03, 1.71120999999999990e-03, 2.13605999999999996e-03, 2.65110999999999992e-03, 3.28300999999999983e-03, 4.04490999999999965e-03, 4.98203000000000014e-03, 6.10709999999999986e-03, 7.44916999999999975e-03, 9.05816000000000086e-03, 1.09685300000000006e-02, 1.31670099999999998e-02, 1.57200699999999992e-02, 1.86480299999999995e-02, 2.19280199999999995e-02, 2.56297499999999998e-02, 2.96914700000000011e-02, 3.39987100000000014e-02, 3.85291599999999998e-02, 4.32065199999999983e-02, 4.77925199999999981e-02, 5.20950000000000024e-02, 5.58929199999999987e-02, 5.89281600000000003e-02, 6.07942600000000027e-02, 6.14343899999999984e-02, 6.04243900000000014e-02, 5.78730599999999970e-02, 5.36075899999999966e-02, 4.78383000000000003e-02, 4.08422000000000021e-02, 3.31306099999999978e-02, 2.52739100000000001e-02, 1.80329800000000005e-02, 1.18452899999999996e-02, 7.14490000000000004e-03, 3.93285999999999983e-03, 1.97573000000000019e-03, 9.14619999999999995e-04, 3.99390000000000010e-04, 1.59910000000000005e-04, 6.32399999999999976e-05, 2.40099999999999988e-05, 8.27000000000000044e-06, 2.91000000000000009e-06, 8.99999999999999959e-07, 2.20000000000000011e-07, 1.19999999999999989e-07, 1.00000000000000002e-08, 2.99999999999999973e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[6][22] = niz6_22;
	static double niz6_23[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 1.00000000000000002e-08, 4.00000000000000008e-08, 4.00000000000000008e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 4.99999999999999977e-08, 4.99999999999999977e-08, 4.99999999999999977e-08, 4.00000000000000008e-08, 8.00000000000000017e-08, 8.00000000000000017e-08, 1.19999999999999989e-07, 1.29999999999999999e-07, 1.60000000000000003e-07, 1.60000000000000003e-07, 2.20000000000000011e-07, 2.59999999999999999e-07, 2.70000000000000009e-07, 3.99999999999999982e-07, 4.79999999999999957e-07, 6.30000000000000003e-07, 8.50000000000000014e-07, 8.09999999999999974e-07, 1.30999999999999995e-06, 1.48999999999999992e-06, 1.61999999999999995e-06, 2.24000000000000015e-06, 2.92999999999999990e-06, 3.70000000000000015e-06, 4.68999999999999999e-06, 5.67999999999999983e-06, 7.11999999999999959e-06, 8.67000000000000000e-06, 1.07500000000000004e-05, 1.43000000000000003e-05, 1.72699999999999990e-05, 2.11600000000000007e-05, 2.72000000000000005e-05, 3.47800000000000024e-05, 4.36700000000000003e-05, 5.56499999999999974e-05, 6.89999999999999967e-05, 8.93599999999999982e-05, 1.09119999999999999e-04, 1.35100000000000004e-04, 1.71769999999999990e-04, 2.12350000000000012e-04, 2.65170000000000011e-04, 3.37110000000000003e-04, 4.18740000000000019e-04, 5.22840000000000002e-04, 6.47930000000000012e-04, 8.15340000000000010e-04, 1.00249999999999992e-03, 1.24883999999999998e-03, 1.54133999999999998e-03, 1.90321999999999996e-03, 2.33977000000000013e-03, 2.88202999999999983e-03, 3.53171999999999991e-03, 4.31552999999999971e-03, 5.22724000000000018e-03, 6.34356999999999976e-03, 7.65966000000000043e-03, 9.21821999999999919e-03, 1.10234400000000007e-02, 1.31271100000000009e-02, 1.55253600000000002e-02, 1.82334700000000016e-02, 2.13043099999999999e-02, 2.47172400000000014e-02, 2.83987199999999988e-02, 3.23792099999999985e-02, 3.65256700000000031e-02, 4.07985299999999995e-02, 4.49667499999999998e-02, 4.89765100000000009e-02, 5.24637000000000020e-02, 5.55511399999999989e-02, 5.76523400000000033e-02, 5.86547799999999966e-02, 5.83699800000000019e-02, 5.67214200000000016e-02, 5.35686100000000026e-02, 4.89740800000000032e-02, 4.31889700000000001e-02, 3.64960500000000021e-02, 2.93313800000000006e-02, 2.22649499999999986e-02, 1.57822399999999995e-02, 1.04274499999999996e-02, 6.33875999999999971e-03, 3.55063999999999987e-03, 1.83866999999999993e-03, 8.83639999999999990e-04, 4.00149999999999996e-04, 1.71559999999999991e-04, 7.21500000000000055e-05, 2.68299999999999989e-05, 1.09500000000000002e-05, 4.30000000000000033e-06, 1.54000000000000008e-06, 5.79999999999999953e-07, 8.00000000000000017e-08, 4.00000000000000008e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[6][23] = niz6_23;
	static double niz6_24[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 2.99999999999999973e-08, 2.99999999999999973e-08, 2.99999999999999973e-08, 2.00000000000000004e-08, 2.00000000000000004e-08, 4.00000000000000008e-08, 2.00000000000000004e-08, 2.99999999999999973e-08, 8.00000000000000017e-08, 4.99999999999999977e-08, 9.99999999999999955e-08, 1.79999999999999997e-07, 1.10000000000000006e-07, 2.49999999999999989e-07, 1.49999999999999993e-07, 2.99999999999999986e-07, 3.70000000000000004e-07, 4.30000000000000012e-07, 5.40000000000000018e-07, 4.99999999999999977e-07, 7.29999999999999999e-07, 1.04999999999999990e-06, 1.43000000000000007e-06, 1.63999999999999997e-06, 1.90999999999999992e-06, 2.31999999999999981e-06, 3.27000000000000003e-06, 3.40999999999999996e-06, 4.38000000000000042e-06, 5.64000000000000021e-06, 7.28999999999999966e-06, 9.02999999999999994e-06, 1.02799999999999998e-05, 1.37400000000000006e-05, 1.76099999999999991e-05, 2.04499999999999990e-05, 2.57699999999999989e-05, 3.25700000000000016e-05, 4.01100000000000005e-05, 5.02600000000000033e-05, 6.24799999999999981e-05, 7.62100000000000039e-05, 9.47900000000000055e-05, 1.18240000000000006e-04, 1.43749999999999998e-04, 1.81929999999999988e-04, 2.27189999999999998e-04, 2.80069999999999993e-04, 3.45970000000000023e-04, 4.29579999999999990e-04, 5.21569999999999955e-04, 6.45069999999999975e-04, 8.03039999999999982e-04, 9.77599999999999910e-04, 1.20827000000000000e-03, 1.49368999999999999e-03, 1.81350999999999995e-03, 2.21956000000000020e-03, 2.69609999999999989e-03, 3.27382000000000020e-03, 3.97926000000000009e-03, 4.80389999999999984e-03, 5.78511000000000043e-03, 6.93741999999999970e-03, 8.28229999999999938e-03, 9.84270999999999931e-03, 1.16445699999999999e-02, 1.37588699999999994e-02, 1.61015000000000012e-02, 1.87502099999999998e-02, 2.16713200000000009e-02, 2.49095400000000008e-02, 2.83791000000000009e-02, 3.20485000000000006e-02, 3.59096900000000011e-02, 3.97979700000000020e-02, 4.36103399999999974e-02, 4.72127099999999980e-02, 5.04636700000000021e-02, 5.32007899999999978e-02, 5.51371699999999992e-02, 5.61175100000000024e-02, 5.60126000000000027e-02, 5.46030799999999983e-02, 5.19825100000000026e-02, 4.80790300000000018e-02, 4.30193999999999993e-02, 3.70772600000000008e-02, 3.06325500000000014e-02, 2.40506100000000000e-02, 1.78087700000000015e-02, 1.23883599999999993e-02, 8.01330999999999918e-03, 4.81198000000000042e-03, 2.67862000000000005e-03, 1.39489999999999992e-03, 6.85390000000000023e-04, 3.12629999999999993e-04, 1.39669999999999996e-04, 5.80400000000000000e-05, 2.34500000000000008e-05, 9.30000000000000074e-06, 3.70000000000000015e-06, 1.28000000000000003e-06, 4.89999999999999967e-07, 2.10000000000000001e-07, 2.00000000000000004e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[6][24] = niz6_24;
	static double niz6_25[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 4.99999999999999977e-08, 2.00000000000000004e-08, 2.00000000000000004e-08, 2.00000000000000004e-08, 2.99999999999999973e-08, 8.00000000000000017e-08, 2.99999999999999973e-08, 4.99999999999999977e-08, 5.99999999999999946e-08, 7.00000000000000048e-08, 1.19999999999999989e-07, 1.40000000000000010e-07, 1.69999999999999987e-07, 2.29999999999999995e-07, 1.99999999999999991e-07, 2.89999999999999976e-07, 4.09999999999999992e-07, 4.49999999999999980e-07, 6.30000000000000003e-07, 7.19999999999999989e-07, 1.04999999999999990e-06, 1.12000000000000008e-06, 1.43000000000000007e-06, 1.54999999999999998e-06, 1.99000000000000001e-06, 2.74000000000000002e-06, 3.04000000000000012e-06, 4.01999999999999963e-06, 4.97999999999999975e-06, 5.94999999999999978e-06, 7.43000000000000001e-06, 8.77000000000000074e-06, 1.15900000000000008e-05, 1.37200000000000008e-05, 1.68100000000000000e-05, 2.11800000000000005e-05, 2.60299999999999998e-05, 3.18699999999999981e-05, 3.99000000000000008e-05, 4.89400000000000024e-05, 5.99100000000000007e-05, 7.29499999999999978e-05, 9.01600000000000041e-05, 1.10749999999999995e-04, 1.38049999999999995e-04, 1.66670000000000002e-04, 2.04300000000000006e-04, 2.54519999999999996e-04, 3.12769999999999975e-04, 3.81639999999999985e-04, 4.66459999999999976e-04, 5.71930000000000008e-04, 6.94669999999999988e-04, 8.44759999999999955e-04, 1.03451999999999993e-03, 1.25880000000000002e-03, 1.53011000000000011e-03, 1.84622999999999992e-03, 2.23765999999999982e-03, 2.69631999999999988e-03, 3.25719000000000009e-03, 3.91562999999999981e-03, 4.67845999999999974e-03, 5.59554000000000041e-03, 6.64648999999999969e-03, 7.89185000000000060e-03, 9.32216999999999942e-03, 1.09702099999999993e-02, 1.28428099999999996e-02, 1.49305800000000006e-02, 1.73122300000000014e-02, 1.99537000000000013e-02, 2.28442199999999984e-02, 2.59725399999999988e-02, 2.92752699999999991e-02, 3.27186400000000002e-02, 3.63084600000000007e-02, 3.98760999999999977e-02, 4.33958399999999980e-02, 4.65682700000000019e-02, 4.93872100000000008e-02, 5.16532300000000014e-02, 5.32123499999999985e-02, 5.39097899999999991e-02, 5.35507600000000028e-02, 5.21709299999999973e-02, 4.96038099999999982e-02, 4.58771499999999985e-02, 4.11964599999999972e-02, 3.56759700000000013e-02, 2.97327299999999989e-02, 2.36809299999999993e-02, 1.78890899999999999e-02, 1.27190700000000007e-02, 8.50373999999999922e-03, 5.30339999999999978e-03, 3.10747000000000020e-03, 1.68606000000000008e-03, 8.61809999999999963e-04, 4.23189999999999992e-04, 1.96910000000000010e-04, 8.57600000000000056e-05, 3.86000000000000031e-05, 1.60100000000000009e-05, 5.99000000000000025e-06, 2.48999999999999988e-06, 1.10999999999999996e-06, 3.80000000000000015e-07, 1.40000000000000010e-07, 7.00000000000000048e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[6][25] = niz6_25;
	static double niz6_26[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 2.99999999999999973e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 2.99999999999999973e-08, 2.99999999999999973e-08, 5.99999999999999946e-08, 4.00000000000000008e-08, 8.99999999999999986e-08, 1.40000000000000010e-07, 8.99999999999999986e-08, 1.60000000000000003e-07, 1.19999999999999989e-07, 2.59999999999999999e-07, 2.89999999999999976e-07, 1.79999999999999997e-07, 3.09999999999999997e-07, 5.19999999999999998e-07, 6.19999999999999993e-07, 7.29999999999999999e-07, 7.29999999999999999e-07, 1.01999999999999998e-06, 1.26000000000000001e-06, 1.48000000000000002e-06, 1.85000000000000008e-06, 1.94999999999999996e-06, 2.68000000000000018e-06, 3.37999999999999983e-06, 4.30000000000000033e-06, 5.18000000000000038e-06, 6.11999999999999985e-06, 7.66999999999999941e-06, 9.09999999999999927e-06, 1.08799999999999992e-05, 1.40199999999999996e-05, 1.66399999999999999e-05, 2.07099999999999999e-05, 2.61000000000000008e-05, 3.12699999999999971e-05, 3.81700000000000022e-05, 4.72900000000000029e-05, 5.84199999999999997e-05, 7.39800000000000066e-05, 8.83999999999999939e-05, 1.09170000000000000e-04, 1.34229999999999994e-04, 1.61389999999999998e-04, 1.98559999999999996e-04, 2.39530000000000005e-04, 2.93879999999999998e-04, 3.54760000000000025e-04, 4.39390000000000006e-04, 5.29359999999999987e-04, 6.38910000000000020e-04, 7.76360000000000028e-04, 9.36679999999999956e-04, 1.12877000000000008e-03, 1.36560000000000002e-03, 1.64813999999999998e-03, 1.98335999999999998e-03, 2.37789000000000013e-03, 2.84463999999999984e-03, 3.39819000000000015e-03, 4.04519999999999966e-03, 4.79521000000000027e-03, 5.69039999999999997e-03, 6.74470000000000017e-03, 7.91860999999999954e-03, 9.26913000000000042e-03, 1.08335199999999993e-02, 1.26119600000000002e-02, 1.45657800000000004e-02, 1.67600899999999983e-02, 1.92236700000000017e-02, 2.18789900000000009e-02, 2.47215799999999999e-02, 2.78077800000000007e-02, 3.09658299999999997e-02, 3.42441699999999974e-02, 3.75525999999999985e-02, 4.08082800000000023e-02, 4.38478799999999988e-02, 4.65985000000000010e-02, 4.88718200000000033e-02, 5.06687300000000021e-02, 5.15676099999999998e-02, 5.17644000000000021e-02, 5.09674300000000011e-02, 4.91886200000000023e-02, 4.64075499999999988e-02, 4.26310900000000034e-02, 3.79685599999999984e-02, 3.28059200000000023e-02, 2.72297700000000004e-02, 2.16186899999999994e-02, 1.63522400000000005e-02, 1.17216100000000004e-02, 7.90089000000000069e-03, 5.01462000000000001e-03, 2.98472000000000017e-03, 1.68227999999999997e-03, 8.86049999999999989e-04, 4.48619999999999998e-04, 2.16479999999999987e-04, 1.02460000000000005e-04, 4.65600000000000015e-05, 2.01200000000000005e-05, 8.38999999999999929e-06, 3.31999999999999998e-06, 1.45000000000000009e-06, 5.60000000000000038e-07, 1.99999999999999991e-07, 8.99999999999999986e-08, 2.99999999999999973e-08, 2.00000000000000004e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[6][26] = niz6_26;
	static double niz6_27[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 1.00000000000000002e-08, 4.00000000000000008e-08, 7.00000000000000048e-08, 5.99999999999999946e-08, 8.99999999999999986e-08, 8.00000000000000017e-08, 8.00000000000000017e-08, 1.29999999999999999e-07, 1.90000000000000007e-07, 8.99999999999999986e-08, 1.99999999999999991e-07, 2.49999999999999989e-07, 3.99999999999999982e-07, 3.49999999999999984e-07, 4.30000000000000012e-07, 5.99999999999999973e-07, 4.89999999999999967e-07, 6.60000000000000034e-07, 8.19999999999999984e-07, 1.10000000000000006e-06, 1.25000000000000010e-06, 1.72000000000000005e-06, 1.90999999999999992e-06, 2.24000000000000015e-06, 2.81000000000000020e-06, 3.76999999999999990e-06, 4.08999999999999980e-06, 5.47000000000000014e-06, 6.52000000000000026e-06, 7.16999999999999996e-06, 9.29000000000000084e-06, 1.04899999999999995e-05, 1.36299999999999999e-05, 1.66299999999999983e-05, 1.93800000000000008e-05, 2.34100000000000012e-05, 2.89099999999999993e-05, 3.61199999999999998e-05, 4.32600000000000026e-05, 5.33100000000000029e-05, 6.31899999999999964e-05, 7.74599999999999936e-05, 9.33699999999999954e-05, 1.14560000000000001e-04, 1.41050000000000013e-04, 1.68059999999999987e-04, 2.03289999999999987e-04, 2.47309999999999989e-04, 2.96219999999999979e-04, 3.56619999999999984e-04, 4.32089999999999991e-04, 5.18670000000000047e-04, 6.24499999999999947e-04, 7.54530000000000001e-04, 9.02470000000000052e-04, 1.08555999999999995e-03, 1.30163999999999996e-03, 1.55392000000000008e-03, 1.85728000000000000e-03, 2.20928000000000010e-03, 2.62757000000000008e-03, 3.10840999999999982e-03, 3.70330000000000008e-03, 4.38043000000000026e-03, 5.15644999999999992e-03, 6.04964000000000023e-03, 7.09656000000000002e-03, 8.27968999999999927e-03, 9.63246000000000067e-03, 1.11800300000000005e-02, 1.28986399999999994e-02, 1.48071899999999996e-02, 1.69221999999999984e-02, 1.92457400000000008e-02, 2.17684599999999999e-02, 2.44550499999999990e-02, 2.73082000000000012e-02, 3.02996399999999992e-02, 3.33622500000000030e-02, 3.64075999999999983e-02, 3.93721799999999997e-02, 4.21983100000000028e-02, 4.47641500000000025e-02, 4.69409599999999969e-02, 4.85668799999999998e-02, 4.96121600000000024e-02, 4.99452099999999968e-02, 4.93752900000000022e-02, 4.79197000000000026e-02, 4.56197600000000023e-02, 4.23777499999999988e-02, 3.83285000000000015e-02, 3.36691100000000021e-02, 2.85574000000000001e-02, 2.33612199999999985e-02, 1.82985300000000004e-02, 1.36386200000000006e-02, 9.65486999999999942e-03, 6.46679999999999998e-03, 4.08054999999999963e-03, 2.42853999999999987e-03, 1.37077000000000010e-03, 7.36070000000000019e-04, 3.76230000000000021e-04, 1.87180000000000007e-04, 8.99899999999999973e-05, 4.15600000000000019e-05, 1.90899999999999985e-05, 8.09000000000000047e-06, 3.67000000000000001e-06, 1.37999999999999992e-06, 8.40000000000000004e-07, 2.39999999999999979e-07, 1.49999999999999993e-07, 5.99999999999999946e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[6][27] = niz6_27;
	static double niz6_28[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 1.00000000000000002e-08, 4.00000000000000008e-08, 0.00000000000000000e+00, 2.99999999999999973e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 2.99999999999999973e-08, 4.99999999999999977e-08, 4.00000000000000008e-08, 5.99999999999999946e-08, 4.00000000000000008e-08, 4.99999999999999977e-08, 4.99999999999999977e-08, 2.99999999999999973e-08, 7.00000000000000048e-08, 1.19999999999999989e-07, 7.00000000000000048e-08, 1.19999999999999989e-07, 1.79999999999999997e-07, 2.29999999999999995e-07, 2.29999999999999995e-07, 2.20000000000000011e-07, 4.99999999999999977e-07, 2.80000000000000019e-07, 4.30000000000000012e-07, 4.89999999999999967e-07, 5.30000000000000008e-07, 8.50000000000000014e-07, 8.29999999999999994e-07, 1.12999999999999998e-06, 1.08000000000000004e-06, 1.59999999999999993e-06, 2.04999999999999985e-06, 2.38000000000000008e-06, 3.00999999999999998e-06, 3.31000000000000007e-06, 3.99999999999999982e-06, 4.80999999999999969e-06, 6.37000000000000000e-06, 7.43000000000000001e-06, 8.74999999999999923e-06, 1.11699999999999998e-05, 1.35900000000000003e-05, 1.65299999999999993e-05, 1.95199999999999995e-05, 2.38199999999999989e-05, 2.93499999999999985e-05, 3.41999999999999978e-05, 4.19199999999999984e-05, 5.07699999999999967e-05, 6.07799999999999974e-05, 7.36799999999999993e-05, 8.74100000000000051e-05, 1.04829999999999998e-04, 1.27400000000000007e-04, 1.51900000000000006e-04, 1.83539999999999994e-04, 2.20680000000000008e-04, 2.63390000000000011e-04, 3.17769999999999988e-04, 3.80369999999999992e-04, 4.53759999999999992e-04, 5.38520000000000014e-04, 6.51690000000000017e-04, 7.75439999999999962e-04, 9.21060000000000021e-04, 1.10333999999999996e-03, 1.31766000000000001e-03, 1.56393999999999999e-03, 1.84121000000000003e-03, 2.18204000000000011e-03, 2.58389000000000015e-03, 3.04984999999999978e-03, 3.58885000000000020e-03, 4.21332000000000043e-03, 4.94636000000000034e-03, 5.78249000000000037e-03, 6.71733999999999960e-03, 7.82054000000000082e-03, 9.03203999999999986e-03, 1.04095899999999998e-02, 1.19681400000000004e-02, 1.36785699999999993e-02, 1.56145099999999998e-02, 1.77249499999999997e-02, 1.99533099999999984e-02, 2.24198200000000000e-02, 2.50112600000000004e-02, 2.76670099999999988e-02, 3.04845699999999990e-02, 3.33324499999999996e-02, 3.61459500000000031e-02, 3.88906200000000007e-02, 4.14175899999999972e-02, 4.37172099999999994e-02, 4.56111199999999981e-02, 4.70582100000000031e-02, 4.79433699999999990e-02, 4.80451199999999967e-02, 4.75360300000000000e-02, 4.60986099999999982e-02, 4.39269600000000010e-02, 4.08859499999999973e-02, 3.72260800000000017e-02, 3.28861999999999974e-02, 2.82226000000000005e-02, 2.33346900000000017e-02, 1.86285399999999990e-02, 1.41786299999999994e-02, 1.02872399999999996e-02, 7.11296999999999971e-03, 4.65300000000000002e-03, 2.87523999999999983e-03, 1.69980999999999995e-03, 9.56000000000000036e-04, 5.16249999999999999e-04, 2.68979999999999990e-04, 1.36389999999999987e-04, 6.74700000000000028e-05, 3.24800000000000007e-05, 1.54400000000000012e-05, 7.05000000000000026e-06, 3.57000000000000012e-06, 1.72999999999999995e-06, 6.89999999999999958e-07, 2.80000000000000019e-07, 9.99999999999999955e-08, 5.99999999999999946e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[6][28] = niz6_28;
	static double niz6_29[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 5.99999999999999946e-08, 4.99999999999999977e-08, 2.99999999999999973e-08, 2.00000000000000004e-08, 8.00000000000000017e-08, 8.00000000000000017e-08, 7.00000000000000048e-08, 4.99999999999999977e-08, 1.10000000000000006e-07, 9.99999999999999955e-08, 2.20000000000000011e-07, 2.80000000000000019e-07, 3.59999999999999994e-07, 2.99999999999999986e-07, 3.20000000000000007e-07, 4.99999999999999977e-07, 5.30000000000000008e-07, 4.89999999999999967e-07, 7.80000000000000049e-07, 8.70000000000000035e-07, 9.70000000000000030e-07, 1.12000000000000008e-06, 1.34999999999999999e-06, 1.59000000000000002e-06, 2.16000000000000007e-06, 2.09999999999999980e-06, 2.79999999999999987e-06, 3.67999999999999992e-06, 3.96000000000000020e-06, 4.76000000000000017e-06, 5.56000000000000013e-06, 7.20999999999999958e-06, 8.30000000000000015e-06, 1.05099999999999993e-05, 1.20499999999999998e-05, 1.41699999999999999e-05, 1.73900000000000012e-05, 2.02700000000000007e-05, 2.41100000000000012e-05, 2.94799999999999990e-05, 3.51699999999999970e-05, 4.26899999999999995e-05, 4.92800000000000025e-05, 6.06499999999999970e-05, 7.09599999999999982e-05, 8.59099999999999957e-05, 1.02130000000000000e-04, 1.23010000000000003e-04, 1.45579999999999999e-04, 1.73400000000000014e-04, 2.09409999999999989e-04, 2.51130000000000016e-04, 2.97300000000000017e-04, 3.52040000000000024e-04, 4.22610000000000021e-04, 5.06460000000000026e-04, 5.95970000000000028e-04, 7.10229999999999954e-04, 8.39440000000000000e-04, 9.99960000000000042e-04, 1.17960000000000005e-03, 1.39743000000000007e-03, 1.64509000000000009e-03, 1.94618999999999999e-03, 2.27448000000000016e-03, 2.67940000000000018e-03, 3.14664000000000003e-03, 3.67233000000000013e-03, 4.27689000000000021e-03, 4.98644999999999991e-03, 5.78022999999999992e-03, 6.68254999999999977e-03, 7.72907000000000021e-03, 8.90406000000000010e-03, 1.01904900000000000e-02, 1.16442600000000000e-02, 1.32563300000000002e-02, 1.50446000000000000e-02, 1.69841899999999997e-02, 1.90595399999999998e-02, 2.13006799999999989e-02, 2.36583700000000015e-02, 2.62073599999999990e-02, 2.87843799999999983e-02, 3.14149199999999990e-02, 3.40839400000000001e-02, 3.66147600000000031e-02, 3.91077999999999981e-02, 4.13138099999999994e-02, 4.32375200000000015e-02, 4.47613800000000034e-02, 4.58590700000000018e-02, 4.63339200000000007e-02, 4.62296999999999986e-02, 4.54075099999999982e-02, 4.38260300000000019e-02, 4.15467600000000020e-02, 3.85251500000000011e-02, 3.49088899999999980e-02, 3.08494100000000007e-02, 2.63922200000000010e-02, 2.18968200000000009e-02, 1.74685800000000009e-02, 1.34267599999999994e-02, 9.83790000000000012e-03, 6.86817999999999977e-03, 4.57997000000000005e-03, 2.89943000000000015e-03, 1.75373999999999994e-03, 1.01056999999999991e-03, 5.58699999999999974e-04, 3.00209999999999973e-04, 1.54880000000000008e-04, 7.79199999999999994e-05, 3.77000000000000016e-05, 1.78100000000000006e-05, 8.17999999999999961e-06, 4.03000000000000038e-06, 1.68999999999999991e-06, 7.60000000000000029e-07, 3.30000000000000017e-07, 1.19999999999999989e-07, 2.99999999999999973e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[6][29] = niz6_29;
	static double niz6_30[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 2.00000000000000004e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 2.00000000000000004e-08, 4.00000000000000008e-08, 2.99999999999999973e-08, 2.00000000000000004e-08, 1.00000000000000002e-08, 7.00000000000000048e-08, 1.10000000000000006e-07, 9.99999999999999955e-08, 8.99999999999999986e-08, 1.40000000000000010e-07, 1.29999999999999999e-07, 2.80000000000000019e-07, 1.90000000000000007e-07, 2.70000000000000009e-07, 2.89999999999999976e-07, 4.09999999999999992e-07, 5.79999999999999953e-07, 6.30000000000000003e-07, 6.99999999999999968e-07, 6.89999999999999958e-07, 9.19999999999999980e-07, 9.99999999999999955e-07, 1.28000000000000003e-06, 1.61000000000000004e-06, 1.90000000000000002e-06, 2.25000000000000006e-06, 2.53999999999999982e-06, 3.31000000000000007e-06, 3.80000000000000004e-06, 4.77999999999999997e-06, 5.62000000000000040e-06, 6.69000000000000032e-06, 7.24000000000000014e-06, 9.43999999999999940e-06, 1.10499999999999992e-05, 1.29200000000000000e-05, 1.50000000000000004e-05, 1.81799999999999987e-05, 2.26799999999999997e-05, 2.58900000000000011e-05, 3.16900000000000032e-05, 3.74800000000000003e-05, 4.36499999999999971e-05, 5.25000000000000022e-05, 6.09999999999999987e-05, 7.27300000000000033e-05, 8.83699999999999959e-05, 1.04370000000000005e-04, 1.24010000000000000e-04, 1.45109999999999998e-04, 1.77560000000000001e-04, 2.09110000000000009e-04, 2.44620000000000026e-04, 2.93980000000000001e-04, 3.51830000000000025e-04, 4.08949999999999993e-04, 4.86180000000000011e-04, 5.74779999999999996e-04, 6.80399999999999950e-04, 8.08789999999999986e-04, 9.53799999999999982e-04, 1.11231999999999998e-03, 1.31309000000000005e-03, 1.53655000000000003e-03, 1.80550999999999997e-03, 2.11691000000000006e-03, 2.46086000000000004e-03, 2.87343000000000017e-03, 3.36096000000000008e-03, 3.88453000000000019e-03, 4.50380999999999958e-03, 5.19635999999999969e-03, 6.01421999999999981e-03, 6.92011000000000015e-03, 7.93706999999999920e-03, 9.08502999999999915e-03, 1.03440600000000004e-02, 1.17717199999999994e-02, 1.32977000000000008e-02, 1.50233499999999996e-02, 1.68554100000000012e-02, 1.88378600000000014e-02, 2.09491200000000016e-02, 2.32175500000000000e-02, 2.55570700000000012e-02, 2.79716700000000006e-02, 3.03954500000000009e-02, 3.28783900000000004e-02, 3.52986299999999975e-02, 3.76261000000000026e-02, 3.97080600000000034e-02, 4.15698499999999985e-02, 4.30599399999999979e-02, 4.41277699999999967e-02, 4.47094400000000031e-02, 4.47981199999999968e-02, 4.41983199999999993e-02, 4.29706399999999974e-02, 4.10546200000000000e-02, 3.84663099999999966e-02, 3.53684299999999993e-02, 3.17124699999999995e-02, 2.77200800000000011e-02, 2.35269900000000011e-02, 1.93267500000000002e-02, 1.53349300000000001e-02, 1.16891700000000005e-02, 8.50474000000000022e-03, 5.92716999999999983e-03, 3.94383999999999967e-03, 2.52245999999999981e-03, 1.52818000000000008e-03, 8.96160000000000012e-04, 5.04470000000000027e-04, 2.75249999999999996e-04, 1.47899999999999990e-04, 7.61600000000000027e-05, 3.79100000000000013e-05, 1.84799999999999992e-05, 8.63000000000000038e-06, 4.15000000000000008e-06, 2.07000000000000009e-06, 9.09999999999999969e-07, 3.30000000000000017e-07, 2.39999999999999979e-07, 1.29999999999999999e-07, 8.99999999999999986e-08, 4.00000000000000008e-08, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[6][30] = niz6_30;

	static double niz7_1[] = { 1.00000000000000000e+00 }; repRatios[7][1] = niz7_1;
	static double niz7_2[] = { 2.65283659999999977e-01, 7.34716339999999968e-01 }; repRatios[7][2] = niz7_2;
	static double niz7_3[] = { 4.03583200000000031e-02, 8.99380199999999935e-02, 4.94828150000000022e-01, 3.74875510000000023e-01 }; repRatios[7][3] = niz7_3;
	static double niz7_4[] = { 5.83061999999999990e-03, 3.67746000000000002e-03, 4.58538799999999996e-02, 1.23643370000000002e-01, 2.85502330000000026e-01, 4.13054299999999985e-01, 1.22438039999999998e-01 }; repRatios[7][4] = niz7_4;
	static double niz7_5[] = { 8.34820000000000007e-04, 1.24940000000000007e-04, 2.24878000000000014e-03, 9.37522000000000008e-03, 2.76949000000000015e-02, 4.68174099999999968e-02, 1.59023319999999996e-01, 2.35748690000000011e-01, 3.20842689999999986e-01, 1.74805540000000009e-01, 2.24836900000000006e-02 }; repRatios[7][5] = niz7_5;
	static double niz7_6[] = { 1.16869999999999997e-04, 3.89999999999999993e-06, 9.10699999999999937e-05, 5.52340000000000014e-04, 2.10608000000000019e-03, 2.72593000000000011e-03, 8.81233000000000016e-03, 1.96454799999999999e-02, 4.71986500000000017e-02, 8.79611799999999999e-02, 1.60221940000000007e-01, 2.40211599999999997e-01, 2.40394219999999992e-01, 1.53718490000000013e-01, 3.44126500000000030e-02, 1.82726999999999998e-03 }; repRatios[7][6] = niz7_6;
	static double niz7_7[] = { 1.65200000000000011e-05, 5.99999999999999946e-08, 3.21000000000000018e-06, 2.63899999999999997e-05, 1.36649999999999988e-04, 2.82540000000000016e-04, 5.78020000000000053e-04, 4.59819999999999999e-04, 2.68796000000000009e-03, 5.59756999999999963e-03, 1.05106799999999997e-02, 1.91708600000000014e-02, 4.39149299999999979e-02, 7.53102799999999933e-02, 1.23235529999999996e-01, 1.80446510000000004e-01, 2.15086780000000005e-01, 1.86292220000000008e-01, 1.05340530000000002e-01, 2.84989499999999986e-02, 2.36607000000000007e-03, 3.79200000000000029e-05 }; repRatios[7][7] = niz7_7;
	static double niz7_8[] = { 2.47999999999999997e-06, 0.00000000000000000e+00, 8.00000000000000017e-08, 1.01000000000000007e-06, 7.36999999999999974e-06, 2.28199999999999984e-05, 5.89099999999999967e-05, 4.25999999999999987e-05, 9.22199999999999946e-05, 2.04219999999999993e-04, 6.44970000000000027e-04, 1.04422000000000000e-03, 2.13678999999999996e-03, 3.29554000000000001e-03, 7.37769000000000012e-03, 1.51004099999999999e-02, 2.52443400000000005e-02, 4.25524499999999986e-02, 7.44101800000000063e-02, 1.12751089999999998e-01, 1.51899019999999996e-01, 1.81962790000000013e-01, 1.77507219999999993e-01, 1.26460739999999988e-01, 6.06275500000000023e-02, 1.51441200000000005e-02, 1.38792999999999989e-03, 2.12399999999999999e-05, 0.00000000000000000e+00 }; repRatios[7][8] = niz7_8;
	static double niz7_9[] = { 3.09999999999999997e-07, 0.00000000000000000e+00, 0.00000000000000000e+00, 4.99999999999999977e-08, 2.20000000000000011e-07, 1.12000000000000008e-06, 4.57000000000000029e-06, 6.95000000000000037e-06, 8.90999999999999940e-06, 4.24999999999999997e-06, 2.58099999999999985e-05, 4.44199999999999982e-05, 1.52189999999999991e-04, 1.82599999999999993e-04, 2.95540000000000006e-04, 5.40000000000000007e-04, 1.14568000000000005e-03, 2.13678000000000002e-03, 3.86919000000000022e-03, 6.34671000000000020e-03, 1.11924799999999994e-02, 1.94170099999999984e-02, 3.34440199999999979e-02, 5.11051699999999984e-02, 7.70446600000000009e-02, 1.09889799999999996e-01, 1.42791790000000002e-01, 1.58898430000000007e-01, 1.57351660000000004e-01, 1.21959040000000005e-01, 7.01930399999999982e-02, 2.63204899999999985e-02, 5.24568999999999990e-03, 3.75689999999999976e-04, 5.73000000000000020e-06, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[7][9] = niz7_9;
	static double niz7_10[] = { 4.00000000000000008e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 5.99999999999999946e-08, 4.20000000000000002e-07, 7.50000000000000019e-07, 1.30000000000000005e-06, 8.89999999999999949e-07, 1.14000000000000010e-06, 1.01999999999999998e-06, 7.86999999999999919e-06, 1.04599999999999998e-05, 2.60899999999999992e-05, 3.52599999999999978e-05, 4.81999999999999993e-05, 6.88999999999999942e-05, 1.55410000000000005e-04, 2.97669999999999988e-04, 5.43740000000000022e-04, 8.01300000000000016e-04, 1.30127999999999993e-03, 2.27187000000000005e-03, 4.15993999999999999e-03, 6.81849999999999991e-03, 1.10546499999999992e-02, 1.74608899999999997e-02, 2.78624599999999986e-02, 4.28565399999999985e-02, 6.27093100000000042e-02, 8.64540800000000026e-02, 1.12170580000000006e-01, 1.35882279999999994e-01, 1.45243690000000009e-01, 1.35531530000000011e-01, 1.05434639999999996e-01, 6.47001199999999999e-02, 2.74734199999999984e-02, 7.61421999999999967e-03, 9.41090000000000004e-04, 5.73200000000000001e-05, 1.06999999999999992e-06, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[7][10] = niz7_10;
	static double niz7_11[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 4.99999999999999977e-08, 5.99999999999999946e-08, 1.10000000000000006e-07, 1.79999999999999997e-07, 1.40000000000000010e-07, 1.00000000000000002e-08, 3.49999999999999984e-07, 3.39999999999999974e-07, 1.63999999999999997e-06, 2.92999999999999990e-06, 4.84000000000000025e-06, 4.86000000000000006e-06, 7.44999999999999982e-06, 9.24999999999999953e-06, 2.17899999999999997e-05, 3.93699999999999974e-05, 6.61199999999999971e-05, 1.02659999999999996e-04, 1.62850000000000001e-04, 2.37810000000000002e-04, 4.01660000000000027e-04, 7.08199999999999975e-04, 1.22867000000000007e-03, 1.88715999999999992e-03, 2.92237000000000009e-03, 4.68419000000000040e-03, 7.61170999999999983e-03, 1.19492899999999996e-02, 1.84583000000000004e-02, 2.68472899999999993e-02, 3.96447399999999978e-02, 5.61058200000000007e-02, 7.61229400000000000e-02, 9.68930300000000050e-02, 1.16667850000000003e-01, 1.29363449999999991e-01, 1.29704889999999989e-01, 1.13632910000000004e-01, 8.41688800000000015e-02, 5.04604999999999984e-02, 2.21803399999999998e-02, 6.54356000000000035e-03, 1.04784999999999991e-03, 9.60800000000000017e-05, 5.30999999999999998e-06, 1.90000000000000007e-07, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[7][11] = niz7_11;
	static double niz7_12[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 2.99999999999999973e-08, 4.00000000000000008e-08, 2.00000000000000004e-08, 4.99999999999999977e-08, 0.00000000000000000e+00, 8.99999999999999986e-08, 5.99999999999999946e-08, 2.70000000000000009e-07, 4.20000000000000002e-07, 8.60000000000000025e-07, 7.50000000000000019e-07, 9.40000000000000000e-07, 1.43000000000000007e-06, 2.46000000000000016e-06, 4.62999999999999972e-06, 9.25999999999999943e-06, 1.41799999999999998e-05, 1.84700000000000010e-05, 2.59999999999999984e-05, 4.14400000000000030e-05, 6.74099999999999933e-05, 1.19270000000000002e-04, 1.88910000000000006e-04, 2.96539999999999976e-04, 4.38770000000000002e-04, 6.79319999999999967e-04, 1.04705000000000011e-03, 1.69447999999999994e-03, 2.66833999999999995e-03, 4.12947999999999961e-03, 6.10896000000000008e-03, 9.18825000000000024e-03, 1.38286699999999995e-02, 2.04000600000000011e-02, 2.91835899999999988e-02, 4.06019700000000011e-02, 5.48445600000000005e-02, 7.16599700000000034e-02, 9.00793899999999953e-02, 1.06001049999999999e-01, 1.16646100000000003e-01, 1.19263330000000001e-01, 1.09485920000000000e-01, 8.84059299999999937e-02, 6.06361100000000000e-02, 3.34865899999999966e-02, 1.40988299999999997e-02, 3.86944000000000003e-03, 6.78039999999999980e-04, 7.62199999999999987e-05, 5.75000000000000000e-06, 2.80000000000000019e-07, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[7][12] = niz7_12;
	static double niz7_13[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.99999999999999973e-08, 4.99999999999999977e-08, 7.00000000000000048e-08, 7.00000000000000048e-08, 9.99999999999999955e-08, 1.19999999999999989e-07, 8.99999999999999986e-08, 8.99999999999999986e-08, 3.70000000000000004e-07, 6.70000000000000044e-07, 1.26000000000000001e-06, 2.16000000000000007e-06, 2.64000000000000013e-06, 3.24999999999999980e-06, 4.59000000000000010e-06, 6.63999999999999995e-06, 1.11599999999999999e-05, 1.81799999999999987e-05, 3.01100000000000014e-05, 4.50000000000000028e-05, 6.47700000000000050e-05, 8.91799999999999966e-05, 1.34759999999999990e-04, 2.12919999999999988e-04, 3.41229999999999984e-04, 5.14739999999999968e-04, 7.83889999999999977e-04, 1.13889999999999998e-03, 1.72174999999999997e-03, 2.55711000000000003e-03, 3.87353000000000003e-03, 5.71338999999999961e-03, 8.41985999999999950e-03, 1.20046400000000004e-02, 1.70584000000000013e-02, 2.38814800000000001e-02, 3.30770499999999967e-02, 4.41677399999999970e-02, 5.72785999999999990e-02, 7.20692400000000066e-02, 8.69829899999999961e-02, 1.00097110000000003e-01, 1.08625059999999996e-01, 1.09066060000000006e-01, 1.01017940000000001e-01, 8.40955000000000036e-02, 6.08503700000000008e-02, 3.71903800000000020e-02, 1.83118599999999992e-02, 6.60475000000000038e-03, 1.60906000000000005e-03, 2.80890000000000003e-04, 3.47899999999999973e-05, 3.22000000000000009e-06, 1.79999999999999997e-07, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[7][13] = niz7_13;
	static double niz7_14[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 4.99999999999999977e-08, 0.00000000000000000e+00, 2.00000000000000004e-08, 0.00000000000000000e+00, 4.00000000000000008e-08, 4.00000000000000008e-08, 1.69999999999999987e-07, 2.59999999999999999e-07, 3.49999999999999984e-07, 5.50000000000000028e-07, 7.09999999999999978e-07, 7.89999999999999954e-07, 9.29999999999999990e-07, 1.46000000000000000e-06, 2.65999999999999994e-06, 4.70999999999999980e-06, 6.01999999999999996e-06, 8.85999999999999987e-06, 1.28900000000000003e-05, 1.66399999999999999e-05, 2.64299999999999994e-05, 3.96199999999999967e-05, 6.15000000000000041e-05, 9.28499999999999936e-05, 1.39270000000000013e-04, 1.94329999999999991e-04, 2.80419999999999975e-04, 4.09100000000000024e-04, 6.19630000000000029e-04, 9.16319999999999982e-04, 1.34993999999999999e-03, 1.95502000000000002e-03, 2.80085000000000013e-03, 4.03751000000000023e-03, 5.80124999999999998e-03, 8.26440999999999981e-03, 1.16055700000000008e-02, 1.61166100000000000e-02, 2.19278499999999987e-02, 2.93798600000000007e-02, 3.86885400000000004e-02, 4.98043199999999991e-02, 6.21855700000000025e-02, 7.49081300000000033e-02, 8.70660199999999940e-02, 9.66433299999999995e-02, 1.01598709999999995e-01, 9.98755699999999969e-02, 9.06755999999999951e-02, 7.48554800000000020e-02, 5.49052999999999972e-02, 3.46268699999999971e-02, 1.80649100000000000e-02, 7.31568999999999969e-03, 2.14992000000000004e-03, 4.68739999999999988e-04, 8.01699999999999998e-05, 1.06000000000000002e-05, 9.09999999999999969e-07, 8.99999999999999986e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[7][14] = niz7_14;
	static double niz7_15[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.00000000000000004e-08, 0.00000000000000000e+00, 4.99999999999999977e-08, 5.99999999999999946e-08, 8.99999999999999986e-08, 7.00000000000000048e-08, 7.00000000000000048e-08, 9.99999999999999955e-08, 2.80000000000000019e-07, 3.59999999999999994e-07, 6.30000000000000003e-07, 1.14000000000000010e-06, 1.17999999999999993e-06, 1.76999999999999999e-06, 2.61999999999999990e-06, 3.30000000000000017e-06, 4.77999999999999997e-06, 7.25999999999999995e-06, 1.07999999999999999e-05, 1.69900000000000017e-05, 2.39299999999999996e-05, 3.20399999999999982e-05, 4.50700000000000005e-05, 6.31800000000000016e-05, 8.89499999999999937e-05, 1.30110000000000013e-04, 1.96269999999999989e-04, 2.83610000000000004e-04, 4.03119999999999976e-04, 5.61269999999999998e-04, 8.06570000000000052e-04, 1.13981999999999994e-03, 1.65700999999999999e-03, 2.35308999999999996e-03, 3.31476999999999987e-03, 4.61040999999999968e-03, 6.42560000000000006e-03, 8.80809999999999926e-03, 1.20884800000000004e-02, 1.63570500000000014e-02, 2.17819100000000015e-02, 2.85337399999999984e-02, 3.67532200000000031e-02, 4.62877999999999970e-02, 5.69929500000000006e-02, 6.82396799999999970e-02, 7.89304400000000045e-02, 8.77949900000000033e-02, 9.34008499999999936e-02, 9.42543500000000006e-02, 8.94601099999999955e-02, 7.85294599999999954e-02, 6.29299999999999998e-02, 4.51812099999999994e-02, 2.82182100000000005e-02, 1.46878800000000004e-02, 6.07208999999999961e-03, 1.92953999999999999e-03, 4.73539999999999996e-04, 9.04000000000000018e-05, 1.50400000000000000e-05, 2.26999999999999987e-06, 2.29999999999999995e-07, 2.00000000000000004e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[7][15] = niz7_15;
	static double niz7_16[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 2.00000000000000004e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 2.99999999999999973e-08, 4.99999999999999977e-08, 1.49999999999999993e-07, 3.30000000000000017e-07, 2.10000000000000001e-07, 3.59999999999999994e-07, 3.09999999999999997e-07, 5.19999999999999998e-07, 6.50000000000000024e-07, 1.10000000000000006e-06, 1.41000000000000005e-06, 2.12000000000000003e-06, 3.06999999999999983e-06, 4.30000000000000033e-06, 5.12000000000000011e-06, 6.70000000000000023e-06, 8.80000000000000045e-06, 1.25500000000000001e-05, 1.91700000000000011e-05, 2.76599999999999994e-05, 3.92600000000000002e-05, 5.35200000000000026e-05, 7.44499999999999936e-05, 1.05480000000000000e-04, 1.45090000000000008e-04, 2.04940000000000000e-04, 2.88369999999999978e-04, 4.10329999999999983e-04, 5.77689999999999953e-04, 8.06670000000000000e-04, 1.12162000000000004e-03, 1.54074000000000008e-03, 2.12753999999999981e-03, 2.96333000000000013e-03, 4.07132999999999974e-03, 5.57445999999999983e-03, 7.53299999999999977e-03, 1.00959299999999995e-02, 1.34172100000000006e-02, 1.76811800000000012e-02, 2.30199900000000006e-02, 2.95013299999999992e-02, 3.70984599999999998e-02, 4.57053300000000023e-02, 5.52202799999999966e-02, 6.50286800000000054e-02, 7.42377500000000051e-02, 8.20677400000000001e-02, 8.71316699999999944e-02, 8.82350100000000026e-02, 8.49997900000000056e-02, 7.67953299999999950e-02, 6.40938300000000044e-02, 4.90298200000000017e-02, 3.35041099999999967e-02, 1.99117400000000007e-02, 9.87929000000000064e-03, 3.94572999999999972e-03, 1.26665000000000002e-03, 3.18330000000000024e-04, 6.86799999999999997e-05, 1.16000000000000007e-05, 1.79000000000000001e-06, 2.49999999999999989e-07, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[7][16] = niz7_16;
	static double niz7_17[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 2.99999999999999973e-08, 7.00000000000000048e-08, 2.99999999999999973e-08, 4.00000000000000008e-08, 5.99999999999999946e-08, 8.99999999999999986e-08, 1.10000000000000006e-07, 1.49999999999999993e-07, 3.80000000000000015e-07, 3.39999999999999974e-07, 5.40000000000000018e-07, 7.40000000000000009e-07, 9.50000000000000010e-07, 1.12000000000000008e-06, 1.56000000000000010e-06, 1.52999999999999996e-06, 2.48999999999999988e-06, 3.46999999999999981e-06, 5.07999999999999964e-06, 7.15000000000000015e-06, 1.01599999999999993e-05, 1.31299999999999996e-05, 1.83299999999999990e-05, 2.39800000000000008e-05, 3.38800000000000009e-05, 4.64599999999999990e-05, 6.49300000000000034e-05, 9.33899999999999986e-05, 1.27660000000000008e-04, 1.74260000000000002e-04, 2.38640000000000006e-04, 3.28510000000000011e-04, 4.48229999999999983e-04, 6.20050000000000028e-04, 8.55650000000000009e-04, 1.17092999999999993e-03, 1.59147999999999993e-03, 2.16969000000000016e-03, 2.92689000000000013e-03, 3.93266000000000015e-03, 5.25330999999999975e-03, 7.00791000000000001e-03, 9.25786999999999964e-03, 1.21408000000000002e-02, 1.56789399999999988e-02, 2.01352599999999986e-02, 2.54437599999999993e-02, 3.18744099999999989e-02, 3.91493899999999992e-02, 4.72193699999999966e-02, 5.56763300000000030e-02, 6.42440400000000023e-02, 7.21113800000000027e-02, 7.85178700000000035e-02, 8.23277199999999931e-02, 8.28886699999999976e-02, 7.95183200000000034e-02, 7.20656699999999983e-02, 6.11656500000000020e-02, 4.78809899999999983e-02, 3.40538900000000033e-02, 2.15801000000000014e-02, 1.17481300000000007e-02, 5.34446999999999960e-03, 1.99178999999999979e-03, 6.08220000000000028e-04, 1.57190000000000004e-04, 3.48100000000000004e-05, 7.34999999999999993e-06, 1.26999999999999991e-06, 2.29999999999999995e-07, 2.00000000000000004e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[7][17] = niz7_17;
	static double niz7_18[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.00000000000000004e-08, 2.00000000000000004e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 4.99999999999999977e-08, 4.99999999999999977e-08, 7.00000000000000048e-08, 1.10000000000000006e-07, 1.49999999999999993e-07, 1.69999999999999987e-07, 1.29999999999999999e-07, 1.90000000000000007e-07, 3.70000000000000004e-07, 4.70000000000000000e-07, 8.19999999999999984e-07, 1.17999999999999993e-06, 1.61999999999999995e-06, 1.90000000000000002e-06, 2.15000000000000017e-06, 3.13000000000000010e-06, 3.80000000000000004e-06, 5.57999999999999994e-06, 7.36999999999999974e-06, 1.05099999999999993e-05, 1.39200000000000006e-05, 1.95900000000000005e-05, 2.58500000000000015e-05, 3.59100000000000001e-05, 4.66599999999999971e-05, 6.23700000000000009e-05, 8.84699999999999983e-05, 1.16750000000000005e-04, 1.60590000000000006e-04, 2.21410000000000010e-04, 2.97110000000000006e-04, 4.00980000000000000e-04, 5.36849999999999957e-04, 7.18969999999999982e-04, 9.69470000000000054e-04, 1.31524000000000007e-03, 1.75533000000000004e-03, 2.33534999999999993e-03, 3.09175999999999982e-03, 4.07886000000000012e-03, 5.36820000000000006e-03, 7.01322999999999964e-03, 9.10191999999999946e-03, 1.17619700000000001e-02, 1.50049699999999994e-02, 1.89551799999999986e-02, 2.36846399999999999e-02, 2.92958799999999998e-02, 3.56240000000000029e-02, 4.26623100000000019e-02, 5.02334300000000025e-02, 5.78491500000000020e-02, 6.51386199999999943e-02, 7.14354199999999995e-02, 7.60114900000000010e-02, 7.82053999999999944e-02, 7.74136899999999933e-02, 7.31685799999999970e-02, 6.56343399999999993e-02, 5.53710200000000000e-02, 4.34209300000000034e-02, 3.11690100000000005e-02, 2.00654400000000004e-02, 1.13313000000000007e-02, 5.47303000000000026e-03, 2.22077999999999989e-03, 7.58140000000000029e-04, 2.22749999999999993e-04, 5.72100000000000028e-05, 1.29200000000000000e-05, 2.90000000000000019e-06, 6.50000000000000024e-07, 1.29999999999999999e-07, 2.00000000000000004e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[7][18] = niz7_18;
	static double niz7_19[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 2.00000000000000004e-08, 2.99999999999999973e-08, 0.00000000000000000e+00, 4.00000000000000008e-08, 7.00000000000000048e-08, 4.99999999999999977e-08, 2.99999999999999973e-08, 4.00000000000000008e-08, 2.99999999999999973e-08, 9.99999999999999955e-08, 1.10000000000000006e-07, 9.99999999999999955e-08, 2.29999999999999995e-07, 3.39999999999999974e-07, 2.89999999999999976e-07, 4.59999999999999990e-07, 6.60000000000000034e-07, 8.19999999999999984e-07, 8.19999999999999984e-07, 1.32999999999999997e-06, 1.88999999999999990e-06, 2.47999999999999997e-06, 2.87000000000000005e-06, 4.24000000000000006e-06, 4.87999999999999986e-06, 7.34999999999999993e-06, 9.38999999999999988e-06, 1.20399999999999999e-05, 1.59000000000000002e-05, 2.09900000000000006e-05, 2.86900000000000014e-05, 3.85400000000000003e-05, 5.10500000000000008e-05, 6.99300000000000030e-05, 9.21699999999999934e-05, 1.22890000000000011e-04, 1.58319999999999989e-04, 2.15400000000000004e-04, 2.85549999999999975e-04, 3.81099999999999993e-04, 5.08839999999999987e-04, 6.77569999999999952e-04, 8.94900000000000014e-04, 1.18121000000000003e-03, 1.54155000000000004e-03, 2.03514999999999989e-03, 2.67833999999999997e-03, 3.50036000000000010e-03, 4.53444999999999977e-03, 5.84770999999999989e-03, 7.52098999999999997e-03, 9.58192000000000071e-03, 1.21336399999999994e-02, 1.52461999999999997e-02, 1.89320299999999990e-02, 2.33581500000000011e-02, 2.84834799999999985e-02, 3.42020599999999994e-02, 4.05132900000000004e-02, 4.72928199999999993e-02, 5.40759000000000031e-02, 6.06845400000000021e-02, 6.65160999999999947e-02, 7.09676999999999947e-02, 7.35959100000000005e-02, 7.37898599999999988e-02, 7.12563300000000066e-02, 6.57719499999999957e-02, 5.76642200000000021e-02, 4.76357099999999978e-02, 3.66601000000000010e-02, 2.59462900000000003e-02, 1.65413100000000000e-02, 9.30814999999999941e-03, 4.53650999999999967e-03, 1.88360000000000003e-03, 6.80179999999999956e-04, 2.11229999999999995e-04, 5.87099999999999986e-05, 1.56300000000000011e-05, 3.32999999999999988e-06, 6.19999999999999993e-07, 1.79999999999999997e-07, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[7][19] = niz7_19;
	static double niz7_20[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 2.00000000000000004e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 5.99999999999999946e-08, 4.00000000000000008e-08, 2.99999999999999973e-08, 1.49999999999999993e-07, 1.19999999999999989e-07, 1.49999999999999993e-07, 1.79999999999999997e-07, 1.69999999999999987e-07, 4.09999999999999992e-07, 3.49999999999999984e-07, 5.79999999999999953e-07, 6.09999999999999983e-07, 1.08999999999999994e-06, 1.23999999999999999e-06, 1.67000000000000010e-06, 2.13999999999999984e-06, 2.74999999999999993e-06, 3.52000000000000018e-06, 4.59000000000000010e-06, 6.24000000000000040e-06, 8.60000000000000067e-06, 1.07900000000000000e-05, 1.44500000000000006e-05, 1.96399999999999983e-05, 2.43099999999999993e-05, 3.28499999999999989e-05, 4.23700000000000026e-05, 5.83000000000000009e-05, 7.48200000000000053e-05, 9.92599999999999949e-05, 1.31659999999999996e-04, 1.75579999999999996e-04, 2.27149999999999992e-04, 3.01390000000000013e-04, 3.91830000000000021e-04, 5.17690000000000012e-04, 6.71959999999999984e-04, 8.88910000000000026e-04, 1.15288999999999995e-03, 1.49803999999999996e-03, 1.94123999999999989e-03, 2.50814999999999979e-03, 3.22323000000000011e-03, 4.13228000000000033e-03, 5.26568999999999995e-03, 6.69620000000000024e-03, 8.44709000000000085e-03, 1.05695400000000005e-02, 1.31760899999999997e-02, 1.62983800000000012e-02, 1.99293900000000017e-02, 2.41748999999999992e-02, 2.90358499999999985e-02, 3.43610400000000024e-02, 4.02191400000000004e-02, 4.62655699999999989e-02, 5.23967600000000006e-02, 5.82376900000000017e-02, 6.33690999999999977e-02, 6.74321400000000015e-02, 6.97220300000000043e-02, 7.00528599999999946e-02, 6.80543599999999943e-02, 6.35855699999999940e-02, 5.67802599999999991e-02, 4.80918999999999999e-02, 3.83765299999999990e-02, 2.85111499999999990e-02, 1.93811600000000014e-02, 1.18959900000000004e-02, 6.47435000000000024e-03, 3.08714999999999988e-03, 1.27180000000000001e-03, 4.62459999999999987e-04, 1.45780000000000004e-04, 4.30199999999999981e-05, 1.16400000000000004e-05, 2.96999999999999994e-06, 6.89999999999999958e-07, 1.69999999999999987e-07, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[7][20] = niz7_20;
	static double niz7_21[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.00000000000000004e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.00000000000000004e-08, 8.99999999999999986e-08, 4.99999999999999977e-08, 8.99999999999999986e-08, 4.00000000000000008e-08, 5.99999999999999946e-08, 8.00000000000000017e-08, 1.69999999999999987e-07, 8.00000000000000017e-08, 9.99999999999999955e-08, 2.10000000000000001e-07, 2.39999999999999979e-07, 4.59999999999999990e-07, 4.99999999999999977e-07, 5.79999999999999953e-07, 7.60000000000000029e-07, 1.06000000000000002e-06, 1.34000000000000009e-06, 1.76000000000000009e-06, 2.37000000000000018e-06, 2.91000000000000009e-06, 3.80000000000000004e-06, 5.27000000000000037e-06, 6.48999999999999970e-06, 8.23000000000000082e-06, 1.09000000000000007e-05, 1.44700000000000004e-05, 1.79099999999999996e-05, 2.44399999999999998e-05, 3.22099999999999982e-05, 4.20899999999999985e-05, 5.46500000000000002e-05, 6.91599999999999951e-05, 9.00499999999999933e-05, 1.18870000000000005e-04, 1.53570000000000009e-04, 1.96610000000000003e-04, 2.60350000000000013e-04, 3.36870000000000019e-04, 4.33850000000000002e-04, 5.57309999999999989e-04, 7.16660000000000040e-04, 9.29950000000000026e-04, 1.19205000000000005e-03, 1.53571999999999997e-03, 1.95377000000000007e-03, 2.51219000000000008e-03, 3.18232000000000020e-03, 4.02577999999999964e-03, 5.06637999999999967e-03, 6.35973000000000007e-03, 7.94895999999999971e-03, 9.86195999999999948e-03, 1.21514499999999994e-02, 1.48840099999999996e-02, 1.80862099999999984e-02, 2.17779799999999989e-02, 2.60185199999999998e-02, 3.06651499999999987e-02, 3.57639599999999974e-02, 4.12311100000000014e-02, 4.67896100000000023e-02, 5.22346100000000008e-02, 5.73010300000000028e-02, 6.16724700000000001e-02, 6.49248699999999956e-02, 6.66108100000000064e-02, 6.64428900000000044e-02, 6.43355199999999933e-02, 6.00400800000000026e-02, 5.38073000000000023e-02, 4.59646100000000030e-02, 3.71413000000000021e-02, 2.81681800000000010e-02, 1.97639400000000007e-02, 1.26995600000000004e-02, 7.32047999999999987e-03, 3.74639999999999999e-03, 1.69166000000000000e-03, 6.75790000000000006e-04, 2.42649999999999989e-04, 7.86599999999999957e-05, 2.44099999999999984e-05, 6.72000000000000003e-06, 1.83999999999999996e-06, 3.90000000000000025e-07, 1.99999999999999991e-07, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[7][21] = niz7_21;
	static double niz7_22[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.99999999999999973e-08, 2.99999999999999973e-08, 2.99999999999999973e-08, 1.00000000000000002e-08, 4.00000000000000008e-08, 4.99999999999999977e-08, 8.00000000000000017e-08, 1.40000000000000010e-07, 1.40000000000000010e-07, 2.10000000000000001e-07, 2.70000000000000009e-07, 2.49999999999999989e-07, 3.99999999999999982e-07, 5.50000000000000028e-07, 5.99999999999999973e-07, 8.09999999999999974e-07, 9.90000000000000050e-07, 1.28000000000000003e-06, 1.61000000000000004e-06, 1.99000000000000001e-06, 2.33000000000000014e-06, 3.58999999999999993e-06, 4.05000000000000019e-06, 5.90000000000000026e-06, 7.07000000000000007e-06, 9.19000000000000010e-06, 1.25400000000000002e-05, 1.50300000000000001e-05, 1.93400000000000012e-05, 2.42899999999999995e-05, 3.23200000000000023e-05, 4.04299999999999975e-05, 5.40300000000000028e-05, 6.72300000000000051e-05, 8.88500000000000048e-05, 1.15119999999999996e-04, 1.44079999999999989e-04, 1.87290000000000004e-04, 2.38299999999999992e-04, 3.07990000000000011e-04, 3.90680000000000020e-04, 5.03619999999999979e-04, 6.41769999999999949e-04, 8.19019999999999948e-04, 1.04145999999999991e-03, 1.32007000000000001e-03, 1.67555999999999998e-03, 2.11424999999999981e-03, 2.65096999999999989e-03, 3.34739000000000000e-03, 4.16882000000000016e-03, 5.19804000000000013e-03, 6.44033000000000019e-03, 7.96203000000000015e-03, 9.76156000000000072e-03, 1.18861499999999998e-02, 1.44256699999999998e-02, 1.73446499999999997e-02, 2.07209999999999998e-02, 2.45095300000000016e-02, 2.87191400000000006e-02, 3.32728600000000013e-02, 3.81810600000000028e-02, 4.32277000000000008e-02, 4.82202200000000011e-02, 5.30048300000000028e-02, 5.72505999999999987e-02, 6.06199799999999969e-02, 6.28690300000000063e-02, 6.36263499999999982e-02, 6.27549899999999966e-02, 5.99812499999999998e-02, 5.54886699999999969e-02, 4.93226299999999993e-02, 4.19417399999999982e-02, 3.38392500000000013e-02, 2.57040899999999989e-02, 1.81892500000000006e-02, 1.18456399999999993e-02, 6.98336000000000009e-03, 3.71305999999999980e-03, 1.75683000000000002e-03, 7.45690000000000025e-04, 2.84669999999999997e-04, 9.95100000000000010e-05, 3.31300000000000030e-05, 9.48000000000000071e-06, 2.71999999999999979e-06, 9.40000000000000000e-07, 2.20000000000000011e-07, 2.99999999999999973e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[7][22] = niz7_22;
	static double niz7_23[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 2.00000000000000004e-08, 2.00000000000000004e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 2.99999999999999973e-08, 2.99999999999999973e-08, 2.99999999999999973e-08, 4.99999999999999977e-08, 4.00000000000000008e-08, 9.99999999999999955e-08, 7.00000000000000048e-08, 1.40000000000000010e-07, 8.00000000000000017e-08, 1.69999999999999987e-07, 9.99999999999999955e-08, 1.69999999999999987e-07, 1.79999999999999997e-07, 3.70000000000000004e-07, 4.59999999999999990e-07, 6.60000000000000034e-07, 7.60000000000000029e-07, 1.01000000000000007e-06, 1.35999999999999990e-06, 1.54999999999999998e-06, 2.11000000000000013e-06, 2.53999999999999982e-06, 2.99000000000000017e-06, 3.82999999999999975e-06, 5.45000000000000034e-06, 6.56999999999999978e-06, 8.26000000000000054e-06, 1.11200000000000003e-05, 1.23800000000000001e-05, 1.69400000000000004e-05, 2.20500000000000006e-05, 2.79499999999999984e-05, 3.41999999999999978e-05, 4.38599999999999968e-05, 5.58800000000000003e-05, 7.16699999999999965e-05, 9.15299999999999995e-05, 1.15959999999999994e-04, 1.48710000000000004e-04, 1.86700000000000012e-04, 2.35970000000000006e-04, 3.03219999999999987e-04, 3.81500000000000003e-04, 4.85899999999999993e-04, 6.14289999999999975e-04, 7.74269999999999971e-04, 9.73519999999999963e-04, 1.22359000000000009e-03, 1.53466999999999991e-03, 1.90595999999999995e-03, 2.38477000000000003e-03, 2.95762000000000021e-03, 3.67582000000000022e-03, 4.53517999999999977e-03, 5.57463999999999963e-03, 6.82788999999999965e-03, 8.32690999999999987e-03, 1.00963200000000006e-02, 1.21683599999999996e-02, 1.46104700000000004e-02, 1.73950600000000004e-02, 2.05632700000000015e-02, 2.41144899999999988e-02, 2.80219599999999985e-02, 3.22386399999999990e-02, 3.67123899999999975e-02, 4.13255599999999973e-02, 4.59111099999999980e-02, 5.03146999999999969e-02, 5.42302399999999990e-02, 5.75101299999999996e-02, 5.97625000000000031e-02, 6.08093800000000032e-02, 6.04457099999999997e-02, 5.84522499999999973e-02, 5.49536799999999978e-02, 4.98801599999999998e-02, 4.35998100000000027e-02, 3.64813999999999972e-02, 2.89358699999999990e-02, 2.16990900000000007e-02, 1.51388700000000005e-02, 9.74792000000000020e-03, 5.73078000000000042e-03, 3.04756999999999988e-03, 1.47202000000000010e-03, 6.40060000000000021e-04, 2.54800000000000013e-04, 9.52299999999999946e-05, 3.14200000000000007e-05, 1.03399999999999993e-05, 3.28999999999999984e-06, 9.50000000000000010e-07, 2.29999999999999995e-07, 7.00000000000000048e-08, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[7][23] = niz7_23;
	static double niz7_24[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.99999999999999973e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 4.00000000000000008e-08, 4.99999999999999977e-08, 9.99999999999999955e-08, 1.40000000000000010e-07, 1.40000000000000010e-07, 1.40000000000000010e-07, 2.20000000000000011e-07, 1.29999999999999999e-07, 1.69999999999999987e-07, 2.99999999999999986e-07, 3.59999999999999994e-07, 3.70000000000000004e-07, 5.99999999999999973e-07, 6.79999999999999948e-07, 8.50000000000000014e-07, 9.79999999999999934e-07, 1.26000000000000001e-06, 1.48000000000000002e-06, 2.43999999999999993e-06, 2.64000000000000013e-06, 3.80000000000000004e-06, 3.85000000000000041e-06, 5.25999999999999961e-06, 6.20999999999999984e-06, 7.16000000000000006e-06, 9.87000000000000037e-06, 1.27599999999999998e-05, 1.58499999999999990e-05, 2.04800000000000004e-05, 2.54499999999999986e-05, 3.08999999999999989e-05, 4.03399999999999966e-05, 5.04899999999999994e-05, 6.52099999999999940e-05, 8.01999999999999979e-05, 1.01370000000000000e-04, 1.25709999999999987e-04, 1.59829999999999993e-04, 2.01449999999999991e-04, 2.52820000000000009e-04, 3.13930000000000025e-04, 3.97529999999999997e-04, 4.92589999999999998e-04, 6.15270000000000010e-04, 7.64169999999999997e-04, 9.61390000000000009e-04, 1.19595000000000009e-03, 1.49539000000000009e-03, 1.83552999999999993e-03, 2.27801000000000002e-03, 2.80911000000000008e-03, 3.44990000000000010e-03, 4.23335000000000031e-03, 5.16398000000000031e-03, 6.27095999999999990e-03, 7.58597999999999998e-03, 9.12728999999999971e-03, 1.09496999999999997e-02, 1.30498200000000002e-02, 1.54669800000000000e-02, 1.82054199999999999e-02, 2.12934999999999999e-02, 2.46827299999999999e-02, 2.83958500000000003e-02, 3.23367400000000027e-02, 3.64988499999999993e-02, 4.06772099999999984e-02, 4.48315099999999980e-02, 4.87947000000000033e-02, 5.22876199999999999e-02, 5.52439399999999983e-02, 5.72443700000000028e-02, 5.81636499999999973e-02, 5.79383700000000029e-02, 5.61991999999999978e-02, 5.31140500000000029e-02, 4.86722500000000002e-02, 4.31120899999999987e-02, 3.66446699999999972e-02, 2.98291499999999987e-02, 2.30193599999999991e-02, 1.67362399999999995e-02, 1.13394299999999993e-02, 7.10567999999999964e-03, 4.07497999999999975e-03, 2.13019000000000012e-03, 1.01376000000000005e-03, 4.44690000000000027e-04, 1.79130000000000001e-04, 6.58700000000000046e-05, 2.36800000000000003e-05, 8.28000000000000035e-06, 2.46000000000000016e-06, 8.70000000000000035e-07, 2.80000000000000019e-07, 1.10000000000000006e-07, 2.99999999999999973e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[7][24] = niz7_24;
	static double niz7_25[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.00000000000000004e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.00000000000000004e-08, 2.99999999999999973e-08, 4.99999999999999977e-08, 2.00000000000000004e-08, 2.00000000000000004e-08, 4.00000000000000008e-08, 2.99999999999999973e-08, 5.99999999999999946e-08, 4.00000000000000008e-08, 7.00000000000000048e-08, 1.40000000000000010e-07, 1.60000000000000003e-07, 1.49999999999999993e-07, 2.10000000000000001e-07, 2.80000000000000019e-07, 3.09999999999999997e-07, 5.09999999999999988e-07, 4.49999999999999980e-07, 5.09999999999999988e-07, 6.19999999999999993e-07, 7.80000000000000049e-07, 1.01999999999999998e-06, 1.26999999999999991e-06, 1.59000000000000002e-06, 2.15000000000000017e-06, 2.68000000000000018e-06, 3.46999999999999981e-06, 4.17999999999999979e-06, 4.49000000000000021e-06, 6.43000000000000027e-06, 8.13999999999999999e-06, 1.00300000000000005e-05, 1.24900000000000007e-05, 1.54499999999999995e-05, 1.94000000000000006e-05, 2.45700000000000002e-05, 3.02699999999999999e-05, 3.81899999999999986e-05, 4.81300000000000017e-05, 5.94100000000000021e-05, 7.56900000000000021e-05, 9.29600000000000044e-05, 1.16059999999999997e-04, 1.42909999999999999e-04, 1.78650000000000006e-04, 2.24469999999999997e-04, 2.76260000000000015e-04, 3.45929999999999990e-04, 4.29609999999999975e-04, 5.32829999999999979e-04, 6.63329999999999953e-04, 8.14220000000000048e-04, 1.00543000000000008e-03, 1.23675000000000000e-03, 1.52462999999999991e-03, 1.87167999999999991e-03, 2.29751000000000000e-03, 2.80205999999999988e-03, 3.40963999999999981e-03, 4.14900999999999985e-03, 5.01752000000000014e-03, 6.04898999999999975e-03, 7.25075000000000025e-03, 8.68931000000000044e-03, 1.03226600000000009e-02, 1.22416699999999996e-02, 1.44019800000000000e-02, 1.68869199999999997e-02, 1.96548300000000016e-02, 2.26842499999999996e-02, 2.59802600000000015e-02, 2.95780799999999996e-02, 3.33327200000000032e-02, 3.71941299999999989e-02, 4.10952899999999996e-02, 4.48132899999999987e-02, 4.82852000000000003e-02, 5.13388700000000017e-02, 5.37412300000000009e-02, 5.53294900000000020e-02, 5.58833499999999983e-02, 5.52660700000000005e-02, 5.34899500000000014e-02, 5.04518499999999995e-02, 4.62047199999999977e-02, 4.10037099999999988e-02, 3.50982199999999994e-02, 2.87723899999999984e-02, 2.25370800000000010e-02, 1.66647499999999990e-02, 1.15830399999999993e-02, 7.49574999999999981e-03, 4.47242000000000039e-03, 2.45940999999999998e-03, 1.24361999999999997e-03, 5.80510000000000010e-04, 2.53589999999999989e-04, 1.03679999999999997e-04, 3.94800000000000015e-05, 1.42099999999999995e-05, 4.81999999999999959e-06, 1.59999999999999993e-06, 6.30000000000000003e-07, 1.19999999999999989e-07, 2.99999999999999973e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[7][25] = niz7_25;
	static double niz7_26[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 2.00000000000000004e-08, 0.00000000000000000e+00, 2.00000000000000004e-08, 4.99999999999999977e-08, 4.99999999999999977e-08, 2.00000000000000004e-08, 4.00000000000000008e-08, 5.99999999999999946e-08, 8.99999999999999986e-08, 1.10000000000000006e-07, 7.00000000000000048e-08, 1.79999999999999997e-07, 2.80000000000000019e-07, 2.10000000000000001e-07, 3.59999999999999994e-07, 2.70000000000000009e-07, 5.19999999999999998e-07, 4.89999999999999967e-07, 6.79999999999999948e-07, 8.70000000000000035e-07, 1.08999999999999994e-06, 1.03000000000000009e-06, 1.41000000000000005e-06, 1.88000000000000000e-06, 2.31999999999999981e-06, 3.04000000000000012e-06, 3.77999999999999981e-06, 4.66000000000000028e-06, 5.80000000000000037e-06, 7.18999999999999977e-06, 8.50999999999999984e-06, 1.06899999999999993e-05, 1.36299999999999999e-05, 1.68800000000000010e-05, 2.06700000000000003e-05, 2.65700000000000014e-05, 3.18500000000000017e-05, 3.89200000000000001e-05, 4.91500000000000021e-05, 5.98999999999999991e-05, 7.47899999999999937e-05, 9.02100000000000054e-05, 1.13690000000000004e-04, 1.39020000000000007e-04, 1.72100000000000009e-04, 2.13030000000000012e-04, 2.63990000000000025e-04, 3.21720000000000003e-04, 3.97139999999999982e-04, 4.85599999999999986e-04, 6.06129999999999972e-04, 7.44210000000000032e-04, 9.05850000000000036e-04, 1.11130999999999990e-03, 1.35373999999999998e-03, 1.64449999999999991e-03, 2.00352999999999989e-03, 2.42479999999999996e-03, 2.93915000000000018e-03, 3.55668999999999994e-03, 4.27157999999999965e-03, 5.13269999999999959e-03, 6.13096000000000040e-03, 7.29537999999999975e-03, 8.66719999999999990e-03, 1.02223300000000000e-02, 1.20325699999999994e-02, 1.40864600000000003e-02, 1.63746700000000009e-02, 1.89253700000000004e-02, 2.17633399999999991e-02, 2.47934000000000002e-02, 2.80762199999999990e-02, 3.15244900000000022e-02, 3.50717899999999985e-02, 3.86233699999999971e-02, 4.21510999999999969e-02, 4.54423499999999994e-02, 4.84202400000000033e-02, 5.08128399999999980e-02, 5.26004200000000019e-02, 5.35322999999999979e-02, 5.35331799999999997e-02, 5.24315200000000023e-02, 5.02561200000000013e-02, 4.69803199999999990e-02, 4.27547500000000011e-02, 3.77433299999999985e-02, 3.20564100000000005e-02, 2.62577199999999983e-02, 2.05038399999999989e-02, 1.51993800000000002e-02, 1.06166500000000000e-02, 6.94341999999999963e-03, 4.21606999999999971e-03, 2.37944000000000003e-03, 1.24766000000000005e-03, 5.96410000000000017e-04, 2.70420000000000003e-04, 1.12759999999999998e-04, 4.64700000000000006e-05, 1.74999999999999985e-05, 7.07000000000000007e-06, 2.52000000000000001e-06, 8.89999999999999949e-07, 3.70000000000000004e-07, 7.00000000000000048e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[7][26] = niz7_26;
	static double niz7_27[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 4.00000000000000008e-08, 2.99999999999999973e-08, 1.00000000000000002e-08, 4.00000000000000008e-08, 2.00000000000000004e-08, 2.00000000000000004e-08, 8.00000000000000017e-08, 4.99999999999999977e-08, 2.00000000000000004e-08, 5.99999999999999946e-08, 8.99999999999999986e-08, 9.99999999999999955e-08, 1.29999999999999999e-07, 1.79999999999999997e-07, 1.90000000000000007e-07, 1.90000000000000007e-07, 3.09999999999999997e-07, 2.70000000000000009e-07, 3.70000000000000004e-07, 5.79999999999999953e-07, 6.50000000000000024e-07, 6.60000000000000034e-07, 6.99999999999999968e-07, 1.14000000000000010e-06, 1.12000000000000008e-06, 1.57999999999999991e-06, 1.88000000000000000e-06, 2.21000000000000002e-06, 2.93999999999999980e-06, 3.46999999999999981e-06, 4.21000000000000035e-06, 5.57999999999999994e-06, 6.51000000000000035e-06, 8.12000000000000018e-06, 9.72000000000000011e-06, 1.13100000000000001e-05, 1.42800000000000005e-05, 1.72400000000000010e-05, 2.17199999999999987e-05, 2.76599999999999994e-05, 3.39300000000000021e-05, 4.13400000000000006e-05, 5.20300000000000016e-05, 6.30099999999999947e-05, 7.79199999999999994e-05, 9.48299999999999984e-05, 1.16479999999999996e-04, 1.41680000000000012e-04, 1.75689999999999993e-04, 2.14310000000000000e-04, 2.63780000000000026e-04, 3.22279999999999984e-04, 3.94450000000000020e-04, 4.72330000000000026e-04, 5.82080000000000011e-04, 7.06009999999999971e-04, 8.61530000000000000e-04, 1.04859000000000007e-03, 1.27395999999999998e-03, 1.53629999999999999e-03, 1.86103000000000006e-03, 2.23273000000000004e-03, 2.68819999999999996e-03, 3.22872999999999997e-03, 3.84923999999999987e-03, 4.60065000000000040e-03, 5.48808000000000022e-03, 6.49299999999999964e-03, 7.67334999999999979e-03, 9.02624999999999955e-03, 1.05539199999999996e-02, 1.23440000000000008e-02, 1.42820499999999993e-02, 1.65079599999999986e-02, 1.89406699999999997e-02, 2.15900299999999996e-02, 2.45121699999999998e-02, 2.75131800000000017e-02, 3.07783099999999997e-02, 3.40477900000000014e-02, 3.73539499999999969e-02, 4.05876299999999995e-02, 4.36591200000000026e-02, 4.64026700000000000e-02, 4.86923500000000023e-02, 5.03794600000000009e-02, 5.14171699999999982e-02, 5.15419800000000011e-02, 5.08152399999999976e-02, 4.91109600000000021e-02, 4.63855999999999991e-02, 4.27308200000000027e-02, 3.83579600000000034e-02, 3.32850599999999983e-02, 2.79424599999999988e-02, 2.25300800000000009e-02, 1.73919499999999998e-02, 1.27319900000000003e-02, 8.80129999999999975e-03, 5.71691000000000039e-03, 3.45556999999999982e-03, 1.95008000000000009e-03, 1.02125000000000002e-03, 5.02309999999999953e-04, 2.36199999999999995e-04, 1.01689999999999997e-04, 4.19699999999999997e-05, 1.69099999999999990e-05, 6.45000000000000008e-06, 2.33000000000000014e-06, 7.50000000000000019e-07, 2.39999999999999979e-07, 1.10000000000000006e-07, 4.99999999999999977e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[7][27] = niz7_27;
	static double niz7_28[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 2.00000000000000004e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 4.00000000000000008e-08, 7.00000000000000048e-08, 7.00000000000000048e-08, 5.99999999999999946e-08, 8.00000000000000017e-08, 9.99999999999999955e-08, 1.40000000000000010e-07, 1.40000000000000010e-07, 1.60000000000000003e-07, 1.40000000000000010e-07, 1.90000000000000007e-07, 3.59999999999999994e-07, 3.20000000000000007e-07, 4.59999999999999990e-07, 6.30000000000000003e-07, 5.70000000000000048e-07, 6.30000000000000003e-07, 1.04000000000000000e-06, 1.06000000000000002e-06, 1.56000000000000010e-06, 1.70000000000000003e-06, 2.17999999999999988e-06, 2.70999999999999989e-06, 3.43000000000000019e-06, 4.01999999999999963e-06, 4.60000000000000000e-06, 6.57999999999999968e-06, 7.40000000000000030e-06, 9.62999999999999928e-06, 1.13999999999999993e-05, 1.37500000000000005e-05, 1.69800000000000001e-05, 2.00800000000000009e-05, 2.54099999999999990e-05, 3.06200000000000016e-05, 3.86899999999999972e-05, 4.53899999999999974e-05, 5.68099999999999999e-05, 6.85200000000000013e-05, 8.33399999999999983e-05, 1.01689999999999997e-04, 1.23029999999999993e-04, 1.50349999999999995e-04, 1.83300000000000010e-04, 2.21730000000000007e-04, 2.70810000000000018e-04, 3.29919999999999985e-04, 3.99890000000000022e-04, 4.88999999999999960e-04, 5.90189999999999985e-04, 7.13810000000000052e-04, 8.58719999999999991e-04, 1.04015000000000010e-03, 1.25004000000000001e-03, 1.49730000000000002e-03, 1.80116000000000000e-03, 2.15839000000000005e-03, 2.57947999999999988e-03, 3.08013999999999987e-03, 3.66662000000000021e-03, 4.34694999999999960e-03, 5.14400000000000013e-03, 6.04743000000000034e-03, 7.11603999999999969e-03, 8.33782999999999920e-03, 9.72196999999999992e-03, 1.13068500000000002e-02, 1.30352000000000003e-02, 1.49889600000000008e-02, 1.71683400000000007e-02, 1.95708700000000006e-02, 2.21210400000000015e-02, 2.48618399999999996e-02, 2.77660399999999988e-02, 3.07830400000000011e-02, 3.38449200000000006e-02, 3.69303299999999973e-02, 3.98716600000000032e-02, 4.26550700000000033e-02, 4.51767699999999980e-02, 4.72510400000000011e-02, 4.87301200000000018e-02, 4.95490999999999987e-02, 4.96803300000000017e-02, 4.89469699999999994e-02, 4.73664199999999994e-02, 4.49220700000000014e-02, 4.16366000000000028e-02, 3.76225899999999974e-02, 3.29910600000000026e-02, 2.80867900000000004e-02, 2.30202299999999992e-02, 1.81090399999999999e-02, 1.36280299999999993e-02, 9.73555000000000080e-03, 6.57143999999999957e-03, 4.16607999999999996e-03, 2.47949999999999993e-03, 1.38115000000000004e-03, 7.19550000000000007e-04, 3.57320000000000001e-04, 1.63649999999999993e-04, 7.18799999999999962e-05, 3.06200000000000016e-05, 1.23300000000000005e-05, 5.15999999999999972e-06, 2.08999999999999989e-06, 8.80000000000000045e-07, 1.99999999999999991e-07, 1.10000000000000006e-07, 5.99999999999999946e-08, 2.99999999999999973e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[7][28] = niz7_28;
	static double niz7_29[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 4.00000000000000008e-08, 0.00000000000000000e+00, 2.00000000000000004e-08, 1.00000000000000002e-08, 2.99999999999999973e-08, 4.00000000000000008e-08, 2.99999999999999973e-08, 1.00000000000000002e-08, 8.00000000000000017e-08, 7.00000000000000048e-08, 1.10000000000000006e-07, 7.00000000000000048e-08, 1.79999999999999997e-07, 1.29999999999999999e-07, 2.80000000000000019e-07, 2.39999999999999979e-07, 3.20000000000000007e-07, 5.09999999999999988e-07, 4.89999999999999967e-07, 5.70000000000000048e-07, 7.70000000000000039e-07, 7.60000000000000029e-07, 8.99999999999999959e-07, 1.21999999999999997e-06, 1.83000000000000005e-06, 1.57999999999999991e-06, 2.37000000000000018e-06, 2.83000000000000001e-06, 3.24999999999999980e-06, 4.48000000000000031e-06, 5.00000000000000041e-06, 5.92999999999999998e-06, 8.24000000000000073e-06, 9.43999999999999940e-06, 1.16200000000000006e-05, 1.41300000000000002e-05, 1.71399999999999985e-05, 2.03100000000000004e-05, 2.48399999999999993e-05, 2.99099999999999999e-05, 3.67799999999999968e-05, 4.47199999999999987e-05, 5.29200000000000015e-05, 6.47000000000000006e-05, 7.94699999999999964e-05, 9.63999999999999986e-05, 1.17170000000000005e-04, 1.41289999999999997e-04, 1.68419999999999990e-04, 2.08010000000000009e-04, 2.49909999999999998e-04, 2.99429999999999998e-04, 3.61529999999999989e-04, 4.35989999999999978e-04, 5.25239999999999952e-04, 6.32320000000000017e-04, 7.57870000000000006e-04, 9.07389999999999998e-04, 1.09045999999999991e-03, 1.29293000000000008e-03, 1.55214999999999997e-03, 1.85147999999999997e-03, 2.20063999999999980e-03, 2.61030999999999980e-03, 3.08882999999999987e-03, 3.65356000000000014e-03, 4.29147000000000035e-03, 5.05810000000000027e-03, 5.91870999999999977e-03, 6.90431000000000031e-03, 8.03941000000000031e-03, 9.31227999999999917e-03, 1.07575399999999995e-02, 1.23837700000000005e-02, 1.41929099999999996e-02, 1.61968299999999989e-02, 1.83517300000000001e-02, 2.07027299999999990e-02, 2.32554700000000003e-02, 2.58862200000000015e-02, 2.86838700000000002e-02, 3.15284700000000029e-02, 3.43932500000000002e-02, 3.71587700000000007e-02, 3.98508100000000004e-02, 4.23448599999999981e-02, 4.44768899999999981e-02, 4.61991900000000011e-02, 4.73890699999999984e-02, 4.79616100000000017e-02, 4.78246599999999980e-02, 4.69536600000000012e-02, 4.52682100000000032e-02, 4.28051600000000018e-02, 3.95563099999999973e-02, 3.57680800000000007e-02, 3.14267099999999966e-02, 2.68359599999999990e-02, 2.21463699999999986e-02, 1.75602800000000010e-02, 1.33749699999999999e-02, 9.70722000000000078e-03, 6.69288999999999995e-03, 4.34001000000000005e-03, 2.66209000000000020e-03, 1.53144000000000001e-03, 8.24010000000000020e-04, 4.22279999999999975e-04, 2.02950000000000000e-04, 9.61099999999999997e-05, 4.25899999999999971e-05, 1.76099999999999991e-05, 7.73000000000000053e-06, 2.88999999999999986e-06, 1.15999999999999991e-06, 4.89999999999999967e-07, 9.99999999999999955e-08, 4.00000000000000008e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[7][29] = niz7_29;
	static double niz7_30[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 2.99999999999999973e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 2.00000000000000004e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 2.99999999999999973e-08, 2.99999999999999973e-08, 5.99999999999999946e-08, 2.99999999999999973e-08, 4.99999999999999977e-08, 5.99999999999999946e-08, 1.10000000000000006e-07, 1.10000000000000006e-07, 1.29999999999999999e-07, 1.69999999999999987e-07, 1.40000000000000010e-07, 2.89999999999999976e-07, 2.10000000000000001e-07, 3.49999999999999984e-07, 4.59999999999999990e-07, 5.30000000000000008e-07, 5.19999999999999998e-07, 7.60000000000000029e-07, 6.79999999999999948e-07, 9.50000000000000010e-07, 1.19000000000000004e-06, 1.43999999999999998e-06, 1.81000000000000003e-06, 1.99000000000000001e-06, 2.40999999999999980e-06, 3.14999999999999991e-06, 3.52000000000000018e-06, 4.54999999999999964e-06, 4.86999999999999996e-06, 6.37000000000000000e-06, 6.86000000000000039e-06, 8.90999999999999940e-06, 1.03299999999999994e-05, 1.28199999999999992e-05, 1.45799999999999993e-05, 1.74399999999999990e-05, 2.09500000000000010e-05, 2.57699999999999989e-05, 3.10500000000000026e-05, 3.62699999999999966e-05, 4.44400000000000014e-05, 5.36199999999999982e-05, 6.47599999999999966e-05, 7.75200000000000032e-05, 9.47400000000000043e-05, 1.14879999999999998e-04, 1.38099999999999996e-04, 1.64360000000000005e-04, 1.99210000000000012e-04, 2.38060000000000008e-04, 2.83820000000000003e-04, 3.46049999999999982e-04, 4.11989999999999991e-04, 4.91659999999999992e-04, 5.86130000000000028e-04, 6.98539999999999990e-04, 8.41179999999999966e-04, 9.93849999999999898e-04, 1.18132999999999997e-03, 1.41204999999999998e-03, 1.66661999999999995e-03, 1.97072000000000002e-03, 2.32718999999999981e-03, 2.74535000000000013e-03, 3.22573000000000000e-03, 3.79123999999999997e-03, 4.42437000000000039e-03, 5.17863000000000004e-03, 6.02841999999999961e-03, 6.98519999999999957e-03, 8.06427000000000012e-03, 9.30667999999999947e-03, 1.07026799999999991e-02, 1.22492399999999998e-02, 1.39537900000000006e-02, 1.58340499999999988e-02, 1.78527799999999987e-02, 2.00662500000000008e-02, 2.23932500000000000e-02, 2.48861899999999990e-02, 2.74851100000000001e-02, 3.01250300000000006e-02, 3.27990400000000015e-02, 3.54228899999999985e-02, 3.79683800000000030e-02, 4.03103699999999981e-02, 4.24188399999999993e-02, 4.41159200000000029e-02, 4.54213399999999975e-02, 4.61502099999999971e-02, 4.63225199999999990e-02, 4.57983000000000001e-02, 4.46082999999999966e-02, 4.26676600000000031e-02, 4.00194599999999998e-02, 3.68153800000000017e-02, 3.30117200000000013e-02, 2.88977499999999998e-02, 2.45242799999999990e-02, 2.01686699999999997e-02, 1.59680599999999992e-02, 1.21465600000000007e-02, 8.83734000000000082e-03, 6.11449000000000020e-03, 4.00903000000000023e-03, 2.48305000000000010e-03, 1.45537000000000010e-03, 8.09939999999999987e-04, 4.19419999999999992e-04, 2.09569999999999987e-04, 1.02769999999999994e-04, 4.59700000000000020e-05, 2.13399999999999990e-05, 8.97000000000000052e-06, 3.58000000000000003e-06, 1.43999999999999998e-06, 6.19999999999999993e-07, 2.10000000000000001e-07, 4.00000000000000008e-08, 2.99999999999999973e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[7][30] = niz7_30;

	static double niz8_1[] = { 1.00000000000000000e+00 }; repRatios[8][1] = niz8_1;
	static double niz8_2[] = { 2.34314579999999995e-01, 7.65685419999999950e-01 }; repRatios[8][2] = niz8_2;
	static double niz8_3[] = { 3.10187300000000013e-02, 7.18373100000000014e-02, 4.66446199999999978e-01, 4.30697759999999985e-01 }; repRatios[8][3] = niz8_3;
	static double niz8_4[] = { 3.91421000000000043e-03, 2.24247999999999982e-03, 3.25362800000000008e-02, 9.94058800000000020e-02, 2.49518629999999991e-01, 4.44204770000000027e-01, 1.68177749999999987e-01 }; repRatios[8][4] = niz8_4;
	static double niz8_5[] = { 4.87389999999999980e-04, 5.91200000000000032e-05, 1.22430999999999994e-03, 5.89393000000000035e-03, 1.84789500000000009e-02, 3.15315200000000004e-02, 1.23737009999999995e-01, 2.07127279999999997e-01, 3.32780340000000008e-01, 2.36607939999999989e-01, 4.20722099999999988e-02 }; repRatios[8][5] = niz8_5;
	static double niz8_6[] = { 6.16600000000000026e-05, 1.34999999999999999e-06, 3.83599999999999986e-05, 2.66039999999999994e-04, 1.15343999999999993e-03, 1.63269000000000001e-03, 4.66430999999999964e-03, 1.17304499999999999e-02, 3.14370699999999975e-02, 6.08382199999999984e-02, 1.24168239999999999e-01, 2.17716020000000010e-01, 2.57626299999999975e-01, 2.13743440000000007e-01, 6.90200799999999975e-02, 5.90232999999999990e-03 }; repRatios[8][6] = niz8_6;
	static double niz8_7[] = { 7.23000000000000023e-06, 4.99999999999999977e-08, 1.15000000000000000e-06, 9.66000000000000069e-06, 5.91500000000000012e-05, 1.43399999999999989e-04, 2.87770000000000018e-04, 1.79060000000000010e-04, 1.26738000000000003e-03, 2.92499000000000014e-03, 5.87028000000000029e-03, 1.05386300000000002e-02, 2.60238700000000010e-02, 5.02202600000000027e-02, 8.96717900000000012e-02, 1.45920440000000012e-01, 2.08410330000000005e-01, 2.19410340000000009e-01, 1.63213080000000010e-01, 6.57612000000000058e-02, 9.70839000000000077e-03, 3.71550000000000005e-04 }; repRatios[8][7] = niz8_7;
	static double niz8_8[] = { 8.70000000000000035e-07, 0.00000000000000000e+00, 4.99999999999999977e-08, 3.49999999999999984e-07, 2.47999999999999997e-06, 9.05999999999999965e-06, 2.56100000000000004e-05, 2.14899999999999992e-05, 3.19999999999999986e-05, 7.44000000000000060e-05, 2.74769999999999973e-04, 4.85509999999999978e-04, 1.00920999999999997e-03, 1.46793000000000010e-03, 3.40932999999999991e-03, 7.82564000000000003e-03, 1.39055800000000007e-02, 2.43203599999999992e-02, 4.60407800000000034e-02, 7.84917299999999957e-02, 1.19409580000000001e-01, 1.63055699999999998e-01, 1.94175209999999987e-01, 1.75931499999999991e-01, 1.15311060000000007e-01, 4.59266200000000013e-02, 8.30048000000000070e-03, 4.86549999999999982e-04, 6.15000000000000041e-06 }; repRatios[8][8] = niz8_8;
	static double niz8_9[] = { 1.10000000000000006e-07, 0.00000000000000000e+00, 0.00000000000000000e+00, 4.99999999999999977e-08, 8.00000000000000017e-08, 4.99999999999999977e-07, 1.46000000000000000e-06, 3.36999999999999992e-06, 3.44000000000000010e-06, 1.08000000000000004e-06, 8.14999999999999990e-06, 1.49199999999999995e-05, 5.87999999999999995e-05, 7.65000000000000028e-05, 1.23330000000000000e-04, 1.99230000000000002e-04, 4.28339999999999982e-04, 8.84200000000000025e-04, 1.71540999999999989e-03, 2.87584000000000017e-03, 5.13068000000000031e-03, 9.29274000000000072e-03, 1.75812000000000017e-02, 2.91706499999999994e-02, 4.67789899999999995e-02, 7.41824499999999970e-02, 1.09783759999999994e-01, 1.42541670000000009e-01, 1.66645399999999999e-01, 1.64551979999999987e-01, 1.27147919999999998e-01, 7.08250200000000024e-02, 2.52434900000000004e-02, 4.44035000000000003e-03, 2.85660000000000026e-04, 3.22999999999999999e-06, 0.00000000000000000e+00 }; repRatios[8][9] = niz8_9;
	static double niz8_10[] = { 4.99999999999999977e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 1.10000000000000006e-07, 1.60000000000000003e-07, 4.59999999999999990e-07, 3.39999999999999974e-07, 2.20000000000000011e-07, 1.79999999999999997e-07, 2.17999999999999988e-06, 3.54999999999999989e-06, 9.20000000000000001e-06, 1.23700000000000001e-05, 1.64699999999999999e-05, 2.02199999999999995e-05, 4.82200000000000025e-05, 9.91799999999999957e-05, 1.98130000000000002e-04, 3.09489999999999993e-04, 4.77129999999999980e-04, 8.35730000000000023e-04, 1.60256999999999999e-03, 2.80698000000000015e-03, 4.85058000000000017e-03, 7.90154000000000030e-03, 1.32331800000000006e-02, 2.18937699999999999e-02, 3.52839399999999997e-02, 5.33831400000000025e-02, 7.66084900000000013e-02, 1.05749750000000003e-01, 1.32961560000000006e-01, 1.49966640000000012e-01, 1.46198920000000010e-01, 1.21255420000000003e-01, 7.68680800000000053e-02, 3.54931200000000030e-02, 1.03135099999999997e-02, 1.51468000000000002e-03, 7.97799999999999985e-05, 9.40000000000000000e-07, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[8][10] = niz8_10;
	static double niz8_11[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.99999999999999973e-08, 4.99999999999999977e-08, 0.00000000000000000e+00, 7.00000000000000048e-08, 8.00000000000000017e-08, 3.59999999999999994e-07, 8.50000000000000014e-07, 1.37999999999999992e-06, 1.70999999999999993e-06, 2.16999999999999998e-06, 2.37000000000000018e-06, 5.23999999999999981e-06, 1.19399999999999992e-05, 2.10899999999999997e-05, 3.45300000000000031e-05, 5.56199999999999994e-05, 7.49999999999999934e-05, 1.22339999999999998e-04, 2.23410000000000004e-04, 4.13469999999999983e-04, 6.79730000000000026e-04, 1.06872000000000000e-03, 1.70035999999999994e-03, 2.85831000000000019e-03, 4.79817999999999998e-03, 7.90540999999999987e-03, 1.22763700000000000e-02, 1.90760500000000006e-02, 2.91341700000000009e-02, 4.36390099999999989e-02, 6.19577200000000008e-02, 8.37619500000000017e-02, 1.06671639999999998e-01, 1.26997219999999994e-01, 1.36861170000000004e-01, 1.30079050000000002e-01, 1.06227950000000002e-01, 7.10779799999999989e-02, 3.62657499999999994e-02, 1.28655200000000001e-02, 2.82964000000000002e-03, 2.83319999999999991e-04, 1.29200000000000000e-05, 1.29999999999999999e-07, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[8][11] = niz8_11;
	static double niz8_12[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 4.00000000000000008e-08, 2.99999999999999973e-08, 1.79999999999999997e-07, 1.60000000000000003e-07, 2.20000000000000011e-07, 2.39999999999999979e-07, 3.70000000000000004e-07, 1.10999999999999996e-06, 1.99000000000000001e-06, 3.65000000000000021e-06, 6.03999999999999977e-06, 7.20999999999999958e-06, 1.07600000000000003e-05, 1.70599999999999993e-05, 3.13000000000000019e-05, 5.42800000000000021e-05, 8.77899999999999980e-05, 1.32270000000000006e-04, 2.07579999999999988e-04, 3.13330000000000010e-04, 5.20379999999999975e-04, 8.55680000000000047e-04, 1.41430000000000006e-03, 2.18723000000000008e-03, 3.35500999999999985e-03, 5.24153000000000032e-03, 8.20293000000000064e-03, 1.25766999999999997e-02, 1.88495800000000012e-02, 2.74744500000000010e-02, 3.89980600000000011e-02, 5.44929399999999967e-02, 7.26647700000000035e-02, 9.16980399999999946e-02, 1.09601569999999995e-01, 1.21755279999999994e-01, 1.24122999999999997e-01, 1.12417110000000001e-01, 8.86696599999999974e-02, 5.83778800000000000e-02, 3.06489700000000011e-02, 1.15947900000000007e-02, 2.96408999999999995e-03, 4.07880000000000005e-04, 3.13099999999999967e-05, 1.23000000000000008e-06, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[8][12] = niz8_12;
	static double niz8_13[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 4.00000000000000008e-08, 2.00000000000000004e-08, 5.99999999999999946e-08, 8.00000000000000017e-08, 4.99999999999999977e-08, 1.69999999999999987e-07, 4.40000000000000022e-07, 7.60000000000000029e-07, 9.79999999999999934e-07, 1.39000000000000003e-06, 1.48000000000000002e-06, 2.30999999999999991e-06, 3.77999999999999981e-06, 7.60999999999999998e-06, 1.21800000000000003e-05, 1.72200000000000011e-05, 2.42699999999999997e-05, 3.48799999999999981e-05, 5.35299999999999974e-05, 8.83099999999999998e-05, 1.39879999999999996e-04, 2.18380000000000006e-04, 3.31069999999999986e-04, 5.02630000000000004e-04, 7.57779999999999999e-04, 1.16350999999999998e-03, 1.81007999999999994e-03, 2.81761999999999985e-03, 4.24375000000000013e-03, 6.29038999999999987e-03, 9.27007000000000005e-03, 1.37143100000000004e-02, 1.98663199999999998e-02, 2.80567999999999998e-02, 3.86416099999999998e-02, 5.18076999999999982e-02, 6.70738599999999990e-02, 8.37551700000000038e-02, 9.91046800000000006e-02, 1.10265730000000006e-01, 1.14327260000000000e-01, 1.08826430000000002e-01, 9.24663899999999955e-02, 6.87335300000000010e-02, 4.31390200000000001e-02, 2.17407000000000017e-02, 8.22413999999999958e-03, 2.09663999999999988e-03, 3.30200000000000003e-04, 3.26500000000000008e-05, 2.07999999999999999e-06, 4.00000000000000008e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[8][13] = niz8_13;
	static double niz8_14[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.99999999999999973e-08, 4.99999999999999977e-08, 8.00000000000000017e-08, 4.00000000000000008e-08, 8.99999999999999986e-08, 1.19999999999999989e-07, 2.59999999999999999e-07, 3.70000000000000004e-07, 4.99999999999999977e-07, 7.29999999999999999e-07, 1.39000000000000003e-06, 2.12999999999999994e-06, 2.93999999999999980e-06, 3.91999999999999974e-06, 5.42999999999999968e-06, 8.84999999999999997e-06, 1.29999999999999992e-05, 2.09999999999999988e-05, 3.22400000000000030e-05, 4.92800000000000025e-05, 6.74200000000000016e-05, 1.00340000000000005e-04, 1.51330000000000003e-04, 2.27970000000000001e-04, 3.54629999999999984e-04, 5.35439999999999983e-04, 7.82189999999999990e-04, 1.15637000000000010e-03, 1.70827999999999995e-03, 2.54170000000000004e-03, 3.74157000000000005e-03, 5.49082000000000042e-03, 7.95788000000000051e-03, 1.13075499999999995e-02, 1.58879599999999996e-02, 2.21178599999999996e-02, 3.03423900000000003e-02, 4.04379200000000022e-02, 5.24427400000000016e-02, 6.59057200000000010e-02, 7.99706800000000023e-02, 9.28629799999999977e-02, 1.02382080000000000e-01, 1.05875339999999998e-01, 1.01509489999999994e-01, 8.93185199999999985e-02, 7.01008800000000043e-02, 4.80530100000000002e-02, 2.77680499999999990e-02, 1.29611199999999996e-02, 4.52852000000000029e-03, 1.07378000000000009e-03, 1.73790000000000001e-04, 1.96499999999999999e-05, 1.50999999999999994e-06, 5.99999999999999946e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[8][14] = niz8_14;
	static double niz8_15[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 2.99999999999999973e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 2.99999999999999973e-08, 4.99999999999999977e-08, 7.00000000000000048e-08, 1.99999999999999991e-07, 1.90000000000000007e-07, 2.80000000000000019e-07, 4.59999999999999990e-07, 6.40000000000000013e-07, 7.70000000000000039e-07, 1.26000000000000001e-06, 2.16999999999999998e-06, 3.36999999999999992e-06, 4.50000000000000011e-06, 6.42000000000000037e-06, 9.27999999999999924e-06, 1.22000000000000001e-05, 1.79699999999999990e-05, 2.64000000000000013e-05, 4.07900000000000008e-05, 6.14099999999999965e-05, 9.01600000000000041e-05, 1.31700000000000003e-04, 1.85760000000000010e-04, 2.65470000000000018e-04, 3.92040000000000021e-04, 5.81519999999999975e-04, 8.58170000000000005e-04, 1.24288999999999997e-03, 1.79185000000000000e-03, 2.55550999999999999e-03, 3.66228999999999990e-03, 5.20940000000000032e-03, 7.37333999999999993e-03, 1.03001099999999995e-02, 1.42282999999999993e-02, 1.93541300000000006e-02, 2.59097299999999989e-02, 3.41289899999999979e-02, 4.40500200000000022e-02, 5.52642100000000011e-02, 6.73214099999999982e-02, 7.91068300000000030e-02, 8.94959599999999994e-02, 9.65075199999999994e-02, 9.83511299999999949e-02, 9.37922399999999989e-02, 8.25466799999999973e-02, 6.60297700000000015e-02, 4.69810599999999981e-02, 2.88617000000000005e-02, 1.48891200000000005e-02, 6.06779999999999993e-03, 1.82340999999999992e-03, 3.91110000000000014e-04, 6.17999999999999978e-05, 7.33000000000000012e-06, 9.29999999999999990e-07, 7.00000000000000048e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[8][15] = niz8_15;
	static double niz8_16[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 2.99999999999999973e-08, 2.99999999999999973e-08, 4.00000000000000008e-08, 8.99999999999999986e-08, 1.10000000000000006e-07, 8.99999999999999986e-08, 5.99999999999999946e-08, 1.60000000000000003e-07, 2.70000000000000009e-07, 4.20000000000000002e-07, 6.40000000000000013e-07, 1.06999999999999992e-06, 1.35999999999999990e-06, 1.61000000000000004e-06, 2.07999999999999999e-06, 2.84999999999999982e-06, 4.98999999999999966e-06, 6.90000000000000001e-06, 9.80999999999999925e-06, 1.43300000000000000e-05, 2.07600000000000011e-05, 2.87799999999999989e-05, 4.15399999999999987e-05, 5.63200000000000029e-05, 8.09200000000000045e-05, 1.16680000000000001e-04, 1.70470000000000013e-04, 2.44299999999999975e-04, 3.45639999999999977e-04, 4.87300000000000027e-04, 6.93460000000000018e-04, 9.80790000000000047e-04, 1.40112000000000006e-03, 1.98920000000000000e-03, 2.78870999999999980e-03, 3.87988999999999999e-03, 5.38648999999999985e-03, 7.40746000000000026e-03, 1.01221200000000001e-02, 1.37020500000000003e-02, 1.83257499999999983e-02, 2.40338200000000009e-02, 3.10956800000000005e-02, 3.94864200000000012e-02, 4.90342399999999998e-02, 5.95798700000000001e-02, 7.01635099999999984e-02, 7.99083200000000049e-02, 8.74673799999999974e-02, 9.16316900000000018e-02, 9.10865800000000003e-02, 8.49517699999999959e-02, 7.36304599999999948e-02, 5.85422400000000023e-02, 4.18747599999999970e-02, 2.62747299999999996e-02, 1.40757599999999997e-02, 6.12785999999999973e-03, 2.07455000000000009e-03, 5.25650000000000010e-04, 1.00920000000000003e-04, 1.49499999999999992e-05, 1.87000000000000010e-06, 1.99999999999999991e-07, 2.99999999999999973e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[8][16] = niz8_16;
	static double niz8_17[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 8.00000000000000017e-08, 4.99999999999999977e-08, 8.00000000000000017e-08, 1.79999999999999997e-07, 1.69999999999999987e-07, 1.79999999999999997e-07, 3.30000000000000017e-07, 3.49999999999999984e-07, 5.30000000000000008e-07, 9.79999999999999934e-07, 1.10999999999999996e-06, 1.59000000000000002e-06, 1.76999999999999999e-06, 3.59999999999999984e-06, 3.97000000000000011e-06, 5.60999999999999965e-06, 7.48000000000000038e-06, 1.08599999999999994e-05, 1.48500000000000001e-05, 2.24199999999999988e-05, 3.09200000000000021e-05, 4.49799999999999996e-05, 5.87800000000000030e-05, 8.15899999999999964e-05, 1.15749999999999995e-04, 1.63630000000000004e-04, 2.30339999999999994e-04, 3.21790000000000021e-04, 4.53879999999999984e-04, 6.30440000000000015e-04, 8.75259999999999992e-04, 1.21784999999999992e-03, 1.68472000000000001e-03, 2.32233999999999999e-03, 3.19893000000000000e-03, 4.36861000000000020e-03, 5.93035000000000003e-03, 7.98588000000000076e-03, 1.06597099999999993e-02, 1.40684399999999998e-02, 1.84274300000000016e-02, 2.37302500000000013e-02, 3.02090799999999993e-02, 3.76604099999999983e-02, 4.61812700000000034e-02, 5.53214799999999993e-02, 6.47698200000000057e-02, 7.34588600000000008e-02, 8.07303999999999938e-02, 8.52424299999999940e-02, 8.61492299999999933e-02, 8.27425499999999980e-02, 7.48654299999999967e-02, 6.30319099999999966e-02, 4.88435300000000031e-02, 3.42320799999999981e-02, 2.12443800000000002e-02, 1.13104000000000000e-02, 4.97695999999999989e-03, 1.74953000000000001e-03, 4.79089999999999995e-04, 1.01760000000000001e-04, 1.78100000000000006e-05, 3.05999999999999993e-06, 3.90000000000000025e-07, 4.99999999999999977e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[8][17] = niz8_17;
	static double niz8_18[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 4.00000000000000008e-08, 4.00000000000000008e-08, 4.00000000000000008e-08, 4.99999999999999977e-08, 8.00000000000000017e-08, 8.00000000000000017e-08, 1.69999999999999987e-07, 2.20000000000000011e-07, 3.80000000000000015e-07, 3.70000000000000004e-07, 5.40000000000000018e-07, 4.79999999999999957e-07, 7.29999999999999999e-07, 1.15000000000000000e-06, 1.59000000000000002e-06, 1.85000000000000008e-06, 2.78999999999999997e-06, 4.10999999999999961e-06, 5.66000000000000002e-06, 7.33000000000000012e-06, 1.03099999999999995e-05, 1.33499999999999992e-05, 1.77799999999999992e-05, 2.46699999999999993e-05, 3.55099999999999971e-05, 4.90300000000000032e-05, 6.74099999999999933e-05, 9.40799999999999937e-05, 1.28259999999999995e-04, 1.73780000000000007e-04, 2.35929999999999999e-04, 3.28999999999999974e-04, 4.50370000000000013e-04, 6.21539999999999961e-04, 8.48169999999999979e-04, 1.15773999999999998e-03, 1.57698999999999990e-03, 2.12051999999999987e-03, 2.85630999999999993e-03, 3.85724000000000006e-03, 5.16587000000000036e-03, 6.85042000000000029e-03, 9.02302999999999959e-03, 1.17813199999999996e-02, 1.52198699999999999e-02, 1.94914399999999988e-02, 2.46418300000000000e-02, 3.07132799999999991e-02, 3.77014899999999972e-02, 4.54812799999999989e-02, 5.36624399999999988e-02, 6.19062000000000015e-02, 6.96064299999999969e-02, 7.60026200000000068e-02, 8.01576799999999950e-02, 8.13553399999999982e-02, 7.88874799999999959e-02, 7.26630199999999948e-02, 6.31145099999999987e-02, 5.09110399999999977e-02, 3.78288000000000027e-02, 2.54195499999999991e-02, 1.51333500000000003e-02, 7.74280000000000020e-03, 3.30259000000000021e-03, 1.13525999999999992e-03, 3.16639999999999977e-04, 7.26500000000000041e-05, 1.33900000000000005e-05, 2.30000000000000000e-06, 2.89999999999999976e-07, 4.00000000000000008e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[8][18] = niz8_18;
	static double niz8_19[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.00000000000000004e-08, 0.00000000000000000e+00, 2.00000000000000004e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 7.00000000000000048e-08, 2.00000000000000004e-08, 2.99999999999999973e-08, 7.00000000000000048e-08, 4.00000000000000008e-08, 1.60000000000000003e-07, 2.49999999999999989e-07, 1.99999999999999991e-07, 1.79999999999999997e-07, 3.20000000000000007e-07, 4.99999999999999977e-07, 7.99999999999999964e-07, 6.70000000000000044e-07, 1.12000000000000008e-06, 1.61999999999999995e-06, 2.11000000000000013e-06, 2.88999999999999986e-06, 3.58000000000000003e-06, 5.02000000000000022e-06, 6.75999999999999965e-06, 9.96999999999999941e-06, 1.34500000000000000e-05, 1.79099999999999996e-05, 2.35400000000000016e-05, 3.27500000000000032e-05, 4.31899999999999981e-05, 5.79499999999999991e-05, 7.90900000000000034e-05, 1.05740000000000001e-04, 1.44310000000000006e-04, 1.96369999999999992e-04, 2.64100000000000023e-04, 3.58309999999999976e-04, 4.82180000000000022e-04, 6.45689999999999979e-04, 8.70859999999999993e-04, 1.17343000000000005e-03, 1.56342999999999998e-03, 2.08961999999999993e-03, 2.77122999999999996e-03, 3.66834999999999991e-03, 4.81745999999999997e-03, 6.28543999999999978e-03, 8.21589999999999994e-03, 1.05951199999999995e-02, 1.35650300000000005e-02, 1.71840400000000011e-02, 2.15059400000000012e-02, 2.66250999999999988e-02, 3.25269499999999989e-02, 3.91682299999999983e-02, 4.63234800000000002e-02, 5.37451300000000021e-02, 6.10340099999999997e-02, 6.76046299999999989e-02, 7.29150999999999966e-02, 7.62007199999999996e-02, 7.67806099999999991e-02, 7.43645599999999962e-02, 6.87227299999999958e-02, 6.01963299999999993e-02, 4.95280899999999968e-02, 3.78796600000000025e-02, 2.65283400000000009e-02, 1.67370800000000014e-02, 9.31288000000000081e-03, 4.44346999999999971e-03, 1.76508999999999997e-03, 5.85730000000000018e-04, 1.59089999999999996e-04, 3.73600000000000014e-05, 7.14000000000000025e-06, 1.35999999999999990e-06, 1.19999999999999989e-07, 4.99999999999999977e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[8][19] = niz8_19;
	static double niz8_20[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 4.99999999999999977e-08, 1.00000000000000002e-08, 4.99999999999999977e-08, 7.00000000000000048e-08, 1.49999999999999993e-07, 8.99999999999999986e-08, 1.49999999999999993e-07, 2.80000000000000019e-07, 3.59999999999999994e-07, 3.70000000000000004e-07, 5.30000000000000008e-07, 7.99999999999999964e-07, 8.80000000000000045e-07, 1.17000000000000002e-06, 1.79000000000000001e-06, 2.26999999999999987e-06, 3.14999999999999991e-06, 4.01999999999999963e-06, 5.43999999999999958e-06, 7.42000000000000011e-06, 9.47000000000000081e-06, 1.26399999999999993e-05, 1.68899999999999992e-05, 2.27500000000000007e-05, 3.05300000000000008e-05, 4.14599999999999995e-05, 5.41600000000000032e-05, 7.26200000000000061e-05, 9.70500000000000008e-05, 1.29330000000000010e-04, 1.74300000000000008e-04, 2.31350000000000013e-04, 3.10429999999999994e-04, 4.10019999999999981e-04, 5.43050000000000000e-04, 7.27230000000000042e-04, 9.56590000000000001e-04, 1.25903999999999990e-03, 1.67611999999999991e-03, 2.18709999999999998e-03, 2.86842999999999994e-03, 3.72880000000000000e-03, 4.84523999999999979e-03, 6.23574000000000003e-03, 7.98833000000000008e-03, 1.01618500000000000e-02, 1.28456400000000002e-02, 1.60740499999999994e-02, 1.99403400000000008e-02, 2.44390900000000001e-02, 2.96369600000000004e-02, 3.54216200000000009e-02, 4.17570199999999989e-02, 4.83981600000000026e-02, 5.51056300000000027e-02, 6.13182199999999997e-02, 6.67206000000000049e-02, 7.07183100000000064e-02, 7.27649199999999968e-02, 7.24122299999999941e-02, 6.93945200000000012e-02, 6.36160300000000040e-02, 5.55109400000000017e-02, 4.57123099999999991e-02, 3.51659299999999980e-02, 2.49912899999999993e-02, 1.61554299999999984e-02, 9.30329000000000052e-03, 4.70399999999999985e-03, 2.02673999999999997e-03, 7.37310000000000027e-04, 2.30399999999999990e-04, 6.25099999999999961e-05, 1.36200000000000000e-05, 2.61999999999999990e-06, 5.60000000000000038e-07, 8.00000000000000017e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[8][20] = niz8_20;
	static double niz8_21[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 1.00000000000000002e-08, 2.99999999999999973e-08, 2.99999999999999973e-08, 4.99999999999999977e-08, 8.99999999999999986e-08, 1.19999999999999989e-07, 1.60000000000000003e-07, 2.29999999999999995e-07, 3.30000000000000017e-07, 2.89999999999999976e-07, 3.49999999999999984e-07, 5.30000000000000008e-07, 7.89999999999999954e-07, 8.29999999999999994e-07, 1.12000000000000008e-06, 1.48999999999999992e-06, 2.00999999999999981e-06, 2.79999999999999987e-06, 3.32999999999999988e-06, 4.52999999999999983e-06, 6.29999999999999982e-06, 7.34999999999999993e-06, 1.08399999999999996e-05, 1.35700000000000005e-05, 1.83800000000000002e-05, 2.26999999999999995e-05, 3.07900000000000017e-05, 4.15100000000000007e-05, 5.50900000000000028e-05, 7.23999999999999980e-05, 9.40900000000000021e-05, 1.25610000000000012e-04, 1.63179999999999993e-04, 2.15770000000000003e-04, 2.85859999999999977e-04, 3.74440000000000027e-04, 4.95710000000000009e-04, 6.54139999999999995e-04, 8.52010000000000050e-04, 1.10858000000000007e-03, 1.43924000000000005e-03, 1.87593999999999999e-03, 2.41838999999999986e-03, 3.11480000000000003e-03, 4.00598000000000013e-03, 5.13096000000000038e-03, 6.51007999999999969e-03, 8.21921999999999930e-03, 1.03105999999999996e-02, 1.28387299999999996e-02, 1.58606399999999988e-02, 1.94455499999999989e-02, 2.36001300000000004e-02, 2.82937899999999992e-02, 3.35251800000000016e-02, 3.92693600000000032e-02, 4.52387799999999993e-02, 5.12537399999999990e-02, 5.69975900000000008e-02, 6.21688599999999994e-02, 6.61619400000000024e-02, 6.86798599999999954e-02, 6.92497700000000022e-02, 6.76398799999999994e-02, 6.36490400000000039e-02, 5.74232199999999970e-02, 4.93889799999999990e-02, 4.01690999999999993e-02, 3.06015799999999998e-02, 2.16376300000000014e-02, 1.40161200000000000e-02, 8.13876000000000009e-03, 4.17732999999999993e-03, 1.85391000000000006e-03, 7.05989999999999981e-04, 2.32460000000000007e-04, 6.66300000000000041e-05, 1.73799999999999996e-05, 4.01999999999999963e-06, 1.04000000000000000e-06, 2.49999999999999989e-07, 4.00000000000000008e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[8][21] = niz8_21;
	static double niz8_22[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 2.99999999999999973e-08, 4.00000000000000008e-08, 5.99999999999999946e-08, 8.00000000000000017e-08, 1.19999999999999989e-07, 1.10000000000000006e-07, 1.29999999999999999e-07, 2.49999999999999989e-07, 2.29999999999999995e-07, 3.59999999999999994e-07, 5.40000000000000018e-07, 6.40000000000000013e-07, 8.40000000000000004e-07, 1.23999999999999999e-06, 1.61000000000000004e-06, 1.95999999999999987e-06, 2.78999999999999997e-06, 3.30000000000000017e-06, 4.16999999999999989e-06, 4.97999999999999975e-06, 7.04000000000000036e-06, 9.24999999999999953e-06, 1.24099999999999998e-05, 1.58899999999999986e-05, 2.01299999999999987e-05, 2.77300000000000005e-05, 3.54200000000000031e-05, 4.44500000000000030e-05, 5.90200000000000007e-05, 7.47799999999999989e-05, 1.00039999999999998e-04, 1.30259999999999990e-04, 1.71139999999999991e-04, 2.23680000000000000e-04, 2.88700000000000024e-04, 3.74749999999999975e-04, 4.81490000000000000e-04, 6.22720000000000001e-04, 8.04330000000000019e-04, 1.04845999999999997e-03, 1.34084999999999998e-03, 1.72506000000000005e-03, 2.20478999999999987e-03, 2.80712000000000019e-03, 3.56169000000000017e-03, 4.50223000000000029e-03, 5.64826000000000043e-03, 7.09405000000000018e-03, 8.83165999999999986e-03, 1.09315699999999998e-02, 1.34469299999999993e-02, 1.63949699999999983e-02, 1.98120599999999994e-02, 2.37734799999999996e-02, 2.81887299999999986e-02, 3.30434500000000020e-02, 3.82984899999999975e-02, 4.37563300000000030e-02, 4.92052499999999990e-02, 5.43617600000000020e-02, 5.90501500000000026e-02, 6.27736200000000022e-02, 6.52214700000000036e-02, 6.60226399999999936e-02, 6.49987600000000026e-02, 6.18802000000000033e-02, 5.67823900000000020e-02, 5.00242499999999993e-02, 4.19774700000000028e-02, 3.33226800000000004e-02, 2.48371600000000005e-02, 1.71550099999999983e-02, 1.08693399999999999e-02, 6.20823000000000035e-03, 3.16059999999999995e-03, 1.40522999999999993e-03, 5.44540000000000041e-04, 1.84809999999999987e-04, 5.67400000000000022e-05, 1.54099999999999998e-05, 4.14000000000000017e-06, 1.01999999999999998e-06, 1.69999999999999987e-07, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[8][22] = niz8_22;
	static double niz8_23[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 4.00000000000000008e-08, 8.99999999999999986e-08, 7.00000000000000048e-08, 1.10000000000000006e-07, 1.90000000000000007e-07, 1.49999999999999993e-07, 1.69999999999999987e-07, 2.29999999999999995e-07, 4.99999999999999977e-07, 3.59999999999999994e-07, 5.50000000000000028e-07, 5.40000000000000018e-07, 8.99999999999999959e-07, 1.25000000000000010e-06, 1.74999999999999997e-06, 1.85999999999999998e-06, 2.42000000000000012e-06, 3.10999999999999987e-06, 3.67000000000000001e-06, 5.47000000000000014e-06, 6.95000000000000037e-06, 9.13000000000000068e-06, 1.13899999999999994e-05, 1.46800000000000001e-05, 1.90699999999999987e-05, 2.51099999999999985e-05, 3.19800000000000021e-05, 4.00499999999999977e-05, 5.32600000000000017e-05, 6.82899999999999984e-05, 8.62400000000000010e-05, 1.11479999999999997e-04, 1.42809999999999996e-04, 1.83870000000000013e-04, 2.35219999999999987e-04, 3.03190000000000002e-04, 3.89760000000000009e-04, 4.96800000000000041e-04, 6.33859999999999979e-04, 8.16290000000000006e-04, 1.04079999999999993e-03, 1.31744999999999996e-03, 1.67150999999999997e-03, 2.12378000000000003e-03, 2.68214999999999990e-03, 3.35001999999999999e-03, 4.19889000000000026e-03, 5.23574000000000001e-03, 6.49127000000000037e-03, 8.02715000000000026e-03, 9.83433000000000050e-03, 1.20369499999999994e-02, 1.45802499999999995e-02, 1.75160200000000002e-02, 2.09090600000000001e-02, 2.47198399999999999e-02, 2.89656400000000008e-02, 3.35957699999999970e-02, 3.84533700000000006e-02, 4.34629500000000002e-02, 4.84189900000000020e-02, 5.30878600000000006e-02, 5.71725699999999989e-02, 6.04605100000000020e-02, 6.24824900000000016e-02, 6.31124799999999986e-02, 6.20258799999999985e-02, 5.92265000000000014e-02, 5.46969200000000030e-02, 4.86574300000000015e-02, 4.14756400000000011e-02, 3.35953199999999980e-02, 2.57993600000000003e-02, 1.85214999999999998e-02, 1.23291700000000004e-02, 7.51209999999999985e-03, 4.12678000000000003e-03, 2.01444000000000015e-03, 8.76110000000000040e-04, 3.30139999999999980e-04, 1.14000000000000006e-04, 3.53300000000000022e-05, 9.30000000000000074e-06, 2.62999999999999981e-06, 6.09999999999999983e-07, 1.10000000000000006e-07, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[8][23] = niz8_23;
	static double niz8_24[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 2.99999999999999973e-08, 1.00000000000000002e-08, 2.99999999999999973e-08, 2.99999999999999973e-08, 4.99999999999999977e-08, 1.29999999999999999e-07, 1.10000000000000006e-07, 7.00000000000000048e-08, 1.60000000000000003e-07, 1.29999999999999999e-07, 2.20000000000000011e-07, 3.39999999999999974e-07, 3.49999999999999984e-07, 4.49999999999999980e-07, 5.70000000000000048e-07, 9.29999999999999990e-07, 1.01999999999999998e-06, 1.03000000000000009e-06, 1.59000000000000002e-06, 1.91999999999999983e-06, 2.52000000000000001e-06, 3.27999999999999994e-06, 3.89999999999999993e-06, 5.38000000000000016e-06, 6.83999999999999973e-06, 8.80000000000000045e-06, 1.16000000000000007e-05, 1.33499999999999992e-05, 1.77799999999999992e-05, 2.33499999999999984e-05, 2.99600000000000011e-05, 3.82900000000000010e-05, 4.80500000000000024e-05, 6.11600000000000040e-05, 8.06499999999999952e-05, 1.00710000000000003e-04, 1.25429999999999997e-04, 1.61149999999999987e-04, 2.06090000000000000e-04, 2.63820000000000005e-04, 3.34460000000000020e-04, 4.26900000000000023e-04, 5.35329999999999986e-04, 6.81089999999999972e-04, 8.59109999999999952e-04, 1.07962000000000010e-03, 1.36163999999999990e-03, 1.70676000000000009e-03, 2.13982000000000018e-03, 2.67724999999999994e-03, 3.33471999999999979e-03, 4.14487000000000015e-03, 5.10679999999999988e-03, 6.26852999999999959e-03, 7.68584000000000021e-03, 9.33842000000000005e-03, 1.12920000000000000e-02, 1.36369600000000001e-02, 1.62777700000000004e-02, 1.93091100000000009e-02, 2.27233800000000014e-02, 2.65327700000000007e-02, 3.06078899999999987e-02, 3.50311199999999989e-02, 3.95426399999999970e-02, 4.41321500000000019e-02, 4.85430000000000028e-02, 5.26311900000000013e-02, 5.60578099999999996e-02, 5.87145199999999992e-02, 6.02002800000000018e-02, 6.02800000000000002e-02, 5.89828199999999983e-02, 5.60491700000000023e-02, 5.15937799999999988e-02, 4.59297999999999998e-02, 3.92825899999999992e-02, 3.20634399999999986e-02, 2.48368399999999989e-02, 1.81491699999999992e-02, 1.23791700000000001e-02, 7.78720000000000020e-03, 4.46538999999999964e-03, 2.31625000000000017e-03, 1.06836999999999991e-03, 4.39849999999999985e-04, 1.62060000000000004e-04, 5.47900000000000023e-05, 1.71800000000000015e-05, 5.06999999999999974e-06, 1.37000000000000001e-06, 4.40000000000000022e-07, 1.49999999999999993e-07, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[8][24] = niz8_24;
	static double niz8_25[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 4.99999999999999977e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.99999999999999973e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 1.00000000000000002e-08, 4.00000000000000008e-08, 4.99999999999999977e-08, 1.10000000000000006e-07, 8.00000000000000017e-08, 1.40000000000000010e-07, 1.10000000000000006e-07, 1.19999999999999989e-07, 1.90000000000000007e-07, 2.99999999999999986e-07, 3.49999999999999984e-07, 5.30000000000000008e-07, 6.50000000000000024e-07, 5.50000000000000028e-07, 7.40000000000000009e-07, 1.08000000000000004e-06, 1.46000000000000000e-06, 1.77999999999999990e-06, 2.43999999999999993e-06, 3.05000000000000002e-06, 3.62999999999999997e-06, 4.03000000000000038e-06, 5.30999999999999998e-06, 7.25000000000000004e-06, 9.00000000000000023e-06, 1.22899999999999992e-05, 1.47800000000000008e-05, 1.89699999999999996e-05, 2.36400000000000007e-05, 2.98999999999999983e-05, 3.65799999999999987e-05, 4.76499999999999995e-05, 5.98800000000000027e-05, 7.66899999999999993e-05, 9.64099999999999934e-05, 1.20780000000000006e-04, 1.55210000000000000e-04, 1.93050000000000003e-04, 2.45780000000000022e-04, 3.06420000000000011e-04, 3.86009999999999999e-04, 4.83360000000000007e-04, 6.10630000000000027e-04, 7.65520000000000003e-04, 9.52550000000000033e-04, 1.19030999999999998e-03, 1.48014999999999996e-03, 1.84318000000000004e-03, 2.27648999999999994e-03, 2.81036999999999997e-03, 3.46343999999999992e-03, 4.25749000000000006e-03, 5.20997000000000040e-03, 6.35152000000000026e-03, 7.69979999999999970e-03, 9.29076000000000034e-03, 1.11403100000000005e-02, 1.33027800000000002e-02, 1.57985999999999994e-02, 1.86150300000000012e-02, 2.17425299999999995e-02, 2.52079299999999999e-02, 2.90152600000000011e-02, 3.30019299999999988e-02, 3.71481199999999998e-02, 4.13789999999999991e-02, 4.54919400000000015e-02, 4.94001700000000002e-02, 5.27068499999999995e-02, 5.54115199999999988e-02, 5.72115399999999982e-02, 5.79264400000000027e-02, 5.73574700000000007e-02, 5.54931199999999999e-02, 5.21565500000000029e-02, 4.76424400000000012e-02, 4.20264100000000002e-02, 3.57011399999999993e-02, 2.90490600000000015e-02, 2.24963000000000003e-02, 1.64199800000000007e-02, 1.12563300000000002e-02, 7.16504000000000012e-03, 4.17005999999999974e-03, 2.20996999999999990e-03, 1.06163999999999998e-03, 4.65299999999999980e-04, 1.83269999999999999e-04, 6.32600000000000008e-05, 2.09700000000000008e-05, 6.30999999999999973e-06, 1.95999999999999987e-06, 5.50000000000000028e-07, 1.19999999999999989e-07, 2.00000000000000004e-08, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[8][25] = niz8_25;
	static double niz8_26[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 2.00000000000000004e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 2.00000000000000004e-08, 2.00000000000000004e-08, 8.99999999999999986e-08, 2.99999999999999973e-08, 8.00000000000000017e-08, 2.99999999999999973e-08, 8.99999999999999986e-08, 1.40000000000000010e-07, 1.49999999999999993e-07, 2.59999999999999999e-07, 3.30000000000000017e-07, 3.39999999999999974e-07, 5.70000000000000048e-07, 6.19999999999999993e-07, 6.19999999999999993e-07, 6.99999999999999968e-07, 8.89999999999999949e-07, 1.12999999999999998e-06, 1.61000000000000004e-06, 2.38000000000000008e-06, 2.77000000000000016e-06, 2.96999999999999994e-06, 3.95000000000000030e-06, 5.06999999999999974e-06, 6.53000000000000016e-06, 7.98999999999999973e-06, 1.02600000000000000e-05, 1.26800000000000006e-05, 1.60700000000000003e-05, 1.97800000000000004e-05, 2.44500000000000014e-05, 3.23699999999999967e-05, 4.01899999999999998e-05, 4.91299999999999989e-05, 6.09999999999999987e-05, 7.73900000000000027e-05, 9.93099999999999962e-05, 1.21499999999999999e-04, 1.52680000000000009e-04, 1.93539999999999994e-04, 2.39890000000000009e-04, 2.96409999999999989e-04, 3.73220000000000008e-04, 4.64170000000000023e-04, 5.81820000000000037e-04, 7.25350000000000040e-04, 8.86240000000000053e-04, 1.10873000000000005e-03, 1.36677000000000001e-03, 1.68516999999999994e-03, 2.07030000000000018e-03, 2.54309000000000002e-03, 3.10350999999999986e-03, 3.78205999999999985e-03, 4.60731999999999982e-03, 5.58123000000000039e-03, 6.72635999999999980e-03, 8.06760999999999937e-03, 9.64668999999999943e-03, 1.14716999999999996e-02, 1.35630100000000003e-02, 1.59321099999999993e-02, 1.86038200000000001e-02, 2.15730899999999996e-02, 2.47988300000000009e-02, 2.83419300000000013e-02, 3.20425199999999979e-02, 3.59090099999999982e-02, 3.97596399999999989e-02, 4.35421000000000002e-02, 4.70629300000000028e-02, 5.03183300000000014e-02, 5.28500000000000011e-02, 5.46878900000000029e-02, 5.55469300000000013e-02, 5.53519300000000006e-02, 5.39534899999999998e-02, 5.13512699999999975e-02, 4.75412100000000004e-02, 4.27796699999999988e-02, 3.72163599999999969e-02, 3.11719300000000005e-02, 2.49869300000000009e-02, 1.90788799999999995e-02, 1.37843700000000007e-02, 9.34438999999999929e-03, 5.88962999999999987e-03, 3.41303000000000006e-03, 1.81834000000000010e-03, 8.82879999999999950e-04, 3.82850000000000009e-04, 1.55720000000000007e-04, 5.82700000000000028e-05, 2.00800000000000009e-05, 6.38999999999999981e-06, 1.88000000000000000e-06, 5.99999999999999973e-07, 1.69999999999999987e-07, 8.00000000000000017e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[8][26] = niz8_26;
	static double niz8_27[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 4.00000000000000008e-08, 2.99999999999999973e-08, 2.99999999999999973e-08, 1.10000000000000006e-07, 4.99999999999999977e-08, 4.99999999999999977e-08, 1.29999999999999999e-07, 1.60000000000000003e-07, 1.60000000000000003e-07, 1.49999999999999993e-07, 2.20000000000000011e-07, 2.20000000000000011e-07, 4.20000000000000002e-07, 3.99999999999999982e-07, 4.49999999999999980e-07, 7.70000000000000039e-07, 9.29999999999999990e-07, 1.10999999999999996e-06, 1.30999999999999995e-06, 1.48999999999999992e-06, 2.26999999999999987e-06, 2.53999999999999982e-06, 2.82000000000000011e-06, 4.19999999999999960e-06, 5.02000000000000022e-06, 6.11999999999999985e-06, 7.77000000000000015e-06, 9.36000000000000017e-06, 1.19900000000000004e-05, 1.44900000000000002e-05, 1.82699999999999996e-05, 2.28100000000000001e-05, 2.79700000000000016e-05, 3.52800000000000010e-05, 4.35100000000000019e-05, 5.32799999999999981e-05, 6.65199999999999933e-05, 8.43500000000000039e-05, 1.03640000000000004e-04, 1.28240000000000005e-04, 1.59450000000000000e-04, 1.96839999999999992e-04, 2.47260000000000014e-04, 3.05180000000000002e-04, 3.75879999999999986e-04, 4.68409999999999996e-04, 5.76229999999999950e-04, 7.15119999999999970e-04, 8.77909999999999975e-04, 1.06923999999999995e-03, 1.31122000000000009e-03, 1.61115000000000000e-03, 1.97018000000000020e-03, 2.38917999999999986e-03, 2.91304999999999993e-03, 3.52749999999999982e-03, 4.25685000000000039e-03, 5.11732999999999980e-03, 6.13209999999999970e-03, 7.32115000000000023e-03, 8.72690999999999918e-03, 1.03265500000000003e-02, 1.21664800000000003e-02, 1.42374500000000005e-02, 1.65935899999999983e-02, 1.91878200000000013e-02, 2.20574899999999990e-02, 2.51620799999999999e-02, 2.84648499999999999e-02, 3.19378800000000018e-02, 3.55664600000000011e-02, 3.91634000000000010e-02, 4.26597199999999982e-02, 4.58662300000000009e-02, 4.87611699999999995e-02, 5.10834299999999991e-02, 5.27039899999999992e-02, 5.34949099999999997e-02, 5.33186000000000007e-02, 5.20192699999999994e-02, 4.97201999999999991e-02, 4.63427000000000006e-02, 4.20272400000000004e-02, 3.69802099999999995e-02, 3.14529600000000020e-02, 2.57734600000000015e-02, 2.01728699999999990e-02, 1.50578499999999994e-02, 1.06224400000000004e-02, 7.01695000000000010e-03, 4.32593000000000040e-03, 2.46246000000000008e-03, 1.28599000000000009e-03, 6.18559999999999987e-04, 2.68679999999999982e-04, 1.09829999999999997e-04, 4.18299999999999976e-05, 1.44400000000000007e-05, 5.00000000000000041e-06, 1.48000000000000002e-06, 4.99999999999999977e-07, 1.49999999999999993e-07, 2.99999999999999973e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[8][27] = niz8_27;
	static double niz8_28[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 2.00000000000000004e-08, 0.00000000000000000e+00, 2.00000000000000004e-08, 0.00000000000000000e+00, 2.99999999999999973e-08, 2.00000000000000004e-08, 8.00000000000000017e-08, 1.00000000000000002e-08, 5.99999999999999946e-08, 7.00000000000000048e-08, 2.00000000000000004e-08, 4.00000000000000008e-08, 1.10000000000000006e-07, 1.10000000000000006e-07, 8.00000000000000017e-08, 2.29999999999999995e-07, 1.60000000000000003e-07, 1.40000000000000010e-07, 2.89999999999999976e-07, 3.99999999999999982e-07, 3.30000000000000017e-07, 4.30000000000000012e-07, 5.79999999999999953e-07, 7.80000000000000049e-07, 9.90000000000000050e-07, 1.19999999999999995e-06, 1.45000000000000009e-06, 1.77999999999999990e-06, 2.31999999999999981e-06, 2.95000000000000013e-06, 3.77999999999999981e-06, 4.25999999999999987e-06, 5.62000000000000040e-06, 6.12999999999999975e-06, 7.65999999999999951e-06, 9.22999999999999972e-06, 1.14200000000000008e-05, 1.42600000000000007e-05, 1.77500000000000012e-05, 2.17300000000000003e-05, 2.73799999999999987e-05, 3.30999999999999982e-05, 4.08400000000000020e-05, 5.15399999999999978e-05, 6.34900000000000037e-05, 7.71800000000000031e-05, 9.56800000000000055e-05, 1.17980000000000005e-04, 1.43850000000000000e-04, 1.78209999999999990e-04, 2.18800000000000006e-04, 2.70789999999999974e-04, 3.33130000000000004e-04, 4.06849999999999996e-04, 4.93990000000000032e-04, 6.06169999999999951e-04, 7.41640000000000008e-04, 9.07119999999999975e-04, 1.10128000000000005e-03, 1.33814000000000003e-03, 1.62545000000000007e-03, 1.97303000000000018e-03, 2.37732999999999998e-03, 2.86185999999999992e-03, 3.44925000000000006e-03, 4.14038999999999987e-03, 4.94256000000000036e-03, 5.89079999999999986e-03, 6.98085000000000025e-03, 8.25977999999999955e-03, 9.70475999999999978e-03, 1.13712299999999995e-02, 1.32752800000000004e-02, 1.53645599999999993e-02, 1.77356400000000004e-02, 2.03345499999999998e-02, 2.31228300000000005e-02, 2.61429000000000002e-02, 2.93408999999999996e-02, 3.26067899999999966e-02, 3.59763000000000027e-02, 3.92583099999999977e-02, 4.24126599999999979e-02, 4.52422700000000011e-02, 4.77369500000000002e-02, 4.97334600000000002e-02, 5.10792799999999977e-02, 5.15345899999999982e-02, 5.11686400000000013e-02, 4.98574999999999990e-02, 4.75542200000000012e-02, 4.43547899999999981e-02, 4.02639799999999978e-02, 3.55864700000000020e-02, 3.04403999999999994e-02, 2.51200199999999998e-02, 1.99339800000000004e-02, 1.51152700000000001e-02, 1.08924499999999997e-02, 7.39505000000000023e-03, 4.71238000000000039e-03, 2.81634000000000008e-03, 1.54121000000000011e-03, 7.81020000000000000e-04, 3.66950000000000002e-04, 1.59710000000000001e-04, 6.44600000000000029e-05, 2.41199999999999995e-05, 8.33999999999999977e-06, 3.14999999999999991e-06, 8.89999999999999949e-07, 2.29999999999999995e-07, 8.00000000000000017e-08, 1.00000000000000002e-08, 2.99999999999999973e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[8][28] = niz8_28;
	static double niz8_29[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 2.00000000000000004e-08, 4.99999999999999977e-08, 2.99999999999999973e-08, 4.00000000000000008e-08, 4.99999999999999977e-08, 4.99999999999999977e-08, 1.19999999999999989e-07, 1.29999999999999999e-07, 1.40000000000000010e-07, 1.49999999999999993e-07, 1.49999999999999993e-07, 2.80000000000000019e-07, 3.30000000000000017e-07, 3.80000000000000015e-07, 3.90000000000000025e-07, 4.49999999999999980e-07, 6.19999999999999993e-07, 6.19999999999999993e-07, 7.89999999999999954e-07, 1.30000000000000005e-06, 1.43999999999999998e-06, 1.34999999999999999e-06, 1.81999999999999994e-06, 2.44999999999999984e-06, 2.70999999999999989e-06, 3.09000000000000006e-06, 4.61999999999999981e-06, 5.54000000000000032e-06, 6.37000000000000000e-06, 7.79999999999999986e-06, 9.53000000000000024e-06, 1.10600000000000008e-05, 1.43200000000000001e-05, 1.69999999999999999e-05, 2.08000000000000008e-05, 2.70800000000000016e-05, 3.10599999999999974e-05, 3.95600000000000007e-05, 4.84499999999999986e-05, 5.87700000000000014e-05, 7.19700000000000038e-05, 9.03700000000000038e-05, 1.07919999999999997e-04, 1.30700000000000006e-04, 1.63940000000000006e-04, 1.97400000000000001e-04, 2.45139999999999974e-04, 2.99659999999999987e-04, 3.61480000000000015e-04, 4.42239999999999994e-04, 5.37739999999999984e-04, 6.54729999999999960e-04, 7.90090000000000020e-04, 9.62460000000000052e-04, 1.16474999999999999e-03, 1.40916000000000001e-03, 1.68585999999999996e-03, 2.04167000000000020e-03, 2.45503999999999991e-03, 2.93529000000000012e-03, 3.48949000000000004e-03, 4.17078999999999974e-03, 4.94985000000000043e-03, 5.85543000000000001e-03, 6.92869000000000037e-03, 8.12485999999999937e-03, 9.50204999999999973e-03, 1.10734300000000004e-02, 1.28359700000000004e-02, 1.47881000000000002e-02, 1.69531399999999985e-02, 1.93915799999999985e-02, 2.19594200000000003e-02, 2.47635699999999986e-02, 2.77042600000000014e-02, 3.07454500000000006e-02, 3.38370699999999969e-02, 3.69051999999999991e-02, 3.99240900000000024e-02, 4.26938600000000001e-02, 4.51977100000000021e-02, 4.72713099999999969e-02, 4.87612399999999974e-02, 4.95766299999999965e-02, 4.96753899999999998e-02, 4.89489400000000033e-02, 4.72917900000000002e-02, 4.48777500000000010e-02, 4.16196900000000009e-02, 3.76544399999999974e-02, 3.31828799999999979e-02, 2.83657200000000005e-02, 2.33766800000000004e-02, 1.86165200000000010e-02, 1.41637699999999991e-02, 1.03033299999999994e-02, 7.05865999999999959e-03, 4.56376000000000004e-03, 2.75630000000000016e-03, 1.55831999999999997e-03, 8.14959999999999990e-04, 3.97979999999999981e-04, 1.78369999999999988e-04, 7.57400000000000033e-05, 2.97000000000000002e-05, 1.08299999999999996e-05, 4.39000000000000032e-06, 1.57000000000000000e-06, 5.60000000000000038e-07, 1.10000000000000006e-07, 4.00000000000000008e-08, 4.00000000000000008e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[8][29] = niz8_29;
	static double niz8_30[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 2.99999999999999973e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 0.00000000000000000e+00, 4.00000000000000008e-08, 2.00000000000000004e-08, 8.99999999999999986e-08, 4.99999999999999977e-08, 5.99999999999999946e-08, 4.00000000000000008e-08, 1.19999999999999989e-07, 7.00000000000000048e-08, 1.40000000000000010e-07, 2.70000000000000009e-07, 1.90000000000000007e-07, 2.20000000000000011e-07, 3.70000000000000004e-07, 3.59999999999999994e-07, 4.09999999999999992e-07, 4.59999999999999990e-07, 5.50000000000000028e-07, 7.29999999999999999e-07, 9.50000000000000010e-07, 1.17000000000000002e-06, 1.35999999999999990e-06, 1.59999999999999993e-06, 1.79999999999999992e-06, 2.12000000000000003e-06, 2.60000000000000009e-06, 3.02999999999999979e-06, 3.80999999999999994e-06, 5.03000000000000012e-06, 5.39000000000000006e-06, 7.22000000000000033e-06, 8.67999999999999990e-06, 1.00900000000000000e-05, 1.18999999999999996e-05, 1.49399999999999993e-05, 1.79400000000000010e-05, 2.24199999999999988e-05, 2.79700000000000016e-05, 3.33800000000000023e-05, 3.92899999999999982e-05, 4.92700000000000009e-05, 6.03000000000000020e-05, 7.16300000000000037e-05, 8.90999999999999973e-05, 1.09420000000000006e-04, 1.30970000000000001e-04, 1.56749999999999988e-04, 1.91620000000000012e-04, 2.35739999999999989e-04, 2.83949999999999990e-04, 3.46080000000000020e-04, 4.17529999999999995e-04, 5.05270000000000046e-04, 6.10740000000000024e-04, 7.37189999999999981e-04, 8.90089999999999957e-04, 1.06733999999999996e-03, 1.28655999999999996e-03, 1.55040999999999990e-03, 1.84365000000000006e-03, 2.20052000000000008e-03, 2.62302000000000021e-03, 3.12380999999999987e-03, 3.69666999999999999e-03, 4.36582000000000029e-03, 5.15350000000000009e-03, 6.02017999999999998e-03, 7.07641999999999993e-03, 8.24598999999999992e-03, 9.60032000000000073e-03, 1.11072800000000006e-02, 1.28041300000000004e-02, 1.46858700000000002e-02, 1.67619100000000014e-02, 1.90344799999999995e-02, 2.14644899999999993e-02, 2.40984799999999985e-02, 2.68200599999999997e-02, 2.96470900000000009e-02, 3.25549700000000025e-02, 3.54356200000000010e-02, 3.82686900000000010e-02, 4.09031499999999992e-02, 4.33093000000000020e-02, 4.52651800000000021e-02, 4.68017699999999995e-02, 4.77816500000000019e-02, 4.81162799999999974e-02, 4.76772000000000029e-02, 4.65081700000000015e-02, 4.45015699999999972e-02, 4.17609599999999997e-02, 3.83151700000000026e-02, 3.43204000000000009e-02, 2.99094599999999988e-02, 2.53718300000000015e-02, 2.07741000000000002e-02, 1.64074500000000005e-02, 1.24053600000000007e-02, 8.97267000000000030e-03, 6.13879999999999981e-03, 3.96236999999999978e-03, 2.41392999999999990e-03, 1.36841000000000003e-03, 7.22980000000000020e-04, 3.54719999999999992e-04, 1.64969999999999988e-04, 7.30299999999999970e-05, 3.04500000000000015e-05, 1.21900000000000002e-05, 4.23000000000000016e-06, 1.59000000000000002e-06, 5.60000000000000038e-07, 1.69999999999999987e-07, 4.00000000000000008e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[8][30] = niz8_30;
	
	static double niz9_1[] = { 1.00000000000000000e+00 }; repRatios[9][1] = niz9_1;
	static double niz9_2[] = { 2.09871019999999991e-01, 7.90128979999999981e-01 }; repRatios[9][2] = niz9_2;
	static double niz9_3[] = { 2.45338699999999993e-02, 5.85434000000000024e-02, 4.38963290000000006e-01, 4.77959440000000013e-01 }; repRatios[9][3] = niz9_3;
	static double niz9_4[] = { 2.74250000000000015e-03, 1.44695999999999996e-03, 2.38531800000000016e-02, 8.14287999999999956e-02, 2.17793519999999990e-01, 4.60289300000000012e-01, 2.12445739999999994e-01 }; repRatios[9][4] = niz9_4;
	static double niz9_5[] = { 3.03209999999999992e-04, 2.95699999999999998e-05, 7.10470000000000047e-04, 3.89114999999999990e-03, 1.29450699999999995e-02, 2.18193399999999996e-02, 9.73455800000000010e-02, 1.80006290000000013e-01, 3.28859889999999988e-01, 2.88534510000000022e-01, 6.55549200000000026e-02 }; repRatios[9][5] = niz9_5;
	static double niz9_6[] = { 3.31899999999999990e-05, 6.50000000000000024e-07, 1.74799999999999987e-05, 1.41060000000000008e-04, 6.73219999999999982e-04, 1.04893999999999994e-03, 2.63087999999999994e-03, 7.28459999999999958e-03, 2.16043300000000014e-02, 4.31446700000000030e-02, 9.53808599999999979e-02, 1.90706039999999993e-01, 2.56151830000000025e-01, 2.58860839999999981e-01, 1.09349409999999994e-01, 1.29719999999999992e-02 }; repRatios[9][6] = niz9_6;
	static double niz9_7[] = { 3.79000000000000014e-06, 2.00000000000000004e-08, 3.80000000000000015e-07, 3.86000000000000031e-06, 2.77700000000000001e-05, 7.93000000000000031e-05, 1.60519999999999988e-04, 7.65899999999999968e-05, 6.39950000000000024e-04, 1.62531000000000004e-03, 3.51556000000000004e-03, 6.15850999999999985e-03, 1.59101399999999997e-02, 3.38243199999999980e-02, 6.53853900000000016e-02, 1.14127690000000004e-01, 1.87350480000000014e-01, 2.29042450000000009e-01, 2.06911060000000008e-01, 1.10180059999999996e-01, 2.35338200000000004e-02, 1.44303000000000009e-03 }; repRatios[9][7] = niz9_7;
	static double niz9_8[] = { 4.99999999999999977e-07, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.29999999999999999e-07, 7.99999999999999964e-07, 3.32999999999999988e-06, 1.17499999999999993e-05, 1.23100000000000007e-05, 1.28500000000000006e-05, 2.95699999999999998e-05, 1.23830000000000012e-04, 2.43269999999999993e-04, 5.29210000000000010e-04, 7.25810000000000019e-04, 1.67348999999999992e-03, 4.26827000000000022e-03, 8.06395000000000028e-03, 1.44514799999999992e-02, 2.87141199999999992e-02, 5.36826300000000020e-02, 9.02017999999999986e-02, 1.35195950000000009e-01, 1.85394239999999988e-01, 2.00879690000000000e-01, 1.62255459999999990e-01, 8.71957000000000010e-02, 2.37774899999999983e-02, 2.48246000000000014e-03, 6.99000000000000050e-05 }; repRatios[9][8] = niz9_8;
	static double niz9_9[] = { 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.99999999999999973e-08, 1.29999999999999999e-07, 6.60000000000000034e-07, 1.39000000000000003e-06, 1.57999999999999991e-06, 3.09999999999999997e-07, 3.02999999999999979e-06, 5.31999999999999989e-06, 2.40200000000000004e-05, 3.55900000000000031e-05, 5.73599999999999997e-05, 8.42000000000000002e-05, 1.78450000000000001e-04, 3.90470000000000021e-04, 8.24929999999999978e-04, 1.42076000000000008e-03, 2.52720999999999979e-03, 4.65067999999999992e-03, 9.56084999999999921e-03, 1.70146200000000011e-02, 2.85172599999999991e-02, 4.85409300000000030e-02, 7.90556699999999946e-02, 1.15270510000000007e-01, 1.51772989999999997e-01, 1.75666440000000007e-01, 1.66860669999999989e-01, 1.18913619999999998e-01, 5.93777500000000000e-02, 1.69698000000000002e-02, 2.17774000000000006e-03, 9.41999999999999993e-05, 7.99999999999999964e-07 }; repRatios[9][9] = niz9_9;
	static double niz9_10[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.99999999999999973e-08, 7.00000000000000048e-08, 1.79999999999999997e-07, 1.29999999999999999e-07, 1.19999999999999989e-07, 4.00000000000000008e-08, 6.79999999999999948e-07, 1.06999999999999992e-06, 3.22000000000000009e-06, 5.36000000000000035e-06, 6.81000000000000002e-06, 7.43000000000000001e-06, 1.58800000000000004e-05, 3.63000000000000014e-05, 7.96499999999999980e-05, 1.33570000000000010e-04, 2.01110000000000004e-04, 3.45299999999999991e-04, 6.70310000000000025e-04, 1.24741000000000001e-03, 2.28678999999999992e-03, 3.85124000000000013e-03, 6.59089000000000029e-03, 1.14253099999999993e-02, 1.97679699999999993e-02, 3.22901300000000002e-02, 4.96451200000000009e-02, 7.47953400000000018e-02, 1.05376689999999995e-01, 1.35592889999999994e-01, 1.54048590000000013e-01, 1.53957719999999992e-01, 1.25157860000000010e-01, 7.78887399999999980e-02, 3.42048100000000022e-02, 9.13191999999999997e-03, 1.17808999999999991e-03, 5.46899999999999998e-05, 5.40000000000000018e-07, 0.00000000000000000e+00 }; repRatios[9][10] = niz9_10;
	static double niz9_11[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 2.00000000000000004e-08, 1.00000000000000002e-08, 1.40000000000000010e-07, 2.70000000000000009e-07, 4.70000000000000000e-07, 5.79999999999999953e-07, 8.40000000000000004e-07, 6.70000000000000044e-07, 1.21000000000000006e-06, 3.59999999999999984e-06, 7.33000000000000012e-06, 1.36000000000000002e-05, 2.08699999999999984e-05, 2.80799999999999988e-05, 4.19300000000000000e-05, 7.70599999999999974e-05, 1.52160000000000007e-04, 2.68390000000000024e-04, 4.40340000000000002e-04, 6.94630000000000009e-04, 1.17281999999999998e-03, 2.03566999999999984e-03, 3.53434999999999990e-03, 5.83544999999999984e-03, 9.40487999999999914e-03, 1.50127999999999998e-02, 2.40403899999999983e-02, 3.70377500000000012e-02, 5.46134200000000028e-02, 7.63520699999999941e-02, 1.01770719999999995e-01, 1.25955829999999991e-01, 1.40406470000000005e-01, 1.38958909999999991e-01, 1.17788560000000000e-01, 8.16155100000000022e-02, 4.28026000000000031e-02, 1.59037900000000010e-02, 3.58977999999999988e-03, 3.99739999999999991e-04, 1.61099999999999999e-05, 1.69999999999999987e-07, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[9][11] = niz9_11;
	static double niz9_12[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 1.00000000000000002e-08, 2.99999999999999973e-08, 2.99999999999999973e-08, 1.10000000000000006e-07, 9.99999999999999955e-08, 5.99999999999999946e-08, 5.99999999999999946e-08, 4.99999999999999977e-08, 1.99999999999999991e-07, 6.60000000000000034e-07, 1.19000000000000004e-06, 1.98000000000000010e-06, 2.59000000000000019e-06, 3.01999999999999988e-06, 4.70999999999999980e-06, 8.82000000000000026e-06, 1.68699999999999994e-05, 3.05599999999999988e-05, 4.64800000000000022e-05, 7.17600000000000041e-05, 1.09190000000000003e-04, 1.77159999999999991e-04, 3.02420000000000022e-04, 5.25639999999999961e-04, 8.45420000000000047e-04, 1.33029000000000003e-03, 2.11555999999999984e-03, 3.43355000000000006e-03, 5.54841000000000015e-03, 8.77759999999999999e-03, 1.35766199999999993e-02, 2.03932200000000001e-02, 3.03843399999999993e-02, 4.41549600000000000e-02, 6.14101499999999967e-02, 8.15229600000000054e-02, 1.02135119999999996e-01, 1.20226410000000006e-01, 1.29389389999999993e-01, 1.24952480000000005e-01, 1.05298470000000005e-01, 7.52113600000000049e-02, 4.30496599999999965e-02, 1.84554900000000015e-02, 5.45083000000000026e-03, 9.54960000000000032e-04, 7.61800000000000058e-05, 2.78000000000000006e-06, 7.00000000000000048e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[9][12] = niz9_12;
	static double niz9_13[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.99999999999999973e-08, 8.00000000000000017e-08, 8.00000000000000017e-08, 2.29999999999999995e-07, 3.99999999999999982e-07, 3.39999999999999974e-07, 3.20000000000000007e-07, 5.50000000000000028e-07, 8.50000000000000014e-07, 1.95999999999999987e-06, 3.27000000000000003e-06, 5.20000000000000019e-06, 7.65999999999999951e-06, 1.04899999999999995e-05, 1.58299999999999992e-05, 2.52799999999999985e-05, 4.18799999999999988e-05, 6.76699999999999942e-05, 1.09170000000000000e-04, 1.66720000000000003e-04, 2.55589999999999984e-04, 3.91559999999999998e-04, 6.22770000000000029e-04, 1.00347000000000001e-03, 1.59731999999999995e-03, 2.46668000000000017e-03, 3.72287000000000009e-03, 5.73279999999999970e-03, 8.74868000000000000e-03, 1.31461500000000005e-02, 1.93923400000000010e-02, 2.78048699999999989e-02, 3.89603300000000013e-02, 5.31832799999999994e-02, 7.00170799999999954e-02, 8.77282300000000043e-02, 1.04030029999999996e-01, 1.15730710000000001e-01, 1.18741899999999997e-01, 1.10382960000000002e-01, 9.05146500000000021e-02, 6.40480499999999953e-02, 3.73228800000000027e-02, 1.70370000000000001e-02, 5.58849999999999972e-03, 1.21969000000000005e-03, 1.42239999999999993e-04, 8.90999999999999940e-06, 4.30000000000000012e-07, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[9][13] = niz9_13;
	static double niz9_14[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 0.00000000000000000e+00, 2.99999999999999973e-08, 1.00000000000000002e-08, 4.99999999999999977e-08, 2.00000000000000004e-08, 7.00000000000000048e-08, 7.00000000000000048e-08, 5.99999999999999946e-08, 1.69999999999999987e-07, 4.09999999999999992e-07, 6.99999999999999968e-07, 8.60000000000000025e-07, 1.21999999999999997e-06, 1.34999999999999999e-06, 2.21999999999999992e-06, 3.14000000000000001e-06, 5.25999999999999961e-06, 9.16000000000000039e-06, 1.32799999999999999e-05, 1.95599999999999991e-05, 2.92099999999999999e-05, 4.19000000000000020e-05, 6.43000000000000044e-05, 1.01810000000000003e-04, 1.62039999999999987e-04, 2.49009999999999976e-04, 3.70029999999999979e-04, 5.57300000000000048e-04, 8.47650000000000031e-04, 1.27739999999999993e-03, 1.94735000000000004e-03, 2.95594000000000022e-03, 4.41395999999999976e-03, 6.44961999999999966e-03, 9.44449999999999977e-03, 1.37157200000000007e-02, 1.96087599999999994e-02, 2.73867700000000013e-02, 3.73329099999999969e-02, 4.95791100000000026e-02, 6.38139900000000010e-02, 7.90706000000000048e-02, 9.37076000000000020e-02, 1.04793470000000000e-01, 1.09862680000000004e-01, 1.06661989999999998e-01, 9.41184999999999938e-02, 7.37745499999999943e-02, 5.02567400000000011e-02, 2.86602799999999998e-02, 1.30627299999999998e-02, 4.42671000000000037e-03, 1.03617000000000010e-03, 1.47440000000000011e-04, 1.28099999999999993e-05, 7.89999999999999954e-07, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[9][14] = niz9_14;
	static double niz9_15[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 2.99999999999999973e-08, 2.99999999999999973e-08, 2.00000000000000004e-08, 8.99999999999999986e-08, 1.19999999999999989e-07, 1.19999999999999989e-07, 1.90000000000000007e-07, 2.20000000000000011e-07, 2.59999999999999999e-07, 4.89999999999999967e-07, 8.29999999999999994e-07, 1.06999999999999992e-06, 1.74000000000000007e-06, 2.69999999999999998e-06, 3.62000000000000007e-06, 4.97999999999999975e-06, 6.37000000000000000e-06, 1.02100000000000005e-05, 1.62499999999999986e-05, 2.43400000000000007e-05, 3.69499999999999969e-05, 5.23999999999999997e-05, 7.43099999999999983e-05, 1.10240000000000002e-04, 1.64219999999999996e-04, 2.48149999999999987e-04, 3.70070000000000013e-04, 5.46069999999999954e-04, 8.06570000000000052e-04, 1.17874999999999989e-03, 1.72869999999999990e-03, 2.53974999999999991e-03, 3.70428999999999984e-03, 5.38652999999999962e-03, 7.71455999999999965e-03, 1.09071700000000008e-02, 1.52577600000000004e-02, 2.10269600000000008e-02, 2.85241999999999996e-02, 3.78893199999999972e-02, 4.89132300000000020e-02, 6.15169600000000025e-02, 7.45948599999999989e-02, 8.70925699999999942e-02, 9.70437299999999947e-02, 1.01999149999999997e-01, 1.00417129999999993e-01, 9.13793700000000014e-02, 7.57218199999999952e-02, 5.58256199999999994e-02, 3.58893500000000004e-02, 1.93672099999999993e-02, 8.40372999999999988e-03, 2.76377999999999997e-03, 6.25209999999999958e-04, 9.58599999999999936e-05, 9.02999999999999994e-06, 6.70000000000000044e-07, 4.00000000000000008e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[9][15] = niz9_15;
	static double niz9_16[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 2.99999999999999973e-08, 4.00000000000000008e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 4.00000000000000008e-08, 2.99999999999999973e-08, 8.00000000000000017e-08, 1.49999999999999993e-07, 1.69999999999999987e-07, 3.20000000000000007e-07, 4.09999999999999992e-07, 4.89999999999999967e-07, 6.50000000000000024e-07, 7.70000000000000039e-07, 1.30999999999999995e-06, 2.17999999999999988e-06, 3.22000000000000009e-06, 4.60000000000000000e-06, 7.06000000000000017e-06, 9.62999999999999928e-06, 1.35099999999999994e-05, 1.91999999999999991e-05, 2.71499999999999992e-05, 4.04900000000000003e-05, 6.01499999999999984e-05, 8.87000000000000012e-05, 1.32050000000000011e-04, 1.84080000000000013e-04, 2.67490000000000002e-04, 3.87050000000000003e-04, 5.60520000000000007e-04, 8.16820000000000003e-04, 1.17970000000000011e-03, 1.69490999999999999e-03, 2.41610999999999996e-03, 3.42915000000000017e-03, 4.84893000000000043e-03, 6.82071999999999973e-03, 9.50412999999999952e-03, 1.30313900000000003e-02, 1.76768399999999992e-02, 2.36179099999999989e-02, 3.10399399999999985e-02, 4.00363700000000017e-02, 5.03991599999999984e-02, 6.16594499999999976e-02, 7.30760700000000069e-02, 8.35648499999999961e-02, 9.14933200000000030e-02, 9.54512299999999980e-02, 9.37503799999999943e-02, 8.60706700000000019e-02, 7.27656099999999945e-02, 5.58756399999999973e-02, 3.81576799999999994e-02, 2.25607500000000009e-02, 1.11655999999999995e-02, 4.43941000000000040e-03, 1.31714000000000006e-03, 2.80670000000000008e-04, 4.26200000000000019e-05, 4.90999999999999958e-06, 2.80000000000000019e-07, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[9][16] = niz9_16;
	static double niz9_17[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.99999999999999973e-08, 2.99999999999999973e-08, 4.99999999999999977e-08, 5.99999999999999946e-08, 4.00000000000000008e-08, 2.99999999999999973e-08, 2.99999999999999973e-08, 1.19999999999999989e-07, 5.99999999999999946e-08, 2.39999999999999979e-07, 3.80000000000000015e-07, 6.09999999999999983e-07, 8.80000000000000045e-07, 1.15000000000000000e-06, 1.52000000000000006e-06, 1.94000000000000006e-06, 3.18999999999999995e-06, 4.43999999999999984e-06, 6.62000000000000015e-06, 8.71999999999999952e-06, 1.35900000000000003e-05, 1.85300000000000005e-05, 2.59399999999999990e-05, 3.76799999999999984e-05, 5.28199999999999991e-05, 7.65300000000000008e-05, 1.09679999999999993e-04, 1.54219999999999997e-04, 2.23269999999999995e-04, 3.13440000000000008e-04, 4.43900000000000002e-04, 6.26669999999999961e-04, 8.82019999999999961e-04, 1.25149000000000007e-03, 1.76680999999999995e-03, 2.47167999999999997e-03, 3.43354000000000012e-03, 4.75023000000000025e-03, 6.52066000000000017e-03, 8.89783000000000067e-03, 1.20135199999999998e-02, 1.60282599999999990e-02, 2.11169699999999988e-02, 2.73860000000000006e-02, 3.48880499999999968e-02, 4.35877600000000032e-02, 5.32970499999999986e-02, 6.34737699999999988e-02, 7.32179000000000024e-02, 8.16900599999999949e-02, 8.75821999999999989e-02, 8.96041000000000060e-02, 8.69680399999999965e-02, 7.92017700000000047e-02, 6.71339400000000031e-02, 5.20968799999999982e-02, 3.64917900000000031e-02, 2.25354200000000005e-02, 1.19521400000000000e-02, 5.24685999999999989e-03, 1.81506000000000007e-03, 4.66060000000000020e-04, 9.04200000000000050e-05, 1.36999999999999993e-05, 1.39000000000000003e-06, 1.79999999999999997e-07, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[9][17] = niz9_17;
	static double niz9_18[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.00000000000000004e-08, 2.99999999999999973e-08, 2.99999999999999973e-08, 4.00000000000000008e-08, 1.00000000000000002e-08, 5.99999999999999946e-08, 1.29999999999999999e-07, 1.49999999999999993e-07, 8.99999999999999986e-08, 2.59999999999999999e-07, 4.40000000000000022e-07, 4.89999999999999967e-07, 5.70000000000000048e-07, 7.29999999999999999e-07, 9.99999999999999955e-07, 1.50000000000000004e-06, 1.65000000000000008e-06, 2.81000000000000020e-06, 3.49000000000000004e-06, 4.97999999999999975e-06, 7.07999999999999998e-06, 9.73000000000000001e-06, 1.41000000000000005e-05, 1.93200000000000014e-05, 2.68600000000000003e-05, 3.72199999999999994e-05, 5.23899999999999981e-05, 7.12299999999999939e-05, 9.87299999999999983e-05, 1.39739999999999987e-04, 1.92699999999999995e-04, 2.73599999999999983e-04, 3.79959999999999987e-04, 5.29949999999999952e-04, 7.31690000000000010e-04, 1.02070000000000004e-03, 1.39830000000000011e-03, 1.93973999999999991e-03, 2.66495000000000013e-03, 3.63493000000000019e-03, 4.92657999999999985e-03, 6.65128999999999981e-03, 8.87316999999999967e-03, 1.17648700000000002e-02, 1.54073100000000004e-02, 2.00095599999999992e-02, 2.55843800000000003e-02, 3.21835200000000002e-02, 3.98364999999999969e-02, 4.82895600000000022e-02, 5.72318600000000025e-02, 6.61897800000000036e-02, 7.42123900000000031e-02, 8.04685599999999945e-02, 8.40490599999999949e-02, 8.39607400000000059e-02, 7.96074900000000030e-02, 7.13098800000000060e-02, 5.95107900000000009e-02, 4.58924900000000011e-02, 3.21527500000000008e-02, 2.01275700000000009e-02, 1.09510800000000002e-02, 5.00611000000000025e-03, 1.85741000000000009e-03, 5.40739999999999949e-04, 1.19000000000000006e-04, 2.08699999999999984e-05, 2.78999999999999997e-06, 3.80000000000000015e-07, 5.99999999999999946e-08, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[9][18] = niz9_18;
	static double niz9_19[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 4.00000000000000008e-08, 2.00000000000000004e-08, 8.99999999999999986e-08, 7.00000000000000048e-08, 1.19999999999999989e-07, 1.40000000000000010e-07, 1.40000000000000010e-07, 3.09999999999999997e-07, 3.90000000000000025e-07, 3.30000000000000017e-07, 5.79999999999999953e-07, 6.30000000000000003e-07, 9.79999999999999934e-07, 1.14000000000000010e-06, 1.68999999999999991e-06, 2.08999999999999989e-06, 3.18000000000000005e-06, 4.48000000000000031e-06, 6.01000000000000006e-06, 8.04999999999999916e-06, 1.04200000000000002e-05, 1.44300000000000008e-05, 1.99599999999999986e-05, 2.72799999999999997e-05, 3.79600000000000025e-05, 5.30400000000000004e-05, 7.39300000000000054e-05, 1.00989999999999994e-04, 1.37660000000000007e-04, 1.83770000000000011e-04, 2.55159999999999990e-04, 3.53039999999999994e-04, 4.85479999999999994e-04, 6.64080000000000052e-04, 9.02559999999999951e-04, 1.22820000000000004e-03, 1.65873999999999991e-03, 2.25093999999999989e-03, 3.02577000000000011e-03, 4.05285000000000020e-03, 5.40159000000000038e-03, 7.17328999999999970e-03, 9.38978000000000035e-03, 1.21910800000000000e-02, 1.57189499999999989e-02, 2.00387500000000010e-02, 2.52274400000000003e-02, 3.12621699999999988e-02, 3.81998200000000024e-02, 4.57438999999999971e-02, 5.37953200000000006e-02, 6.17093599999999978e-02, 6.90321799999999985e-02, 7.49698599999999993e-02, 7.87346700000000066e-02, 7.96555800000000036e-02, 7.71908500000000053e-02, 7.11819399999999991e-02, 6.20137899999999992e-02, 5.05260100000000031e-02, 3.80803300000000025e-02, 2.62013299999999984e-02, 1.61468399999999991e-02, 8.71350000000000076e-03, 4.01901999999999988e-03, 1.51983999999999995e-03, 4.59329999999999981e-04, 1.10600000000000005e-04, 2.19099999999999986e-05, 3.62000000000000007e-06, 4.89999999999999967e-07, 8.99999999999999986e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[9][19] = niz9_19;
	static double niz9_20[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.99999999999999973e-08, 0.00000000000000000e+00, 2.00000000000000004e-08, 0.00000000000000000e+00, 2.99999999999999973e-08, 4.99999999999999977e-08, 5.99999999999999946e-08, 1.19999999999999989e-07, 8.99999999999999986e-08, 1.49999999999999993e-07, 2.59999999999999999e-07, 2.39999999999999979e-07, 4.49999999999999980e-07, 5.60000000000000038e-07, 6.50000000000000024e-07, 6.99999999999999968e-07, 1.03000000000000009e-06, 1.52999999999999996e-06, 2.13999999999999984e-06, 2.42000000000000012e-06, 3.70000000000000015e-06, 5.00000000000000041e-06, 7.16999999999999996e-06, 9.55999999999999995e-06, 1.27100000000000003e-05, 1.70700000000000009e-05, 2.24300000000000004e-05, 3.18100000000000021e-05, 4.14999999999999991e-05, 5.69699999999999983e-05, 7.90999999999999982e-05, 1.04879999999999999e-04, 1.41490000000000002e-04, 1.93240000000000013e-04, 2.58550000000000023e-04, 3.53979999999999996e-04, 4.72919999999999992e-04, 6.41120000000000015e-04, 8.56270000000000013e-04, 1.15862999999999990e-03, 1.54148999999999996e-03, 2.05346000000000001e-03, 2.71389000000000005e-03, 3.58967000000000010e-03, 4.71218999999999978e-03, 6.18316999999999999e-03, 8.02230999999999951e-03, 1.03215000000000008e-02, 1.31891800000000000e-02, 1.67031800000000015e-02, 2.09004799999999991e-02, 2.58584799999999997e-02, 3.15610600000000019e-02, 3.79798500000000025e-02, 4.49217599999999981e-02, 5.20968500000000001e-02, 5.91404199999999991e-02, 6.56813400000000047e-02, 7.10604499999999972e-02, 7.45866000000000029e-02, 7.56375600000000065e-02, 7.38373699999999994e-02, 6.90717599999999959e-02, 6.14030600000000024e-02, 5.15176899999999979e-02, 4.04766299999999996e-02, 2.94302399999999999e-02, 1.95102499999999998e-02, 1.16192299999999995e-02, 6.06819000000000022e-03, 2.72235000000000012e-03, 1.00847000000000003e-03, 3.07179999999999996e-04, 7.57100000000000053e-05, 1.57800000000000014e-05, 2.25000000000000006e-06, 2.59999999999999999e-07, 2.99999999999999973e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[9][20] = niz9_20;
	static double niz9_21[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 0.00000000000000000e+00, 2.00000000000000004e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 2.99999999999999973e-08, 4.00000000000000008e-08, 8.00000000000000017e-08, 9.99999999999999955e-08, 1.29999999999999999e-07, 2.10000000000000001e-07, 1.49999999999999993e-07, 2.89999999999999976e-07, 2.70000000000000009e-07, 4.89999999999999967e-07, 6.99999999999999968e-07, 7.60000000000000029e-07, 9.99999999999999955e-07, 1.70999999999999993e-06, 2.04999999999999985e-06, 2.73000000000000012e-06, 3.58000000000000003e-06, 4.74000000000000036e-06, 6.66999999999999967e-06, 8.88999999999999959e-06, 1.16600000000000002e-05, 1.63900000000000006e-05, 2.10100000000000004e-05, 2.77399999999999987e-05, 3.78200000000000004e-05, 4.94900000000000022e-05, 6.56400000000000017e-05, 8.55399999999999975e-05, 1.19909999999999995e-04, 1.54880000000000008e-04, 2.09950000000000007e-04, 2.77820000000000020e-04, 3.70639999999999989e-04, 4.92600000000000047e-04, 6.52670000000000051e-04, 8.69989999999999956e-04, 1.13922000000000003e-03, 1.51019000000000001e-03, 1.98252000000000020e-03, 2.60260999999999999e-03, 3.37859999999999983e-03, 4.40133000000000017e-03, 5.66694999999999959e-03, 7.28870000000000039e-03, 9.30398999999999983e-03, 1.17615900000000006e-02, 1.47693100000000008e-02, 1.83317900000000006e-02, 2.25367900000000010e-02, 2.74639900000000006e-02, 3.29341800000000004e-02, 3.89499700000000004e-02, 4.53859399999999996e-02, 5.19043500000000019e-02, 5.82323400000000005e-02, 6.38819699999999963e-02, 6.83963399999999999e-02, 7.11663899999999960e-02, 7.19108700000000017e-02, 7.00429300000000032e-02, 6.56350400000000056e-02, 5.87375300000000031e-02, 5.00238100000000019e-02, 4.01074800000000009e-02, 3.00306200000000009e-02, 2.07573199999999992e-02, 1.30372500000000002e-02, 7.35043999999999975e-03, 3.61413000000000012e-03, 1.52181999999999990e-03, 5.32629999999999974e-04, 1.59979999999999996e-04, 3.91999999999999974e-05, 9.12000000000000077e-06, 1.90000000000000002e-06, 3.49999999999999984e-07, 5.99999999999999946e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[9][21] = niz9_21;
	static double niz9_22[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 2.00000000000000004e-08, 2.00000000000000004e-08, 2.99999999999999973e-08, 2.00000000000000004e-08, 5.99999999999999946e-08, 7.00000000000000048e-08, 5.99999999999999946e-08, 1.40000000000000010e-07, 1.79999999999999997e-07, 2.80000000000000019e-07, 3.70000000000000004e-07, 3.80000000000000015e-07, 5.19999999999999998e-07, 5.89999999999999963e-07, 8.89999999999999949e-07, 1.01999999999999998e-06, 1.45000000000000009e-06, 1.88000000000000000e-06, 2.13999999999999984e-06, 2.87000000000000005e-06, 4.22000000000000025e-06, 5.66000000000000002e-06, 7.13000000000000034e-06, 8.91999999999999930e-06, 1.12400000000000008e-05, 1.52799999999999994e-05, 2.05000000000000002e-05, 2.76999999999999991e-05, 3.48200000000000020e-05, 4.61199999999999989e-05, 6.01800000000000032e-05, 8.00399999999999994e-05, 1.03969999999999996e-04, 1.37479999999999992e-04, 1.79309999999999989e-04, 2.37540000000000006e-04, 3.12729999999999996e-04, 4.15029999999999989e-04, 5.45220000000000015e-04, 7.12410000000000018e-04, 9.20409999999999978e-04, 1.20589999999999998e-03, 1.57634000000000008e-03, 2.02663000000000018e-03, 2.62912999999999992e-03, 3.38359000000000012e-03, 4.34489999999999963e-03, 5.54129999999999987e-03, 7.01930000000000002e-03, 8.84645000000000049e-03, 1.10782699999999994e-02, 1.37679399999999993e-02, 1.69556699999999991e-02, 2.06980000000000011e-02, 2.49930899999999991e-02, 2.98474500000000011e-02, 3.52071099999999998e-02, 4.09035000000000024e-02, 4.68422699999999984e-02, 5.27262100000000025e-02, 5.81927900000000012e-02, 6.29446800000000029e-02, 6.64210699999999987e-02, 6.83205399999999990e-02, 6.81861099999999942e-02, 6.59563700000000003e-02, 6.13917900000000016e-02, 5.48579199999999975e-02, 4.66349000000000000e-02, 3.76338599999999981e-02, 2.85454600000000017e-02, 2.00841499999999985e-02, 1.29860099999999992e-02, 7.60755000000000025e-03, 3.95286999999999982e-03, 1.78592000000000009e-03, 6.91160000000000017e-04, 2.29850000000000003e-04, 6.43000000000000044e-05, 1.64100000000000004e-05, 3.54999999999999989e-06, 6.09999999999999983e-07, 1.29999999999999999e-07, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[9][22] = niz9_22;
	static double niz9_23[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.00000000000000004e-08, 0.00000000000000000e+00, 2.00000000000000004e-08, 4.00000000000000008e-08, 2.00000000000000004e-08, 2.99999999999999973e-08, 2.99999999999999973e-08, 7.00000000000000048e-08, 9.99999999999999955e-08, 1.10000000000000006e-07, 1.69999999999999987e-07, 2.80000000000000019e-07, 2.59999999999999999e-07, 4.09999999999999992e-07, 5.30000000000000008e-07, 6.70000000000000044e-07, 8.60000000000000025e-07, 9.79999999999999934e-07, 1.32000000000000007e-06, 1.99000000000000001e-06, 2.47999999999999997e-06, 3.14999999999999991e-06, 4.63999999999999962e-06, 5.65000000000000011e-06, 7.06000000000000017e-06, 8.90999999999999940e-06, 1.16700000000000001e-05, 1.58600000000000006e-05, 2.03399999999999984e-05, 2.67899999999999993e-05, 3.39700000000000017e-05, 4.55699999999999991e-05, 5.84599999999999993e-05, 7.59700000000000062e-05, 9.74700000000000002e-05, 1.27419999999999996e-04, 1.66460000000000002e-04, 2.16020000000000009e-04, 2.81759999999999986e-04, 3.65590000000000001e-04, 4.75610000000000008e-04, 6.17020000000000025e-04, 7.99239999999999998e-04, 1.03553999999999994e-03, 1.32524000000000010e-03, 1.70567000000000006e-03, 2.18111999999999993e-03, 2.79055000000000015e-03, 3.54718000000000004e-03, 4.48450999999999971e-03, 5.65369000000000028e-03, 7.08644000000000027e-03, 8.84898999999999929e-03, 1.09735300000000004e-02, 1.34530299999999995e-02, 1.64212600000000000e-02, 1.98702299999999991e-02, 2.38154499999999984e-02, 2.82086099999999985e-02, 3.30320600000000020e-02, 3.82189399999999999e-02, 4.35704300000000003e-02, 4.89652400000000002e-02, 5.41158899999999998e-02, 5.86548100000000017e-02, 6.22701299999999999e-02, 6.46769999999999984e-02, 6.54781900000000056e-02, 6.43960100000000035e-02, 6.13731799999999994e-02, 5.64126299999999983e-02, 4.97837199999999966e-02, 4.20180299999999979e-02, 3.36696500000000024e-02, 2.54424200000000003e-02, 1.79480300000000002e-02, 1.17050799999999997e-02, 6.93447999999999981e-03, 3.67957000000000006e-03, 1.72725000000000005e-03, 7.02889999999999960e-04, 2.47319999999999983e-04, 7.38199999999999946e-05, 2.08299999999999988e-05, 4.96999999999999985e-06, 1.06000000000000002e-06, 2.39999999999999979e-07, 4.99999999999999977e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[9][23] = niz9_23;
	static double niz9_24[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 2.99999999999999973e-08, 1.00000000000000002e-08, 2.99999999999999973e-08, 2.00000000000000004e-08, 2.99999999999999973e-08, 0.00000000000000000e+00, 2.00000000000000004e-08, 4.99999999999999977e-08, 4.99999999999999977e-08, 7.00000000000000048e-08, 1.10000000000000006e-07, 1.10000000000000006e-07, 1.29999999999999999e-07, 2.29999999999999995e-07, 1.69999999999999987e-07, 3.49999999999999984e-07, 3.59999999999999994e-07, 4.20000000000000002e-07, 6.60000000000000034e-07, 7.80000000000000049e-07, 1.08999999999999994e-06, 1.30000000000000005e-06, 1.72000000000000005e-06, 2.12000000000000003e-06, 2.52999999999999992e-06, 3.34000000000000021e-06, 4.34999999999999986e-06, 5.92000000000000007e-06, 6.99999999999999989e-06, 1.00300000000000005e-05, 1.29899999999999993e-05, 1.64100000000000004e-05, 2.08999999999999998e-05, 2.73500000000000007e-05, 3.48700000000000033e-05, 4.53700000000000010e-05, 6.06000000000000026e-05, 7.44999999999999948e-05, 9.78100000000000003e-05, 1.25909999999999992e-04, 1.64930000000000008e-04, 2.12210000000000003e-04, 2.73569999999999998e-04, 3.49479999999999995e-04, 4.46190000000000009e-04, 5.74889999999999993e-04, 7.36699999999999963e-04, 9.40810000000000040e-04, 1.19191999999999996e-03, 1.52870000000000002e-03, 1.93848000000000002e-03, 2.45027999999999999e-03, 3.08051999999999979e-03, 3.88172999999999990e-03, 4.84159999999999972e-03, 6.03291999999999978e-03, 7.47692999999999969e-03, 9.21663999999999990e-03, 1.12591099999999993e-02, 1.37067600000000001e-02, 1.65130300000000015e-02, 1.97866200000000013e-02, 2.34847200000000006e-02, 2.75712400000000003e-02, 3.20535299999999967e-02, 3.68258200000000022e-02, 4.17688299999999998e-02, 4.66822100000000018e-02, 5.14047399999999974e-02, 5.56610300000000002e-02, 5.91271099999999966e-02, 6.15596500000000005e-02, 6.25692100000000001e-02, 6.21189700000000025e-02, 5.98914399999999972e-02, 5.60218300000000016e-02, 5.05181899999999975e-02, 4.38433299999999998e-02, 3.63862400000000002e-02, 2.86817400000000007e-02, 2.13316500000000006e-02, 1.48703900000000007e-02, 9.57327000000000004e-03, 5.62603999999999969e-03, 2.98407000000000013e-03, 1.40361999999999995e-03, 5.78920000000000021e-04, 2.05469999999999996e-04, 6.73100000000000044e-05, 1.94999999999999996e-05, 4.95000000000000004e-06, 1.06000000000000002e-06, 1.10000000000000006e-07, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[9][24] = niz9_24;
	static double niz9_25[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 0.00000000000000000e+00, 2.00000000000000004e-08, 1.00000000000000002e-08, 4.00000000000000008e-08, 2.00000000000000004e-08, 8.99999999999999986e-08, 4.00000000000000008e-08, 4.99999999999999977e-08, 5.99999999999999946e-08, 1.60000000000000003e-07, 1.60000000000000003e-07, 1.79999999999999997e-07, 2.59999999999999999e-07, 3.59999999999999994e-07, 5.99999999999999973e-07, 5.30000000000000008e-07, 5.79999999999999953e-07, 9.70000000000000030e-07, 1.10000000000000006e-06, 1.54999999999999998e-06, 1.99999999999999991e-06, 2.69999999999999998e-06, 3.18999999999999995e-06, 4.18999999999999969e-06, 5.45000000000000034e-06, 6.87000000000000029e-06, 9.02999999999999994e-06, 1.16500000000000003e-05, 1.45799999999999993e-05, 1.89699999999999996e-05, 2.33600000000000000e-05, 2.99200000000000015e-05, 3.77999999999999972e-05, 4.77400000000000003e-05, 6.08199999999999971e-05, 8.00699999999999974e-05, 1.01840000000000001e-04, 1.28199999999999999e-04, 1.69130000000000002e-04, 2.11250000000000012e-04, 2.69240000000000018e-04, 3.45609999999999993e-04, 4.43120000000000026e-04, 5.61039999999999955e-04, 7.11330000000000035e-04, 9.01519999999999947e-04, 1.13744999999999992e-03, 1.43777000000000011e-03, 1.80966000000000004e-03, 2.26961000000000003e-03, 2.83738999999999996e-03, 3.53849000000000004e-03, 4.39522999999999997e-03, 5.42658000000000029e-03, 6.66835999999999991e-03, 8.15041000000000029e-03, 9.93743000000000057e-03, 1.20163000000000006e-02, 1.44429399999999996e-02, 1.72327599999999997e-02, 2.03955000000000004e-02, 2.39038999999999988e-02, 2.78327600000000015e-02, 3.20390099999999997e-02, 3.64444500000000032e-02, 4.10687500000000011e-02, 4.55433299999999999e-02, 4.98160299999999973e-02, 5.36319499999999977e-02, 5.67699399999999979e-02, 5.90018600000000032e-02, 5.99463999999999969e-02, 5.95832400000000026e-02, 5.77124899999999982e-02, 5.43937999999999991e-02, 4.96254600000000032e-02, 4.37197900000000014e-02, 3.70356400000000016e-02, 2.99648399999999995e-02, 2.30550900000000003e-02, 1.67259699999999997e-02, 1.13502900000000007e-02, 7.13107999999999971e-03, 4.08745000000000028e-03, 2.11787000000000000e-03, 9.81820000000000002e-04, 4.00889999999999992e-04, 1.45210000000000001e-04, 4.83800000000000010e-05, 1.38000000000000000e-05, 4.08999999999999980e-06, 9.59999999999999914e-07, 1.40000000000000010e-07, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[9][25] = niz9_25;
	static double niz9_26[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 2.99999999999999973e-08, 1.00000000000000002e-08, 2.99999999999999973e-08, 1.00000000000000002e-08, 2.99999999999999973e-08, 4.99999999999999977e-08, 2.00000000000000004e-08, 5.99999999999999946e-08, 2.00000000000000004e-08, 4.99999999999999977e-08, 7.00000000000000048e-08, 8.00000000000000017e-08, 1.29999999999999999e-07, 1.99999999999999991e-07, 2.29999999999999995e-07, 2.29999999999999995e-07, 3.30000000000000017e-07, 3.70000000000000004e-07, 5.70000000000000048e-07, 6.50000000000000024e-07, 7.60000000000000029e-07, 1.15000000000000000e-06, 1.19999999999999995e-06, 1.52999999999999996e-06, 2.00999999999999981e-06, 2.57999999999999986e-06, 3.06999999999999983e-06, 3.86000000000000031e-06, 4.80999999999999969e-06, 6.37999999999999990e-06, 8.04999999999999916e-06, 1.04799999999999996e-05, 1.32700000000000000e-05, 1.67599999999999988e-05, 2.19799999999999996e-05, 2.70800000000000016e-05, 3.42700000000000022e-05, 4.33999999999999978e-05, 5.64599999999999981e-05, 7.21000000000000043e-05, 9.08799999999999972e-05, 1.13859999999999997e-04, 1.44129999999999991e-04, 1.84400000000000010e-04, 2.29210000000000009e-04, 2.88999999999999977e-04, 3.63199999999999992e-04, 4.64789999999999973e-04, 5.77390000000000000e-04, 7.28350000000000004e-04, 9.18949999999999975e-04, 1.13845999999999999e-03, 1.43060999999999991e-03, 1.76982000000000007e-03, 2.21369999999999987e-03, 2.74815999999999993e-03, 3.38471999999999992e-03, 4.14854000000000004e-03, 5.10619000000000003e-03, 6.22960000000000007e-03, 7.56851999999999959e-03, 9.15667000000000043e-03, 1.10213599999999991e-02, 1.31600199999999997e-02, 1.56301000000000009e-02, 1.84238899999999983e-02, 2.15592400000000003e-02, 2.50391600000000013e-02, 2.87832499999999998e-02, 3.27744000000000021e-02, 3.69468199999999983e-02, 4.11275300000000024e-02, 4.52542800000000009e-02, 4.90695300000000001e-02, 5.24452600000000005e-02, 5.51433399999999990e-02, 5.69327899999999970e-02, 5.76534299999999986e-02, 5.71177400000000002e-02, 5.53195599999999968e-02, 5.21326500000000026e-02, 4.76693700000000026e-02, 4.22254599999999994e-02, 3.60712099999999994e-02, 2.95519100000000007e-02, 2.31524099999999983e-02, 1.71473400000000005e-02, 1.19901299999999999e-02, 7.80993999999999959e-03, 4.71829999999999992e-03, 2.59421000000000001e-03, 1.28291999999999989e-03, 5.74089999999999974e-04, 2.26700000000000008e-04, 8.01199999999999986e-05, 2.68299999999999989e-05, 8.41000000000000079e-06, 1.97000000000000020e-06, 5.70000000000000048e-07, 1.60000000000000003e-07, 4.00000000000000008e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[9][26] = niz9_26;
	static double niz9_27[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 4.00000000000000008e-08, 2.00000000000000004e-08, 2.00000000000000004e-08, 0.00000000000000000e+00, 2.99999999999999973e-08, 2.99999999999999973e-08, 5.99999999999999946e-08, 4.99999999999999977e-08, 8.00000000000000017e-08, 7.00000000000000048e-08, 5.99999999999999946e-08, 8.99999999999999986e-08, 1.90000000000000007e-07, 1.79999999999999997e-07, 2.59999999999999999e-07, 2.10000000000000001e-07, 2.39999999999999979e-07, 3.49999999999999984e-07, 3.49999999999999984e-07, 4.99999999999999977e-07, 6.60000000000000034e-07, 7.29999999999999999e-07, 1.01000000000000007e-06, 1.28000000000000003e-06, 1.74000000000000007e-06, 2.21999999999999992e-06, 2.50000000000000020e-06, 3.15999999999999981e-06, 4.07000000000000000e-06, 5.27000000000000037e-06, 6.80000000000000012e-06, 7.78000000000000005e-06, 1.02699999999999999e-05, 1.30600000000000003e-05, 1.62600000000000002e-05, 2.01999999999999997e-05, 2.57499999999999991e-05, 3.17899999999999989e-05, 4.08300000000000004e-05, 5.07100000000000007e-05, 6.34299999999999941e-05, 8.12900000000000027e-05, 1.02470000000000000e-04, 1.26980000000000007e-04, 1.62880000000000013e-04, 2.02950000000000000e-04, 2.53540000000000015e-04, 3.17220000000000002e-04, 3.96140000000000012e-04, 4.97339999999999978e-04, 6.16340000000000052e-04, 7.71010000000000033e-04, 9.57709999999999963e-04, 1.19122999999999994e-03, 1.47711999999999995e-03, 1.82446999999999991e-03, 2.25141000000000013e-03, 2.76143999999999999e-03, 3.39329000000000019e-03, 4.14138000000000006e-03, 5.00862000000000009e-03, 6.07641999999999991e-03, 7.33549000000000007e-03, 8.80476999999999996e-03, 1.05095299999999996e-02, 1.24768299999999995e-02, 1.47154599999999997e-02, 1.72679599999999989e-02, 2.01350500000000016e-02, 2.32672299999999999e-02, 2.66622400000000002e-02, 3.03247199999999995e-02, 3.41487899999999983e-02, 3.80427299999999968e-02, 4.18723599999999974e-02, 4.55613900000000002e-02, 4.89829700000000007e-02, 5.17711199999999969e-02, 5.39066900000000002e-02, 5.51900199999999994e-02, 5.54706500000000033e-02, 5.45246100000000011e-02, 5.24765000000000023e-02, 4.92235999999999993e-02, 4.48860899999999965e-02, 3.96994000000000027e-02, 3.39547099999999991e-02, 2.78960200000000005e-02, 2.19835799999999991e-02, 1.64938300000000010e-02, 1.16581700000000007e-02, 7.78429000000000013e-03, 4.80445000000000004e-03, 2.72506000000000007e-03, 1.41394999999999997e-03, 6.62939999999999992e-04, 2.81009999999999995e-04, 1.07689999999999994e-04, 3.78600000000000000e-05, 1.21800000000000003e-05, 3.14000000000000001e-06, 1.01000000000000007e-06, 2.49999999999999989e-07, 4.00000000000000008e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[9][27] = niz9_27;
	static double niz9_28[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.99999999999999973e-08, 2.00000000000000004e-08, 2.99999999999999973e-08, 2.99999999999999973e-08, 5.99999999999999946e-08, 4.99999999999999977e-08, 5.99999999999999946e-08, 1.19999999999999989e-07, 8.99999999999999986e-08, 1.10000000000000006e-07, 1.40000000000000010e-07, 2.59999999999999999e-07, 1.19999999999999989e-07, 3.39999999999999974e-07, 4.20000000000000002e-07, 4.79999999999999957e-07, 5.70000000000000048e-07, 7.99999999999999964e-07, 9.50000000000000010e-07, 1.32999999999999997e-06, 1.79999999999999992e-06, 2.03999999999999995e-06, 2.25999999999999996e-06, 2.73000000000000012e-06, 3.67000000000000001e-06, 4.42999999999999994e-06, 5.27000000000000037e-06, 7.17999999999999987e-06, 8.31000000000000006e-06, 1.12600000000000006e-05, 1.42199999999999994e-05, 1.69099999999999990e-05, 2.09100000000000014e-05, 2.63100000000000005e-05, 3.34200000000000019e-05, 4.13299999999999990e-05, 5.10299999999999976e-05, 6.46799999999999974e-05, 7.99800000000000033e-05, 9.85799999999999947e-05, 1.25129999999999989e-04, 1.55859999999999988e-04, 1.91060000000000004e-04, 2.39100000000000011e-04, 2.96529999999999982e-04, 3.67890000000000003e-04, 4.52550000000000023e-04, 5.62630000000000053e-04, 6.99179999999999984e-04, 8.61620000000000007e-04, 1.05996999999999992e-03, 1.30659000000000005e-03, 1.59423000000000008e-03, 1.94225999999999991e-03, 2.38506999999999999e-03, 2.91033000000000003e-03, 3.53402000000000013e-03, 4.27695999999999979e-03, 5.16825000000000010e-03, 6.18685999999999976e-03, 7.40737999999999987e-03, 8.82968999999999941e-03, 1.04598599999999996e-02, 1.23348999999999993e-02, 1.44583300000000001e-02, 1.68475200000000012e-02, 1.94862399999999984e-02, 2.24006599999999993e-02, 2.55641399999999991e-02, 2.89359900000000017e-02, 3.24503599999999975e-02, 3.60098599999999977e-02, 3.95819000000000032e-02, 4.30684200000000031e-02, 4.62551400000000001e-02, 4.90316800000000011e-02, 5.12825100000000034e-02, 5.27662500000000007e-02, 5.33786200000000016e-02, 5.30817400000000023e-02, 5.16301099999999999e-02, 4.91899100000000034e-02, 4.57014300000000012e-02, 4.13831299999999971e-02, 3.63110499999999975e-02, 3.07890200000000003e-02, 2.51879500000000006e-02, 1.97605599999999999e-02, 1.47981599999999994e-02, 1.04830400000000008e-02, 7.00060999999999999e-03, 4.35924000000000034e-03, 2.51568000000000017e-03, 1.33605000000000008e-03, 6.46960000000000026e-04, 2.83190000000000004e-04, 1.13309999999999998e-04, 4.12200000000000018e-05, 1.38699999999999993e-05, 4.27999999999999968e-06, 1.19000000000000004e-06, 2.59999999999999999e-07, 1.10000000000000006e-07, 2.00000000000000004e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[9][28] = niz9_28;
	static double niz9_29[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 0.00000000000000000e+00, 2.00000000000000004e-08, 2.99999999999999973e-08, 2.00000000000000004e-08, 2.00000000000000004e-08, 0.00000000000000000e+00, 4.99999999999999977e-08, 8.00000000000000017e-08, 5.99999999999999946e-08, 4.00000000000000008e-08, 8.00000000000000017e-08, 1.40000000000000010e-07, 1.60000000000000003e-07, 2.49999999999999989e-07, 2.70000000000000009e-07, 3.70000000000000004e-07, 3.90000000000000025e-07, 5.09999999999999988e-07, 5.89999999999999963e-07, 8.09999999999999974e-07, 9.19999999999999980e-07, 1.32999999999999997e-06, 1.39000000000000003e-06, 1.74999999999999997e-06, 2.21999999999999992e-06, 2.65999999999999994e-06, 3.23999999999999990e-06, 4.51000000000000002e-06, 4.63999999999999962e-06, 6.18000000000000012e-06, 7.32000000000000022e-06, 9.51000000000000043e-06, 1.13000000000000002e-05, 1.39500000000000003e-05, 1.74799999999999987e-05, 2.16300000000000013e-05, 2.69300000000000014e-05, 3.40299999999999978e-05, 4.10699999999999981e-05, 5.06800000000000027e-05, 6.39600000000000043e-05, 7.95799999999999936e-05, 9.81599999999999953e-05, 1.23120000000000000e-04, 1.49860000000000005e-04, 1.87269999999999987e-04, 2.29599999999999997e-04, 2.82980000000000005e-04, 3.50690000000000019e-04, 4.28890000000000022e-04, 5.30219999999999975e-04, 6.46850000000000029e-04, 7.92959999999999997e-04, 9.77510000000000011e-04, 1.19472999999999997e-03, 1.45520999999999997e-03, 1.77482000000000009e-03, 2.15594999999999979e-03, 2.59793999999999997e-03, 3.13917000000000015e-03, 3.77860999999999995e-03, 4.54916000000000001e-03, 5.43394999999999989e-03, 6.47593000000000040e-03, 7.70757000000000039e-03, 9.10936000000000037e-03, 1.06864500000000001e-02, 1.25019299999999996e-02, 1.45917100000000008e-02, 1.68698400000000005e-02, 1.93804599999999987e-02, 2.21827500000000011e-02, 2.51141900000000015e-02, 2.83183200000000010e-02, 3.15767200000000026e-02, 3.49158899999999980e-02, 3.82385000000000017e-02, 4.14998899999999976e-02, 4.45095599999999966e-02, 4.70986899999999986e-02, 4.92967500000000003e-02, 5.07387099999999994e-02, 5.15399799999999991e-02, 5.13418299999999980e-02, 5.03358699999999978e-02, 4.83217800000000017e-02, 4.53730099999999983e-02, 4.15381699999999993e-02, 3.70548100000000005e-02, 3.21091199999999979e-02, 2.69528700000000003e-02, 2.17448099999999998e-02, 1.68490799999999989e-02, 1.24778000000000007e-02, 8.76623999999999980e-03, 5.79484999999999983e-03, 3.59823000000000000e-03, 2.07099999999999992e-03, 1.09574000000000000e-03, 5.38399999999999968e-04, 2.41439999999999992e-04, 9.78000000000000055e-05, 3.67799999999999968e-05, 1.30200000000000007e-05, 4.43999999999999984e-06, 1.12000000000000008e-06, 5.09999999999999988e-07, 1.40000000000000010e-07, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[9][29] = niz9_29;
	static double niz9_30[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.00000000000000004e-08, 1.00000000000000002e-08, 2.99999999999999973e-08, 2.99999999999999973e-08, 5.99999999999999946e-08, 9.99999999999999955e-08, 4.99999999999999977e-08, 7.00000000000000048e-08, 1.29999999999999999e-07, 8.00000000000000017e-08, 8.00000000000000017e-08, 1.19999999999999989e-07, 1.69999999999999987e-07, 2.59999999999999999e-07, 2.89999999999999976e-07, 3.09999999999999997e-07, 3.59999999999999994e-07, 5.50000000000000028e-07, 5.50000000000000028e-07, 5.89999999999999963e-07, 8.40000000000000004e-07, 9.19999999999999980e-07, 1.17999999999999993e-06, 1.32999999999999997e-06, 1.52000000000000006e-06, 1.81000000000000003e-06, 2.40999999999999980e-06, 3.27999999999999994e-06, 3.75000000000000010e-06, 4.26999999999999978e-06, 5.90000000000000026e-06, 6.90999999999999991e-06, 8.45000000000000041e-06, 1.03700000000000007e-05, 1.26600000000000008e-05, 1.56199999999999995e-05, 2.02900000000000006e-05, 2.43800000000000004e-05, 2.93499999999999985e-05, 3.74500000000000023e-05, 4.53000000000000033e-05, 5.59899999999999976e-05, 6.92500000000000027e-05, 8.33600000000000015e-05, 1.01680000000000002e-04, 1.26460000000000006e-04, 1.53959999999999996e-04, 1.94870000000000010e-04, 2.35039999999999999e-04, 2.84469999999999992e-04, 3.53279999999999979e-04, 4.29550000000000006e-04, 5.24900000000000019e-04, 6.40790000000000023e-04, 7.75850000000000021e-04, 9.42160000000000046e-04, 1.14770999999999992e-03, 1.38921000000000010e-03, 1.68468999999999997e-03, 2.03466000000000020e-03, 2.44889999999999995e-03, 2.95099000000000012e-03, 3.51376999999999983e-03, 4.20144999999999980e-03, 4.99793000000000025e-03, 5.93679999999999989e-03, 7.01462000000000006e-03, 8.26073000000000085e-03, 9.67028999999999979e-03, 1.12870799999999997e-02, 1.30996700000000008e-02, 1.51391600000000005e-02, 1.73527800000000017e-02, 1.98255999999999988e-02, 2.24876300000000015e-02, 2.53375700000000002e-02, 2.83591099999999999e-02, 3.14345200000000005e-02, 3.45620700000000003e-02, 3.76899899999999996e-02, 4.06402199999999977e-02, 4.33892000000000028e-02, 4.57925600000000030e-02, 4.77315400000000029e-02, 4.90943800000000000e-02, 4.97585799999999967e-02, 4.96456099999999997e-02, 4.86362200000000008e-02, 4.68107499999999982e-02, 4.41767799999999988e-02, 4.07829499999999984e-02, 3.66921100000000000e-02, 3.21223900000000007e-02, 2.73113799999999997e-02, 2.24467599999999996e-02, 1.78199900000000008e-02, 1.35340600000000005e-02, 9.81317999999999947e-03, 6.75511999999999987e-03, 4.38397000000000005e-03, 2.66636999999999994e-03, 1.50865999999999999e-03, 7.88450000000000002e-04, 3.80850000000000014e-04, 1.67610000000000003e-04, 6.94699999999999972e-05, 2.60100000000000000e-05, 9.57999999999999976e-06, 3.17000000000000014e-06, 1.08999999999999994e-06, 4.20000000000000002e-07, 8.99999999999999986e-08, 2.00000000000000004e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[9][30] = niz9_30;
	static double niz10_1[] = { 1.00000000000000000e+00 }; repRatios[10][1] = niz10_1;
	static double niz10_2[] = { 1.89952969999999999e-01, 8.10047030000000001e-01 }; repRatios[10][2] = niz10_2;
	static double niz10_3[] = { 1.98814499999999984e-02, 4.85865499999999992e-02, 4.13085690000000005e-01, 5.18446309999999966e-01 }; repRatios[10][3] = niz10_3;
	static double niz10_4[] = { 1.99896000000000015e-03, 9.70110000000000048e-04, 1.79679100000000001e-02, 6.77120799999999939e-02, 1.90772319999999995e-01, 4.66486469999999986e-01, 2.54092150000000017e-01 }; repRatios[10][4] = niz10_4;
	static double niz10_5[] = { 1.97280000000000009e-04, 1.64199999999999986e-05, 4.34660000000000016e-04, 2.67009999999999990e-03, 9.40144000000000049e-03, 1.55367100000000005e-02, 7.74998799999999932e-02, 1.55959650000000005e-01, 3.16480150000000016e-01, 3.30349359999999981e-01, 9.14543500000000037e-02 }; repRatios[10][5] = niz10_5;
	static double niz10_6[] = { 2.08600000000000002e-05, 2.20000000000000011e-07, 8.89999999999999949e-06, 8.04300000000000007e-05, 4.17260000000000027e-04, 7.09589999999999960e-04, 1.57364000000000006e-03, 4.71595999999999994e-03, 1.53323299999999999e-02, 3.14282199999999998e-02, 7.34575199999999984e-02, 1.64685940000000003e-01, 2.44555880000000003e-01, 2.89239310000000027e-01, 1.50899439999999996e-01, 2.28744999999999990e-02 }; repRatios[10][6] = niz10_6;
	static double niz10_7[] = { 2.08999999999999989e-06, 0.00000000000000000e+00, 1.60000000000000003e-07, 1.65999999999999999e-06, 1.32400000000000003e-05, 4.43699999999999970e-05, 9.43399999999999946e-05, 3.51100000000000010e-05, 3.44010000000000008e-04, 9.45309999999999987e-04, 2.20028000000000020e-03, 3.79272999999999980e-03, 1.00563500000000004e-02, 2.31984000000000010e-02, 4.82709299999999966e-02, 8.83703099999999936e-02, 1.62290299999999998e-01, 2.24209159999999991e-01, 2.34740029999999988e-01, 1.54564349999999989e-01, 4.31721300000000030e-02, 3.65474000000000007e-03 }; repRatios[10][7] = niz10_7;
	static double niz10_8[] = { 2.29999999999999995e-07, 0.00000000000000000e+00, 0.00000000000000000e+00, 4.99999999999999977e-08, 3.20000000000000007e-07, 1.81999999999999994e-06, 6.07000000000000033e-06, 7.07000000000000007e-06, 5.66999999999999992e-06, 1.27200000000000002e-05, 6.14700000000000061e-05, 1.31270000000000009e-04, 2.95589999999999980e-04, 3.90329999999999985e-04, 8.62440000000000016e-04, 2.42382000000000014e-03, 4.85178999999999992e-03, 8.94842000000000033e-03, 1.82701200000000008e-02, 3.67135000000000031e-02, 6.72575499999999993e-02, 1.08541670000000007e-01, 1.65174270000000012e-01, 2.06281330000000013e-01, 1.94944549999999994e-01, 1.30014689999999988e-01, 4.73325699999999974e-02, 7.14465999999999973e-03, 3.26010000000000004e-04 }; repRatios[10][8] = niz10_8;
	static double niz10_9[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 5.99999999999999946e-08, 1.90000000000000007e-07, 5.79999999999999953e-07, 9.09999999999999969e-07, 1.79999999999999997e-07, 1.21999999999999997e-06, 2.15000000000000017e-06, 1.09200000000000005e-05, 1.77199999999999997e-05, 2.90900000000000010e-05, 3.98300000000000032e-05, 7.92399999999999935e-05, 1.87829999999999996e-04, 4.31210000000000013e-04, 7.61650000000000001e-04, 1.34571999999999990e-03, 2.44952000000000017e-03, 5.36103000000000014e-03, 1.01893999999999995e-02, 1.77558800000000017e-02, 3.17073699999999986e-02, 5.55872000000000033e-02, 8.88789799999999963e-02, 1.28690209999999999e-01, 1.66884510000000014e-01, 1.85142639999999997e-01, 1.58107620000000004e-01, 9.92364200000000057e-02, 3.88865899999999987e-02, 7.60803000000000000e-03, 5.93210000000000048e-04, 1.28900000000000003e-05 }; repRatios[10][9] = niz10_9;
	static double niz10_10[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.29999999999999999e-07, 1.00000000000000002e-08, 2.00000000000000004e-08, 0.00000000000000000e+00, 1.90000000000000007e-07, 3.30000000000000017e-07, 1.43999999999999998e-06, 2.30999999999999991e-06, 3.13000000000000010e-06, 3.21000000000000018e-06, 5.82000000000000018e-06, 1.46400000000000004e-05, 3.61300000000000014e-05, 6.41899999999999936e-05, 9.55300000000000018e-05, 1.56999999999999994e-04, 2.96240000000000023e-04, 5.80969999999999989e-04, 1.14382999999999998e-03, 1.98321000000000001e-03, 3.44968000000000011e-03, 6.09788999999999991e-03, 1.11836000000000001e-02, 1.95745800000000011e-02, 3.17588599999999999e-02, 5.10091100000000033e-02, 7.84351100000000023e-02, 1.11562469999999997e-01, 1.42293909999999996e-01, 1.62117889999999987e-01, 1.57007459999999988e-01, 1.20313139999999999e-01, 6.85846900000000037e-02, 2.61510899999999984e-02, 5.52346999999999994e-03, 5.31230000000000049e-04, 1.73500000000000016e-05, 1.29999999999999999e-07 }; repRatios[10][10] = niz10_10;
	static double niz10_11[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 4.99999999999999977e-08, 8.99999999999999986e-08, 2.59999999999999999e-07, 1.90000000000000007e-07, 3.09999999999999997e-07, 3.30000000000000017e-07, 5.09999999999999988e-07, 1.17999999999999993e-06, 2.39999999999999989e-06, 4.71999999999999970e-06, 9.33000000000000046e-06, 1.20699999999999996e-05, 1.75100000000000001e-05, 2.98199999999999991e-05, 6.04700000000000021e-05, 1.15710000000000002e-04, 1.96920000000000005e-04, 3.08600000000000020e-04, 5.22360000000000033e-04, 9.32160000000000020e-04, 1.66763999999999996e-03, 2.90215999999999998e-03, 4.84728999999999976e-03, 7.99443000000000029e-03, 1.33487199999999997e-02, 2.18425899999999985e-02, 3.45654899999999973e-02, 5.17599399999999973e-02, 7.46449099999999949e-02, 1.02193279999999997e-01, 1.28184149999999997e-01, 1.45195280000000010e-01, 1.44357289999999999e-01, 1.22392470000000003e-01, 8.23311800000000038e-02, 4.17935899999999985e-02, 1.45097000000000004e-02, 2.95836000000000016e-03, 2.86029999999999997e-04, 1.03800000000000006e-05, 1.19999999999999989e-07, 0.00000000000000000e+00 }; repRatios[10][11] = niz10_11;
	static double niz10_12[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.99999999999999973e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 2.99999999999999973e-08, 4.00000000000000008e-08, 7.00000000000000048e-08, 7.00000000000000048e-08, 3.30000000000000017e-07, 4.30000000000000012e-07, 8.70000000000000035e-07, 9.90000000000000050e-07, 1.41999999999999996e-06, 1.94000000000000006e-06, 2.87000000000000005e-06, 5.87999999999999961e-06, 1.09300000000000004e-05, 1.87799999999999998e-05, 2.99899999999999992e-05, 4.30699999999999993e-05, 6.83999999999999956e-05, 1.16139999999999996e-04, 2.11050000000000007e-04, 3.60140000000000004e-04, 5.79619999999999983e-04, 9.24950000000000013e-04, 1.52314000000000008e-03, 2.54965000000000009e-03, 4.22642999999999977e-03, 6.84312000000000028e-03, 1.07855199999999998e-02, 1.67579500000000006e-02, 2.58317300000000007e-02, 3.86704000000000006e-02, 5.54972899999999977e-02, 7.58620299999999970e-02, 9.85827900000000035e-02, 1.19676630000000006e-01, 1.32848780000000000e-01, 1.31896979999999997e-01, 1.14503789999999994e-01, 8.37335899999999966e-02, 4.88451800000000019e-02, 2.13271400000000014e-02, 6.41919999999999991e-03, 1.13882000000000002e-03, 9.86700000000000023e-05, 3.06999999999999983e-06, 2.99999999999999973e-08, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[10][12] = niz10_12;
	static double niz10_13[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 0.00000000000000000e+00, 5.99999999999999946e-08, 2.00000000000000004e-08, 2.99999999999999973e-08, 7.00000000000000048e-08, 1.49999999999999993e-07, 1.19999999999999989e-07, 2.10000000000000001e-07, 3.39999999999999974e-07, 6.30000000000000003e-07, 1.10000000000000006e-06, 1.99000000000000001e-06, 2.55000000000000015e-06, 3.67000000000000001e-06, 5.74000000000000010e-06, 8.37999999999999939e-06, 1.42399999999999992e-05, 2.42300000000000001e-05, 3.91000000000000017e-05, 6.24799999999999981e-05, 9.68400000000000012e-05, 1.50280000000000005e-04, 2.37879999999999992e-04, 3.90300000000000000e-04, 6.45390000000000026e-04, 1.03396999999999994e-03, 1.60031999999999991e-03, 2.52017999999999990e-03, 3.96732999999999981e-03, 6.26002999999999976e-03, 9.65944999999999998e-03, 1.46258599999999992e-02, 2.16681599999999988e-02, 3.14080600000000015e-02, 4.46202200000000021e-02, 6.09977000000000019e-02, 7.93896199999999941e-02, 9.84191600000000055e-02, 1.14351439999999999e-01, 1.23247940000000000e-01, 1.19938409999999995e-01, 1.03935020000000003e-01, 7.76313000000000003e-02, 4.83601499999999976e-02, 2.36669600000000008e-02, 8.59741999999999972e-03, 2.10007999999999983e-03, 2.95029999999999999e-04, 1.98700000000000012e-05, 4.79999999999999957e-07, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[10][13] = niz10_13;
	static double niz10_14[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 4.00000000000000008e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.00000000000000004e-08, 2.99999999999999973e-08, 1.19999999999999989e-07, 1.60000000000000003e-07, 2.80000000000000019e-07, 3.49999999999999984e-07, 4.20000000000000002e-07, 5.19999999999999998e-07, 9.50000000000000010e-07, 1.54999999999999998e-06, 2.52999999999999992e-06, 4.08999999999999980e-06, 6.80000000000000012e-06, 9.78999999999999944e-06, 1.41500000000000000e-05, 2.01799999999999999e-05, 3.39399999999999969e-05, 5.41000000000000004e-05, 8.36700000000000036e-05, 1.36410000000000003e-04, 2.00669999999999988e-04, 3.09460000000000009e-04, 4.72680000000000008e-04, 7.40439999999999978e-04, 1.16252999999999994e-03, 1.80801000000000009e-03, 2.74300000000000021e-03, 4.13882999999999959e-03, 6.23384999999999998e-03, 9.33248000000000064e-03, 1.37900799999999997e-02, 1.99434799999999995e-02, 2.81910099999999990e-02, 3.89309899999999987e-02, 5.23542999999999994e-02, 6.78572800000000059e-02, 8.44089400000000017e-02, 9.94629999999999959e-02, 1.10407510000000000e-01, 1.14034070000000001e-01, 1.07723029999999997e-01, 9.12073000000000050e-02, 6.76983899999999972e-02, 4.27599700000000013e-02, 2.19962699999999983e-02, 8.73438999999999986e-03, 2.48420000000000021e-03, 4.56169999999999991e-04, 4.52699999999999986e-05, 2.20000000000000011e-06, 8.00000000000000017e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[10][14] = niz10_14;
	static double niz10_15[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.00000000000000004e-08, 1.00000000000000002e-08, 4.00000000000000008e-08, 1.00000000000000002e-08, 1.49999999999999993e-07, 1.69999999999999987e-07, 2.80000000000000019e-07, 3.99999999999999982e-07, 8.09999999999999974e-07, 9.29999999999999990e-07, 1.52999999999999996e-06, 2.02000000000000014e-06, 2.74999999999999993e-06, 4.31000000000000024e-06, 6.19999999999999993e-06, 1.11599999999999999e-05, 1.60599999999999987e-05, 2.45199999999999990e-05, 3.36999999999999992e-05, 5.06800000000000027e-05, 7.73699999999999995e-05, 1.21470000000000001e-04, 1.83140000000000012e-04, 2.78429999999999975e-04, 4.15859999999999993e-04, 6.17539999999999973e-04, 9.34519999999999990e-04, 1.39419000000000001e-03, 2.10547999999999985e-03, 3.14043000000000004e-03, 4.61186999999999968e-03, 6.73127000000000014e-03, 9.68498999999999922e-03, 1.38759199999999999e-02, 1.95826300000000002e-02, 2.70196099999999995e-02, 3.64967000000000000e-02, 4.80009100000000008e-02, 6.13311900000000007e-02, 7.55881699999999962e-02, 8.91826800000000003e-02, 1.00052600000000005e-01, 1.05596200000000001e-01, 1.04103550000000003e-01, 9.41103900000000021e-02, 7.68665600000000004e-02, 5.54582299999999973e-02, 3.44958799999999996e-02, 1.78004099999999991e-02, 7.27208000000000021e-03, 2.19850999999999987e-03, 4.54330000000000022e-04, 5.71100000000000004e-05, 3.88000000000000012e-06, 1.19999999999999989e-07, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[10][15] = niz10_15;
	static double niz10_16[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.99999999999999973e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.00000000000000004e-08, 9.99999999999999955e-08, 1.29999999999999999e-07, 8.00000000000000017e-08, 1.49999999999999993e-07, 1.49999999999999993e-07, 2.59999999999999999e-07, 2.80000000000000019e-07, 6.09999999999999983e-07, 8.50000000000000014e-07, 1.28999999999999993e-06, 2.20000000000000011e-06, 2.96000000000000004e-06, 4.35999999999999976e-06, 5.67999999999999983e-06, 7.73000000000000053e-06, 1.16300000000000005e-05, 1.83499999999999988e-05, 2.69799999999999992e-05, 4.06499999999999987e-05, 5.67800000000000019e-05, 8.11499999999999938e-05, 1.19179999999999994e-04, 1.74870000000000011e-04, 2.65869999999999974e-04, 3.88610000000000008e-04, 5.74680000000000048e-04, 8.32990000000000032e-04, 1.22349000000000004e-03, 1.76766000000000011e-03, 2.57873999999999994e-03, 3.73596999999999992e-03, 5.37179000000000042e-03, 7.63006000000000014e-03, 1.07008099999999998e-02, 1.48428399999999995e-02, 2.03343500000000010e-02, 2.73541399999999990e-02, 3.60942200000000032e-02, 4.64283899999999999e-02, 5.82228200000000015e-02, 7.05318899999999999e-02, 8.25520599999999966e-02, 9.23656800000000056e-02, 9.82587399999999972e-02, 9.82402899999999940e-02, 9.17361700000000058e-02, 7.87844800000000040e-02, 6.13212100000000010e-02, 4.23035000000000008e-02, 2.53017599999999995e-02, 1.26800899999999998e-02, 5.09899000000000029e-03, 1.54225999999999994e-03, 3.28979999999999984e-04, 4.55699999999999991e-05, 4.21000000000000035e-06, 1.99999999999999991e-07, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[10][16] = niz10_16;
	static double niz10_17[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 4.99999999999999977e-08, 4.99999999999999977e-08, 2.99999999999999973e-08, 5.99999999999999946e-08, 5.99999999999999946e-08, 1.40000000000000010e-07, 1.60000000000000003e-07, 3.30000000000000017e-07, 3.39999999999999974e-07, 4.79999999999999957e-07, 5.60000000000000038e-07, 7.99999999999999964e-07, 1.21000000000000006e-06, 1.41000000000000005e-06, 2.07999999999999999e-06, 3.30000000000000017e-06, 4.81999999999999959e-06, 7.10999999999999969e-06, 1.00900000000000000e-05, 1.32899999999999998e-05, 1.91900000000000009e-05, 2.92899999999999991e-05, 4.14999999999999991e-05, 6.09199999999999995e-05, 9.04299999999999999e-05, 1.29309999999999994e-04, 1.86440000000000011e-04, 2.63329999999999988e-04, 3.85380000000000000e-04, 5.56779999999999992e-04, 8.01740000000000005e-04, 1.14912000000000000e-03, 1.63524000000000004e-03, 2.32684000000000016e-03, 3.29291999999999996e-03, 4.64075999999999985e-03, 6.48516000000000023e-03, 8.95600000000000042e-03, 1.22644499999999997e-02, 1.65775600000000016e-02, 2.20848000000000017e-02, 2.89289600000000001e-02, 3.71854799999999999e-02, 4.68142600000000034e-02, 5.74329999999999979e-02, 6.83286500000000047e-02, 7.85893700000000056e-02, 8.69932000000000066e-02, 9.21403499999999959e-02, 9.23909100000000066e-02, 8.72452400000000017e-02, 7.67464499999999938e-02, 6.20420500000000014e-02, 4.53763199999999978e-02, 2.94216999999999985e-02, 1.65568399999999998e-02, 7.78898999999999998e-03, 2.94590999999999993e-03, 8.48459999999999991e-04, 1.72170000000000000e-04, 2.50000000000000012e-05, 2.93999999999999980e-06, 1.69999999999999987e-07, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[10][17] = niz10_17;
	static double niz10_18[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 2.99999999999999973e-08, 2.99999999999999973e-08, 2.99999999999999973e-08, 1.10000000000000006e-07, 1.69999999999999987e-07, 8.00000000000000017e-08, 1.79999999999999997e-07, 2.59999999999999999e-07, 2.80000000000000019e-07, 5.19999999999999998e-07, 6.79999999999999948e-07, 9.70000000000000030e-07, 1.12999999999999998e-06, 1.54999999999999998e-06, 2.00999999999999981e-06, 3.13000000000000010e-06, 4.51999999999999992e-06, 5.83000000000000009e-06, 9.39999999999999979e-06, 1.28900000000000003e-05, 1.79899999999999989e-05, 2.52799999999999985e-05, 3.44300000000000007e-05, 4.96399999999999991e-05, 7.15099999999999980e-05, 1.03369999999999995e-04, 1.45620000000000005e-04, 2.09650000000000000e-04, 2.93840000000000019e-04, 4.13269999999999979e-04, 5.79230000000000023e-04, 8.18519999999999990e-04, 1.15773000000000004e-03, 1.62771000000000009e-03, 2.26360000000000016e-03, 3.15384000000000020e-03, 4.32440999999999989e-03, 5.92936999999999978e-03, 8.05502999999999948e-03, 1.08899900000000004e-02, 1.44843699999999999e-02, 1.91023900000000003e-02, 2.47833400000000009e-02, 3.15812899999999980e-02, 3.96206100000000006e-02, 4.86417300000000011e-02, 5.82836899999999991e-02, 6.78690500000000002e-02, 7.65855700000000056e-02, 8.34081099999999936e-02, 8.71218700000000040e-02, 8.67532300000000006e-02, 8.17006499999999997e-02, 7.22718499999999986e-02, 5.93180499999999972e-02, 4.46308099999999999e-02, 3.02544099999999989e-02, 1.81520600000000011e-02, 9.36600999999999927e-03, 4.03802999999999974e-03, 1.38969000000000007e-03, 3.57679999999999977e-04, 6.71600000000000007e-05, 9.44999999999999931e-06, 9.40000000000000000e-07, 8.99999999999999986e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[10][18] = niz10_18;
	static double niz10_19[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.99999999999999973e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 4.99999999999999977e-08, 2.00000000000000004e-08, 4.00000000000000008e-08, 8.00000000000000017e-08, 8.00000000000000017e-08, 8.99999999999999986e-08, 1.49999999999999993e-07, 2.20000000000000011e-07, 3.70000000000000004e-07, 3.90000000000000025e-07, 4.09999999999999992e-07, 8.29999999999999994e-07, 9.99999999999999955e-07, 1.19000000000000004e-06, 2.16999999999999998e-06, 2.43000000000000003e-06, 3.50999999999999985e-06, 4.68000000000000008e-06, 6.57999999999999968e-06, 8.99000000000000032e-06, 1.23200000000000006e-05, 1.80999999999999995e-05, 2.39699999999999992e-05, 3.29900000000000009e-05, 4.62600000000000009e-05, 6.41299999999999976e-05, 9.03200000000000026e-05, 1.23229999999999998e-04, 1.74040000000000007e-04, 2.40370000000000004e-04, 3.36279999999999999e-04, 4.67509999999999974e-04, 6.45949999999999953e-04, 8.89070000000000051e-04, 1.23120000000000000e-03, 1.69449000000000010e-03, 2.32393000000000009e-03, 3.17169000000000001e-03, 4.30555000000000000e-03, 5.78507999999999974e-03, 7.75494000000000010e-03, 1.02596600000000003e-02, 1.34972800000000004e-02, 1.75343300000000007e-02, 2.24616000000000017e-02, 2.83857599999999995e-02, 3.52627599999999972e-02, 4.30991599999999975e-02, 5.15538099999999985e-02, 6.02172100000000002e-02, 6.85217600000000010e-02, 7.56237800000000016e-02, 8.05320699999999973e-02, 8.26470499999999997e-02, 8.10413700000000015e-02, 7.55221400000000015e-02, 6.63766600000000040e-02, 5.44163800000000003e-02, 4.12414700000000023e-02, 2.84791099999999985e-02, 1.76389700000000003e-02, 9.52556000000000062e-03, 4.39301000000000014e-03, 1.67231999999999993e-03, 4.95540000000000043e-04, 1.13330000000000001e-04, 2.00899999999999991e-05, 2.65000000000000004e-06, 3.80000000000000015e-07, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[10][19] = niz10_19;
	static double niz10_20[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 1.00000000000000002e-08, 2.99999999999999973e-08, 1.00000000000000002e-08, 2.99999999999999973e-08, 7.00000000000000048e-08, 4.99999999999999977e-08, 2.99999999999999973e-08, 9.99999999999999955e-08, 2.20000000000000011e-07, 2.10000000000000001e-07, 2.39999999999999979e-07, 4.20000000000000002e-07, 4.40000000000000022e-07, 4.79999999999999957e-07, 6.40000000000000013e-07, 1.19000000000000004e-06, 1.54000000000000008e-06, 1.94000000000000006e-06, 2.84999999999999982e-06, 3.67999999999999992e-06, 5.06999999999999974e-06, 6.21999999999999974e-06, 8.69999999999999971e-06, 1.19800000000000005e-05, 1.60399999999999989e-05, 2.33799999999999998e-05, 3.30499999999999970e-05, 4.36700000000000003e-05, 6.00699999999999992e-05, 8.08900000000000065e-05, 1.15030000000000001e-04, 1.53990000000000008e-04, 2.14090000000000005e-04, 2.90669999999999980e-04, 4.02610000000000023e-04, 5.51089999999999957e-04, 7.44369999999999949e-04, 1.01490999999999994e-03, 1.37341999999999998e-03, 1.85509999999999993e-03, 2.51096999999999996e-03, 3.36022000000000013e-03, 4.48540999999999957e-03, 5.94660999999999974e-03, 7.81934999999999922e-03, 1.02156999999999994e-02, 1.32017499999999999e-02, 1.69059600000000011e-02, 2.13640200000000009e-02, 2.67235699999999986e-02, 3.28948000000000018e-02, 3.97555299999999973e-02, 4.73190299999999980e-02, 5.51563200000000017e-02, 6.27788499999999972e-02, 6.95541999999999966e-02, 7.48398400000000047e-02, 7.79133800000000043e-02, 7.80817699999999948e-02, 7.49606000000000022e-02, 6.85412799999999961e-02, 5.92133199999999998e-02, 4.79980699999999968e-02, 3.61320099999999991e-02, 2.49438199999999985e-02, 1.54862200000000002e-02, 8.53410999999999927e-03, 4.05189999999999977e-03, 1.60881999999999995e-03, 5.21160000000000004e-04, 1.30929999999999995e-04, 2.69599999999999994e-05, 4.33999999999999995e-06, 5.70000000000000048e-07, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[10][20] = niz10_20;
	static double niz10_21[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 2.99999999999999973e-08, 2.00000000000000004e-08, 2.00000000000000004e-08, 2.99999999999999973e-08, 5.99999999999999946e-08, 2.99999999999999973e-08, 5.99999999999999946e-08, 8.00000000000000017e-08, 1.10000000000000006e-07, 1.19999999999999989e-07, 1.79999999999999997e-07, 2.99999999999999986e-07, 4.79999999999999957e-07, 4.59999999999999990e-07, 6.09999999999999983e-07, 9.29999999999999990e-07, 1.23999999999999999e-06, 1.59999999999999993e-06, 2.20000000000000011e-06, 3.01999999999999988e-06, 4.12000000000000036e-06, 5.60999999999999965e-06, 7.50000000000000019e-06, 1.02699999999999999e-05, 1.25999999999999996e-05, 1.86800000000000007e-05, 2.41599999999999991e-05, 3.33400000000000027e-05, 4.35600000000000031e-05, 6.01399999999999968e-05, 8.04800000000000019e-05, 1.10569999999999993e-04, 1.51210000000000011e-04, 2.01819999999999989e-04, 2.71240000000000012e-04, 3.69289999999999983e-04, 4.95890000000000024e-04, 6.65640000000000003e-04, 8.97530000000000007e-04, 1.19489000000000010e-03, 1.59617000000000005e-03, 2.13069000000000019e-03, 2.81528999999999981e-03, 3.72731000000000017e-03, 4.88572999999999959e-03, 6.38033999999999997e-03, 8.25927000000000085e-03, 1.06121700000000006e-02, 1.35264200000000008e-02, 1.70499999999999992e-02, 2.12821600000000014e-02, 2.62705300000000003e-02, 3.19666300000000028e-02, 3.82646499999999973e-02, 4.50931200000000004e-02, 5.21220500000000031e-02, 5.90287000000000034e-02, 6.52807100000000057e-02, 7.03476100000000049e-02, 7.35911100000000012e-02, 7.44209200000000015e-02, 7.26263600000000009e-02, 6.78707999999999950e-02, 6.04926699999999984e-02, 5.10622099999999968e-02, 4.04510800000000004e-02, 2.97689099999999991e-02, 2.01927299999999990e-02, 1.23909899999999993e-02, 6.76260999999999963e-03, 3.20815999999999983e-03, 1.28415999999999990e-03, 4.21900000000000009e-04, 1.15089999999999998e-04, 2.54800000000000000e-05, 4.36999999999999966e-06, 6.19999999999999993e-07, 8.00000000000000017e-08, 2.99999999999999973e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[10][21] = niz10_21;
	static double niz10_22[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 2.00000000000000004e-08, 1.00000000000000002e-08, 4.99999999999999977e-08, 2.99999999999999973e-08, 8.99999999999999986e-08, 5.99999999999999946e-08, 1.49999999999999993e-07, 1.60000000000000003e-07, 1.79999999999999997e-07, 2.80000000000000019e-07, 2.80000000000000019e-07, 3.70000000000000004e-07, 5.99999999999999973e-07, 6.89999999999999958e-07, 8.99999999999999959e-07, 1.23999999999999999e-06, 1.79999999999999992e-06, 2.17999999999999988e-06, 2.69999999999999998e-06, 3.86000000000000031e-06, 5.22000000000000000e-06, 6.40999999999999961e-06, 8.60000000000000067e-06, 1.15099999999999999e-05, 1.47900000000000007e-05, 2.03399999999999984e-05, 2.62100000000000015e-05, 3.61099999999999982e-05, 4.78800000000000024e-05, 6.27100000000000010e-05, 8.52999999999999998e-05, 1.13330000000000001e-04, 1.53959999999999996e-04, 2.04329999999999990e-04, 2.72849999999999991e-04, 3.58919999999999986e-04, 4.80879999999999990e-04, 6.40570000000000028e-04, 8.41399999999999960e-04, 1.11673999999999996e-03, 1.47974999999999995e-03, 1.94334000000000000e-03, 2.54139000000000014e-03, 3.31547999999999999e-03, 4.30271000000000039e-03, 5.54789999999999971e-03, 7.11965999999999988e-03, 9.06691999999999915e-03, 1.14823400000000006e-02, 1.44075200000000000e-02, 1.78775699999999989e-02, 2.19695500000000009e-02, 2.67440799999999999e-02, 3.21053000000000033e-02, 3.79808300000000001e-02, 4.42072000000000020e-02, 5.06230900000000025e-02, 5.68173800000000007e-02, 6.24520299999999987e-02, 6.69940499999999994e-02, 7.00437000000000004e-02, 7.09734100000000007e-02, 6.96182399999999979e-02, 6.57602399999999976e-02, 5.94942899999999983e-02, 5.13797500000000018e-02, 4.19295299999999996e-02, 3.21358799999999986e-02, 2.29405599999999987e-02, 1.50621300000000000e-02, 8.97180000000000026e-03, 4.75950999999999978e-03, 2.19637000000000001e-03, 8.53739999999999968e-04, 2.81009999999999995e-04, 7.68400000000000029e-05, 1.69699999999999985e-05, 3.46999999999999981e-06, 6.19999999999999993e-07, 8.00000000000000017e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[10][22] = niz10_22;
	static double niz10_23[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.00000000000000004e-08, 0.00000000000000000e+00, 2.99999999999999973e-08, 2.00000000000000004e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 2.99999999999999973e-08, 2.99999999999999973e-08, 5.99999999999999946e-08, 4.99999999999999977e-08, 9.99999999999999955e-08, 7.00000000000000048e-08, 1.29999999999999999e-07, 2.10000000000000001e-07, 2.89999999999999976e-07, 3.70000000000000004e-07, 2.70000000000000009e-07, 4.79999999999999957e-07, 6.09999999999999983e-07, 8.99999999999999959e-07, 1.32999999999999997e-06, 1.23000000000000008e-06, 1.85000000000000008e-06, 2.50000000000000020e-06, 3.40000000000000006e-06, 4.78999999999999988e-06, 5.99000000000000025e-06, 7.40000000000000030e-06, 9.68000000000000049e-06, 1.29899999999999993e-05, 1.76200000000000007e-05, 2.33200000000000003e-05, 3.06100000000000000e-05, 4.13900000000000018e-05, 5.30699999999999984e-05, 7.17400000000000009e-05, 9.34999999999999959e-05, 1.23509999999999988e-04, 1.64580000000000000e-04, 2.17240000000000000e-04, 2.84650000000000007e-04, 3.74809999999999998e-04, 4.90080000000000051e-04, 6.49029999999999985e-04, 8.50159999999999978e-04, 1.10957999999999998e-03, 1.43478000000000008e-03, 1.86703999999999993e-03, 2.41674000000000012e-03, 3.11195999999999999e-03, 3.98865999999999978e-03, 5.10421999999999959e-03, 6.48425000000000043e-03, 8.18342000000000028e-03, 1.02476800000000003e-02, 1.27610399999999995e-02, 1.57769700000000013e-02, 1.92939999999999987e-02, 2.33650000000000004e-02, 2.79893200000000016e-02, 3.30999999999999975e-02, 3.86544700000000033e-02, 4.44483800000000026e-02, 5.02640599999999993e-02, 5.58072500000000027e-02, 6.07434099999999977e-02, 6.46660200000000046e-02, 6.70875199999999977e-02, 6.77813500000000041e-02, 6.63660400000000011e-02, 6.27703299999999992e-02, 5.71494899999999972e-02, 4.97749399999999967e-02, 4.13350200000000001e-02, 3.23836799999999980e-02, 2.38248700000000015e-02, 1.62869599999999996e-02, 1.02090099999999993e-02, 5.78801999999999962e-03, 2.91597999999999987e-03, 1.28052999999999999e-03, 4.83489999999999994e-04, 1.51490000000000001e-04, 4.11700000000000005e-05, 9.57999999999999976e-06, 1.83999999999999996e-06, 1.99999999999999991e-07, 5.99999999999999946e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[10][23] = niz10_23;
	static double niz10_24[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.00000000000000004e-08, 1.00000000000000002e-08, 4.99999999999999977e-08, 2.00000000000000004e-08, 4.00000000000000008e-08, 8.99999999999999986e-08, 4.99999999999999977e-08, 7.00000000000000048e-08, 1.49999999999999993e-07, 1.79999999999999997e-07, 1.69999999999999987e-07, 2.29999999999999995e-07, 3.70000000000000004e-07, 3.09999999999999997e-07, 4.20000000000000002e-07, 7.50000000000000019e-07, 8.70000000000000035e-07, 1.06000000000000002e-06, 1.72000000000000005e-06, 1.88000000000000000e-06, 2.33000000000000014e-06, 3.10999999999999987e-06, 3.98999999999999991e-06, 5.62000000000000040e-06, 6.98000000000000009e-06, 8.91999999999999930e-06, 1.26199999999999995e-05, 1.53799999999999984e-05, 2.05700000000000013e-05, 2.77300000000000005e-05, 3.57400000000000000e-05, 4.75099999999999974e-05, 6.23600000000000060e-05, 8.19400000000000049e-05, 1.06880000000000007e-04, 1.38070000000000011e-04, 1.81790000000000006e-04, 2.37719999999999994e-04, 3.06540000000000003e-04, 4.00989999999999994e-04, 5.22050000000000031e-04, 6.82279999999999952e-04, 8.79079999999999966e-04, 1.13283999999999998e-03, 1.46401999999999990e-03, 1.88293000000000011e-03, 2.40390000000000005e-03, 3.06791000000000008e-03, 3.89969999999999987e-03, 4.93935000000000034e-03, 6.20176999999999968e-03, 7.75933999999999999e-03, 9.63094999999999923e-03, 1.18810500000000006e-02, 1.45669700000000003e-02, 1.77027100000000000e-02, 2.13054500000000001e-02, 2.54315399999999990e-02, 3.00025699999999992e-02, 3.49589400000000008e-02, 4.01123499999999980e-02, 4.54516199999999981e-02, 5.07261400000000029e-02, 5.55865899999999982e-02, 5.97528199999999982e-02, 6.28471399999999958e-02, 6.46197200000000055e-02, 6.46787899999999999e-02, 6.28841499999999998e-02, 5.92636699999999975e-02, 5.38078199999999993e-02, 4.68645800000000029e-02, 3.90687600000000010e-02, 3.09133200000000011e-02, 2.30695700000000010e-02, 1.61065500000000007e-02, 1.03822800000000007e-02, 6.12804000000000040e-03, 3.25991999999999992e-03, 1.52132000000000005e-03, 6.22280000000000012e-04, 2.15999999999999992e-04, 6.42399999999999948e-05, 1.70799999999999991e-05, 3.80000000000000004e-06, 6.30000000000000003e-07, 1.40000000000000010e-07, 4.00000000000000008e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[10][24] = niz10_24;
	static double niz10_25[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 2.99999999999999973e-08, 2.99999999999999973e-08, 2.99999999999999973e-08, 4.00000000000000008e-08, 5.99999999999999946e-08, 7.00000000000000048e-08, 8.00000000000000017e-08, 9.99999999999999955e-08, 1.60000000000000003e-07, 1.40000000000000010e-07, 2.89999999999999976e-07, 2.29999999999999995e-07, 3.20000000000000007e-07, 4.79999999999999957e-07, 5.89999999999999963e-07, 9.29999999999999990e-07, 8.09999999999999974e-07, 1.32999999999999997e-06, 1.57000000000000000e-06, 2.25000000000000006e-06, 2.69000000000000008e-06, 3.43000000000000019e-06, 4.89999999999999967e-06, 6.07000000000000033e-06, 7.51000000000000009e-06, 9.53000000000000024e-06, 1.20699999999999996e-05, 1.59900000000000011e-05, 2.09199999999999996e-05, 2.68000000000000009e-05, 3.49400000000000009e-05, 4.50800000000000021e-05, 5.74600000000000021e-05, 7.48500000000000033e-05, 9.67499999999999936e-05, 1.26629999999999999e-04, 1.62509999999999987e-04, 2.10129999999999996e-04, 2.71860000000000016e-04, 3.50329999999999988e-04, 4.55730000000000002e-04, 5.83799999999999987e-04, 7.45740000000000053e-04, 9.62249999999999998e-04, 1.22049000000000007e-03, 1.55327999999999998e-03, 1.98046999999999980e-03, 2.50090999999999985e-03, 3.14789999999999992e-03, 3.95751999999999996e-03, 4.96764999999999967e-03, 6.16200999999999988e-03, 7.64814000000000032e-03, 9.42227999999999989e-03, 1.15318599999999997e-02, 1.40311700000000008e-02, 1.68800799999999987e-02, 2.02019600000000014e-02, 2.39128499999999994e-02, 2.80670499999999996e-02, 3.25243900000000002e-02, 3.73288900000000035e-02, 4.22291500000000000e-02, 4.70849900000000002e-02, 5.17036199999999987e-02, 5.58032200000000006e-02, 5.90947200000000034e-02, 6.12980700000000031e-02, 6.21562699999999996e-02, 6.14488200000000012e-02, 5.91058299999999981e-02, 5.51038599999999976e-02, 4.96711499999999972e-02, 4.29900500000000019e-02, 3.57053700000000002e-02, 2.81824900000000010e-02, 2.10850500000000010e-02, 1.48092199999999997e-02, 9.65986999999999922e-03, 5.81923999999999983e-03, 3.15842999999999983e-03, 1.53809999999999993e-03, 6.59799999999999992e-04, 2.46489999999999980e-04, 7.90400000000000022e-05, 2.32800000000000007e-05, 5.74000000000000010e-06, 1.25000000000000010e-06, 3.20000000000000007e-07, 8.00000000000000017e-08, 4.99999999999999977e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[10][25] = niz10_25;
	static double niz10_26[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 2.00000000000000004e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.99999999999999973e-08, 4.99999999999999977e-08, 4.00000000000000008e-08, 4.99999999999999977e-08, 4.00000000000000008e-08, 5.99999999999999946e-08, 8.99999999999999986e-08, 1.10000000000000006e-07, 1.79999999999999997e-07, 2.39999999999999979e-07, 3.30000000000000017e-07, 4.09999999999999992e-07, 5.50000000000000028e-07, 6.40000000000000013e-07, 9.90000000000000050e-07, 1.01999999999999998e-06, 1.28999999999999993e-06, 1.90000000000000002e-06, 2.25000000000000006e-06, 2.79999999999999987e-06, 3.61000000000000016e-06, 4.24999999999999997e-06, 6.01000000000000006e-06, 8.02999999999999935e-06, 9.75999999999999973e-06, 1.20499999999999998e-05, 1.69400000000000004e-05, 2.08800000000000000e-05, 2.70899999999999998e-05, 3.50300000000000017e-05, 4.51700000000000029e-05, 5.75299999999999998e-05, 7.45900000000000024e-05, 9.56800000000000055e-05, 1.22040000000000004e-04, 1.55560000000000008e-04, 1.94749999999999990e-04, 2.56109999999999986e-04, 3.27780000000000009e-04, 4.13190000000000020e-04, 5.32440000000000018e-04, 6.71420000000000046e-04, 8.46949999999999960e-04, 1.07364999999999999e-03, 1.35687999999999998e-03, 1.70936999999999999e-03, 2.15430999999999999e-03, 2.70040999999999988e-03, 3.38363999999999982e-03, 4.19825999999999967e-03, 5.18547000000000018e-03, 6.40571000000000022e-03, 7.85198999999999966e-03, 9.56793000000000053e-03, 1.16170100000000005e-02, 1.39702200000000002e-02, 1.67153999999999983e-02, 1.98084400000000001e-02, 2.32918899999999991e-02, 2.71164900000000000e-02, 3.12827099999999983e-02, 3.56882599999999994e-02, 4.02048699999999967e-02, 4.46794299999999991e-02, 4.89949000000000010e-02, 5.28974399999999970e-02, 5.61006199999999969e-02, 5.84109400000000015e-02, 5.96058000000000004e-02, 5.94432000000000016e-02, 5.78170299999999984e-02, 5.47246600000000014e-02, 5.02604099999999984e-02, 4.46320799999999976e-02, 3.82282800000000034e-02, 3.13797599999999996e-02, 2.44968199999999990e-02, 1.81959600000000006e-02, 1.27091800000000005e-02, 8.25481999999999952e-03, 4.95485000000000023e-03, 2.72375000000000004e-03, 1.33266999999999999e-03, 5.90919999999999987e-04, 2.25999999999999991e-04, 7.63499999999999991e-05, 2.31100000000000007e-05, 6.19999999999999993e-06, 1.48000000000000002e-06, 3.39999999999999974e-07, 7.00000000000000048e-08, 2.99999999999999973e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[10][26] = niz10_26;
	static double niz10_27[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.00000000000000004e-08, 2.99999999999999973e-08, 5.99999999999999946e-08, 7.00000000000000048e-08, 8.00000000000000017e-08, 9.99999999999999955e-08, 1.49999999999999993e-07, 1.60000000000000003e-07, 1.29999999999999999e-07, 2.49999999999999989e-07, 2.59999999999999999e-07, 4.70000000000000000e-07, 4.30000000000000012e-07, 4.79999999999999957e-07, 6.79999999999999948e-07, 1.17000000000000002e-06, 1.21000000000000006e-06, 1.43000000000000007e-06, 2.00999999999999981e-06, 2.46000000000000016e-06, 3.22999999999999999e-06, 3.88000000000000012e-06, 5.11000000000000020e-06, 6.40999999999999961e-06, 8.91999999999999930e-06, 1.08399999999999996e-05, 1.36399999999999998e-05, 1.68400000000000014e-05, 2.20799999999999987e-05, 2.82400000000000007e-05, 3.57299999999999984e-05, 4.53000000000000033e-05, 5.88200000000000027e-05, 7.46499999999999985e-05, 9.51300000000000057e-05, 1.20920000000000001e-04, 1.55439999999999989e-04, 1.94429999999999993e-04, 2.46960000000000007e-04, 3.07860000000000024e-04, 3.95249999999999985e-04, 4.95829999999999947e-04, 6.30950000000000022e-04, 7.96000000000000050e-04, 9.90500000000000061e-04, 1.24982000000000001e-03, 1.56828000000000002e-03, 1.95061999999999991e-03, 2.42898999999999980e-03, 3.01310999999999983e-03, 3.72909000000000001e-03, 4.60495000000000002e-03, 5.60847999999999989e-03, 6.86987000000000014e-03, 8.30977999999999925e-03, 1.00575700000000001e-02, 1.20534600000000002e-02, 1.43717199999999993e-02, 1.70228200000000010e-02, 1.99869800000000014e-02, 2.33230399999999997e-02, 2.69403099999999986e-02, 3.08426200000000011e-02, 3.49353599999999986e-02, 3.91600500000000018e-02, 4.32872399999999977e-02, 4.72785999999999970e-02, 5.08543700000000029e-02, 5.39017999999999997e-02, 5.60616099999999978e-02, 5.72667700000000016e-02, 5.73003700000000032e-02, 5.60566399999999979e-02, 5.34879600000000011e-02, 4.96904700000000005e-02, 4.47741499999999987e-02, 3.90068500000000026e-02, 3.27323600000000020e-02, 2.63741000000000010e-02, 2.02121000000000002e-02, 1.47438399999999994e-02, 1.00935100000000000e-02, 6.47653000000000031e-03, 3.82831000000000013e-03, 2.07478999999999997e-03, 1.00920000000000003e-03, 4.35739999999999999e-04, 1.69679999999999988e-04, 5.84999999999999989e-05, 1.72099999999999995e-05, 4.23000000000000016e-06, 1.17000000000000002e-06, 2.59999999999999999e-07, 7.00000000000000048e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[10][27] = niz10_27;
	static double niz10_28[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 2.00000000000000004e-08, 2.00000000000000004e-08, 5.99999999999999946e-08, 4.00000000000000008e-08, 7.00000000000000048e-08, 1.10000000000000006e-07, 4.00000000000000008e-08, 7.00000000000000048e-08, 8.99999999999999986e-08, 2.49999999999999989e-07, 1.99999999999999991e-07, 2.10000000000000001e-07, 2.39999999999999979e-07, 2.29999999999999995e-07, 4.89999999999999967e-07, 6.40000000000000013e-07, 9.90000000000000050e-07, 8.89999999999999949e-07, 1.28000000000000003e-06, 1.37999999999999992e-06, 1.90999999999999992e-06, 2.62999999999999981e-06, 2.93999999999999980e-06, 3.79000000000000014e-06, 4.86000000000000006e-06, 6.45000000000000008e-06, 7.67999999999999931e-06, 9.98999999999999922e-06, 1.19099999999999995e-05, 1.55600000000000001e-05, 1.95799999999999989e-05, 2.38799999999999984e-05, 3.18400000000000001e-05, 3.94800000000000015e-05, 5.02000000000000005e-05, 6.33100000000000020e-05, 8.16099999999999996e-05, 1.00309999999999993e-04, 1.24940000000000007e-04, 1.61060000000000006e-04, 2.01040000000000013e-04, 2.52600000000000014e-04, 3.16440000000000026e-04, 4.00630000000000018e-04, 4.97339999999999978e-04, 6.27210000000000007e-04, 7.80030000000000025e-04, 9.70049999999999970e-04, 1.21330000000000006e-03, 1.49625999999999991e-03, 1.86100999999999996e-03, 2.29451999999999998e-03, 2.82889000000000014e-03, 3.47773000000000006e-03, 4.24338999999999966e-03, 5.16246999999999973e-03, 6.27079999999999999e-03, 7.56246000000000002e-03, 9.09236000000000072e-03, 1.08351899999999998e-02, 1.28695600000000004e-02, 1.51953599999999998e-02, 1.78171700000000002e-02, 2.07224300000000000e-02, 2.39330599999999991e-02, 2.74274499999999991e-02, 3.11174399999999997e-02, 3.49613500000000021e-02, 3.88252700000000020e-02, 4.26108200000000006e-02, 4.62454799999999985e-02, 4.95131600000000005e-02, 5.21509200000000034e-02, 5.41199600000000017e-02, 5.51765899999999976e-02, 5.51363900000000004e-02, 5.40450400000000025e-02, 5.16576200000000013e-02, 4.82002700000000034e-02, 4.37593800000000005e-02, 3.84948300000000007e-02, 3.27738299999999969e-02, 2.68236799999999991e-02, 2.10689099999999997e-02, 1.57446000000000010e-02, 1.11657900000000001e-02, 7.46485000000000030e-03, 4.63545000000000016e-03, 2.67212999999999999e-03, 1.40323000000000010e-03, 6.64279999999999949e-04, 2.85409999999999993e-04, 1.09790000000000004e-04, 3.74599999999999971e-05, 1.18400000000000001e-05, 3.13000000000000010e-06, 8.40000000000000004e-07, 1.40000000000000010e-07, 7.00000000000000048e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[10][28] = niz10_28;
	static double niz10_29[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 4.00000000000000008e-08, 1.00000000000000002e-08, 4.00000000000000008e-08, 5.99999999999999946e-08, 5.99999999999999946e-08, 4.99999999999999977e-08, 1.49999999999999993e-07, 1.19999999999999989e-07, 1.40000000000000010e-07, 1.99999999999999991e-07, 2.20000000000000011e-07, 3.09999999999999997e-07, 3.39999999999999974e-07, 5.09999999999999988e-07, 6.40000000000000013e-07, 7.40000000000000009e-07, 1.06000000000000002e-06, 1.10000000000000006e-06, 1.50000000000000004e-06, 1.79999999999999992e-06, 2.48999999999999988e-06, 2.95000000000000013e-06, 3.67999999999999992e-06, 4.44999999999999975e-06, 5.87999999999999961e-06, 6.82999999999999983e-06, 9.73000000000000001e-06, 1.17099999999999997e-05, 1.52000000000000002e-05, 1.90200000000000009e-05, 2.26999999999999995e-05, 2.88899999999999995e-05, 3.57100000000000020e-05, 4.45999999999999999e-05, 5.58000000000000011e-05, 7.21500000000000055e-05, 8.81000000000000001e-05, 1.10119999999999996e-04, 1.39910000000000007e-04, 1.74190000000000011e-04, 2.15140000000000004e-04, 2.69079999999999992e-04, 3.34570000000000017e-04, 4.15059999999999973e-04, 5.17619999999999994e-04, 6.43449999999999946e-04, 7.90490000000000029e-04, 9.85079999999999940e-04, 1.21323000000000004e-03, 1.49865999999999997e-03, 1.84658999999999995e-03, 2.25784000000000011e-03, 2.76890999999999986e-03, 3.36980000000000005e-03, 4.08526000000000028e-03, 4.93501000000000009e-03, 5.94382999999999977e-03, 7.12300999999999993e-03, 8.53331000000000055e-03, 1.01596900000000007e-02, 1.19747399999999993e-02, 1.40328299999999996e-02, 1.64397499999999995e-02, 1.90954100000000002e-02, 2.19534400000000011e-02, 2.50948800000000000e-02, 2.84598700000000017e-02, 3.19801399999999972e-02, 3.55773799999999987e-02, 3.92074899999999976e-02, 4.26633100000000029e-02, 4.58934199999999973e-02, 4.87297400000000006e-02, 5.09735499999999994e-02, 5.25674299999999983e-02, 5.32979800000000017e-02, 5.30251799999999981e-02, 5.18029600000000021e-02, 4.93896699999999966e-02, 4.60721099999999995e-02, 4.18842800000000029e-02, 3.69283300000000023e-02, 3.15948500000000007e-02, 2.60697299999999993e-02, 2.06819999999999990e-02, 1.57109300000000014e-02, 1.13527300000000001e-02, 7.74878000000000025e-03, 4.95521999999999976e-03, 2.97678000000000005e-03, 1.64229000000000003e-03, 8.26160000000000045e-04, 3.82179999999999976e-04, 1.58059999999999988e-04, 5.89900000000000027e-05, 2.02599999999999991e-05, 5.91000000000000017e-06, 1.87000000000000010e-06, 3.90000000000000025e-07, 9.99999999999999955e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[10][29] = niz10_29;
	static double niz10_30[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.99999999999999973e-08, 2.00000000000000004e-08, 1.00000000000000002e-08, 4.99999999999999977e-08, 2.99999999999999973e-08, 2.99999999999999973e-08, 4.00000000000000008e-08, 4.00000000000000008e-08, 2.00000000000000004e-08, 5.99999999999999946e-08, 8.99999999999999986e-08, 1.19999999999999989e-07, 1.10000000000000006e-07, 2.39999999999999979e-07, 2.20000000000000011e-07, 2.59999999999999999e-07, 3.39999999999999974e-07, 3.20000000000000007e-07, 6.09999999999999983e-07, 6.30000000000000003e-07, 7.09999999999999978e-07, 7.70000000000000039e-07, 1.21999999999999997e-06, 1.37999999999999992e-06, 1.54999999999999998e-06, 1.91999999999999983e-06, 2.40999999999999980e-06, 3.05999999999999993e-06, 3.90999999999999983e-06, 4.76000000000000017e-06, 5.83000000000000009e-06, 6.99999999999999989e-06, 9.33000000000000046e-06, 1.05600000000000005e-05, 1.33800000000000006e-05, 1.73200000000000002e-05, 2.17500000000000001e-05, 2.78699999999999991e-05, 3.35500000000000023e-05, 4.15899999999999999e-05, 5.26399999999999974e-05, 6.47200000000000038e-05, 8.01499999999999966e-05, 1.01730000000000003e-04, 1.25959999999999993e-04, 1.57009999999999989e-04, 1.93200000000000007e-04, 2.37970000000000000e-04, 2.93940000000000022e-04, 3.62059999999999986e-04, 4.50800000000000007e-04, 5.62719999999999952e-04, 6.86349999999999959e-04, 8.45420000000000047e-04, 1.03520999999999995e-03, 1.26878999999999989e-03, 1.55824999999999996e-03, 1.90557000000000009e-03, 2.30174000000000004e-03, 2.80252000000000018e-03, 3.38530999999999988e-03, 4.07627999999999983e-03, 4.88802999999999981e-03, 5.86074999999999964e-03, 6.98039000000000038e-03, 8.27298999999999916e-03, 9.77893999999999985e-03, 1.14942199999999994e-02, 1.34347900000000003e-02, 1.56381699999999998e-02, 1.80284100000000017e-02, 2.06924700000000010e-02, 2.35960900000000001e-02, 2.66977699999999991e-02, 2.98846200000000006e-02, 3.32869800000000007e-02, 3.66472099999999995e-02, 3.99846900000000033e-02, 4.30328599999999992e-02, 4.58907399999999993e-02, 4.83040500000000012e-02, 5.01131999999999966e-02, 5.12787099999999982e-02, 5.15204000000000009e-02, 5.09207900000000005e-02, 4.93552699999999997e-02, 4.68195500000000014e-02, 4.34585600000000002e-02, 3.93213300000000016e-02, 3.46017600000000022e-02, 2.95649899999999993e-02, 2.43912200000000016e-02, 1.94096900000000003e-02, 1.48085300000000003e-02, 1.07837999999999996e-02, 7.44290999999999963e-03, 4.84486000000000031e-03, 2.96004000000000015e-03, 1.67574000000000000e-03, 8.74769999999999975e-04, 4.11840000000000014e-04, 1.79249999999999993e-04, 6.98000000000000026e-05, 2.52399999999999989e-05, 8.28000000000000035e-06, 2.64000000000000013e-06, 7.89999999999999954e-07, 2.49999999999999989e-07, 2.99999999999999973e-08, 4.00000000000000008e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[10][30] = niz10_30;
	static double niz11_1[] = { 1.00000000000000000e+00 }; repRatios[11][1] = niz11_1;
	static double niz11_2[] = { 1.73563799999999990e-01, 8.26436199999999954e-01 }; repRatios[11][2] = niz11_2;
	static double niz11_3[] = { 1.64810300000000007e-02, 4.09691800000000009e-02, 3.89336860000000007e-01, 5.53212930000000047e-01 }; repRatios[11][3] = niz11_3;
	static double niz11_4[] = { 1.49792999999999996e-03, 6.76680000000000033e-04, 1.39004400000000000e-02, 5.71525000000000019e-02, 1.67850300000000008e-01, 4.66322720000000024e-01, 2.92599429999999994e-01 }; repRatios[11][4] = niz11_4;
	static double niz11_5[] = { 1.34880000000000010e-04, 9.77999999999999954e-06, 2.78419999999999980e-04, 1.89184000000000010e-03, 7.08236000000000022e-03, 1.13541100000000006e-02, 6.25181699999999979e-02, 1.35694229999999999e-01, 2.99801280000000003e-01, 3.62698089999999973e-01, 1.18536840000000004e-01 }; repRatios[11][5] = niz11_5;
	static double niz11_6[] = { 1.24199999999999997e-05, 1.19999999999999989e-07, 4.17999999999999979e-06, 4.72500000000000033e-05, 2.67939999999999986e-04, 5.03430000000000023e-04, 9.79569999999999920e-04, 3.14423000000000003e-03, 1.11530099999999997e-02, 2.34852699999999991e-02, 5.70003899999999980e-02, 1.41503860000000009e-01, 2.28413260000000007e-01, 3.07316839999999980e-01, 1.90906120000000012e-01, 3.52621099999999993e-02 }; repRatios[11][6] = niz11_6;
	static double niz11_7[] = { 1.23000000000000008e-06, 0.00000000000000000e+00, 5.99999999999999946e-08, 1.04000000000000000e-06, 7.06000000000000017e-06, 2.70100000000000006e-05, 5.97900000000000018e-05, 1.78100000000000006e-05, 1.95040000000000003e-04, 5.72679999999999999e-04, 1.45203999999999993e-03, 2.47456000000000021e-03, 6.55186999999999957e-03, 1.62290499999999983e-02, 3.61131700000000000e-02, 6.85152499999999998e-02, 1.37884630000000008e-01, 2.11562009999999995e-01, 2.48896909999999999e-01, 1.94744030000000012e-01, 6.74059300000000028e-02, 7.28882999999999961e-03 }; repRatios[11][7] = niz11_7;
	static double niz11_8[] = { 1.10000000000000006e-07, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.10000000000000001e-07, 9.09999999999999969e-07, 3.08000000000000016e-06, 4.17999999999999979e-06, 2.53999999999999982e-06, 5.66000000000000002e-06, 3.22300000000000014e-05, 7.32599999999999999e-05, 1.77240000000000004e-04, 2.24899999999999991e-04, 4.72839999999999979e-04, 1.44633000000000001e-03, 3.05404999999999999e-03, 5.77716999999999987e-03, 1.19662799999999993e-02, 2.54343399999999997e-02, 5.01936499999999994e-02, 8.61021899999999951e-02, 1.41815620000000003e-01, 1.99288330000000014e-01, 2.13504969999999988e-01, 1.67985770000000006e-01, 7.63274699999999945e-02, 1.51377899999999999e-02, 9.68870000000000039e-04 }; repRatios[11][8] = niz11_8;
	static double niz11_9[] = { 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 1.19999999999999989e-07, 2.89999999999999976e-07, 4.40000000000000022e-07, 2.00000000000000004e-08, 4.70000000000000000e-07, 1.06999999999999992e-06, 5.53000000000000042e-06, 1.06200000000000000e-05, 1.66500000000000015e-05, 2.05500000000000015e-05, 3.74900000000000019e-05, 9.20200000000000033e-05, 2.29150000000000013e-04, 4.24789999999999977e-04, 7.62329999999999974e-04, 1.34420999999999998e-03, 3.10309000000000019e-03, 6.30967999999999980e-03, 1.13480600000000001e-02, 2.09896499999999986e-02, 3.89860299999999979e-02, 6.72417299999999996e-02, 1.05368600000000007e-01, 1.48967719999999998e-01, 1.86734960000000005e-01, 1.83850490000000005e-01, 1.36872319999999992e-01, 6.74768300000000015e-02, 1.77240700000000015e-02, 2.00894999999999980e-03, 7.20399999999999947e-05 }; repRatios[11][9] = niz11_9;
	static double niz11_10[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 4.99999999999999977e-08, 4.99999999999999977e-08, 2.99999999999999973e-08, 0.00000000000000000e+00, 8.00000000000000017e-08, 1.60000000000000003e-07, 5.79999999999999953e-07, 1.28000000000000003e-06, 1.79000000000000001e-06, 1.59999999999999993e-06, 2.64000000000000013e-06, 6.58999999999999959e-06, 1.66700000000000013e-05, 3.22400000000000030e-05, 4.94100000000000030e-05, 8.07499999999999977e-05, 1.43229999999999996e-04, 2.93330000000000012e-04, 6.02100000000000053e-04, 1.09007000000000006e-03, 1.91965999999999990e-03, 3.41486999999999997e-03, 6.50095000000000013e-03, 1.20969800000000002e-02, 2.05901900000000013e-02, 3.45504400000000017e-02, 5.68014199999999983e-02, 8.74576799999999960e-02, 1.22499780000000003e-01, 1.54233170000000003e-01, 1.70227810000000007e-01, 1.53073789999999987e-01, 1.05406399999999997e-01, 5.15009199999999986e-02, 1.50639899999999993e-02, 2.20510000000000020e-03, 1.32079999999999996e-04, 2.08999999999999989e-06 }; repRatios[11][10] = niz11_10;
	static double niz11_11[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 4.99999999999999977e-08, 1.40000000000000010e-07, 1.90000000000000007e-07, 9.99999999999999955e-08, 1.90000000000000007e-07, 4.09999999999999992e-07, 1.08999999999999994e-06, 2.35999999999999985e-06, 4.34999999999999986e-06, 5.57000000000000003e-06, 7.70000000000000082e-06, 1.19500000000000008e-05, 2.68600000000000003e-05, 5.33900000000000021e-05, 9.37299999999999988e-05, 1.52289999999999994e-04, 2.50459999999999984e-04, 4.49940000000000019e-04, 8.27229999999999979e-04, 1.49033999999999994e-03, 2.60595000000000011e-03, 4.39174999999999982e-03, 7.53435000000000042e-03, 1.29425700000000005e-02, 2.17193799999999999e-02, 3.45140999999999989e-02, 5.28193900000000008e-02, 7.81585000000000057e-02, 1.07265100000000002e-01, 1.34811509999999996e-01, 1.50976190000000010e-01, 1.48022569999999992e-01, 1.19456270000000003e-01, 7.51365600000000050e-02, 3.43837300000000012e-02, 1.01302900000000001e-02, 1.62969999999999999e-03, 1.20180000000000005e-04, 3.49999999999999995e-06, 0.00000000000000000e+00 }; repRatios[11][11] = niz11_11;
	static double niz11_12[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 8.99999999999999986e-08, 3.30000000000000017e-07, 2.70000000000000009e-07, 4.89999999999999967e-07, 6.70000000000000044e-07, 8.89999999999999949e-07, 2.38000000000000008e-06, 4.43999999999999984e-06, 7.31000000000000032e-06, 1.39700000000000001e-05, 1.98300000000000016e-05, 2.78600000000000009e-05, 4.88399999999999999e-05, 9.25299999999999967e-05, 1.61969999999999996e-04, 2.72400000000000008e-04, 4.34389999999999993e-04, 7.19550000000000007e-04, 1.22792999999999991e-03, 2.10799000000000012e-03, 3.54791999999999998e-03, 5.82154000000000005e-03, 9.35591000000000027e-03, 1.50473900000000008e-02, 2.38321800000000014e-02, 3.64610199999999968e-02, 5.32902400000000026e-02, 7.44963299999999995e-02, 9.90588800000000019e-02, 1.22192650000000000e-01, 1.37011460000000002e-01, 1.36935329999999994e-01, 1.18538930000000001e-01, 8.50752500000000050e-02, 4.78423499999999988e-02, 1.98970000000000015e-02, 5.50747000000000042e-03, 8.75429999999999958e-04, 6.65599999999999997e-05, 1.94000000000000006e-06, 2.99999999999999973e-08, 0.00000000000000000e+00 }; repRatios[11][12] = niz11_12;
	static double niz11_13[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 4.99999999999999977e-08, 2.99999999999999973e-08, 2.00000000000000004e-08, 1.29999999999999999e-07, 2.10000000000000001e-07, 3.49999999999999984e-07, 6.60000000000000034e-07, 1.06999999999999992e-06, 1.48999999999999992e-06, 2.15000000000000017e-06, 2.83999999999999991e-06, 5.05999999999999983e-06, 1.01699999999999992e-05, 1.54899999999999991e-05, 2.49199999999999986e-05, 4.07600000000000028e-05, 6.18299999999999959e-05, 9.89500000000000064e-05, 1.61619999999999987e-04, 2.75960000000000007e-04, 4.61770000000000019e-04, 7.28759999999999955e-04, 1.16792999999999997e-03, 1.87670999999999997e-03, 3.03877000000000010e-03, 4.92646999999999963e-03, 7.77642000000000003e-03, 1.20329300000000007e-02, 1.82748899999999985e-02, 2.74056199999999986e-02, 4.00198999999999971e-02, 5.60841300000000029e-02, 7.51116899999999948e-02, 9.55503999999999937e-02, 1.14488039999999999e-01, 1.26167210000000002e-01, 1.25974059999999999e-01, 1.11342590000000005e-01, 8.48191100000000031e-02, 5.33726299999999973e-02, 2.63478899999999988e-02, 9.61124000000000006e-03, 2.35946999999999980e-03, 3.34890000000000014e-04, 2.22299999999999989e-05, 4.49999999999999980e-07, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[11][13] = niz11_13;
	static double niz11_14[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 4.99999999999999977e-08, 8.00000000000000017e-08, 8.99999999999999986e-08, 1.79999999999999997e-07, 1.79999999999999997e-07, 2.10000000000000001e-07, 4.20000000000000002e-07, 5.99999999999999973e-07, 8.89999999999999949e-07, 1.72999999999999995e-06, 2.78999999999999997e-06, 4.07999999999999990e-06, 5.23999999999999981e-06, 8.06000000000000076e-06, 1.22100000000000000e-05, 1.97699999999999988e-05, 3.27300000000000000e-05, 5.23800000000000033e-05, 8.13799999999999967e-05, 1.22790000000000009e-04, 1.93019999999999992e-04, 3.00740000000000024e-04, 4.79089999999999995e-04, 7.76039999999999976e-04, 1.21625000000000010e-03, 1.89236999999999999e-03, 2.92276999999999988e-03, 4.50933999999999970e-03, 6.95124000000000002e-03, 1.05241499999999995e-02, 1.56622099999999993e-02, 2.27549400000000013e-02, 3.24300500000000019e-02, 4.50142300000000023e-02, 6.04818700000000001e-02, 7.77328300000000028e-02, 9.49986899999999967e-02, 1.09579750000000004e-01, 1.17548029999999998e-01, 1.15551290000000001e-01, 1.01879109999999995e-01, 7.91123999999999994e-02, 5.23349099999999984e-02, 2.83523000000000004e-02, 1.19454499999999998e-02, 3.66898000000000007e-03, 7.51040000000000019e-04, 8.57600000000000056e-05, 5.05999999999999983e-06, 1.69999999999999987e-07, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[11][14] = niz11_14;
	static double niz11_15[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 2.00000000000000004e-08, 2.99999999999999973e-08, 2.99999999999999973e-08, 4.99999999999999977e-08, 8.00000000000000017e-08, 5.99999999999999946e-08, 1.60000000000000003e-07, 2.20000000000000011e-07, 2.10000000000000001e-07, 3.49999999999999984e-07, 5.50000000000000028e-07, 7.60000000000000029e-07, 9.90000000000000050e-07, 1.37999999999999992e-06, 2.17999999999999988e-06, 3.65000000000000021e-06, 5.96999999999999959e-06, 8.23000000000000082e-06, 1.28099999999999993e-05, 1.76800000000000001e-05, 2.76100000000000016e-05, 4.20399999999999973e-05, 6.67499999999999962e-05, 1.05149999999999994e-04, 1.63090000000000012e-04, 2.42150000000000004e-04, 3.67770000000000011e-04, 5.59319999999999978e-04, 8.60909999999999996e-04, 1.32194999999999990e-03, 2.01947000000000021e-03, 3.04482000000000017e-03, 4.52979999999999963e-03, 6.71653000000000007e-03, 9.91189999999999953e-03, 1.44041499999999992e-02, 2.04931799999999997e-02, 2.86092200000000012e-02, 3.89979500000000034e-02, 5.16555600000000031e-02, 6.62149699999999980e-02, 8.15327500000000011e-02, 9.56062099999999970e-02, 1.05920979999999998e-01, 1.09719490000000003e-01, 1.04910699999999996e-01, 9.09181700000000065e-02, 7.00945800000000036e-02, 4.69983299999999979e-02, 2.64996699999999995e-02, 1.20222799999999998e-02, 4.16489000000000009e-03, 1.02953000000000007e-03, 1.58879999999999997e-04, 1.34100000000000004e-05, 4.20000000000000002e-07, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[11][15] = niz11_15;
	static double niz11_16[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 4.99999999999999977e-08, 4.00000000000000008e-08, 8.99999999999999986e-08, 1.40000000000000010e-07, 8.99999999999999986e-08, 1.40000000000000010e-07, 1.90000000000000007e-07, 3.09999999999999997e-07, 4.30000000000000012e-07, 6.40000000000000013e-07, 9.70000000000000030e-07, 1.21999999999999997e-06, 1.72000000000000005e-06, 2.47000000000000007e-06, 3.37999999999999983e-06, 5.92000000000000007e-06, 8.32999999999999987e-06, 1.28099999999999993e-05, 1.84700000000000010e-05, 2.68200000000000007e-05, 3.95399999999999975e-05, 5.90099999999999991e-05, 8.95300000000000051e-05, 1.33489999999999998e-04, 2.07020000000000007e-04, 3.12029999999999979e-04, 4.59969999999999975e-04, 6.83840000000000012e-04, 1.01606000000000005e-03, 1.51052999999999995e-03, 2.23814999999999995e-03, 3.32096999999999991e-03, 4.82323000000000040e-03, 6.98381000000000002e-03, 9.96894000000000079e-03, 1.41006800000000009e-02, 1.96473599999999991e-02, 2.68742200000000007e-02, 3.59089299999999986e-02, 4.68358399999999966e-02, 5.92602600000000021e-02, 7.26352100000000056e-02, 8.55026299999999961e-02, 9.59024799999999983e-02, 1.01765330000000001e-01, 1.01262550000000007e-01, 9.33658599999999950e-02, 7.85919800000000057e-02, 5.93614199999999981e-02, 3.93419299999999972e-02, 2.23017200000000006e-02, 1.03632599999999991e-02, 3.80948000000000007e-03, 1.02703999999999990e-03, 1.88989999999999991e-04, 2.11699999999999989e-05, 1.25000000000000010e-06, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[11][16] = niz11_16;
	static double niz11_17[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 4.99999999999999977e-08, 8.00000000000000017e-08, 8.00000000000000017e-08, 1.49999999999999993e-07, 1.49999999999999993e-07, 1.90000000000000007e-07, 3.20000000000000007e-07, 3.80000000000000015e-07, 6.30000000000000003e-07, 1.03000000000000009e-06, 1.19999999999999995e-06, 1.93000000000000016e-06, 3.09999999999999997e-06, 3.88000000000000012e-06, 5.76999999999999981e-06, 9.53000000000000024e-06, 1.22499999999999996e-05, 1.85800000000000017e-05, 2.73300000000000009e-05, 4.01500000000000001e-05, 6.00000000000000015e-05, 8.77099999999999988e-05, 1.25150000000000006e-04, 1.86789999999999992e-04, 2.77720000000000018e-04, 4.12439999999999975e-04, 5.96210000000000013e-04, 8.65879999999999970e-04, 1.25815999999999992e-03, 1.82207000000000007e-03, 2.63190999999999989e-03, 3.79299999999999993e-03, 5.38795999999999980e-03, 7.61153999999999997e-03, 1.05928700000000008e-02, 1.45956599999999999e-02, 1.98584299999999998e-02, 2.65512099999999987e-02, 3.47971399999999972e-02, 4.45510299999999984e-02, 5.56188000000000030e-02, 6.73617600000000066e-02, 7.87342300000000023e-02, 8.83459000000000050e-02, 9.46675899999999959e-02, 9.59323700000000029e-02, 9.12026600000000048e-02, 8.05295500000000053e-02, 6.51066200000000039e-02, 4.73140699999999997e-02, 3.04589899999999983e-02, 1.68840999999999991e-02, 7.80171999999999984e-03, 2.87258999999999995e-03, 8.00079999999999997e-04, 1.57219999999999989e-04, 2.01900000000000015e-05, 1.72000000000000005e-06, 1.40000000000000010e-07, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[11][17] = niz11_17;
	static double niz11_18[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 4.00000000000000008e-08, 4.99999999999999977e-08, 8.00000000000000017e-08, 1.10000000000000006e-07, 1.10000000000000006e-07, 5.99999999999999946e-08, 1.79999999999999997e-07, 1.79999999999999997e-07, 3.49999999999999984e-07, 6.89999999999999958e-07, 7.19999999999999989e-07, 1.28000000000000003e-06, 1.94999999999999996e-06, 2.39999999999999989e-06, 3.05000000000000002e-06, 5.66999999999999992e-06, 7.07000000000000007e-06, 9.65000000000000078e-06, 1.46500000000000003e-05, 2.03300000000000002e-05, 3.08400000000000029e-05, 4.46399999999999995e-05, 6.33600000000000032e-05, 9.30400000000000037e-05, 1.31230000000000002e-04, 1.85959999999999988e-04, 2.68449999999999993e-04, 3.87609999999999984e-04, 5.53349999999999979e-04, 7.96410000000000000e-04, 1.14119999999999998e-03, 1.61542999999999995e-03, 2.28902000000000012e-03, 3.20560999999999980e-03, 4.50262999999999965e-03, 6.26361000000000018e-03, 8.62112999999999942e-03, 1.17369299999999996e-02, 1.57861600000000005e-02, 2.09782999999999983e-02, 2.73770300000000001e-02, 3.51223000000000021e-02, 4.41679099999999977e-02, 5.41552800000000001e-02, 6.45178700000000049e-02, 7.45474799999999993e-02, 8.30685000000000034e-02, 8.88262100000000027e-02, 9.04747699999999960e-02, 8.72311000000000059e-02, 7.87945800000000030e-02, 6.61606500000000014e-02, 5.08775399999999989e-02, 3.52554500000000007e-02, 2.16119900000000011e-02, 1.15008799999999998e-02, 5.11088999999999988e-03, 1.83281000000000004e-03, 4.93709999999999961e-04, 9.61300000000000029e-05, 1.21600000000000005e-05, 1.10999999999999996e-06, 8.00000000000000017e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[11][18] = niz11_18;
	static double niz11_19[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.00000000000000004e-08, 2.00000000000000004e-08, 4.00000000000000008e-08, 4.00000000000000008e-08, 8.00000000000000017e-08, 4.00000000000000008e-08, 8.99999999999999986e-08, 1.79999999999999997e-07, 1.29999999999999999e-07, 3.20000000000000007e-07, 2.39999999999999979e-07, 4.79999999999999957e-07, 6.70000000000000044e-07, 7.99999999999999964e-07, 1.12999999999999998e-06, 1.87000000000000010e-06, 2.00999999999999981e-06, 3.36000000000000002e-06, 4.60000000000000000e-06, 6.31999999999999963e-06, 8.91999999999999930e-06, 1.23000000000000008e-05, 1.71300000000000003e-05, 2.40400000000000002e-05, 3.46000000000000008e-05, 4.93700000000000033e-05, 6.82600000000000004e-05, 9.59700000000000044e-05, 1.40149999999999991e-04, 1.96180000000000009e-04, 2.78119999999999973e-04, 3.92219999999999982e-04, 5.52760000000000013e-04, 7.82229999999999970e-04, 1.09362999999999995e-03, 1.52417000000000004e-03, 2.12505999999999980e-03, 2.93708999999999984e-03, 4.03857999999999995e-03, 5.53134000000000004e-03, 7.49171000000000038e-03, 1.00815499999999999e-02, 1.34159299999999995e-02, 1.76410600000000001e-02, 2.28539100000000016e-02, 2.91902399999999992e-02, 3.66541000000000020e-02, 4.50503500000000029e-02, 5.42393600000000004e-02, 6.35430200000000056e-02, 7.22922700000000057e-02, 7.95309899999999959e-02, 8.42918099999999948e-02, 8.55109599999999970e-02, 8.24811800000000012e-02, 7.52102199999999943e-02, 6.41995600000000027e-02, 5.07763899999999976e-02, 3.67856900000000028e-02, 2.40108100000000005e-02, 1.38219799999999993e-02, 6.89274999999999957e-03, 2.86248000000000015e-03, 9.52359999999999969e-04, 2.42870000000000011e-04, 4.50300000000000009e-05, 6.27000000000000011e-06, 4.79999999999999957e-07, 8.99999999999999986e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[11][19] = niz11_19;
	static double niz11_20[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 8.00000000000000017e-08, 4.00000000000000008e-08, 8.00000000000000017e-08, 4.99999999999999977e-08, 4.99999999999999977e-08, 1.99999999999999991e-07, 1.49999999999999993e-07, 3.09999999999999997e-07, 3.90000000000000025e-07, 5.60000000000000038e-07, 9.40000000000000000e-07, 1.23999999999999999e-06, 1.72999999999999995e-06, 2.30000000000000000e-06, 3.31999999999999998e-06, 4.23000000000000016e-06, 5.66000000000000002e-06, 8.43000000000000060e-06, 1.15199999999999998e-05, 1.58200000000000010e-05, 2.23300000000000014e-05, 2.95199999999999986e-05, 4.22000000000000025e-05, 5.69299999999999987e-05, 8.21200000000000066e-05, 1.10740000000000000e-04, 1.55479999999999995e-04, 2.18010000000000008e-04, 3.02049999999999996e-04, 4.21549999999999974e-04, 5.79839999999999978e-04, 8.03769999999999984e-04, 1.10250999999999991e-03, 1.52268000000000000e-03, 2.08544000000000004e-03, 2.84323999999999992e-03, 3.85665000000000010e-03, 5.17054000000000038e-03, 6.91837000000000008e-03, 9.18320000000000074e-03, 1.20716100000000000e-02, 1.57139199999999993e-02, 2.01726399999999986e-02, 2.55971400000000009e-02, 3.19372699999999968e-02, 3.91386899999999968e-02, 4.71354699999999988e-02, 5.55071599999999998e-02, 6.37213600000000047e-02, 7.11278999999999939e-02, 7.70752100000000051e-02, 8.04547800000000035e-02, 8.07067199999999957e-02, 7.74649300000000013e-02, 7.04507899999999992e-02, 6.04140300000000005e-02, 4.83547000000000005e-02, 3.57151900000000008e-02, 2.40828699999999993e-02, 1.45527799999999995e-02, 7.71174999999999986e-03, 3.50509000000000020e-03, 1.31920999999999991e-03, 3.94829999999999986e-04, 9.17399999999999992e-05, 1.57500000000000000e-05, 2.03000000000000005e-06, 1.40000000000000010e-07, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[11][20] = niz11_20;
	static double niz11_21[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 2.99999999999999973e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 2.99999999999999973e-08, 5.99999999999999946e-08, 2.00000000000000004e-08, 2.99999999999999973e-08, 2.99999999999999973e-08, 8.99999999999999986e-08, 1.49999999999999993e-07, 8.99999999999999986e-08, 1.90000000000000007e-07, 2.89999999999999976e-07, 3.70000000000000004e-07, 4.99999999999999977e-07, 6.09999999999999983e-07, 9.50000000000000010e-07, 1.12000000000000008e-06, 1.77999999999999990e-06, 2.20000000000000011e-06, 3.10999999999999987e-06, 4.31000000000000024e-06, 5.87999999999999961e-06, 7.34000000000000003e-06, 1.02000000000000006e-05, 1.50999999999999994e-05, 2.02999999999999988e-05, 2.81699999999999996e-05, 3.82000000000000002e-05, 5.19999999999999968e-05, 7.35200000000000008e-05, 9.97499999999999987e-05, 1.36019999999999989e-04, 1.87059999999999988e-04, 2.52429999999999994e-04, 3.47819999999999987e-04, 4.78640000000000012e-04, 6.51740000000000045e-04, 8.80849999999999971e-04, 1.19910999999999998e-03, 1.60954999999999996e-03, 2.16978000000000006e-03, 2.90286000000000016e-03, 3.87873999999999988e-03, 5.14621999999999996e-03, 6.78974999999999978e-03, 8.86541000000000065e-03, 1.14854299999999996e-02, 1.47418700000000007e-02, 1.87046600000000014e-02, 2.34519299999999993e-02, 2.91010899999999996e-02, 3.54501600000000014e-02, 4.24757600000000013e-02, 4.99302800000000005e-02, 5.74360299999999990e-02, 6.45769999999999955e-02, 7.06440599999999946e-02, 7.50387299999999979e-02, 7.70138199999999967e-02, 7.60273499999999935e-02, 7.19425800000000060e-02, 6.47705900000000029e-02, 5.51895899999999967e-02, 4.40821699999999969e-02, 3.27141300000000010e-02, 2.23110200000000009e-02, 1.37661199999999997e-02, 7.55926999999999988e-03, 3.61838000000000003e-03, 1.46038000000000005e-03, 4.86610000000000005e-04, 1.27460000000000003e-04, 2.66399999999999990e-05, 3.91999999999999974e-06, 5.09999999999999988e-07, 2.99999999999999973e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[11][21] = niz11_21;
	static double niz11_22[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.99999999999999973e-08, 4.99999999999999977e-08, 4.00000000000000008e-08, 8.99999999999999986e-08, 7.00000000000000048e-08, 1.90000000000000007e-07, 2.39999999999999979e-07, 2.29999999999999995e-07, 4.09999999999999992e-07, 6.40000000000000013e-07, 6.99999999999999968e-07, 8.99999999999999959e-07, 1.41000000000000005e-06, 1.59999999999999993e-06, 2.65999999999999994e-06, 2.97999999999999984e-06, 4.09999999999999971e-06, 5.87999999999999961e-06, 7.65999999999999951e-06, 1.02899999999999997e-05, 1.52200000000000000e-05, 1.98500000000000014e-05, 2.69599999999999994e-05, 3.63900000000000023e-05, 4.99100000000000016e-05, 6.68400000000000038e-05, 9.19200000000000008e-05, 1.23360000000000012e-04, 1.67579999999999991e-04, 2.26199999999999996e-04, 3.04259999999999991e-04, 4.07020000000000016e-04, 5.50770000000000014e-04, 7.42229999999999973e-04, 9.90699999999999957e-04, 1.32568000000000009e-03, 1.76297999999999993e-03, 2.35183000000000007e-03, 3.09031000000000019e-03, 4.07237999999999958e-03, 5.31021000000000010e-03, 6.90745999999999982e-03, 8.89610000000000053e-03, 1.13682599999999998e-02, 1.44715999999999994e-02, 1.81271399999999999e-02, 2.25218699999999994e-02, 2.76117700000000008e-02, 3.33657300000000032e-02, 3.96950400000000009e-02, 4.63872999999999994e-02, 5.32710900000000001e-02, 5.98491300000000004e-02, 6.56747899999999968e-02, 7.02275700000000030e-02, 7.28746900000000059e-02, 7.31311000000000044e-02, 7.08069100000000007e-02, 6.57218299999999950e-02, 5.82205999999999974e-02, 4.88771399999999995e-02, 3.86160300000000026e-02, 2.84573499999999993e-02, 1.92907699999999988e-02, 1.19629899999999997e-02, 6.63772999999999967e-03, 3.25193000000000010e-03, 1.35841000000000000e-03, 4.72089999999999988e-04, 1.34899999999999999e-04, 3.15900000000000008e-05, 5.36000000000000035e-06, 7.70000000000000039e-07, 1.29999999999999999e-07, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[11][22] = niz11_22;
	static double niz11_23[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 4.00000000000000008e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 2.99999999999999973e-08, 8.00000000000000017e-08, 4.99999999999999977e-08, 2.00000000000000004e-08, 4.00000000000000008e-08, 1.29999999999999999e-07, 2.10000000000000001e-07, 1.49999999999999993e-07, 1.69999999999999987e-07, 3.09999999999999997e-07, 2.70000000000000009e-07, 3.90000000000000025e-07, 4.70000000000000000e-07, 7.50000000000000019e-07, 9.50000000000000010e-07, 1.43999999999999998e-06, 1.54000000000000008e-06, 2.22999999999999982e-06, 2.46000000000000016e-06, 3.40999999999999996e-06, 4.79999999999999978e-06, 6.31999999999999963e-06, 8.39999999999999920e-06, 1.20100000000000002e-05, 1.58499999999999990e-05, 2.04800000000000004e-05, 2.80700000000000006e-05, 3.62699999999999966e-05, 4.79100000000000004e-05, 6.54600000000000001e-05, 8.78800000000000056e-05, 1.17640000000000005e-04, 1.56629999999999996e-04, 2.11740000000000002e-04, 2.80899999999999997e-04, 3.74030000000000022e-04, 4.95349999999999979e-04, 6.63019999999999951e-04, 8.83600000000000010e-04, 1.15989999999999995e-03, 1.53035999999999992e-03, 2.00813999999999984e-03, 2.61904999999999994e-03, 3.40965000000000018e-03, 4.42081999999999978e-03, 5.69358000000000017e-03, 7.31340000000000028e-03, 9.28870000000000043e-03, 1.17326700000000006e-02, 1.46717800000000006e-02, 1.81659300000000003e-02, 2.23190800000000016e-02, 2.70432100000000016e-02, 3.23535000000000003e-02, 3.82029899999999992e-02, 4.43638299999999999e-02, 5.06451600000000016e-02, 5.66604699999999975e-02, 6.20632299999999970e-02, 6.64546099999999973e-02, 6.92398999999999931e-02, 7.00402700000000017e-02, 6.86462500000000059e-02, 6.47985900000000031e-02, 5.87176199999999981e-02, 5.08109399999999989e-02, 4.17795399999999970e-02, 3.23111999999999983e-02, 2.33502699999999994e-02, 1.56373300000000014e-02, 9.57844000000000056e-03, 5.27141999999999975e-03, 2.56053000000000010e-03, 1.07736000000000008e-03, 3.84310000000000012e-04, 1.11550000000000001e-04, 2.63599999999999983e-05, 5.42999999999999968e-06, 9.79999999999999934e-07, 7.00000000000000048e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[11][23] = niz11_23;
	static double niz11_24[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.00000000000000004e-08, 4.99999999999999977e-08, 2.00000000000000004e-08, 4.99999999999999977e-08, 4.99999999999999977e-08, 7.00000000000000048e-08, 4.99999999999999977e-08, 4.99999999999999977e-08, 1.60000000000000003e-07, 1.49999999999999993e-07, 1.99999999999999991e-07, 2.80000000000000019e-07, 3.70000000000000004e-07, 3.59999999999999994e-07, 4.40000000000000022e-07, 6.09999999999999983e-07, 6.99999999999999968e-07, 9.90000000000000050e-07, 1.39999999999999994e-06, 2.02000000000000014e-06, 2.20000000000000011e-06, 3.48000000000000014e-06, 4.35999999999999976e-06, 5.74000000000000010e-06, 7.07000000000000007e-06, 8.98000000000000042e-06, 1.25400000000000002e-05, 1.67100000000000009e-05, 2.28199999999999984e-05, 2.96099999999999994e-05, 3.87799999999999980e-05, 5.15700000000000026e-05, 6.86000000000000005e-05, 9.00399999999999985e-05, 1.19350000000000001e-04, 1.58450000000000003e-04, 2.08829999999999991e-04, 2.74409999999999997e-04, 3.67619999999999980e-04, 4.78630000000000017e-04, 6.27790000000000032e-04, 8.23419999999999946e-04, 1.07511999999999994e-03, 1.39830000000000011e-03, 1.80808000000000010e-03, 2.35369999999999980e-03, 3.03387000000000014e-03, 3.89072999999999980e-03, 4.98367999999999988e-03, 6.32774000000000010e-03, 8.00773999999999930e-03, 1.00269000000000000e-02, 1.24868700000000006e-02, 1.54293099999999999e-02, 1.88511799999999986e-02, 2.29030300000000013e-02, 2.73615000000000004e-02, 3.23959799999999978e-02, 3.78333900000000015e-02, 4.34766399999999970e-02, 4.93003899999999995e-02, 5.47385700000000003e-02, 5.96950200000000014e-02, 6.36037700000000039e-02, 6.61970600000000020e-02, 6.70323000000000030e-02, 6.59657700000000069e-02, 6.27111499999999933e-02, 5.75991699999999981e-02, 5.06801200000000021e-02, 4.26188200000000017e-02, 3.39760500000000007e-02, 2.55953800000000009e-02, 1.79735199999999998e-02, 1.17000699999999999e-02, 6.97535999999999989e-03, 3.72624000000000002e-03, 1.77020999999999993e-03, 7.21790000000000040e-04, 2.50539999999999997e-04, 7.30400000000000054e-05, 1.79899999999999989e-05, 3.98000000000000001e-06, 7.29999999999999999e-07, 8.00000000000000017e-08, 2.99999999999999973e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[11][24] = niz11_24;
	static double niz11_25[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 2.99999999999999973e-08, 4.99999999999999977e-08, 4.99999999999999977e-08, 8.00000000000000017e-08, 8.99999999999999986e-08, 1.49999999999999993e-07, 9.99999999999999955e-08, 1.49999999999999993e-07, 1.90000000000000007e-07, 1.90000000000000007e-07, 3.20000000000000007e-07, 4.70000000000000000e-07, 5.09999999999999988e-07, 5.99999999999999973e-07, 7.40000000000000009e-07, 8.09999999999999974e-07, 1.34000000000000009e-06, 1.63999999999999997e-06, 1.98000000000000010e-06, 2.55000000000000015e-06, 3.87000000000000022e-06, 5.00000000000000041e-06, 6.08000000000000023e-06, 8.49999999999999993e-06, 1.13100000000000001e-05, 1.46700000000000002e-05, 1.93299999999999996e-05, 2.50000000000000012e-05, 3.25099999999999988e-05, 4.26700000000000031e-05, 5.57799999999999979e-05, 7.44300000000000040e-05, 9.70200000000000028e-05, 1.27489999999999987e-04, 1.65859999999999987e-04, 2.13880000000000005e-04, 2.82469999999999998e-04, 3.67750000000000021e-04, 4.82959999999999997e-04, 6.21739999999999966e-04, 8.04680000000000000e-04, 1.04283000000000002e-03, 1.33360000000000011e-03, 1.72561000000000003e-03, 2.21566999999999988e-03, 2.82650999999999996e-03, 3.59740000000000016e-03, 4.55144000000000035e-03, 5.72822999999999995e-03, 7.19809999999999981e-03, 8.95630000000000037e-03, 1.10927600000000001e-02, 1.36357700000000002e-02, 1.66040800000000002e-02, 2.00649000000000001e-02, 2.39790900000000015e-02, 2.83613999999999984e-02, 3.31398399999999968e-02, 3.82437399999999983e-02, 4.35092399999999976e-02, 4.87347200000000022e-02, 5.36924500000000027e-02, 5.80210300000000012e-02, 6.14531300000000016e-02, 6.36883200000000066e-02, 6.42980900000000022e-02, 6.32107600000000047e-02, 6.02454300000000026e-02, 5.54854899999999984e-02, 4.92606999999999975e-02, 4.19495800000000002e-02, 3.40350700000000006e-02, 2.61972099999999986e-02, 1.89750900000000000e-02, 1.28250399999999994e-02, 8.02519999999999969e-03, 4.57663999999999987e-03, 2.35478999999999983e-03, 1.06813999999999997e-03, 4.25939999999999977e-04, 1.42439999999999998e-04, 4.00700000000000009e-05, 1.03299999999999994e-05, 2.04999999999999985e-06, 4.70000000000000000e-07, 1.40000000000000010e-07, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[11][25] = niz11_25;
	static double niz11_26[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 4.99999999999999977e-08, 2.00000000000000004e-08, 2.00000000000000004e-08, 1.00000000000000002e-08, 4.00000000000000008e-08, 4.99999999999999977e-08, 4.00000000000000008e-08, 7.00000000000000048e-08, 1.10000000000000006e-07, 1.60000000000000003e-07, 2.20000000000000011e-07, 1.99999999999999991e-07, 3.39999999999999974e-07, 4.20000000000000002e-07, 4.70000000000000000e-07, 7.50000000000000019e-07, 8.80000000000000045e-07, 1.26000000000000001e-06, 2.00999999999999981e-06, 2.43999999999999993e-06, 3.00000000000000008e-06, 3.62999999999999997e-06, 4.74000000000000036e-06, 6.29999999999999982e-06, 7.72000000000000062e-06, 9.85000000000000056e-06, 1.31099999999999998e-05, 1.76499999999999987e-05, 2.22800000000000001e-05, 2.97900000000000011e-05, 3.77299999999999996e-05, 4.88699999999999980e-05, 6.44999999999999957e-05, 8.19900000000000061e-05, 1.06869999999999998e-04, 1.39240000000000002e-04, 1.78480000000000012e-04, 2.32799999999999994e-04, 3.02870000000000006e-04, 3.87140000000000010e-04, 5.01350000000000016e-04, 6.40040000000000032e-04, 8.24430000000000020e-04, 1.06594999999999997e-03, 1.35237000000000009e-03, 1.72064000000000006e-03, 2.18357000000000013e-03, 2.77049000000000002e-03, 3.49587999999999982e-03, 4.38546999999999982e-03, 5.47902000000000024e-03, 6.79977000000000012e-03, 8.41111999999999936e-03, 1.03069000000000008e-02, 1.25779700000000008e-02, 1.52571400000000006e-02, 1.83414000000000008e-02, 2.17951299999999994e-02, 2.57248599999999987e-02, 2.99917700000000009e-02, 3.46207700000000021e-02, 3.94388099999999978e-02, 4.42998400000000001e-02, 4.90204200000000020e-02, 5.33865300000000015e-02, 5.70776500000000006e-02, 5.98391699999999971e-02, 6.14701799999999993e-02, 6.16078099999999990e-02, 6.02125400000000019e-02, 5.71351100000000028e-02, 5.25619599999999979e-02, 4.66439900000000032e-02, 3.98358499999999990e-02, 3.25352100000000019e-02, 2.53534200000000015e-02, 1.86692700000000017e-02, 1.29164699999999993e-02, 8.32813999999999950e-03, 4.93521999999999971e-03, 2.65900999999999985e-03, 1.28472000000000005e-03, 5.44360000000000026e-04, 2.02360000000000007e-04, 6.42300000000000000e-05, 1.80200000000000003e-05, 4.44999999999999975e-06, 8.40000000000000004e-07, 1.60000000000000003e-07, 4.00000000000000008e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[11][26] = niz11_26;
	static double niz11_27[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 2.99999999999999973e-08, 1.00000000000000002e-08, 2.99999999999999973e-08, 2.00000000000000004e-08, 4.99999999999999977e-08, 4.99999999999999977e-08, 4.99999999999999977e-08, 4.99999999999999977e-08, 8.99999999999999986e-08, 5.99999999999999946e-08, 8.00000000000000017e-08, 8.99999999999999986e-08, 2.39999999999999979e-07, 1.49999999999999993e-07, 2.89999999999999976e-07, 3.39999999999999974e-07, 5.19999999999999998e-07, 5.09999999999999988e-07, 8.50000000000000014e-07, 8.70000000000000035e-07, 1.30000000000000005e-06, 1.70000000000000003e-06, 1.65000000000000008e-06, 2.59000000000000019e-06, 3.48000000000000014e-06, 4.74000000000000036e-06, 5.59999999999999975e-06, 7.00999999999999980e-06, 9.01000000000000013e-06, 1.28300000000000008e-05, 1.60199999999999991e-05, 2.01799999999999999e-05, 2.72700000000000015e-05, 3.47800000000000024e-05, 4.50400000000000025e-05, 5.77299999999999978e-05, 7.52900000000000059e-05, 9.56800000000000055e-05, 1.23459999999999987e-04, 1.59130000000000003e-04, 2.03360000000000005e-04, 2.61690000000000024e-04, 3.32910000000000009e-04, 4.25260000000000004e-04, 5.46130000000000031e-04, 6.94130000000000051e-04, 8.83120000000000042e-04, 1.11958999999999995e-03, 1.41135000000000002e-03, 1.78673999999999999e-03, 2.23754000000000010e-03, 2.82059999999999993e-03, 3.51841999999999997e-03, 4.37842000000000005e-03, 5.41076999999999964e-03, 6.67735000000000030e-03, 8.19555999999999930e-03, 9.95846000000000058e-03, 1.20747700000000003e-02, 1.45281600000000000e-02, 1.73120600000000006e-02, 2.05060599999999996e-02, 2.40781000000000016e-02, 2.79681999999999986e-02, 3.21730000000000002e-02, 3.65838900000000009e-02, 4.10877099999999995e-02, 4.55310300000000001e-02, 4.97000599999999973e-02, 5.34185199999999971e-02, 5.63840999999999995e-02, 5.84712000000000010e-02, 5.92828800000000031e-02, 5.88349199999999989e-02, 5.69770799999999994e-02, 5.36758599999999989e-02, 4.89794100000000010e-02, 4.33070799999999978e-02, 3.68828400000000001e-02, 3.01103300000000011e-02, 2.34640500000000002e-02, 1.73721499999999994e-02, 1.20954300000000008e-02, 7.91922999999999933e-03, 4.79885000000000034e-03, 2.65372999999999998e-03, 1.32138000000000004e-03, 5.93149999999999971e-04, 2.33539999999999990e-04, 7.93699999999999939e-05, 2.37700000000000011e-05, 6.19000000000000003e-06, 1.21999999999999997e-06, 2.80000000000000019e-07, 8.99999999999999986e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[11][27] = niz11_27;
	static double niz11_28[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 2.00000000000000004e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.99999999999999973e-08, 5.99999999999999946e-08, 4.99999999999999977e-08, 4.99999999999999977e-08, 2.99999999999999973e-08, 4.00000000000000008e-08, 4.00000000000000008e-08, 8.99999999999999986e-08, 1.19999999999999989e-07, 1.19999999999999989e-07, 9.99999999999999955e-08, 1.69999999999999987e-07, 2.10000000000000001e-07, 2.80000000000000019e-07, 4.09999999999999992e-07, 6.50000000000000024e-07, 7.60000000000000029e-07, 8.09999999999999974e-07, 1.15999999999999991e-06, 1.28000000000000003e-06, 1.94999999999999996e-06, 2.69999999999999998e-06, 2.93999999999999980e-06, 3.70000000000000015e-06, 4.67000000000000018e-06, 5.99000000000000025e-06, 7.92000000000000040e-06, 9.73000000000000001e-06, 1.24900000000000007e-05, 1.68899999999999992e-05, 2.10800000000000015e-05, 2.66399999999999990e-05, 3.49900000000000021e-05, 4.40799999999999981e-05, 5.58299999999999991e-05, 7.17100000000000029e-05, 9.19100000000000060e-05, 1.15899999999999998e-04, 1.45489999999999991e-04, 1.86440000000000011e-04, 2.38989999999999987e-04, 3.01649999999999987e-04, 3.79470000000000024e-04, 4.80120000000000004e-04, 6.10370000000000053e-04, 7.67169999999999961e-04, 9.63019999999999978e-04, 1.21096000000000007e-03, 1.52239999999999993e-03, 1.90440000000000010e-03, 2.37359000000000007e-03, 2.95977999999999996e-03, 3.65484999999999985e-03, 4.50839000000000014e-03, 5.55194999999999994e-03, 6.77705999999999968e-03, 8.22868000000000037e-03, 9.93661000000000023e-03, 1.19653899999999994e-02, 1.42700899999999992e-02, 1.69006699999999996e-02, 1.98764399999999987e-02, 2.31792800000000000e-02, 2.68094600000000002e-02, 3.06696299999999998e-02, 3.47863600000000023e-02, 3.89213699999999968e-02, 4.30078799999999983e-02, 4.70084699999999966e-02, 5.05546099999999998e-02, 5.35465899999999981e-02, 5.57218699999999997e-02, 5.69660599999999989e-02, 5.70539499999999991e-02, 5.58890900000000024e-02, 5.33920999999999979e-02, 4.96894400000000014e-02, 4.48517999999999972e-02, 3.92094200000000018e-02, 3.30997000000000027e-02, 2.68329999999999992e-02, 2.08186900000000008e-02, 1.53445700000000001e-02, 1.06968099999999993e-02, 6.99061000000000040e-03, 4.23747000000000013e-03, 2.37703000000000003e-03, 1.20477999999999991e-03, 5.51660000000000041e-04, 2.22140000000000011e-04, 8.05300000000000032e-05, 2.52399999999999989e-05, 6.48999999999999970e-06, 1.70999999999999993e-06, 3.99999999999999982e-07, 1.10000000000000006e-07, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[11][28] = niz11_28;
	static double niz11_29[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 4.99999999999999977e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 4.00000000000000008e-08, 2.99999999999999973e-08, 9.99999999999999955e-08, 1.29999999999999999e-07, 8.00000000000000017e-08, 1.79999999999999997e-07, 2.10000000000000001e-07, 1.79999999999999997e-07, 3.70000000000000004e-07, 3.59999999999999994e-07, 5.89999999999999963e-07, 5.60000000000000038e-07, 6.99999999999999968e-07, 1.08000000000000004e-06, 1.72999999999999995e-06, 1.70000000000000003e-06, 2.21000000000000002e-06, 2.70999999999999989e-06, 3.36000000000000002e-06, 4.13000000000000027e-06, 5.39000000000000006e-06, 6.72999999999999994e-06, 8.43000000000000060e-06, 1.11999999999999995e-05, 1.37700000000000003e-05, 1.79200000000000012e-05, 2.29699999999999986e-05, 2.82800000000000003e-05, 3.40299999999999978e-05, 4.43100000000000010e-05, 5.63200000000000029e-05, 7.22900000000000007e-05, 9.06100000000000015e-05, 1.12759999999999998e-04, 1.45200000000000006e-04, 1.81330000000000000e-04, 2.26290000000000004e-04, 2.87189999999999993e-04, 3.59830000000000002e-04, 4.49340000000000004e-04, 5.58169999999999977e-04, 7.02189999999999997e-04, 8.79919999999999964e-04, 1.09968000000000002e-03, 1.36201000000000009e-03, 1.69517999999999991e-03, 2.10954999999999997e-03, 2.59589000000000000e-03, 3.20282999999999983e-03, 3.92097000000000018e-03, 4.79981999999999978e-03, 5.82060000000000043e-03, 7.07085000000000005e-03, 8.51009999999999961e-03, 1.01982300000000008e-02, 1.21696800000000004e-02, 1.43878800000000005e-02, 1.69292400000000016e-02, 1.97520800000000017e-02, 2.28752499999999998e-02, 2.62998099999999999e-02, 2.99676499999999985e-02, 3.37618400000000013e-02, 3.76508300000000032e-02, 4.14812099999999975e-02, 4.51938699999999971e-02, 4.84895700000000027e-02, 5.13630699999999968e-02, 5.35289499999999988e-02, 5.47727299999999986e-02, 5.50976499999999980e-02, 5.42734100000000011e-02, 5.23197700000000016e-02, 4.92070199999999972e-02, 4.50651700000000016e-02, 4.01494199999999982e-02, 3.46271299999999990e-02, 2.87535099999999995e-02, 2.30029399999999995e-02, 1.76150899999999999e-02, 1.28304000000000005e-02, 8.86883999999999936e-03, 5.72789000000000024e-03, 3.45680999999999983e-03, 1.93399999999999996e-03, 9.87870000000000067e-04, 4.52780000000000012e-04, 1.87180000000000007e-04, 6.79100000000000054e-05, 2.19200000000000002e-05, 6.37000000000000000e-06, 1.81000000000000003e-06, 4.59999999999999990e-07, 1.99999999999999991e-07, 4.99999999999999977e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[11][29] = niz11_29;
	static double niz11_30[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 4.00000000000000008e-08, 2.99999999999999973e-08, 2.00000000000000004e-08, 2.00000000000000004e-08, 9.99999999999999955e-08, 4.99999999999999977e-08, 9.99999999999999955e-08, 1.19999999999999989e-07, 1.49999999999999993e-07, 1.40000000000000010e-07, 1.99999999999999991e-07, 3.49999999999999984e-07, 3.80000000000000015e-07, 4.79999999999999957e-07, 4.89999999999999967e-07, 6.79999999999999948e-07, 1.04999999999999990e-06, 1.01999999999999998e-06, 1.35999999999999990e-06, 1.99999999999999991e-06, 2.38999999999999999e-06, 2.77000000000000016e-06, 3.76000000000000000e-06, 4.50000000000000011e-06, 5.99000000000000025e-06, 7.32000000000000022e-06, 8.60000000000000067e-06, 1.14300000000000007e-05, 1.51500000000000006e-05, 1.82400000000000015e-05, 2.31399999999999987e-05, 3.03699999999999989e-05, 3.74000000000000011e-05, 4.52599999999999970e-05, 5.79200000000000011e-05, 7.24599999999999940e-05, 9.18999999999999976e-05, 1.11880000000000006e-04, 1.44670000000000009e-04, 1.80730000000000013e-04, 2.22310000000000004e-04, 2.80980000000000010e-04, 3.52629999999999990e-04, 4.41629999999999985e-04, 5.46539999999999982e-04, 6.74200000000000016e-04, 8.41790000000000030e-04, 1.03906000000000007e-03, 1.29187000000000008e-03, 1.58683000000000001e-03, 1.96213999999999980e-03, 2.40019999999999990e-03, 2.93039000000000016e-03, 3.57032000000000009e-03, 4.34620999999999966e-03, 5.24621000000000028e-03, 6.33710000000000002e-03, 7.60823999999999962e-03, 9.08212000000000082e-03, 1.07900500000000007e-02, 1.27231400000000008e-02, 1.49473300000000000e-02, 1.74063999999999990e-02, 2.01465800000000007e-02, 2.31962900000000014e-02, 2.64355299999999988e-02, 2.98372499999999992e-02, 3.34497600000000020e-02, 3.70526300000000031e-02, 4.06320500000000029e-02, 4.40405700000000011e-02, 4.70861399999999986e-02, 4.97137600000000027e-02, 5.17016699999999982e-02, 5.29031100000000032e-02, 5.32157499999999992e-02, 5.25482499999999977e-02, 5.07608500000000032e-02, 4.80906799999999968e-02, 4.43541400000000002e-02, 3.98862999999999995e-02, 3.47996399999999997e-02, 2.94283499999999990e-02, 2.39547599999999986e-02, 1.87922800000000015e-02, 1.41215999999999998e-02, 1.00610400000000003e-02, 6.80003000000000031e-03, 4.31297000000000017e-03, 2.56047000000000002e-03, 1.39046999999999999e-03, 6.97970000000000014e-04, 3.17479999999999976e-04, 1.29330000000000010e-04, 4.81200000000000001e-05, 1.57300000000000002e-05, 4.52999999999999983e-06, 1.15000000000000000e-06, 3.09999999999999997e-07, 2.99999999999999973e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[11][30] = niz11_30;
	static double niz12_1[] = { 1.00000000000000000e+00 }; repRatios[12][1] = niz12_1;
	static double niz12_2[] = { 1.59765710000000005e-01, 8.40234290000000050e-01 }; repRatios[12][2] = niz12_2;
	static double niz12_3[] = { 1.38588900000000004e-02, 3.50194399999999989e-02, 3.67544270000000006e-01, 5.83577400000000024e-01 }; repRatios[12][3] = niz12_3;
	static double niz12_4[] = { 1.15835000000000005e-03, 4.84600000000000016e-04, 1.09512299999999993e-02, 4.87906599999999996e-02, 1.48475600000000013e-01, 4.61957200000000012e-01, 3.28182360000000006e-01 }; repRatios[12][4] = niz12_4;
	static double niz12_5[] = { 9.84999999999999954e-05, 5.50999999999999976e-06, 1.86820000000000004e-04, 1.37855000000000009e-03, 5.44837000000000012e-03, 8.42152000000000005e-03, 5.10452399999999987e-02, 1.18453959999999997e-01, 2.81586280000000022e-01, 3.87552769999999991e-01, 1.45822480000000004e-01 }; repRatios[12][5] = niz12_5;
	static double niz12_6[] = { 8.13999999999999999e-06, 4.99999999999999977e-08, 2.34999999999999995e-06, 2.95399999999999984e-05, 1.79330000000000006e-04, 3.65849999999999975e-04, 6.38259999999999978e-04, 2.14946000000000017e-03, 8.27727999999999971e-03, 1.79480500000000001e-02, 4.46595399999999976e-02, 1.21554880000000004e-01, 2.10658659999999998e-01, 3.16061099999999984e-01, 2.27878119999999990e-01, 4.95893899999999971e-02 }; repRatios[12][6] = niz12_6;
	static double niz12_7[] = { 7.70000000000000039e-07, 0.00000000000000000e+00, 0.00000000000000000e+00, 3.90000000000000025e-07, 4.32000000000000014e-06, 1.70199999999999997e-05, 3.83000000000000026e-05, 8.76000000000000083e-06, 1.16589999999999993e-04, 3.68329999999999992e-04, 9.85179999999999997e-04, 1.66685000000000010e-03, 4.39551000000000004e-03, 1.15875500000000003e-02, 2.74967199999999988e-02, 5.35676699999999978e-02, 1.16160650000000004e-01, 1.95535999999999988e-01, 2.53336930000000016e-01, 2.28280189999999994e-01, 9.40278499999999962e-02, 1.24044199999999993e-02 }; repRatios[12][7] = niz12_7;
	static double niz12_8[] = { 8.99999999999999986e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 4.00000000000000008e-08, 3.90000000000000025e-07, 1.59999999999999993e-06, 2.78999999999999997e-06, 1.15999999999999991e-06, 2.91999999999999999e-06, 1.62099999999999990e-05, 4.39099999999999980e-05, 1.08040000000000002e-04, 1.38169999999999987e-04, 2.69219999999999974e-04, 8.86230000000000004e-04, 1.98211999999999998e-03, 3.86974999999999993e-03, 8.03463999999999914e-03, 1.78694800000000001e-02, 3.76407799999999987e-02, 6.82634000000000019e-02, 1.19433070000000002e-01, 1.85479320000000003e-01, 2.20703299999999991e-01, 1.98620820000000003e-01, 1.07925019999999997e-01, 2.65443199999999997e-02, 2.16321000000000005e-03 }; repRatios[12][8] = niz12_8;
	static double niz12_9[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 7.00000000000000048e-08, 1.29999999999999999e-07, 2.29999999999999995e-07, 4.99999999999999977e-08, 1.90000000000000007e-07, 3.59999999999999994e-07, 2.60000000000000009e-06, 5.13000000000000001e-06, 1.00100000000000007e-05, 1.12199999999999993e-05, 1.88799999999999988e-05, 4.94800000000000006e-05, 1.30159999999999987e-04, 2.54900000000000016e-04, 4.57150000000000026e-04, 7.82110000000000032e-04, 1.86351000000000008e-03, 4.01423999999999965e-03, 7.48491000000000000e-03, 1.41749000000000007e-02, 2.75116000000000006e-02, 5.05495399999999970e-02, 8.49067099999999964e-02, 1.28515159999999989e-01, 1.77666390000000007e-01, 1.96785660000000001e-01, 1.67891000000000012e-01, 9.91614700000000016e-02, 3.26525000000000010e-02, 4.85862000000000013e-03, 2.41119999999999995e-04 }; repRatios[12][9] = niz12_9;
	static double niz12_10[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.00000000000000004e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.99999999999999973e-08, 9.99999999999999955e-08, 3.20000000000000007e-07, 4.89999999999999967e-07, 8.70000000000000035e-07, 8.99999999999999959e-07, 1.10000000000000006e-06, 3.14999999999999991e-06, 8.33999999999999977e-06, 1.78800000000000016e-05, 2.72900000000000013e-05, 4.17499999999999984e-05, 7.33699999999999972e-05, 1.49490000000000007e-04, 3.32800000000000012e-04, 6.27610000000000017e-04, 1.11910999999999998e-03, 1.99600999999999989e-03, 3.89110000000000020e-03, 7.65193000000000036e-03, 1.36031499999999996e-02, 2.35864200000000003e-02, 4.08591099999999971e-02, 6.70344100000000026e-02, 1.01548280000000005e-01, 1.38701240000000003e-01, 1.69426600000000011e-01, 1.73188470000000011e-01, 1.38156449999999986e-01, 8.11668700000000021e-02, 3.02534599999999994e-02, 5.99485000000000035e-03, 5.22409999999999953e-04, 1.46000000000000008e-05 }; repRatios[12][10] = niz12_10;
	static double niz12_11[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.99999999999999973e-08, 4.00000000000000008e-08, 1.60000000000000003e-07, 2.99999999999999973e-08, 1.10000000000000006e-07, 2.80000000000000019e-07, 5.60000000000000038e-07, 1.03000000000000009e-06, 1.95999999999999987e-06, 2.56000000000000005e-06, 4.07999999999999990e-06, 5.40999999999999987e-06, 1.27599999999999998e-05, 2.57600000000000007e-05, 4.72800000000000013e-05, 7.82099999999999983e-05, 1.29309999999999994e-04, 2.28280000000000003e-04, 4.28090000000000003e-04, 8.11410000000000039e-04, 1.46648999999999998e-03, 2.52856000000000001e-03, 4.40728000000000040e-03, 7.82654999999999983e-03, 1.37829000000000007e-02, 2.30191400000000004e-02, 3.69381100000000032e-02, 5.79629899999999990e-02, 8.56209899999999940e-02, 1.17075780000000004e-01, 1.44364400000000004e-01, 1.57998090000000008e-01, 1.46701439999999989e-01, 1.08669650000000007e-01, 6.07972899999999969e-02, 2.32243500000000012e-02, 5.21527000000000015e-03, 5.94169999999999985e-04, 2.87300000000000011e-05, 4.59999999999999990e-07 }; repRatios[12][11] = niz12_11;
	static double niz12_12[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 7.00000000000000048e-08, 1.10000000000000006e-07, 1.79999999999999997e-07, 2.39999999999999979e-07, 2.20000000000000011e-07, 2.39999999999999979e-07, 4.89999999999999967e-07, 1.03000000000000009e-06, 1.88999999999999990e-06, 3.67000000000000001e-06, 6.22999999999999964e-06, 9.77999999999999954e-06, 1.36399999999999998e-05, 2.17100000000000005e-05, 4.12300000000000034e-05, 7.62799999999999947e-05, 1.32649999999999999e-04, 2.17839999999999988e-04, 3.59800000000000018e-04, 6.20250000000000033e-04, 1.08512999999999991e-03, 1.90620000000000004e-03, 3.24642999999999980e-03, 5.34041000000000030e-03, 8.89831999999999949e-03, 1.46886900000000008e-02, 2.36487299999999998e-02, 3.66292199999999971e-02, 5.42550300000000027e-02, 7.74142800000000020e-02, 1.03746749999999999e-01, 1.27799400000000007e-01, 1.42443049999999988e-01, 1.39890419999999988e-01, 1.17365919999999999e-01, 7.94512400000000063e-02, 4.13965300000000008e-02, 1.52703000000000005e-02, 3.53989999999999990e-03, 4.49139999999999999e-04, 2.67800000000000011e-05, 5.40000000000000018e-07, 0.00000000000000000e+00 }; repRatios[12][12] = niz12_12;
	static double niz12_13[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 2.99999999999999973e-08, 2.00000000000000004e-08, 2.00000000000000004e-08, 5.99999999999999946e-08, 2.00000000000000004e-08, 1.40000000000000010e-07, 3.09999999999999997e-07, 3.90000000000000025e-07, 6.99999999999999968e-07, 9.29999999999999990e-07, 1.25000000000000010e-06, 1.79000000000000001e-06, 3.46999999999999981e-06, 6.98999999999999999e-06, 1.17299999999999995e-05, 1.92900000000000000e-05, 2.90200000000000000e-05, 4.32500000000000010e-05, 7.15699999999999941e-05, 1.23640000000000002e-04, 2.13720000000000007e-04, 3.54140000000000021e-04, 5.75789999999999961e-04, 9.32109999999999992e-04, 1.54198000000000009e-03, 2.55742999999999986e-03, 4.19969999999999979e-03, 6.75871000000000024e-03, 1.06535599999999994e-02, 1.66357900000000010e-02, 2.55714899999999988e-02, 3.79910800000000035e-02, 5.43722499999999970e-02, 7.41943500000000061e-02, 9.63668099999999972e-02, 1.16794700000000001e-01, 1.29986070000000009e-01, 1.30305140000000014e-01, 1.14907270000000006e-01, 8.63860500000000059e-02, 5.27539500000000008e-02, 2.49657499999999984e-02, 8.53668999999999956e-03, 1.88003999999999992e-03, 2.36220000000000012e-04, 1.43000000000000003e-05, 2.70000000000000009e-07, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[12][13] = niz12_13;
	static double niz12_14[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.99999999999999973e-08, 2.99999999999999973e-08, 8.99999999999999986e-08, 5.99999999999999946e-08, 1.19999999999999989e-07, 1.60000000000000003e-07, 3.70000000000000004e-07, 5.19999999999999998e-07, 9.09999999999999969e-07, 1.54999999999999998e-06, 2.12000000000000003e-06, 3.18000000000000005e-06, 4.65000000000000037e-06, 7.28999999999999966e-06, 1.25300000000000003e-05, 2.11299999999999993e-05, 3.43399999999999999e-05, 5.43600000000000013e-05, 8.50499999999999938e-05, 1.31409999999999990e-04, 2.14329999999999989e-04, 3.53689999999999983e-04, 5.71219999999999996e-04, 9.09780000000000007e-04, 1.42764999999999993e-03, 2.26068000000000015e-03, 3.57078999999999990e-03, 5.61960999999999971e-03, 8.70348999999999949e-03, 1.32163799999999998e-02, 1.96997699999999984e-02, 2.88158199999999989e-02, 4.10065100000000030e-02, 5.63849400000000014e-02, 7.42277999999999966e-02, 9.29933000000000010e-02, 1.09713260000000007e-01, 1.20465550000000005e-01, 1.20524649999999997e-01, 1.08368859999999997e-01, 8.52027499999999938e-02, 5.68038999999999974e-02, 3.07978500000000016e-02, 1.29422700000000005e-02, 3.96408999999999997e-03, 7.86849999999999963e-04, 8.87800000000000004e-05, 5.39000000000000006e-06, 1.29999999999999999e-07, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[12][14] = niz12_14;
	static double niz12_15[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.99999999999999973e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 8.99999999999999986e-08, 1.19999999999999989e-07, 1.69999999999999987e-07, 1.69999999999999987e-07, 3.70000000000000004e-07, 3.59999999999999994e-07, 4.79999999999999957e-07, 8.99999999999999959e-07, 1.45000000000000009e-06, 2.15000000000000017e-06, 3.36000000000000002e-06, 5.30999999999999998e-06, 7.14000000000000025e-06, 1.11400000000000001e-05, 1.68499999999999996e-05, 2.76599999999999994e-05, 4.18900000000000004e-05, 6.66399999999999989e-05, 1.00810000000000006e-04, 1.57799999999999987e-04, 2.41090000000000011e-04, 3.72460000000000022e-04, 5.82889999999999971e-04, 9.13089999999999974e-04, 1.42275999999999991e-03, 2.17550999999999986e-03, 3.32458000000000016e-03, 5.05970000000000031e-03, 7.62308999999999990e-03, 1.13517900000000005e-02, 1.65933699999999996e-02, 2.37613599999999987e-02, 3.32746299999999995e-02, 4.54114200000000010e-02, 6.00142999999999996e-02, 7.61393199999999964e-02, 9.20439599999999941e-02, 1.05347529999999995e-01, 1.12739350000000002e-01, 1.11363160000000003e-01, 9.97690400000000033e-02, 7.97457399999999955e-02, 5.53722199999999998e-02, 3.23722200000000002e-02, 1.52865999999999991e-02, 5.54394999999999975e-03, 1.44319000000000001e-03, 2.42980000000000008e-04, 2.27999999999999985e-05, 9.19999999999999980e-07, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[12][15] = niz12_15;
	static double niz12_16[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.99999999999999973e-08, 2.00000000000000004e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 4.00000000000000008e-08, 4.00000000000000008e-08, 9.99999999999999955e-08, 2.99999999999999986e-07, 3.80000000000000015e-07, 5.50000000000000028e-07, 6.40000000000000013e-07, 9.59999999999999914e-07, 1.15999999999999991e-06, 1.72999999999999995e-06, 2.91999999999999999e-06, 4.39000000000000032e-06, 6.93999999999999962e-06, 1.02200000000000004e-05, 1.53700000000000002e-05, 2.34900000000000004e-05, 3.35400000000000007e-05, 5.19699999999999988e-05, 8.15800000000000016e-05, 1.24210000000000005e-04, 1.90890000000000010e-04, 2.82780000000000000e-04, 4.25970000000000016e-04, 6.45080000000000024e-04, 9.75159999999999981e-04, 1.48206000000000010e-03, 2.23989000000000002e-03, 3.33246000000000020e-03, 4.91467000000000032e-03, 7.19234000000000019e-03, 1.04295299999999994e-02, 1.49850399999999998e-02, 2.10728799999999987e-02, 2.90217600000000006e-02, 3.90319100000000030e-02, 5.11045799999999967e-02, 6.48507299999999953e-02, 7.90923099999999990e-02, 9.22349600000000047e-02, 1.01835949999999995e-01, 1.05841309999999994e-01, 1.02122050000000006e-01, 9.01667000000000024e-02, 7.17041499999999943e-02, 5.03562200000000001e-02, 3.04159399999999989e-02, 1.52671100000000004e-02, 6.12210000000000011e-03, 1.85077000000000006e-03, 3.95730000000000008e-04, 5.27900000000000011e-05, 3.43000000000000019e-06, 1.19999999999999989e-07, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[12][16] = niz12_16;
	static double niz12_17[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 5.99999999999999946e-08, 2.00000000000000004e-08, 7.00000000000000048e-08, 1.10000000000000006e-07, 1.10000000000000006e-07, 1.99999999999999991e-07, 2.59999999999999999e-07, 2.80000000000000019e-07, 4.09999999999999992e-07, 7.60000000000000029e-07, 1.06999999999999992e-06, 1.46999999999999990e-06, 2.28000000000000019e-06, 2.71999999999999979e-06, 4.09999999999999971e-06, 6.24000000000000040e-06, 1.00600000000000002e-05, 1.51500000000000006e-05, 2.18899999999999988e-05, 3.24900000000000023e-05, 4.73499999999999990e-05, 6.95100000000000036e-05, 1.04069999999999998e-04, 1.54350000000000011e-04, 2.33710000000000010e-04, 3.43819999999999998e-04, 5.10730000000000038e-04, 7.50220000000000010e-04, 1.10720000000000002e-03, 1.64134000000000003e-03, 2.39852999999999985e-03, 3.50937999999999988e-03, 5.05814000000000003e-03, 7.24087999999999989e-03, 1.02194699999999996e-02, 1.43530099999999994e-02, 1.97770900000000006e-02, 2.67934600000000016e-02, 3.55387299999999975e-02, 4.59421399999999994e-02, 5.77580800000000033e-02, 7.03445300000000023e-02, 8.24648600000000009e-02, 9.24052900000000010e-02, 9.83125700000000019e-02, 9.85205499999999984e-02, 9.21941099999999958e-02, 7.93238599999999960e-02, 6.19674100000000005e-02, 4.31217399999999987e-02, 2.61851999999999988e-02, 1.34640100000000002e-02, 5.67098999999999989e-03, 1.85024999999999990e-03, 4.44579999999999975e-04, 7.16800000000000049e-05, 6.96000000000000028e-06, 3.59999999999999994e-07, 2.99999999999999973e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[12][17] = niz12_17;
	static double niz12_18[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 4.00000000000000008e-08, 2.00000000000000004e-08, 4.99999999999999977e-08, 1.10000000000000006e-07, 1.19999999999999989e-07, 1.10000000000000006e-07, 1.99999999999999991e-07, 1.99999999999999991e-07, 2.80000000000000019e-07, 3.30000000000000017e-07, 4.79999999999999957e-07, 7.19999999999999989e-07, 1.30000000000000005e-06, 1.68999999999999991e-06, 2.37000000000000018e-06, 3.31999999999999998e-06, 4.63999999999999962e-06, 6.66999999999999967e-06, 9.67000000000000059e-06, 1.45799999999999993e-05, 2.27100000000000011e-05, 3.21699999999999986e-05, 4.61000000000000025e-05, 6.55199999999999961e-05, 9.48099999999999952e-05, 1.36839999999999998e-04, 2.03350000000000010e-04, 2.96099999999999987e-04, 4.31269999999999982e-04, 6.27219999999999948e-04, 9.09870000000000015e-04, 1.31455999999999999e-03, 1.89028999999999998e-03, 2.71579999999999998e-03, 3.86053000000000004e-03, 5.47294999999999986e-03, 7.62603999999999973e-03, 1.05933899999999994e-02, 1.44622699999999993e-02, 1.95190200000000015e-02, 2.59714100000000003e-02, 3.38536700000000024e-02, 4.31256799999999996e-02, 5.36330000000000001e-02, 6.46847900000000059e-02, 7.56107099999999976e-02, 8.49994300000000008e-02, 9.14249699999999943e-02, 9.34250900000000023e-02, 9.00916600000000040e-02, 8.11240099999999964e-02, 6.76106100000000015e-02, 5.12392600000000017e-02, 3.48290600000000020e-02, 2.08210599999999989e-02, 1.06781399999999992e-02, 4.52006000000000022e-03, 1.52552999999999998e-03, 3.87489999999999992e-04, 6.81099999999999967e-05, 7.90000000000000060e-06, 6.09999999999999983e-07, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[12][18] = niz12_18;
	static double niz12_19[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 2.99999999999999973e-08, 1.00000000000000002e-08, 5.99999999999999946e-08, 5.99999999999999946e-08, 9.99999999999999955e-08, 4.00000000000000008e-08, 0.00000000000000000e+00, 1.29999999999999999e-07, 1.99999999999999991e-07, 2.29999999999999995e-07, 3.59999999999999994e-07, 5.60000000000000038e-07, 7.80000000000000049e-07, 9.40000000000000000e-07, 1.39000000000000003e-06, 2.08999999999999989e-06, 2.44999999999999984e-06, 4.21000000000000035e-06, 5.80000000000000037e-06, 7.32000000000000022e-06, 1.15099999999999999e-05, 1.57899999999999996e-05, 2.21600000000000013e-05, 3.27300000000000000e-05, 4.73600000000000006e-05, 6.72499999999999948e-05, 9.72199999999999941e-05, 1.37820000000000005e-04, 1.96080000000000006e-04, 2.79820000000000014e-04, 3.96750000000000021e-04, 5.67180000000000028e-04, 8.06769999999999948e-04, 1.14514999999999994e-03, 1.61404999999999990e-03, 2.28502999999999996e-03, 3.18710999999999994e-03, 4.42809999999999992e-03, 6.13851999999999974e-03, 8.39059999999999979e-03, 1.13784400000000001e-02, 1.52713099999999997e-02, 2.01470800000000012e-02, 2.62122499999999994e-02, 3.35450100000000001e-02, 4.20661800000000016e-02, 5.15003299999999969e-02, 6.14679900000000001e-02, 7.11323900000000037e-02, 7.96580600000000028e-02, 8.57680499999999985e-02, 8.83107399999999987e-02, 8.64380599999999971e-02, 7.97855700000000001e-02, 6.88923699999999944e-02, 5.49646099999999971e-02, 4.00563800000000025e-02, 2.62615900000000013e-02, 1.51594499999999997e-02, 7.56369999999999959e-03, 3.14482999999999993e-03, 1.05575999999999999e-03, 2.71379999999999994e-04, 4.86499999999999967e-05, 5.54000000000000032e-06, 4.79999999999999957e-07, 2.00000000000000004e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[12][19] = niz12_19;
	static double niz12_20[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.99999999999999973e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 2.00000000000000004e-08, 1.00000000000000002e-08, 4.00000000000000008e-08, 4.99999999999999977e-08, 2.99999999999999973e-08, 7.00000000000000048e-08, 1.10000000000000006e-07, 1.40000000000000010e-07, 2.20000000000000011e-07, 2.49999999999999989e-07, 3.30000000000000017e-07, 3.80000000000000015e-07, 4.40000000000000022e-07, 5.89999999999999963e-07, 1.08999999999999994e-06, 1.19999999999999995e-06, 1.90999999999999992e-06, 2.61999999999999990e-06, 3.10999999999999987e-06, 4.48000000000000031e-06, 6.29999999999999982e-06, 8.87999999999999968e-06, 1.24199999999999997e-05, 1.82800000000000012e-05, 2.48799999999999990e-05, 3.46100000000000024e-05, 4.87899999999999987e-05, 6.92399999999999944e-05, 9.85799999999999947e-05, 1.37939999999999997e-04, 1.96770000000000002e-04, 2.74180000000000007e-04, 3.84129999999999997e-04, 5.41070000000000049e-04, 7.57769999999999950e-04, 1.05521000000000000e-03, 1.47276000000000004e-03, 2.04346999999999992e-03, 2.81176999999999989e-03, 3.85565999999999990e-03, 5.25283999999999994e-03, 7.10457000000000016e-03, 9.52343999999999934e-03, 1.26628399999999999e-02, 1.66202499999999996e-02, 2.14815400000000004e-02, 2.74258999999999996e-02, 3.44736900000000013e-02, 4.23570299999999969e-02, 5.09867300000000009e-02, 6.00009999999999988e-02, 6.86528099999999947e-02, 7.60716899999999974e-02, 8.14314599999999972e-02, 8.36504799999999993e-02, 8.21923799999999954e-02, 7.66486299999999954e-02, 6.74090999999999996e-02, 5.53165700000000024e-02, 4.20317899999999994e-02, 2.91678200000000006e-02, 1.82222099999999991e-02, 1.00052900000000000e-02, 4.76166999999999997e-03, 1.89401000000000001e-03, 6.05280000000000032e-04, 1.47910000000000012e-04, 2.74800000000000012e-05, 3.40000000000000006e-06, 3.39999999999999974e-07, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[12][20] = niz12_20;
	static double niz12_21[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.99999999999999973e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 4.00000000000000008e-08, 7.00000000000000048e-08, 8.99999999999999986e-08, 4.99999999999999977e-08, 4.00000000000000008e-08, 7.00000000000000048e-08, 1.10000000000000006e-07, 2.49999999999999989e-07, 2.39999999999999979e-07, 2.99999999999999986e-07, 4.09999999999999992e-07, 3.09999999999999997e-07, 6.30000000000000003e-07, 8.40000000000000004e-07, 9.99999999999999955e-07, 1.74999999999999997e-06, 2.20000000000000011e-06, 2.87000000000000005e-06, 4.15999999999999998e-06, 5.49999999999999986e-06, 7.62999999999999979e-06, 1.02200000000000004e-05, 1.50899999999999995e-05, 2.09900000000000006e-05, 2.86000000000000006e-05, 4.01500000000000001e-05, 5.48499999999999983e-05, 7.75700000000000044e-05, 1.06750000000000006e-04, 1.45240000000000012e-04, 2.07220000000000012e-04, 2.85600000000000003e-04, 3.91559999999999998e-04, 5.46020000000000034e-04, 7.49250000000000024e-04, 1.03198000000000005e-03, 1.41233999999999999e-03, 1.92840999999999998e-03, 2.62829000000000014e-03, 3.54723000000000017e-03, 4.77745999999999987e-03, 6.37322999999999969e-03, 8.44234999999999951e-03, 1.10991400000000004e-02, 1.44102799999999993e-02, 1.85624599999999994e-02, 2.35117399999999997e-02, 2.94014400000000009e-02, 3.61506600000000011e-02, 4.36477300000000026e-02, 5.16295999999999977e-02, 5.97670999999999966e-02, 6.73293799999999942e-02, 7.36257699999999932e-02, 7.79860700000000046e-02, 7.95295200000000063e-02, 7.78456000000000009e-02, 7.27374799999999933e-02, 6.42956499999999959e-02, 5.35605399999999968e-02, 4.15808199999999975e-02, 2.97853400000000004e-02, 1.94781499999999996e-02, 1.14081200000000008e-02, 5.86329000000000017e-03, 2.60825999999999983e-03, 9.71500000000000033e-04, 2.85920000000000000e-04, 6.60199999999999947e-05, 1.17700000000000008e-05, 1.43000000000000007e-06, 1.90000000000000007e-07, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[12][21] = niz12_21;
	static double niz12_22[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 1.00000000000000002e-08, 2.00000000000000004e-08, 1.00000000000000002e-08, 4.00000000000000008e-08, 0.00000000000000000e+00, 2.99999999999999973e-08, 8.00000000000000017e-08, 1.40000000000000010e-07, 9.99999999999999955e-08, 5.99999999999999946e-08, 2.10000000000000001e-07, 2.20000000000000011e-07, 1.49999999999999993e-07, 3.80000000000000015e-07, 5.09999999999999988e-07, 6.19999999999999993e-07, 7.80000000000000049e-07, 1.17999999999999993e-06, 1.41999999999999996e-06, 1.99000000000000001e-06, 2.65999999999999994e-06, 4.00999999999999972e-06, 5.21000000000000009e-06, 7.55999999999999962e-06, 9.84000000000000066e-06, 1.34899999999999996e-05, 1.78399999999999986e-05, 2.50400000000000008e-05, 3.28300000000000025e-05, 4.72699999999999997e-05, 6.28100000000000034e-05, 8.63200000000000002e-05, 1.16700000000000004e-04, 1.61490000000000001e-04, 2.23599999999999987e-04, 3.03109999999999990e-04, 4.15369999999999975e-04, 5.73570000000000026e-04, 7.77009999999999962e-04, 1.04936999999999999e-03, 1.42196000000000011e-03, 1.91802000000000010e-03, 2.56895999999999991e-03, 3.44020999999999997e-03, 4.56623000000000012e-03, 6.00609000000000039e-03, 7.88174999999999987e-03, 1.02193000000000006e-02, 1.31392599999999998e-02, 1.67453000000000012e-02, 2.10818200000000011e-02, 2.61714699999999988e-02, 3.21022700000000022e-02, 3.86598800000000006e-02, 4.57942399999999999e-02, 5.31376399999999999e-02, 6.02777899999999978e-02, 6.68045399999999956e-02, 7.19228999999999979e-02, 7.50848900000000014e-02, 7.56899600000000006e-02, 7.34539399999999953e-02, 6.80936500000000056e-02, 6.01129399999999967e-02, 5.01913599999999974e-02, 3.92646099999999984e-02, 2.85575700000000009e-02, 1.91216199999999989e-02, 1.16021900000000001e-02, 6.29533000000000002e-03, 2.98510000000000008e-03, 1.20977999999999993e-03, 3.98919999999999982e-04, 1.08969999999999995e-04, 2.22099999999999991e-05, 3.82999999999999975e-06, 3.70000000000000004e-07, 4.00000000000000008e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[12][22] = niz12_22;
	static double niz12_23[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 2.99999999999999973e-08, 2.00000000000000004e-08, 4.00000000000000008e-08, 1.00000000000000002e-08, 4.00000000000000008e-08, 1.00000000000000002e-08, 8.00000000000000017e-08, 7.00000000000000048e-08, 8.99999999999999986e-08, 1.40000000000000010e-07, 1.40000000000000010e-07, 1.79999999999999997e-07, 3.09999999999999997e-07, 4.30000000000000012e-07, 4.89999999999999967e-07, 5.50000000000000028e-07, 8.19999999999999984e-07, 1.25000000000000010e-06, 1.50000000000000004e-06, 1.99000000000000001e-06, 3.14000000000000001e-06, 3.81999999999999985e-06, 4.79999999999999978e-06, 6.57999999999999968e-06, 9.31000000000000065e-06, 1.20399999999999999e-05, 1.70100000000000015e-05, 2.25400000000000010e-05, 3.05599999999999988e-05, 4.12399999999999982e-05, 5.68099999999999999e-05, 7.74599999999999936e-05, 1.05190000000000001e-04, 1.39049999999999992e-04, 1.90680000000000011e-04, 2.58140000000000019e-04, 3.48119999999999994e-04, 4.65450000000000011e-04, 6.29730000000000003e-04, 8.40970000000000020e-04, 1.13138999999999991e-03, 1.50409000000000003e-03, 1.99908999999999981e-03, 2.64087999999999996e-03, 3.48399000000000018e-03, 4.55623999999999960e-03, 5.93006000000000002e-03, 7.67836000000000039e-03, 9.87318000000000050e-03, 1.25390599999999994e-02, 1.57988899999999995e-02, 1.96925899999999994e-02, 2.42804600000000002e-02, 2.95899199999999987e-02, 3.54674199999999995e-02, 4.18770399999999973e-02, 4.85029999999999975e-02, 5.51289800000000010e-02, 6.13291700000000023e-02, 6.65917399999999965e-02, 7.04228699999999985e-02, 7.22618700000000058e-02, 7.17031100000000005e-02, 6.85693799999999992e-02, 6.28507799999999950e-02, 5.49969199999999978e-02, 4.55981499999999970e-02, 3.56181200000000031e-02, 2.59738200000000016e-02, 1.75341900000000016e-02, 1.07964099999999993e-02, 6.00737999999999966e-03, 2.93712000000000010e-03, 1.24602999999999997e-03, 4.46209999999999999e-04, 1.33599999999999995e-04, 3.08000000000000033e-05, 5.75000000000000000e-06, 9.50000000000000010e-07, 1.29999999999999999e-07, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[12][23] = niz12_23;
	static double niz12_24[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.00000000000000002e-08, 4.00000000000000008e-08, 2.00000000000000004e-08, 1.00000000000000002e-08, 1.00000000000000002e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 4.00000000000000008e-08, 8.00000000000000017e-08, 5.99999999999999946e-08, 5.99999999999999946e-08, 9.99999999999999955e-08, 1.29999999999999999e-07, 2.10000000000000001e-07, 2.70000000000000009e-07, 3.59999999999999994e-07, 4.30000000000000012e-07, 4.79999999999999957e-07, 7.40000000000000009e-07, 9.79999999999999934e-07, 1.28000000000000003e-06, 1.45000000000000009e-06, 2.28000000000000019e-06, 3.02999999999999979e-06, 4.13000000000000027e-06, 5.39999999999999997e-06, 7.16999999999999996e-06, 9.93999999999999970e-06, 1.30600000000000003e-05, 1.72099999999999995e-05, 2.30300000000000014e-05, 3.06700000000000028e-05, 3.94300000000000003e-05, 5.36900000000000026e-05, 7.25000000000000004e-05, 9.53799999999999982e-05, 1.27019999999999987e-04, 1.72229999999999996e-04, 2.29619999999999987e-04, 3.01200000000000003e-04, 4.05909999999999995e-04, 5.39800000000000002e-04, 7.17439999999999961e-04, 9.47110000000000031e-04, 1.24974999999999999e-03, 1.64509000000000009e-03, 2.15817000000000005e-03, 2.82629999999999991e-03, 3.66236999999999986e-03, 4.74090000000000015e-03, 6.07880999999999960e-03, 7.78571000000000037e-03, 9.84502999999999941e-03, 1.23889199999999994e-02, 1.54604500000000006e-02, 1.91020000000000009e-02, 2.33141499999999988e-02, 2.81386999999999991e-02, 3.35073899999999980e-02, 3.93381400000000006e-02, 4.54217199999999988e-02, 5.15390599999999977e-02, 5.73191300000000029e-02, 6.24251200000000006e-02, 6.64064600000000005e-02, 6.87285499999999994e-02, 6.90700999999999954e-02, 6.72760000000000025e-02, 6.31086800000000003e-02, 5.69334400000000018e-02, 4.90462099999999998e-02, 4.01464100000000004e-02, 3.10343000000000008e-02, 2.24961099999999997e-02, 1.51119099999999992e-02, 9.31892999999999957e-03, 5.21940999999999985e-03, 2.59784000000000013e-03, 1.13367000000000003e-03, 4.24010000000000001e-04, 1.33950000000000003e-04, 3.44899999999999967e-05, 7.24000000000000014e-06, 1.15000000000000000e-06, 1.49999999999999993e-07, 4.99999999999999977e-08, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00 }; repRatios[12][24] = niz12_24;
	static double niz12_25[] = { 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.000000000