#include "ConfidenceBound.h"
#include <cmath>

using namespace std;

namespace {
	double z[100] = {0	,
		0.01253347	,
		0.025068908	,
		0.050153583	,
		0.062706778	,
		0.075269862	,
		0.087844838	,
		0.100433721	,
		0.113038541	,
		0.125661347	,
		0.138304208	,
		0.150969215	,
		0.163658486	,
		0.176374165	,
		0.189118426	,
		0.201893479	,
		0.214701568	,
		0.227544977	,
		0.240426031	,
		0.253347103	,
		0.266310613	,
		0.279319034	,
		0.292374896	,
		0.305480788	,
		0.318639364	,
		0.331853346	,
		0.345125531	,
		0.358458793	,
		0.371856089	,
		0.385320466	,
		0.398855066	,
		0.412463129	,
		0.426148008	,
		0.439913166	,
		0.45376219	,
		0.467698799	,
		0.48172685	,
		0.495850347	,
		0.510073457	,
		0.524400513	,
		0.53883603	,
		0.55338472	,
		0.568051498	,
		0.582841507	,
		0.597760126	,
		0.612812991	,
		0.628006014	,
		0.643345405	,
		0.658837693	,
		0.67448975	,
		0.690308824	,
		0.706302563	,
		0.722479052	,
		0.738846849	,
		0.755415026	,
		0.772193214	,
		0.789191653	,
		0.806421247	,
		0.82389363	,
		0.841621234	,
		0.859617364	,
		0.877896295	,
		0.896473364	,
		0.915365088	,
		0.934589291	,
		0.954165253	,
		0.974113877	,
		0.994457883	,
		1.015222033	,
		1.036433389	,
		1.058121618	,
		1.080319341	,
		1.103062556	,
		1.126391129	,
		1.15034938	,
		1.174986792	,
		1.200358858	,
		1.22652812	,
		1.253565438	,
		1.281551566	,
		1.310579112	,
		1.340755034	,
		1.372203809	,
		1.40507156	,
		1.439531471	,
		1.475791028	,
		1.514101888	,
		1.554773595	,
		1.59819314	,
		1.644853627	,
		1.69539771	,
		1.750686071	,
		1.811910673	,
		1.880793608	,
		1.959963985	,
		2.053748911	,
		2.170090378	,
		2.326347874	,
		2.575829304	};

	int CummulativeInversePoisson(double Lambda,double confidence){
		double sum = 0;
		double lnFactorijelk = 0;
		double lnLambda = log(Lambda);
		int k = 0;
		double LnPoisson = 0;

		while(sum < confidence) {
			LnPoisson = -Lambda + k * lnLambda - lnFactorijelk;
			sum = sum + exp(LnPoisson); 
			k++;
			lnFactorijelk += log(k);
		}
		return k-1;
	}
}

double GetConfidenceBound (double expected, double confidence) {
	double ret;
	if (expected <= 30) {
		ret = CummulativeInversePoisson(expected,confidence);
	}
	else {
		ret = expected + sqrt(expected)*z[int(100*confidence)-1];
	}
	return ret;
}